/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModelInitException;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.DCModelObject;
import com.sap.ide.eclipse.component.provider.objects.DCProjectModelObject;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.dii.component.IAskForSaveEditor;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorManager;

public class DCProjectUtil {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$ComponentUtil == null ? (class$com$sap$ide$eclipse$component$provider$ComponentUtil = DCProjectUtil.class$("com.sap.ide.eclipse.component.provider.ComponentUtil")) : class$com$sap$ide$eclipse$component$provider$ComponentUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$ComponentUtil;

    public static IProject getProject(IDevelopmentComponentNode dcNode) {
        IContainer[] res;
        String dcFolder = dcNode.getComponentRootFolder();
        if (dcFolder == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null && (res = root.findContainersForLocation((IPath)new Path(dcFolder))) != null && res.length > 0 && res[0] instanceof IProject) {
            return (IProject)res[0];
        }
        return null;
    }

    public static IProject getProject(IDCProxy dcProxy) {
        IContainer[] res;
        String dcFolder = dcProxy.getRootFolder();
        if (dcFolder == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null && (res = root.findContainersForLocation((IPath)new Path(dcFolder))) != null && res.length > 0 && res[0] instanceof IProject) {
            return (IProject)res[0];
        }
        return null;
    }

    public static IProject getProject(Element element) {
        Object obj = ObjectUtil.getComponentModelObject(element);
        if (obj instanceof DCProjectModelObject) {
            return ((DCProjectModelObject)obj).getProject();
        }
        if (!(obj instanceof DCModelObject)) {
            return null;
        }
        DCModelObject dcModelObject = (DCModelObject)obj;
        IDevelopmentComponentNode dcNode = ((DCModelObject)obj).getDCNode();
        if (dcNode != null && (ComponentUtil.isActive(element) ? dcNode.isSynchedAsInActiveSource() : dcNode.isSynchedAsActiveSource())) {
            return null;
        }
        Element pElement = ObjectUtil.getDCProjectElement(dcModelObject);
        return (IProject)ObjectUtil.getObject(pElement);
    }

    public static Element getProjectElement(Element dcElement) {
        Object obj = ObjectUtil.getComponentModelObject(dcElement);
        if (obj instanceof DCModelObject) {
            return ObjectUtil.getDCProjectElement((DCModelObject)obj);
        }
        return null;
    }

    public static Element getParentProjectElement(Element element) {
        String sd = element.getUniqueName().getSubDomain();
        while (element != null && !SelenaElementUtil.isProjectModel((Element)element)) {
            if ((element = ObjectUtil.getParent(element)) == null) {
                return null;
            }
            sd = element.getUniqueName().getSubDomain();
            if (!"com.sap.ide.eclipse.component.DC".equals(sd)) continue;
            UniqueName configUniqueName = ComponentUtil.getParentDevConfElement(element).getUniqueName();
            UniqueName projectUniqueName = ObjectUtil.getDCProjectUniqueNameByDCNodeUin(element.getUniqueName(), configUniqueName);
            if (projectUniqueName == null) break;
            return ModelAccess.getModel((UniqueName)projectUniqueName);
        }
        return element;
    }

    public static IProject getParentProject(Element element) {
        element = DCProjectUtil.getParentProjectElement(element);
        return DCProjectUtil.getProject(element);
    }

    public static Element getParentDCElement(Element element) {
        IProject project = DCProjectUtil.getParentProject(element);
        return ObjectUtil.getDCNodeElement(project);
    }

    public static Element[] getDCNodeElements(Element[] elements) {
        Element[] el = new Element[elements.length];
        int i = 0;
        while (i < elements.length) {
            el[i] = DCProjectUtil.getParentDCElement(elements[i]);
            ++i;
        }
        return el;
    }

    public static IPPModel createPublicPart(IProject aDCProject, String aPPName, String aPPurpose, String aPPCaption, String aPPDescription) {
        ActionStatus actionResult;
        MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
        if (aDCProject == null || aPPName == null || aPPName.length() == 0 || aPPurpose == null) {
            return null;
        }
        PublicPart.Purpose aPurpose = null;
        try {
            aPurpose = PublicPart.Purpose.valueOf((String)aPPurpose);
        }
        catch (IllegalArgumentException iae) {
            Util.logException(theTracer, iae);
            return null;
        }
        IResource aDefFolder = aDCProject.findMember("def");
        if (aDefFolder == null || !aDefFolder.exists() || !(aDefFolder instanceof IFolder)) {
            Util.logExceptionMessage(theTracer, 2, theMessageUtil.getString("Warning.Could.Not.Find.PP.Folder"), null);
            return null;
        }
        IFolder theDefFolder = (IFolder)aDefFolder;
        IFile aPPFile = theDefFolder.getFile(aPPName + ".pp");
        if (aPPFile != null && aPPFile.exists()) {
            Util.logExceptionMessage(theTracer, 2, theMessageUtil.getString("Warning.PP.Alreay.Exists"), null);
            return null;
        }
        PPModel aNewModel = null;
        try {
            aNewModel = new PPModel(aPPName, new DCModel(aDCProject, theMessageUtil), false, theMessageUtil);
            aNewModel.setPurpose(aPPurpose);
        }
        catch (DCModelInitException rea) {
            Util.logExceptionMessage(theTracer, 2, theMessageUtil.format("Exception.Occured.See.Logs", new Object[]{rea.getMessage()}), rea);
            return null;
        }
        if (aPPCaption != null && !aPPCaption.trim().equals("")) {
            aNewModel.setCaption(aPPCaption);
        }
        if (aPPDescription != null && !aPPDescription.trim().equals("")) {
            aNewModel.setDescription(aPPDescription);
        }
        if (!(actionResult = aNewModel.writeModelTo(aPPFile)).getStatus()) {
            try {
                aPPFile.refreshLocal(0, null);
            }
            catch (Exception e) {
                Util.logException(theTracer, e);
            }
            if (aPPFile.exists()) {
                try {
                    aPPFile.delete(true, false, null);
                }
                catch (Exception e) {
                    Util.logException(theTracer, e);
                }
            }
            return null;
        }
        return aNewModel;
    }

    public static void setDTRTeamProviderForProject(IDevelopmentComponentNode dcNode) throws CoreException, RepositoryAccessException {
        RepositoryProvider theTeamProvider;
        IProject project = DCProjectUtil.getProject(dcNode);
        if (project != null && project.exists() && DCProjectInfo.isDCProject((IProject)project) && (theTeamProvider = RepositoryProvider.getProvider((IProject)project)) == null) {
            if (dcNode.isLocalOnlySource() && !dcNode.isAvailableAsSource()) {
                return;
            }
            String clientDefName = ComponentUtil.getDTRClientName(dcNode);
            if (clientDefName != null) {
                BluebirdPlugin.getDefault().associateProjectWithDTR(project, clientDefName);
            }
        }
    }

    public static boolean saveSensitiveEditors(IProject project) {
        if (project == null) {
            return true;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            ArrayList<IEditorPart> toSaveEditors = new ArrayList<IEditorPart>();
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && editor instanceof IAskForSaveEditor && project.equals((Object)(inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        toSaveEditors.add(editor);
                    }
                    ++k;
                }
                ++j;
            }
            if (!toSaveEditors.isEmpty()) {
                return EditorManager.saveAll(toSaveEditors, (boolean)true, (IWorkbenchWindow)windows[i]);
            }
            ++i;
        }
        return true;
    }

    public static void updateProject(IDevelopmentConfiguration config, DevelopmentComponent dc) throws InvocationTargetException, InterruptedException {
        if (config == null || dc == null) {
            return;
        }
        final ProjectConsistencyManager myManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)config);
        final DevelopmentComponent aLocalDC = dc;
        IRunnableWithProgress aRunnable = new IRunnableWithProgress(){
            private ProjectConsistencyManager theManager;
            private DevelopmentComponent theDC;
            {
                this.theManager = myManager;
                this.theDC = aLocalDC;
            }

            public void run(IProgressMonitor aMonitor) {
                this.theManager.synchronizeProject(this.theDC, aMonitor);
            }
        };
        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        aProgressMonitor.run(false, false, aRunnable);
    }

    public static void updateProjects(IDevelopmentConfiguration config) throws InvocationTargetException, InterruptedException {
        if (config == null) {
            return;
        }
        ProjectConsistencyManager myManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)config);
        IRunnableWithProgress aRunnable = new IRunnableWithProgress(myManager){
            private ProjectConsistencyManager theManager;
            private final /* synthetic */ ProjectConsistencyManager val$myManager;
            {
                this.theManager = this.val$myManager = val$myManager;
            }

            public void run(IProgressMonitor aMonitor) {
                this.theManager.synchronizeProjects(aMonitor);
            }
        };
        ProgressMonitorDialog aProgressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
        aProgressMonitor.run(false, false, aRunnable);
    }

    public static void removeDevConfProjects(IDevelopmentConfiguration devConfig) {
        if (devConfig == null) {
            return;
        }
        try {
            Path configPath = new Path(devConfig.getConfigurationRootFolder());
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].exists() && configPath.isPrefixOf(projects[i].getLocation())) {
                    projects[i].delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
        }
        catch (Throwable ex) {
            Util.logExceptionMessage(theTracer, 3, "Delete DC Projects failed:" + devConfig.getConfigurationRootFolder(), ex);
        }
    }

    public static DCProject getDCProject(IProject project) {
        try {
            if (project != null && DCProjectInfo.isDCProject((IProject)project)) {
                return (DCProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            }
        }
        catch (CoreException e) {
            Util.logExceptionMessage(theTracer, 3, "get DCProject failed", e);
        }
        return null;
    }

    public static List pruneResources(List resourceCollection) {
        if (resourceCollection.size() < 2) {
            return resourceCollection;
        }
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjects = new ArrayList<Object>(resourceCollection.size());
            ArrayList unorderedProjects = new ArrayList(resourceCollection.size());
            unorderedProjects.addAll(resourceCollection);
            int i = 0;
            while (i < orderedNames.length) {
                String projectName = orderedNames[i];
                int j = 0;
                while (j < resourceCollection.size()) {
                    IProject project = (IProject)resourceCollection.get(j);
                    if (project.getName().equals(projectName)) {
                        orderedProjects.add(project);
                        unorderedProjects.remove(project);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            orderedProjects.addAll(unorderedProjects);
            return orderedProjects;
        }
        IProject[] projects = new IProject[resourceCollection.size()];
        projects = resourceCollection.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjects = new ArrayList<IProject>();
        orderedProjects.addAll(Arrays.asList(po.projects));
        return orderedProjects;
    }

    public static boolean isDcDirty(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        IProjectNature projectNature = project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        if (projectNature instanceof IDCExtendedProject) {
            IDCExtendedProject extendedProject = (IDCExtendedProject)projectNature;
            IDevelopmentComponentNode dcNode = extendedProject.getDCNode();
            if (dcNode == null) {
                Util.showUserOutputViewer();
                theTracer.userOut("Development Component", 2, "Could not get DC for project " + project.getName());
                return false;
            }
            return dcNode.isDirty();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

