/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.AbstractComponentProvider;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public class DCMetaDataFolderProvider
extends AbstractComponentProvider
implements ChildrenProvider {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        UpdateUtil.refreshElement((Element)parent);
        ArrayList<Object> childrenList = new ArrayList<Object>();
        Object object = ObjectUtil.getComponentObject((Element)parent);
        if (!(object instanceof IDevelopmentComponentNode)) {
            return null;
        }
        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)object;
        String state = ComponentUtil.getEntityState(parent);
        String sd = parent.getUniqueName().getSubDomain();
        if (sd.equals("com.sap.ide.eclipse.component.DC") || SelenaElementUtil.isProjectModel((Element)parent)) {
            childrenList.add(ComponentMetaDataUtil.createDCMetaData(parent, dcNode, state));
        }
        DevelopmentComponent dc = null;
        try {
            dc = dcNode.getDevelopmentComponent(true);
        }
        catch (Exception RepositoryAccessException2) {
            Util.logExceptionMessage(this.theTracer, 3, "get DC Meta Data failed", RepositoryAccessException2);
        }
        if (sd.equals("com.sap.ide.eclipse.component.DCMetaData.Folder")) {
            childrenList.add(ComponentMetaDataUtil.createDCDefinition(parent, dcNode, state));
            childrenList.add(ComponentMetaDataUtil.createPPFolder(parent, dc, state));
        } else if (sd.equals("com.sap.ide.eclipse.component.DCMetaData.DCDefinition")) {
            childrenList.add(ComponentMetaDataUtil.createChildrenDCsFolder(parent, dcNode, state));
            childrenList.add(ComponentMetaDataUtil.createDependencyFolder(parent, dc, state));
            childrenList.add(ComponentMetaDataUtil.createDcAccessListFolder(parent, dc, state));
            childrenList.add(ComponentMetaDataUtil.createDcFolderFolder(parent, dc, state));
            IProject project = DCProjectUtil.getParentProject((Element)parent);
            if (project != null && com.sap.ide.eclipse.component.wizard.java.Util.isJavaProject(project)) {
                childrenList.add(ComponentMetaDataUtil.createPackageFolder(parent, dc, state));
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(childrenList.iterator());
    }
}

