/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.provider.AbstractComponentProvider;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.UpdateUtil;
import com.sap.ide.eclipse.component.provider.listener.VfsListener;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class DCFolderFileProvider
extends AbstractComponentProvider
implements ChildrenProvider {
    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        UpdateUtil.refreshElement((Element)parent);
        List children = new ArrayList();
        IVfsFolder vfsRootFolder = null;
        IDevelopmentComponentNode dcNode = null;
        String state = ComponentUtil.getEntityState(parent);
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        Object obj = ObjectUtil.getComponentObject((Element)parent);
        try {
            if (obj instanceof IDevelopmentComponentNode) {
                vfsRootFolder = ComponentUtil.getVfsComponentRootFolder((Element)parent);
                if (vfsRootFolder != null) {
                    DCFolderFileProvider.addDcListeners(vfsRootFolder);
                } else {
                    dcNode = (IDevelopmentComponentNode)obj;
                    String compFolder = dcNode.getComponentRootFolder();
                    File folder = new File(compFolder);
                    children = this.addFolderItems(children, folder, state, parent);
                }
            } else if (obj instanceof IVfsFolder) {
                vfsRootFolder = (IVfsFolder)obj;
            } else if (obj instanceof File) {
                children = this.addFolderItems(children, (File)obj, state, parent);
            }
            if (vfsRootFolder != null) {
                children = this.addVfsFolderItems(children, vfsRootFolder, state, parent);
            }
        }
        catch (Exception e) {
            shell.setCursor(null);
            return null;
        }
        shell.setCursor(null);
        return EnumerationConverter.toUniqueNameEnumeration(children.iterator());
    }

    private List addVfsFolderItems(List children, IVfsFolder vfsFolder, String state, Entity parent) throws VfsException {
        IVfsFolderItem[] items = vfsFolder.getFolderItems();
        int i = 0;
        while (i < items.length) {
            children.add(ComponentMetaDataUtil.createVfsFolderItem(parent, items[i], state));
            ++i;
        }
        return children;
    }

    private List addFolderItems(List children, File folderItem, String state, Entity parent) {
        if (folderItem.isDirectory()) {
            File[] files = folderItem.listFiles();
            int i = 0;
            while (i < files.length) {
                children.add(ComponentMetaDataUtil.createFileItem(parent, files[i], state));
                ++i;
            }
        }
        return children;
    }

    private static void addDcListeners(IVfsFolder vfsRootFolder) {
        if (vfsRootFolder != null) {
            VfsListener vfsListener = ComponentProviderPlugin.getPlugin().getMyVfsListener();
            IVersionedFileSystemManager manager = vfsRootFolder.getVersionedFileSystemManager();
            manager.addFolderItemListener((IVfsFolderItemListener)vfsListener);
            manager.addVersionListener((IVfsVersionListener)vfsListener);
        }
    }
}

