/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.objects.ComponentVfsModelObject;
import com.sap.ide.eclipse.component.provider.objects.DCModelObject;
import com.sap.ide.eclipse.component.provider.objects.DCProjectModelObject;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DCName;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDCVariantContext;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class ComponentUtil {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$ComponentUtil == null ? (class$com$sap$ide$eclipse$component$provider$ComponentUtil = ComponentUtil.class$("com.sap.ide.eclipse.component.provider.ComponentUtil")) : class$com$sap$ide$eclipse$component$provider$ComponentUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$ComponentUtil;

    public static boolean isLoginConfiguration(Element element) {
        if (element == null) {
            return false;
        }
        String domain = element.getUniqueName().getDomain();
        String subDomain = element.getUniqueName().getSubDomain();
        return domain.equals("com.sap.ide.eclipse.component.login") && subDomain.equals("com.sap.ide.eclipse.component.login.model");
    }

    public static boolean isLocal(UniqueName uName) {
        if (uName == null) {
            return false;
        }
        return uName.getSubDomain().equals("com.sap.ide.eclipse.component.local.model");
    }

    public static boolean isLocal(Element element) {
        if (element == null) {
            return false;
        }
        if ((element = ComponentUtil.getParentDevConfElement(element)) == null) {
            return false;
        }
        return ComponentUtil.isLocal(element.getUniqueName());
    }

    public static String getUniqueNameState(UniqueName uin) {
        DCProjectModelObject dcProjectObject;
        if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)uin) && (dcProjectObject = ObjectUtil.getDCProjectModelObject(uin)) != null) {
            uin = dcProjectObject.getDCNodeUin();
        }
        String state = null;
        if (uin != null) {
            state = uin.getParameter(0);
        }
        return state;
    }

    public static String getElementState(Element element) {
        if (element == null) {
            return null;
        }
        String state = ComponentUtil.getUniqueNameState(element.getUniqueName());
        return state;
    }

    public static String getEntityState(Entity entity) {
        if (entity == null) {
            return null;
        }
        String state = ComponentUtil.getUniqueNameState(entity.getUniqueName());
        return state;
    }

    public static boolean inOtherState(Element element) {
        Object obj = ObjectUtil.getComponentObject(element);
        if (!(obj instanceof IDevelopmentComponentNode)) {
            return true;
        }
        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
        DCNodeSyncMode mode = dcNode.getNodeSyncMode();
        if ((DCNodeSyncMode.SYNCHED_AS_ARCHIVE.equals(mode) || DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE.equals(mode)) && !ComponentUtil.isActive(element)) {
            return true;
        }
        return DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE.equals(mode) && ComponentUtil.isActive(element);
    }

    public static boolean isActive(Element element) {
        if (element == null) {
            return false;
        }
        String state = ComponentUtil.getElementState(element);
        if (state == null) {
            return false;
        }
        return state.equals("active");
    }

    public static boolean isDevConfElement(Element element) {
        if (element == null) {
            return false;
        }
        String domain = element.getUniqueName().getDomain();
        if (domain.equals("com.sap.ide.eclipse.component")) {
            String subdomain = element.getUniqueName().getSubDomain();
            if (subdomain.equals("com.sap.ide.eclipse.component.model")) {
                return true;
            }
            if (subdomain.equals("com.sap.ide.eclipse.component.local.model")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDCElement(Element element) {
        String subdomain;
        if (element == null) {
            return false;
        }
        String domain = element.getUniqueName().getDomain();
        return domain.equals("com.sap.ide.eclipse.component") && (subdomain = element.getUniqueName().getSubDomain()).equals("com.sap.ide.eclipse.component.DC");
    }

    public static boolean isSameState(IDevelopmentComponentNode dcNode, String state) {
        boolean ret = false;
        if (state == "active") {
            ret = true;
            if (dcNode.isSynchedAsInActiveSource()) {
                ret = false;
            }
        } else if (state == "inactive") {
            ret = true;
            if (dcNode.isSynchedAsArchives() || dcNode.isSynchedAsActiveSource()) {
                ret = false;
            }
        }
        return ret;
    }

    public static Element getParentDevConfElement(Element element) {
        while (element != null && !(ObjectUtil.getObject(element) instanceof IDevelopmentConfiguration)) {
            element = ObjectUtil.getComponentParent(element);
        }
        return element;
    }

    public static IDevelopmentConfiguration getParentDevConf(Element element) {
        Element e = ComponentUtil.getParentDevConfElement(element);
        if (e == null) {
            return null;
        }
        return (IDevelopmentConfiguration)ObjectUtil.getObject(e);
    }

    public static Element getParentCompartmentElement(Element element) {
        while (element != null && !(ObjectUtil.getObject(element) instanceof ICompartmentNode)) {
            element = ObjectUtil.getComponentParent(element);
        }
        return element;
    }

    public static ICompartmentNode getParentCompartmentNode(Element element) {
        Element e = ComponentUtil.getParentCompartmentElement(element);
        if (e == null) {
            return null;
        }
        return (ICompartmentNode)ObjectUtil.getObject(e);
    }

    public static ISoftwareComponentNode getParentSCNode(Element element) {
        ISoftwareComponentNode scNode = null;
        ICompartmentNode compartment = ComponentUtil.getParentCompartmentNode(element);
        if (compartment != null) {
            scNode = ComponentUtil.isActive(element) ? compartment.getActiveSCNode() : compartment.getInactiveSCNode();
        }
        return scNode;
    }

    public static Element getParentDCElement(Element element) {
        String sd = element.getUniqueName().getSubDomain();
        while (element != null && !sd.equals("com.sap.ide.eclipse.component.DC")) {
            if ((element = ObjectUtil.getComponentParent(element)) == null) {
                return null;
            }
            sd = element.getUniqueName().getSubDomain();
        }
        return element;
    }

    public static IDevelopmentComponentNode getParentDCNode(Element element) {
        IDevelopmentComponentNode dcNode = null;
        element = ComponentUtil.getParentDCElement(element);
        dcNode = ComponentUtil.getDCNode(element);
        return dcNode;
    }

    public static IDevelopmentComponentNode getDCNode(Element element) {
        Object obj = ObjectUtil.getComponentObject(element);
        if (!(obj instanceof IDevelopmentComponentNode)) {
            return null;
        }
        return (IDevelopmentComponentNode)obj;
    }

    public static Image getDCTypeImage(Element element) {
        IDevelopmentComponentNode dcNode;
        Image image = "inactive".equals(element.getUniqueName().getParameter(0)) ? ComponentCategoryImage.getImage("Development Component (inactive)") : ComponentCategoryImage.getImage("Development Component (active)");
        Object object = ObjectUtil.getComponentObject(element);
        if (object instanceof IDevelopmentComponentNode && (dcNode = (IDevelopmentComponentNode)object) != null) {
            try {
                image = ComponentTypeTreeViewer.getTypeImage(dcNode.getDevelopmentComponent(false).getComponentType());
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 3, "get typed DC Image failed", e);
            }
        }
        return image;
    }

    public static String getBuildVariant(IDevelopmentConfiguration devConf, String compartmentName) throws Exception {
        String buildVariant = null;
        try {
            buildVariant = Util.getBuildVariant(devConf, compartmentName);
        }
        catch (Exception e) {
            Util.logExceptionMessage(theTracer, 2, "Getting Build Variant failed", e);
            throw e;
        }
        return buildVariant;
    }

    public static String getBuildVariant(Element element) throws Exception {
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(element);
        ICompartmentNode compNode = ComponentUtil.getParentCompartmentNode(element);
        if (config == null || compNode == null) {
            return null;
        }
        Compartment compartment = compNode.getCompartment();
        String compName = compartment.getName();
        String buildVariant = ComponentUtil.getBuildVariant(config, compName);
        return buildVariant;
    }

    public static HashSet getDCVariantContexts(IDevelopmentConfiguration devConf, Collection dcCollection) throws Exception {
        String compName;
        HashSet<Set> variantContextSets = new HashSet<Set>();
        HashMap compMaps = new HashMap();
        List compList = null;
        Iterator<Object> it = dcCollection.iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            compName = dcNode.getCompartmentName();
            if (compMaps.containsKey(compName)) {
                compList = (List)compMaps.get(compName);
            } else {
                compList = new ArrayList();
                compMaps.put(compName, compList);
            }
            compList.add(new DCName(dcNode.getName(), dcNode.getVendor()));
        }
        Set compSet = compMaps.keySet();
        it = compSet.iterator();
        while (it.hasNext()) {
            compName = (String)it.next();
            String buildVariant = ComponentUtil.getBuildVariant(devConf, compName);
            compList = (List)compMaps.get(compName);
            Set variantContextSet = devConf.getDCVariantContexts(compName, buildVariant, compList.toArray(new DCName[compList.size()]));
            variantContextSets.add(variantContextSet);
        }
        return variantContextSets;
    }

    public static String getDCState(IDevelopmentComponentNode dcNode) {
        return dcNode.isAvailableInactive() ? "inactive" : "active";
    }

    public static DtriRelevantObjects getDtrRelevantObjects(Element element) {
        DtriRelevantObjects dtriObjects = new DtriRelevantObjects();
        Object obj = ObjectUtil.getComponentModelObject(element);
        if (obj instanceof ComponentVfsModelObject) {
            dtriObjects.addVfsFolderItem(((ComponentVfsModelObject)obj).getVfsFolderItem());
        }
        return dtriObjects;
    }

    public static IVfsFolder getVfsComponentRootFolder(Element element) {
        IVfsFolder vfsComponentRootFolder = null;
        Object obj = ObjectUtil.getComponentModelObject(element = ComponentUtil.getParentDCElement(element));
        if (obj instanceof DCModelObject) {
            DCModelObject dmo = (DCModelObject)obj;
            vfsComponentRootFolder = dmo.getVfsComponentRootFolder();
        }
        return vfsComponentRootFolder;
    }

    public static IVfsFolder getVfsComponentRootFolder(ICompartmentNode compNode, IDevelopmentComponentNode dcNode) {
        if (compNode == null || dcNode == null) {
            return null;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            return null;
        }
        Compartment compartment = compNode.getCompartment();
        if (compartment.isLocal()) {
            return null;
        }
        if (dcNode.isLocalOnlySource()) {
            return null;
        }
        if (DCNodeSyncMode.LOCAL_ONLY.equals(dcNode.getNodeSyncMode())) {
            return null;
        }
        if (!dcNode.hasSourceState()) {
            return null;
        }
        IVfsFolder vfsRootFolder = null;
        try {
            vfsRootFolder = dcNode.getVfsComponentRootFolder();
        }
        catch (RepositoryAccessException rae) {
            Util.logExceptionMessage(theTracer, 3, "get root folder failed", rae);
        }
        return vfsRootFolder;
    }

    public static String getDTRClientName(IDevelopmentComponentNode dcNode) {
        if (dcNode == null) {
            return null;
        }
        if (dcNode.isLocalOnlySource()) {
            return null;
        }
        if (DCNodeSyncMode.LOCAL_ONLY.equals(dcNode.getNodeSyncMode())) {
            return null;
        }
        if (!dcNode.hasSourceState()) {
            return null;
        }
        IDevelopmentConfiguration config = dcNode.getConfiguration();
        IClient client = null;
        try {
            client = config.getDTRClient();
        }
        catch (OfflineException e) {
            Util.logExceptionMessage(theTracer, 3, "get DTR Client failed", e);
        }
        if (client != null) {
            return client.getName();
        }
        return null;
    }

    public static ActionStatus syncDCsAsArchive(IProgressMonitor monitor, Collection dcCollection, boolean force) {
        IDevelopmentConfiguration devConf;
        ActionStatus result = ActionStatus.OKAY;
        HashMap devConfMaps = new HashMap();
        List<IDevelopmentComponentNode> dcList = new ArrayList();
        Iterator dcCollectionIt = dcCollection.iterator();
        while (dcCollectionIt.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)dcCollectionIt.next();
            devConf = dcNode.getConfiguration();
            if (devConfMaps.containsKey(devConf)) {
                dcList = (List)devConfMaps.get(devConf);
            } else {
                dcList = new ArrayList();
                devConfMaps.put(devConf, dcList);
            }
            dcList.add(dcNode);
        }
        monitor.beginTask("Syncing Archive(s)", 100);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Set devConfCollection = devConfMaps.keySet();
        Iterator devConfIt = devConfCollection.iterator();
        while (devConfIt.hasNext()) {
            devConf = (IDevelopmentConfiguration)devConfIt.next();
            if (devConf.isInOfflineMode()) continue;
            Collection dcCollectionTemp = (Collection)devConfMaps.get(devConf);
            monitor = new SubProgressMonitor(monitor, 100 / dcCollectionTemp.size());
            try {
                HashSet variantContexts = ComponentUtil.getDCVariantContexts(devConf, dcCollectionTemp);
                Iterator it1 = variantContexts.iterator();
                while (it1.hasNext()) {
                    Set set = (Set)it1.next();
                    Iterator it2 = set.iterator();
                    while (it2.hasNext()) {
                        IDCVariantContext variantContext = (IDCVariantContext)it2.next();
                        monitor.subTask("Syncing of " + variantContext.getDCName());
                        try {
                            devConf.syncAsArchives(variantContext, force);
                        }
                        catch (Throwable e) {
                            exceptions.add(e);
                            Util.logExceptionMessage(theTracer, 2, "Sync Archives failed for" + variantContext.getDCName(), e);
                        }
                        monitor.subTask("");
                        monitor.worked(100 / dcCollectionTemp.size());
                    }
                }
            }
            catch (Exception e) {
                result = new ActionStatus(false, e.getMessage(), e);
                Util.logExceptionMessage(theTracer, 2, "Sync Archives failed:", e);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

