/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.devconf.DevConfContentProvider;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.devconf.DevConfValidator;
import com.sap.ide.eclipse.component.devconf.LandScapeContentProvider;
import com.sap.ide.eclipse.component.provider.LSDValidator;
import com.sap.ide.eclipse.component.provider.listener.DCProjectModelListener;
import com.sap.ide.eclipse.component.provider.listener.DCProjectMoveDeleteHook;
import com.sap.ide.eclipse.component.provider.listener.DevConfLoginListener;
import com.sap.ide.eclipse.component.provider.listener.VfsListener;
import com.sap.ide.eclipse.component.provider.listener.WorkspaceResourceListener;
import com.sap.ide.eclipse.dii.component.DCBuildSettings;
import com.sap.ide.eclipse.dii.component.InfrastructureManager;
import com.sap.ide.login.IValidityCheckerWithProgress;
import com.sap.ide.login.LoginListenerWithProgress;
import com.sap.ide.login.UserValidator;
import com.sap.ide.ping.PingServerDialog;
import com.sap.tc.cbs.client.CBSFactory;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTCPHelper;
import com.tssap.util.ui.image.SapImageRegistry;
import java.io.PrintStream;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ComponentProviderPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.sap.ide.eclipse.component.provider";
    private static ComponentProviderPlugin pluginInstance;
    private static Shell myShell;
    private static VfsListener myVfsListener;
    private static SapImageRegistry myImageRegistry;

    public ComponentProviderPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        pluginInstance = this;
    }

    public static ComponentProviderPlugin getPlugin() {
        return pluginInstance;
    }

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PingServerDialog.addTreeContentProvider((ITreeContentProvider)new DevConfContentProvider());
                PingServerDialog.addTreeContentProvider((ITreeContentProvider)new LandScapeContentProvider());
                ModelAccess.addModelAccessListener((ModelAccessListener)new DCProjectModelListener());
                DAVTeamProvider.addMoveDeleteHook((IMoveDeleteHook)new DCProjectMoveDeleteHook());
                DevConfManager.initializeDevConfs();
                UserValidator.addValidityChecker((IValidityCheckerWithProgress)DevConfValidator.getDefaultServerValidator());
                UserValidator.addValidityChecker((IValidityCheckerWithProgress)LSDValidator.getDefaultValidator());
                InfrastructureManager.finishInitialisation();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)WorkspaceResourceListener.getListener());
                if (DCBuildSettings.promptLogonOnStart() && UserValidator.isDefaultServerLoginEnabled()) {
                    UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, null);
                }
            }
        });
    }

    public void startup() throws CoreException {
        super.startup();
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.DC", (boolean)true);
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.File", (boolean)false);
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.Folder", (boolean)true);
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.VfsFile", (boolean)false);
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.VfsFolder", (boolean)true);
        DataModelTCPHelper.addHandledDomain((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.Folder", (boolean)true);
        DevConfManager.removeNotDeletedFolders();
    }

    public Shell getMyShell() {
        if (myShell == null) {
            myShell = new Shell();
        }
        return myShell;
    }

    public VfsListener getMyVfsListener() {
        if (myVfsListener == null) {
            myVfsListener = new VfsListener();
        }
        return myVfsListener;
    }

    public SapImageRegistry getMyImageRegistry() {
        if (myImageRegistry == null) {
            myImageRegistry = new SapImageRegistry();
        }
        return myImageRegistry;
    }

    static {
        CBSFactory.setServerCallLogOutput((PrintStream)Logbook.getInfoChapter());
        UserValidator.addLoginListener((LoginListenerWithProgress)new DevConfLoginListener());
    }
}

