/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.provider;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.listener.DevConfListener;
import com.sap.ide.eclipse.component.provider.objects.ComponentModelObjectMap;
import com.sap.ide.eclipse.component.provider.objects.PackageObject;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevConfListener;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;

public class ComponentMetaDataUtil
extends ComponentModelObjectMap {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$provider$ComponentMetaDataUtil == null ? (class$com$sap$ide$eclipse$component$provider$ComponentMetaDataUtil = ComponentMetaDataUtil.class$("com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil")) : class$com$sap$ide$eclipse$component$provider$ComponentMetaDataUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$provider$ComponentMetaDataUtil;

    public static Model createAndRegisterModel(UniqueName uin, Object object) {
        Model model = ModelAccess.createModel((UniqueName)uin);
        ComponentModelObjectMap.addModel(model, object);
        return model;
    }

    public static UniqueName createDevConfLoginName() {
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.login", (String)"com.sap.ide.eclipse.component.login.model", null, (String)"OFFLINE", null);
        return uin;
    }

    public static Model createDevConfLogin() {
        UniqueName uin = ComponentMetaDataUtil.createDevConfLoginName();
        return ModelAccess.createModel((UniqueName)uin);
    }

    public static UniqueName createDevConfLocalName(String loc, String name) {
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.local.model", (String)loc.replace(':', '#'), (String)name.replace(':', '#'), null);
        return uin;
    }

    public static UniqueName createDevConfLocalName(IDevelopmentConfiguration devConf) {
        UniqueName uin = ComponentMetaDataUtil.createDevConfLocalName(devConf.getConfigurationRootFolder(), ComponentMetaDataUtil.getNumberedDevConfigName(devConf));
        return uin;
    }

    public static String getNumberedDevConfigName(IDevelopmentConfiguration devConf) {
        String number = ComponentMetaDataUtil.getConfigurationFolderNumber(devConf);
        return devConf.getConfigurationData().getCaption() + (number != null ? " [" + number + "]" : "");
    }

    private static String getConfigurationFolderNumber(IDevelopmentConfiguration devConf) {
        String number = null;
        String root = devConf.getConfigurationRootFolder();
        Path path = new Path(root);
        if (path != null) {
            String lastSegment = path.lastSegment();
            try {
                int value = Integer.parseInt(lastSegment);
                number = lastSegment;
            }
            catch (NumberFormatException e) {
                number = null;
            }
        }
        return number;
    }

    public static Model createDevConfLocal(IDevelopmentConfiguration devConf) {
        UniqueName uin = ComponentMetaDataUtil.createDevConfLocalName(devConf);
        devConf.registerDevConfListener((IDevConfListener)DevConfListener.getDevConfListener());
        return ComponentMetaDataUtil.createAndRegisterModel(uin, devConf);
    }

    public static UniqueName createDevConfName(String loc, String name) {
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.model", (String)loc.replace(':', '#'), (String)name.replace(':', '#'), null);
        return uin;
    }

    public static UniqueName createDevConfName(IDevelopmentConfiguration devConf) {
        UniqueName uin = ComponentMetaDataUtil.createDevConfName(devConf.getConfigurationRootFolder(), ComponentMetaDataUtil.getNumberedDevConfigName(devConf));
        return uin;
    }

    public static Model createDevConf(IDevelopmentConfiguration config) {
        UniqueName uin = ComponentMetaDataUtil.createDevConfName(config);
        config.registerDevConfListener((IDevConfListener)DevConfListener.getDevConfListener());
        return ComponentMetaDataUtil.createAndRegisterModel(uin, config);
    }

    public static UniqueName createCompartmentName(Compartment compartment) {
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.compartment", (String)(compartment.getScName() + " (" + compartment.getScVendor() + ")"), (String)compartment.getCaption(), null);
        return uin;
    }

    public static UniqueName createCompartmentName(ICompartmentNode compNode) {
        Compartment compartment = compNode.getCompartment();
        return ComponentMetaDataUtil.createCompartmentName(compartment);
    }

    protected static UniqueName createCompartment(Entity parent, ICompartmentNode compNode) {
        UniqueName uin = ComponentMetaDataUtil.createCompartmentName(compNode);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, compNode);
        return uin;
    }

    public static UniqueName createSCActiveName(Compartment compartment) {
        String[] param = new String[]{"active"};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.SC.active", (String)(compartment.getScName() + " (" + compartment.getScVendor() + ")"), (String)compartment.getCaption(), (String[])param);
        return uin;
    }

    public static UniqueName createSCActive(Entity parent, ICompartmentNode compNode) {
        UniqueName uin = ComponentMetaDataUtil.createSCActiveName(compNode.getCompartment());
        ComponentModelObjectMap.addComponentModelObject(parent, uin, compNode);
        return uin;
    }

    public static UniqueName createSCInactiveName(Compartment compartment) {
        String[] param = new String[]{"inactive"};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.SC.inactive", (String)(compartment.getScName() + " (" + compartment.getScVendor() + ")"), (String)compartment.getCaption(), (String[])param);
        return uin;
    }

    public static UniqueName createSCInactive(Entity parent, ICompartmentNode compNode) {
        UniqueName uin = ComponentMetaDataUtil.createSCInactiveName(compNode.getCompartment());
        ComponentModelObjectMap.addComponentModelObject(parent, uin, compNode);
        return uin;
    }

    public static UniqueName createDCName(IDevelopmentComponentNode dcNode, String state) {
        String[] param = new String[]{state, dcNode.getVendor()};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.DC", null, (String)dcNode.getName(), (String[])param);
        return uin;
    }

    public static UniqueName createDCName(DevelopmentComponent dc, String state) {
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)"com.sap.ide.eclipse.component.DC", null, (String)dc.getName(), (String[])param);
        return uin;
    }

    protected static UniqueName createDC(Entity parent, ICompartmentNode compNode, IDevelopmentComponentNode dcNode, String state) {
        IProject project;
        UniqueName projectUin = null;
        UniqueName dcUin = ComponentMetaDataUtil.createDCName(dcNode, state);
        if (ComponentUtil.isSameState(dcNode, state) && (project = DCProjectUtil.getProject(dcNode)) != null && project.isAccessible()) {
            projectUin = ModelAccess.createModelUniqueName((String)project.getName());
            ComponentModelObjectMap.addDCProjectModelObject(parent, projectUin, dcUin, project);
        }
        ComponentModelObjectMap.addDCModelObject(parent, dcUin, compNode, dcNode, projectUin);
        return dcUin;
    }

    public static UniqueName createVfsFolderItemName(IVfsFolderItem folderItem, String state) {
        String vfsDomain = "com.sap.ide.eclipse.component.VfsFolder";
        if (folderItem instanceof IVfsFile) {
            vfsDomain = "com.sap.ide.eclipse.component.VfsFile";
        }
        String name = folderItem.getName();
        String loc = folderItem.getAbsoluteRemotePath();
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)vfsDomain, (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createVfsFolderItem(Entity parent, IVfsFolderItem folderItem, String state) {
        UniqueName folderItemName = ComponentMetaDataUtil.createVfsFolderItemName(folderItem, state);
        ComponentModelObjectMap.addComponentVfsModelObject(parent, folderItemName, folderItem);
        return folderItemName;
    }

    public static UniqueName createFileItemName(File file, String state) {
        String fileDomain = "com.sap.ide.eclipse.component.File";
        if (file.isDirectory()) {
            fileDomain = "com.sap.ide.eclipse.component.Folder";
        }
        String name = file.getName();
        String loc = file.getAbsolutePath().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component", (String)fileDomain, (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createFileItem(Entity parent, File file, String state) {
        UniqueName fileItemName = ComponentMetaDataUtil.createFileItemName(file, state);
        ComponentModelObjectMap.addComponentModelObject(parent, fileItemName, file);
        return fileItemName;
    }

    public static UniqueName createDCMetaDataName(Element parent, String state) {
        String name = "DC MetaData";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.Folder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createDCMetaData(Entity parent, IDevelopmentComponentNode dcNode, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDCMetaDataName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dcNode);
        return uin;
    }

    public static UniqueName createDCDefinitionName(Element parent, String state) {
        String name = "DC Definition";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCDefinition", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createDCDefinition(Entity parent, IDevelopmentComponentNode dcNode, String state) {
        IVersionedFileSystemManager vfsm;
        IVfsFolderItem vfsFolderItem = null;
        IVfsFolder rootFolder = ComponentUtil.getVfsComponentRootFolder((Element)parent);
        if (rootFolder != null && (vfsm = rootFolder.getVersionedFileSystemManager()) != null) {
            String fileName = ".dcdef";
            try {
                vfsFolderItem = vfsm.getFolderItem(rootFolder.getLocalPath() + fileName);
            }
            catch (VfsException e) {
                Util.logExceptionMessage(theTracer, 3, "Create Default Configuration failed", e);
            }
        }
        UniqueName uin = ComponentMetaDataUtil.createDCDefinitionName((Element)parent, state);
        ComponentModelObjectMap.addComponentVfsModelObject(parent, uin, dcNode, vfsFolderItem);
        return uin;
    }

    public static UniqueName createPPFolderName(Element parent, String state) {
        String name = "Public Parts";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPPFolder(Entity parent, DevelopmentComponent dc, String state) {
        IVersionedFileSystemManager vfsm;
        UniqueName uin = ComponentMetaDataUtil.createPPFolderName((Element)parent, state);
        IVfsFolderItem vfsFolderItem = null;
        IVfsFolder rootFolder = ComponentUtil.getVfsComponentRootFolder((Element)parent);
        if (rootFolder != null && (vfsm = rootFolder.getVersionedFileSystemManager()) != null) {
            String folderName = "def";
            String rootPath = rootFolder.getLocalPath();
            if (rootPath != null) {
                String folderPath = rootPath + folderName;
                new File(folderPath).mkdirs();
                try {
                    vfsFolderItem = vfsm.getFolderItem(folderPath);
                }
                catch (VfsException e) {
                    Util.logExceptionMessage(theTracer, 3, "Create PP Folder failed", e);
                }
            }
        }
        ComponentModelObjectMap.addComponentVfsModelObject(parent, uin, dc, vfsFolderItem);
        return uin;
    }

    public static UniqueName createPPMetaDataName(UniqueName parentUN, String aPPName, String state) {
        String name = aPPName;
        String loc = parentUN.toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPMetaData", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPPMetaData(Entity parent, DevelopmentComponent dc, PublicPart aPP, String state) {
        IVersionedFileSystemManager vfsm;
        UniqueName uin = ComponentMetaDataUtil.createPPMetaDataName(parent.getUniqueName(), aPP.getName(), state);
        IVfsFolderItem vfsFolderItem = null;
        IVfsFolder rootFolder = ComponentUtil.getVfsComponentRootFolder((Element)parent);
        if (rootFolder != null && (vfsm = rootFolder.getVersionedFileSystemManager()) != null) {
            String fileName = "def" + File.separator + uin.getName() + ".pp";
            try {
                vfsFolderItem = vfsm.getFolderItem(rootFolder.getLocalPath() + fileName);
            }
            catch (VfsException e) {
                Util.logExceptionMessage(theTracer, 3, "Create PP MetaData failed", e);
            }
        }
        ComponentModelObjectMap.addComponentVfsModelObject(parent, uin, aPP, vfsFolderItem);
        return uin;
    }

    public static UniqueName createPackageFolderName(Element parent, String state) {
        String name = "Package Names";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PackageFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPackageFolder(Entity parent, DevelopmentComponent dc, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPackageFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dc);
        return uin;
    }

    public static UniqueName createDependencyFolderName(Element parent, String state) {
        String name = "Used DCs";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCDependencyFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createDependencyFolder(Entity parent, DevelopmentComponent dc, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDependencyFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dc);
        return uin;
    }

    protected static UniqueName createDcAccessListFolder(Entity parent, DevelopmentComponent dc, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcAccessListFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dc);
        return uin;
    }

    protected static UniqueName createDcFolderFolder(Entity parent, DevelopmentComponent dc, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcFolderFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dc);
        return uin;
    }

    public static UniqueName createDcFolderFolderName(Element parent, String state) {
        String name = "Folders";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCFolderFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPPAccessListFolder(Entity parent, PublicPart pp, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPAccessListFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, pp);
        return uin;
    }

    protected static UniqueName createPPEntityFolder(Entity parent, PublicPart pp, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPEntityFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, pp);
        return uin;
    }

    protected static UniqueName createPPEntityReferenceFolder(Entity parent, PublicPart aPP, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPEntityReferenceFolderName((Element)parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, aPP);
        return uin;
    }

    public static UniqueName createPPEntityReferenceFolderName(Element parent, String state) {
        String name = "Entity References";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPEntityReferenceFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    public static UniqueName createPPEntityFolderName(Element parent, String state) {
        String name = "Entities";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPEntityFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    public static UniqueName createPPAccessListFolderName(Element parent, String state) {
        String name = "Access List";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPAccessListFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    public static UniqueName createDcAccessListFolderName(Element parent, String state) {
        String name = "Access List";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.AccessListFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    public static UniqueName createPPEntityName(UniqueName aParentUniqueName, com.sap.tc.complib.Entity entity, String state) {
        String name = entity.getName();
        String type = entity.getType();
        String subType = entity.getSubType();
        String packageName = entity.getPackageName();
        String loc = aParentUniqueName.toString().replace(':', '#');
        String[] param = new String[]{state, type, subType != null ? subType : "", packageName != null ? packageName : ""};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPEntity", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPPEntity(Entity parent, com.sap.tc.complib.Entity entity, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPEntityName(parent.getUniqueName(), entity, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, entity);
        return uin;
    }

    protected static UniqueName createPPEntityReference(Entity parent, EntityReference entityRef, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPEntityReferenceName(parent.getUniqueName(), entityRef, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, entityRef);
        return uin;
    }

    public static UniqueName createPPEntityReferenceName(UniqueName aParentUniqueName, EntityReference entityRef, String state) {
        String ppRef = entityRef.getPublicPart();
        String name = entityRef.getName();
        String type = entityRef.getType();
        String dcName = entityRef.getComponent().getName();
        String dcVendor = entityRef.getComponent().getVendor();
        String scAlias = entityRef.getComponent().getSCAlias();
        String loc = aParentUniqueName.toString().replace(':', '#');
        String[] param = new String[]{state, dcName, dcVendor, scAlias == null ? "" : scAlias, name == null ? "" : name, type == null ? "" : type};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPEntityReference", (String)loc, (String)ppRef, (String[])param);
        return uin;
    }

    public static UniqueName createDcDependencyName(UniqueName aParentUniqueName, Dependency dependency, String state) {
        UniqueName uin = null;
        DCReference dcRef = dependency.getComponent();
        String aPPName = dependency.getPublicPart();
        String scAlias = dependency.getComponent().getSCAlias();
        StringBuffer name = new StringBuffer(dcRef.getName());
        if (aPPName != null && !aPPName.trim().equals("")) {
            name.append(" (").append(aPPName).append(")");
        }
        StringBuffer flags = new StringBuffer();
        flags.append(dependency.isAtBuildTime() ? "true" : "false");
        flags.append(dependency.isAtDeployTime() ? "true" : "false");
        flags.append(dependency.isAtDesignTime() ? "true" : "false");
        flags.append(dependency.isAtRunTime() ? "true" : "false");
        flags.append(dependency.isForChildrenOnly() ? "true" : "false");
        String loc = aParentUniqueName.toString().replace(':', '#');
        String[] param = new String[]{state, scAlias != null ? scAlias : "", aPPName != null ? aPPName : "", flags.toString()};
        uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCDependency", (String)loc, (String)name.toString(), (String[])param);
        return uin;
    }

    protected static UniqueName createDcDependency(Entity parent, Dependency dependency, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcDependencyName(parent.getUniqueName(), dependency, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dependency);
        return uin;
    }

    protected static UniqueName createDcGrant(Entity parent, ComponentReference grant, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcGrantName(parent.getUniqueName(), grant, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, grant);
        return uin;
    }

    protected static UniqueName createDcSourceFolder(Entity parent, String aFolder, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcSourceFolderName(parent.getUniqueName(), aFolder, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, aFolder);
        return uin;
    }

    public static UniqueName createDcSourceFolderName(UniqueName aParentUniqueName, String aFolder, String state) {
        UniqueName uin = null;
        try {
            String type = "(source) ";
            String name = type + aFolder;
            String loc = aParentUniqueName.toString().replace(':', '#');
            String[] param = new String[]{state};
            uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCFolder", (String)loc, (String)name, (String[])param);
        }
        catch (Exception VfsException2) {
            Util.logExceptionMessage(theTracer, 3, "Create Src Folder failed", VfsException2);
        }
        return uin;
    }

    protected static UniqueName createDcPackageFolder(Entity parent, String aFolder, String state) {
        UniqueName uin = ComponentMetaDataUtil.createDcPackageFolderName(parent.getUniqueName(), aFolder, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, aFolder);
        return uin;
    }

    public static UniqueName createDcPackageFolderName(UniqueName aParentUniqueName, String aFolder, String state) {
        UniqueName uin = null;
        try {
            String type = "(package) ";
            String name = type + aFolder;
            String loc = aParentUniqueName.toString().replace(':', '#');
            String[] param = new String[]{state};
            uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCFolder", (String)loc, (String)name, (String[])param);
        }
        catch (Exception VfsException2) {
            Util.logExceptionMessage(theTracer, 3, "Create Src Folder failed", VfsException2);
        }
        return uin;
    }

    public static UniqueName createDcGrantName(UniqueName aParentUniqueName, ComponentReference grant, String state) {
        UniqueName uin = null;
        String name = grant.getName();
        String loc = aParentUniqueName.toString().replace(':', '#');
        String[] param = new String[]{state};
        uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.AccessList", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static UniqueName createPPGrant(Entity parent, ComponentReference grant, String state) {
        UniqueName uin = ComponentMetaDataUtil.createPPGrantName(parent.getUniqueName(), grant, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, grant);
        return uin;
    }

    public static UniqueName createPPGrantName(UniqueName aParentUniqueName, ComponentReference grant, String state) {
        UniqueName uin = null;
        String name = grant.getName();
        String loc = aParentUniqueName.toString().replace(':', '#');
        String[] param = new String[]{state};
        uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.PPAccessList", (String)loc, (String)name, (String[])param);
        return uin;
    }

    public static UniqueName createChildrenDCsFolderName(Entity parent, String state) {
        String name = "Child DCs";
        String loc = parent.getUniqueName().toString().replace(':', '#');
        String[] param = new String[]{state};
        UniqueName uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.DCChildrenFolder", (String)loc, (String)name, (String[])param);
        return uin;
    }

    protected static Object createChildrenDCsFolder(Entity parent, IDevelopmentComponentNode dcNode, String state) {
        UniqueName uin = ComponentMetaDataUtil.createChildrenDCsFolderName(parent, state);
        ComponentModelObjectMap.addComponentModelObject(parent, uin, dcNode);
        return uin;
    }

    public static UniqueName createPackageName(Entity parent, String name) {
        UniqueName uin = null;
        String loc = parent.getUniqueName().toString().replace(':', '#');
        uin = ModelAccess.createUniqueName((String)"com.sap.ide.eclipse.component.DCMetaData", (String)"com.sap.ide.eclipse.component.DCMetaData.Package", (String)loc, (String)name, null);
        return uin;
    }

    protected static UniqueName createPackage(IPackageFragment fragment, Entity parent) {
        UniqueName uin = ComponentMetaDataUtil.createPackageName(parent, fragment.getElementName());
        AllocationState mState = null;
        ComponentModelObjectMap.addComponentModelObject(parent, uin, new PackageObject(fragment, mState));
        return uin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

