/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DTRServerData;
import com.sap.ide.eclipse.component.devconf.DevConfServerData;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.NameAllocator;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.security.KeyStore;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class NameServerData
extends DTRServerData {
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public NameServerData(String nameServer, DevConfServerData parentData) {
        super(nameServer, parentData);
    }

    public Image getImage() {
        return ComponentCategoryImage.getImage("Name Server");
    }

    public void runCheck() {
        Map map = DTRServerData.serverMap;
        synchronized (map) {
            Object obj = DTRServerData.serverMap.get(this.myServer);
            if (obj instanceof DTRServerData) {
                NameServerData data = (NameServerData)((Object)obj);
                this.setState(data.getState());
                this.setResponseTime(data.getResponseTime());
                this.updateParent();
                return;
            }
        }
        boolean pingOK = false;
        long time = -1L;
        long start = System.currentTimeMillis();
        try {
            URL url = new URL(this.myServer);
            pingOK = NameAllocator.pingNameServer((URL)url, (KeyStore)UserValidator.getKeyStore());
        }
        catch (Throwable ex) {
            Util.logExceptionMessage(this.theTracer, 2, "ping Name Server " + this.myServer + " failed", ex);
        }
        time = System.currentTimeMillis() - start;
        if (pingOK) {
            this.setState("ok");
        } else {
            this.setState("failed");
        }
        this.setResponseTime(time);
        this.updateParent();
        Map map2 = DTRServerData.serverMap;
        synchronized (map2) {
            DTRServerData.serverMap.put(this.myServer, this);
        }
    }
}

