/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferencePage;
import com.sap.ide.login.UserValidator;
import com.sap.ide.ping.ServerData;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Date;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class LandScapeContentProvider
implements ITreeContentProvider {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String) {
            if ("root".equals(parentElement)) {
                UserValidator.Data userData = UserValidator.getDefaultServerData();
                if (UserValidator.isDefaultServerOnline() || userData != null) {
                    String password = userData.getPassword();
                    String user = userData.getUser();
                    CIMClient cimClient = null;
                    try {
                        cimClient = DevConfManager.getCIMClient(user, password, UserValidator.getKeyStore());
                    }
                    catch (CIMClientException e) {
                        Util.logExceptionMessage(this.theTracer, 3, "Get Landscape Directory Client failed", e);
                    }
                    if (cimClient != null) {
                        return new Object[]{new LandScapeData()};
                    }
                }
            }
            return null;
        }
        if (parentElement instanceof ServerData) {
            return ((ServerData)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String && "root".equals(element)) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] objs = this.getChildren(inputElement);
        if (objs == null) {
            return new Object[0];
        }
        return objs;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static class LandScapeData
    extends ServerData {
        private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

        public boolean hasChildren() {
            return false;
        }

        public ServerData[] getChildren() {
            return new ServerData[0];
        }

        public ServerData getParent() {
            return null;
        }

        public void runCheck() {
            UserValidator.Data userData = UserValidator.getDefaultServerData();
            if (!UserValidator.isDefaultServerOnline() || userData == null) {
                this.setState("unknown");
                this.setResponseTime(-1L);
                return;
            }
            String password = userData.getPassword();
            String user = userData.getUser();
            CIMClient cimClient = null;
            try {
                cimClient = DevConfManager.getCIMClient(user, password, UserValidator.getKeyStore());
            }
            catch (CIMClientException e) {
                Util.logExceptionMessage(this.theTracer, 3, "Get Landscape Directory Client failed", e);
            }
            if (cimClient == null) {
                this.setState("unknown");
                this.setResponseTime(-1L);
                return;
            }
            boolean pingOk = true;
            long time = -1L;
            Date start = new Date();
            try {
                cimClient.ping();
            }
            catch (Throwable ex) {
                pingOk = false;
            }
            Date end = new Date();
            time = end.getTime() - start.getTime();
            this.setState(pingOk ? "ok" : "failed");
            this.setResponseTime(time);
        }

        public String getName() {
            return DevConfPreferencePage.getDevConfPoolURL();
        }

        public Image getImage() {
            return ComponentCategoryImage.getImage("Landscape Directory");
        }
    }
}

