/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.login.IValidityCheckerWithProgress;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class DevConfValidator
implements IValidityCheckerWithProgress {
    protected static DevConfValidator defaultValidator;
    protected static List serverChecker;
    protected Map nameServerMap = null;
    protected Map buildServerMap = null;
    protected Map dtrServerMap = null;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private String message = "";
    private int severity = -1;
    private boolean atLeastOneOK = false;

    public DevConfValidator() {
        DevConfValidator.update();
    }

    public static void update() {
        DevConfValidator.getServerChecker().clear();
        List configs = DevConfManager.getInstalledDevConfs();
        if (configs != null) {
            DevConfValidator.getServerChecker().addAll(configs);
        }
        UserValidator.enableLoginButton();
    }

    public IStatus validate(UserValidator.Data data, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.severity = -1;
        this.atLeastOneOK = false;
        this.message = "";
        this.getNameServerMap().clear();
        this.getBuildServerMap().clear();
        this.getDtrServerMap().clear();
        if (DevConfValidator.getServerChecker().isEmpty()) {
            return new Status(0, "com.sap.ide.eclipse.component.provider", -1, "No Development Configurations are imported.", null);
        }
        try {
            ConnectionContext context = new ConnectionContext(data.getUser(), data.getPassword(), UserValidator.getKeyStore(), null);
            Iterator it = DevConfValidator.getServerChecker().iterator();
            while (it.hasNext()) {
                IDevelopmentConfiguration config = (IDevelopmentConfiguration)it.next();
                this.checkBuildServer(context, config, monitor);
                this.checkDTRserver(context, config, monitor);
                this.checkNameServer(context, config, monitor);
            }
        }
        catch (AuthenticationException e) {
            Util.logExceptionMessage(this.theTracer, 3, "user or password are invalid", e);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "ping devConfiguration servers failed", e);
        }
        if (this.severity == 4 && this.atLeastOneOK) {
            this.severity = 2;
        } else if (this.severity == -1) {
            this.severity = 0;
        }
        monitor.subTask("");
        return new Status(this.severity, "com.sap.ide.eclipse.component.provider", 0, this.message, null);
    }

    private void checkDTRserver(ConnectionContext context, IDevelopmentConfiguration config, IProgressMonitor monitor) throws AuthenticationException {
        Map map;
        if (!config.isLocalConfiguration() && (map = config.getConfigurationData().getCompartments()) != null) {
            String[] names = config.getRepositoryServerURLs();
            HashSet<String> nameSet = new HashSet<String>();
            nameSet.addAll(Arrays.asList(names));
            Iterator dtrURLs = nameSet.iterator();
            while (dtrURLs.hasNext()) {
                String dtrServer = (String)dtrURLs.next();
                IStatus dtrStatus = (IStatus)this.getDtrServerMap().get(dtrServer);
                if (dtrStatus != null && (4 == dtrStatus.getSeverity() || 2 == dtrStatus.getSeverity())) {
                    return;
                }
                monitor.subTask("DTR Server: " + dtrServer);
                int result = 2;
                result = config.pingDTRServer(dtrServer, 3, 3000, (IConnectionContext)context);
                String location = "DTR Server " + dtrServer + " ";
                if (result == 0) {
                    this.atLeastOneOK = true;
                    continue;
                }
                String dtrMessage = DevConfValidator.getMessage(location, result);
                dtrStatus = new Status(4, "com.sap.ide.eclipse.component.provider", 0, dtrMessage, null);
                this.updateStstusData(dtrStatus);
                if (result != 1) continue;
                this.getDtrServerMap().put(dtrServer, dtrStatus);
                throw new AuthenticationException("User is not authorized");
            }
        }
    }

    private void checkBuildServer(ConnectionContext context, IDevelopmentConfiguration config, IProgressMonitor monitor) throws AuthenticationException {
        int buildServerResult = 0;
        String buildServer = config.getConfigurationData().getBuildServer();
        if (buildServer != null && buildServer.length() > 0) {
            IStatus buildSrvStatus = (IStatus)this.getBuildServerMap().get(buildServer);
            if (buildSrvStatus == null) {
                monitor.subTask("Build Server: " + buildServer);
                try {
                    buildServerResult = config.pingBuildServer(2, 2500, (IConnectionContext)context);
                }
                catch (Throwable ex) {
                    this.theTracer.log(6, "ping Buld Server failed", ex);
                    buildServerResult = -1;
                }
                String bsMessage = DevConfValidator.getMessage("Build Server " + buildServer, buildServerResult);
                buildSrvStatus = buildServerResult == 0 ? new Status(0, "com.sap.ide.eclipse.component.provider", 0, bsMessage, null) : new Status(4, "com.sap.ide.eclipse.component.provider", 0, bsMessage, null);
                this.updateStstusData(buildSrvStatus);
                this.getBuildServerMap().put(buildServer, buildSrvStatus);
                if (1 == buildServerResult) {
                    throw new AuthenticationException("User is not authorized");
                }
            }
            if (buildSrvStatus.getSeverity() == 0) {
                monitor.subTask("Build Space: " + config.getConfigurationData().getName());
                try {
                    buildServerResult = config.pingBuildSpace((IConnectionContext)context);
                }
                catch (Exception ex) {
                    this.theTracer.log(6, "ping Buld Space failed", (Throwable)ex);
                    buildServerResult = 2;
                }
                this.message = this.message + DevConfValidator.getMessage("Build Space " + buildServer, config.getConfigurationData().getName(), buildServerResult);
            }
            if (buildServerResult == 0) {
                this.atLeastOneOK = true;
            } else {
                this.severity = 4;
            }
        }
    }

    private void checkNameServer(ConnectionContext context, IDevelopmentConfiguration config, IProgressMonitor monitor) throws AuthenticationException {
        String nameserver = config.getConfigurationData().getNameServer();
        if (nameserver != null) {
            IStatus nsStatus = (IStatus)this.getNameServerMap().get(nameserver);
            if (nsStatus != null) {
                return;
            }
            monitor.subTask("Name Server: " + nameserver);
            URL url = null;
            boolean pingPassed = false;
            try {
                url = new URL(nameserver);
                pingPassed = NameAllocator.pingNameServer((URL)url, (KeyStore)UserValidator.getKeyStore());
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "ping nameserver " + nameserver + " failed", e);
                pingPassed = false;
            }
            if (!pingPassed) {
                nsStatus = new Status(2, "com.sap.ide.eclipse.component.provider", 0, DevConfValidator.getMessage("Name Server " + nameserver, 2), null);
                this.updateStstusData(nsStatus);
            } else {
                boolean exceptionThrown = false;
                try {
                    pingPassed = NameAllocator.checkUserOnNameServer((URL)url, (String)context.getUserName(), (String)context.getPassword(), (KeyStore)UserValidator.getKeyStore());
                }
                catch (CommunicationFailureException e1) {
                    Util.logExceptionMessage(this.theTracer, 2, "check User for nameserver " + nameserver + " failed", e1);
                    nsStatus = new Status(2, "com.sap.ide.eclipse.component.provider", 0, DevConfValidator.getMessage("Name Server " + nameserver, 2), null);
                    this.updateStstusData(nsStatus);
                    exceptionThrown = true;
                }
                if (!pingPassed && !exceptionThrown) {
                    nsStatus = new Status(2, "com.sap.ide.eclipse.component.provider", 0, DevConfValidator.getMessage("Name Server " + nameserver, 1), null);
                    this.updateStstusData(nsStatus);
                    this.getNameServerMap().put(nameserver, nsStatus);
                    throw new AuthenticationException("User is not authorized");
                }
            }
            if (nsStatus == null) {
                nsStatus = new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
            }
            this.getNameServerMap().put(nameserver, nsStatus);
        }
    }

    private void updateStstusData(IStatus nsStatus) {
        if (nsStatus.getMessage() != null && nsStatus.getMessage().length() > 0) {
            if (this.message == null) {
                this.message = "";
            }
            this.message = this.message + nsStatus.getMessage();
        }
        switch (nsStatus.getSeverity()) {
            case 4: {
                this.severity = nsStatus.getSeverity();
                break;
            }
            case 2: {
                if (this.severity == 4) break;
                this.severity = nsStatus.getSeverity();
                break;
            }
            case 1: {
                if (this.severity == 4 || this.severity == 2) break;
                this.severity = nsStatus.getSeverity();
                break;
            }
        }
    }

    private static List getServerChecker() {
        if (serverChecker == null) {
            serverChecker = new ArrayList();
        }
        return serverChecker;
    }

    public static DevConfValidator getDefaultServerValidator() {
        if (defaultValidator == null) {
            defaultValidator = new DevConfValidator();
        }
        return defaultValidator;
    }

    private static String getMessage(String url, String configName, int pingResult) {
        String message = "";
        switch (pingResult) {
            case 0: {
                break;
            }
            case 1: {
                message = url + ": Invalid Username and/or Password\n";
                break;
            }
            case 2: {
                message = url + " is unreachable.\n";
                break;
            }
            case 3: {
                message = " There is no Build Space with Identifier '" + configName + "'\n";
                break;
            }
            default: {
                message = "Ping of " + url + " failed. For more Information see Error Log\n";
            }
        }
        return message;
    }

    private static String getMessage(String url, int pingResult) {
        return DevConfValidator.getMessage(url, "", pingResult);
    }

    public boolean canValidate(IProgressMonitor monitor) {
        Iterator it;
        if (!DevConfValidator.getServerChecker().isEmpty()) {
            List list = DevConfValidator.getServerChecker();
            it = list.iterator();
            while (it.hasNext()) {
                IDevelopmentConfiguration devCnf = (IDevelopmentConfiguration)it.next();
                if (!devCnf.isLoginRequired()) continue;
                return true;
            }
        }
        try {
            IConfiguration config = Configuration.getConfiguration();
            if (config != null && (it = config.clients()) != null && it.hasNext()) {
                return true;
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "Check for Login Validation failed", e);
        }
        return false;
    }

    protected Map getBuildServerMap() {
        if (this.buildServerMap == null) {
            this.buildServerMap = new HashMap();
        }
        return this.buildServerMap;
    }

    protected Map getDtrServerMap() {
        if (this.dtrServerMap == null) {
            this.dtrServerMap = new HashMap();
        }
        return this.dtrServerMap;
    }

    protected Map getNameServerMap() {
        if (this.nameServerMap == null) {
            this.nameServerMap = new HashMap();
        }
        return this.nameServerMap;
    }

    static {
        serverChecker = null;
    }
}

