/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.devconf.BuildServerData;
import com.sap.ide.eclipse.component.devconf.DTRServerData;
import com.sap.ide.eclipse.component.devconf.NameServerData;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.ping.ServerData;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DevConfServerData
extends ServerData {
    IDevelopmentConfiguration devConfig = null;
    List children;

    public DevConfServerData(IDevelopmentConfiguration devConfig) {
        this.devConfig = devConfig;
    }

    public boolean hasChildren() {
        return true;
    }

    public ServerData[] getChildren() {
        if (this.children == null) {
            String nameServer;
            this.children = new ArrayList();
            String[] urls = this.devConfig.getRepositoryServerURLs();
            if (urls != null) {
                HashSet<String> dtrServerSet = new HashSet<String>();
                dtrServerSet.addAll(Arrays.asList(urls));
                Iterator it = dtrServerSet.iterator();
                while (it.hasNext()) {
                    String dtrSrver = (String)it.next();
                    this.children.add(new DTRServerData(dtrSrver, this));
                }
            }
            if ((nameServer = this.devConfig.getConfigurationData().getNameServer()) != null && nameServer.length() > 0) {
                this.children.add(new NameServerData(nameServer, this));
            }
            if (this.devConfig.isWithBuildServer()) {
                this.children.add(new BuildServerData(this.devConfig.getBuildServer(), this));
            }
        }
        return this.children.toArray(new ServerData[this.children.size()]);
    }

    public ServerData getParent() {
        return null;
    }

    public void runCheck() {
        this.setState("ok");
        this.setResponseTime(-1L);
    }

    public String getName() {
        String name = this.devConfig.getConfigurationData().getCaption();
        if (name == null) {
            name = this.devConfig.getConfigurationData().getName();
        }
        if (name == null) {
            name = "Unknown Development Configuration";
        }
        return name;
    }

    public Image getImage() {
        return ComponentCategoryImage.getImage("Configuration");
    }

    public IDevelopmentConfiguration getDevConfig() {
        return this.devConfig;
    }
}

