/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.cms.client.ideAPI.CmsConfiguration;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfUtil;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.DevConfRemoveAction;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferencePage;
import com.sap.ide.eclipse.component.wizard.DevConfWizard;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.sapmodel.CIMInstancenameJavacimobject;
import com.sap.lcr.api.sapmodel.CIMInstancepathJavacimobject;
import com.sap.lcr.api.sapmodel.JavaCIMObject;
import com.sap.lcr.api.sapmodel.SAP_CMSMaintainedConfiguration;
import com.sap.lcr.api.sapmodel.SAP_ChangeManagementServer;
import com.sap.lcr.api.sapmodel.SAP_DesignTimeConfiguration;
import com.sap.lcr.api.sapmodel.SAP_DesignTimeConfigurationAccessor;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DevConfManager {
    private static final String TO_DELETE_DEV_CONF_FOLDER = "TO_DELETE_DEV_CONF_FOLDER";
    private static boolean configured = false;
    private static boolean initialized = false;
    public static final String DEVCONF_WORK_FOLDER = System.getProperty("user.home") + File.separator + ".dtc";
    protected static String defaultDevConfName = null;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$devconf$DevConfManager == null ? (class$com$sap$ide$eclipse$component$devconf$DevConfManager = DevConfManager.class$("com.sap.ide.eclipse.component.devconf.DevConfManager")) : class$com$sap$ide$eclipse$component$devconf$DevConfManager));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$devconf$DevConfManager;

    public static void initializeDevConfs() {
        DevConfManager.initializeDevConfs(true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initializeDevConfs(boolean realRefresh, IProgressMonitor monitor) {
        boolean bl;
        long start = System.currentTimeMillis();
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (!UserValidator.isDefaultServerOnline()) {
                ComponentMetaDataUtil.createDevConfLogin();
            }
            if (realRefresh || !configured) {
                configured = true;
                DevConfManager.initDevConfFactory();
                DevConfManager.updateLocalConfiguratin();
                List configList = DevConfManager.getInstalledDevConfs(monitor);
                if (configList != null) {
                    int i = 0;
                    while (true) {
                        if (i >= configList.size()) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    ObjectUtil.initLocalModel();
                                }
                            });
                            break;
                        }
                        IDevelopmentConfiguration config = (IDevelopmentConfiguration)configList.get(i);
                        if (config != null) {
                            String configDesc = config.getConfigurationData().getDescription();
                            if (configDesc == null) {
                                configDesc = config.getConfigurationData().getName();
                            }
                            monitor.subTask("Creating Model for " + configDesc);
                            ComponentMetaDataUtil.createDevConfLocal(config);
                            if (!config.isInOfflineMode()) {
                                ComponentMetaDataUtil.createDevConf(config);
                            }
                            monitor.subTask("");
                        }
                        ++i;
                    }
                }
                if (configList == null || configList.size() <= 0) {
                    configured = false;
                }
                boolean bl2 = true;
                Object var9_9 = null;
                long elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)"DevConfManager.initializeDevConfs");
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            long elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)"DevConfManager.initializeDevConfs");
            throw throwable;
        }
        Object var9_10 = null;
        long elapsed = System.currentTimeMillis() - start;
        LogUtil.logElapsedTime((long)elapsed, (String)"DevConfManager.initializeDevConfs");
        return bl;
    }

    private static void updateLocalConfiguratin() {
        if (DevConfManager.isDefaultDevConfInstalled()) {
            InputStream installedDevConfStream = null;
            File importedConfdef = DevConfManager.getDefaultConfDefFile();
            if (importedConfdef == null || !importedConfdef.exists()) {
                return;
            }
            String installedVersion = null;
            String importedVersion = null;
            try {
                installedDevConfStream = DevConfUtil.getDefaultDevConfStream();
                if (installedDevConfStream == null) {
                    return;
                }
                installedVersion = DevConfManager.getDefaultDevConfVersion(installedDevConfStream);
                FileInputStream importedDefconfStream = new FileInputStream(importedConfdef);
                if (importedDefconfStream != null) {
                    importedVersion = DevConfManager.getDefaultDevConfVersion(importedDefconfStream);
                }
            }
            catch (IOException e) {
                Util.logExceptionMessage(theTracer, 3, "Reding of Versions for Development Configurations failed", e);
            }
            double installedVersionFloat = 0.0;
            double importedVersionFloat = 0.0;
            if (installedVersion != null && !installedVersion.equals(importedVersion)) {
                installedVersionFloat = Double.parseDouble(installedVersion);
                if (importedVersion != null) {
                    importedVersionFloat = Double.parseDouble(importedVersion);
                }
            }
            if (installedVersionFloat > importedVersionFloat) {
                try {
                    int bytes_read;
                    installedDevConfStream = DevConfUtil.getDefaultDevConfStream();
                    FileOutputStream destination = new FileOutputStream(importedConfdef);
                    byte[] buffer = new byte[1024];
                    while ((bytes_read = installedDevConfStream.read(buffer)) != -1) {
                        ((OutputStream)destination).write(buffer, 0, bytes_read);
                    }
                    ((OutputStream)destination).close();
                }
                catch (FileNotFoundException e) {
                    Util.logExceptionMessage(theTracer, 2, "Update default local Development configuration failed", e);
                }
                catch (IOException e) {
                    Util.logExceptionMessage(theTracer, 2, "Update default local Development configuration failed", e);
                }
            }
            if (installedDevConfStream != null) {
                try {
                    installedDevConfStream.close();
                }
                catch (IOException e) {
                    Util.logExceptionMessage(theTracer, 3, "Update default local Development configuration completed with errors", e);
                }
            }
        }
    }

    private static void updateDCProjects(IDevelopmentConfiguration config) {
        try {
            if (config == null || config.isInOfflineMode()) {
                return;
            }
            List dcList = config.getDevelopmentComponentNodes();
            if (dcList == null) {
                return;
            }
            Iterator it = dcList.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
                if (!dcNode.isSynchedAsSource()) continue;
                try {
                    DCProjectUtil.setDTRTeamProviderForProject(dcNode);
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 3, "set Project DTR TeamProvider for DC " + dcNode.getName(), e);
                }
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(theTracer, 3, "Update DC Projects fails", e);
        }
    }

    public static IDevelopmentConfiguration getDevConf(UniqueName name) {
        Object object = ObjectUtil.getObject(name, name);
        if (object instanceof IDevelopmentConfiguration) {
            return (IDevelopmentConfiguration)object;
        }
        throw new IllegalStateException("Wrong adapter registration for name:" + name);
    }

    private static String getDefaultDevConfName() {
        if (defaultDevConfName != null) {
            return defaultDevConfName;
        }
        InputStream stream = null;
        defaultDevConfName = "";
        try {
            stream = DevConfUtil.getDefaultDevConfStream();
        }
        catch (IOException e) {
            Util.logExceptionMessage(theTracer, 3, "Getting Configuration Name failed", e);
        }
        if (stream != null) {
            DevConfWizard.SimpleFileDevConfInputProvider in = new DevConfWizard.SimpleFileDevConfInputProvider(stream);
            DevelopmentConfiguration devConf = null;
            try {
                devConf = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)in);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 3, "Getting Configuration Name failed", e);
            }
            if (devConf != null) {
                defaultDevConfName = devConf.getName();
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Util.logExceptionMessage(theTracer, 3, "Getting Configuration Name problem", e);
                }
            }
        }
        return defaultDevConfName;
    }

    private static String getDefaultDevConfVersion(InputStream stream) {
        if (stream == null) {
            return null;
        }
        String version = null;
        if (stream != null) {
            DevConfWizard.SimpleFileDevConfInputProvider in = new DevConfWizard.SimpleFileDevConfInputProvider(stream);
            DevelopmentConfiguration devConf = null;
            try {
                devConf = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)in);
                if (devConf != null) {
                    version = devConf.getConfigVersion();
                }
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 3, "Getting Configuration Version failed", e);
            }
        }
        return version;
    }

    private static boolean isDefaultDevConfInstalled() {
        if (DevConfManager.getDefaultDevConfName().length() <= 0) {
            return false;
        }
        File confdef = DevConfManager.getDefaultConfDefFile();
        return confdef.exists();
    }

    protected static File getDefaultConfDefFile() {
        File confdef = new File(DevConfPreferencePage.getDevConfPoolRoot() + File.separator + DevConfManager.getDefaultDevConfName() + File.separator + ".confdef");
        return confdef;
    }

    private static IDevelopmentConfiguration createDefaultDevConf() {
        String user = "";
        String password = "";
        ConnectionContext context = new ConnectionContext(user, password, UserValidator.getKeyStore(), null);
        IDevelopmentConfiguration createdDevConf = null;
        try {
            String root = DevConfPreferencePage.getDevConfPoolRoot() + File.separator + DevConfManager.getDefaultDevConfName();
            createdDevConf = DevelopmentConfigurationFactory.getInstance().addConfiguration(root, DevConfUtil.getDefaultDevConfStream(), null, null, false, (IConnectionContext)context);
        }
        catch (SyncException e) {
            Util.logExceptionMessage(theTracer, 3, "Create Default Configuration failed", e);
        }
        catch (IOException e) {
            Util.logExceptionMessage(theTracer, 3, "Create Default Configuration failed", e);
        }
        if (createdDevConf != null) {
            HashMap resultMap = new HashMap();
            Iterator it = createdDevConf.getCompartmentNodes().iterator();
            while (it.hasNext()) {
                Map map;
                Set keys;
                ICompartmentNode cNode = (ICompartmentNode)it.next();
                Compartment compartment = cNode.getCompartment();
                if (compartment == null || (keys = (map = compartment.getBuildVariants()).keySet()) == null || keys.isEmpty()) continue;
                resultMap.put(compartment.getName(), keys.iterator().next());
            }
            Util.saveBuildVariants(createdDevConf, resultMap);
        }
        return createdDevConf;
    }

    public static List getInstalledDevConfs() {
        return DevConfManager.getInstalledDevConfs(null);
    }

    public static List getInstalledDevConfs(IProgressMonitor monitor) {
        File directory;
        ArrayList<IDevelopmentConfiguration> list = new ArrayList<IDevelopmentConfiguration>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        UserValidator.Data data = UserValidator.getDefaultServerData();
        String user = "";
        String password = "";
        boolean online = UserValidator.isDefaultServerOnline();
        if (data != null && online) {
            user = data.getUser();
            password = data.getPassword();
        }
        if ((directory = new File(DevConfPreferencePage.getDevConfPoolRoot())).exists() && directory.isDirectory()) {
            File[] fileList = directory.listFiles();
            IDevelopmentConfiguration conf = null;
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory() && Arrays.asList(fileList[i].list()).contains(".confdef")) {
                    String rootFolder = fileList[i].toString() + File.separator;
                    monitor.subTask("Initializing of Development Configuration from Folder " + fileList[i].getName());
                    if (online) {
                        theTracer.debug("Start Instantiation online Development Congihuration for: " + rootFolder);
                        try {
                            ConnectionContext context = new ConnectionContext(user, password, UserValidator.getKeyStore(), null);
                            conf = DevelopmentConfigurationFactory.getInstance().getDevelopmentConfigurationInstance(rootFolder, (IConnectionContext)context);
                            theTracer.debug("End Instantiation online Development Congihuration for: " + rootFolder);
                        }
                        catch (Throwable e) {
                            Util.logExceptionMessage(theTracer, 2, "Development Configuration Instantiation failed: " + rootFolder, e);
                        }
                    } else {
                        theTracer.debug("Start Instantiation offline Development Congihuration for: " + rootFolder);
                        try {
                            conf = DevelopmentConfigurationFactory.getInstance().getDevelopmentConfigurationInstance(rootFolder, null, null, true, null, null);
                            theTracer.debug("End Instantiation offline Development Congihuration for:" + rootFolder);
                        }
                        catch (Throwable e) {
                            Util.logExceptionMessage(theTracer, 2, "Development Configuration Instantiation failed: " + rootFolder, e);
                        }
                    }
                    if (conf != null) {
                        Util.initBuildVariant(conf);
                        list.add(conf);
                    }
                }
                ++i;
            }
        }
        if (!initialized && list.isEmpty() && !DevConfManager.isDefaultDevConfInstalled()) {
            monitor.subTask("Creating default Development Configuration");
            IDevelopmentConfiguration createdDevConf = DevConfManager.createDefaultDevConf();
            if (createdDevConf != null) {
                list.add(createdDevConf);
            }
        }
        initialized = true;
        monitor.subTask("");
        return list;
    }

    public static boolean isRootMovable() {
        String folderName = DevConfPreferencePage.getDevConfPoolRoot();
        File file = new File(folderName);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return true;
        }
        File[] dirs = file.listFiles(new DirectoryFilter());
        if (dirs == null) {
            return true;
        }
        int i = 0;
        while (i < dirs.length) {
            String[] files;
            if (!dirs[i].getName().equals(DevConfManager.getDefaultDevConfName()) && (files = dirs[i].list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return ".confdef".equals(name);
                }
            })) != null && files.length > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List listRemoteDevConfNames(final Shell shell) {
        final ArrayList result = new ArrayList();
        CIMClient xclient = null;
        try {
            xclient = DevConfManager.getCIMClient(shell);
        }
        catch (CIMClientException e) {
            Util.logExceptionMessage(theTracer, 2, "Get Landscape Client failed.", e);
        }
        final CIMClient client = xclient;
        final boolean[] ok = new boolean[]{true};
        if (client == null) {
            return result;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                CIMInstancenameJavacimobject[] objects = null;
                SAP_DesignTimeConfigurationAccessor confAccessor = new SAP_DesignTimeConfigurationAccessor((CIMClientHandle)client);
                try {
                    objects = confAccessor.enumerateInstances(false, false, null);
                }
                catch (LcrException e) {
                    Util.logExceptionMessage(theTracer, 3, "List Development Configurations failed", e);
                    Util.showException(e, shell);
                }
                if (objects == null) {
                    ok[0] = false;
                    return;
                }
                if (objects != null) {
                    int i = 0;
                    while (i < objects.length) {
                        if (objects[0].getJavaCIMObject() instanceof SAP_DesignTimeConfiguration) {
                            SAP_DesignTimeConfiguration element = (SAP_DesignTimeConfiguration)objects[i].getJavaCIMObject();
                            result.add(element);
                        }
                        ++i;
                    }
                }
            }
        });
        if (ok[0]) {
            return result;
        }
        return null;
    }

    public static CIMClient getCIMClient(Shell shell) throws CIMClientException {
        String urlValue = DevConfPreferencePage.getDevConfPoolURL();
        if ((urlValue == null || urlValue.length() <= 0) && shell != null && MessageDialog.openConfirm((Shell)shell, (String)"Warning", (String)"Development Configuration Pool is not configured.\nConfigurate?")) {
            DevConfPreferencePage.popUpPage(shell);
            urlValue = DevConfPreferencePage.getDevConfPoolURL();
        }
        if (urlValue == null || urlValue.length() <= 0) {
            return null;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            return null;
        }
        UserValidator.Data loginData = UserValidator.getDefaultServerData();
        String user = loginData.getUser();
        String password = loginData.getPassword();
        return DevConfManager.getCIMClient(user, password, UserValidator.getKeyStore());
    }

    public static CIMClient getCIMClient(String user, String password, KeyStore keyStore) throws CIMClientException {
        String urlValue = DevConfPreferencePage.getDevConfPoolURL();
        if (urlValue == null || urlValue.length() <= 0) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            Util.logExceptionMessage(theTracer, 3, "Connection to Landscape Directory failed", e);
            return null;
        }
        try {
            return DevConfManager.getCIMClient(url, user, password, keyStore);
        }
        catch (IOException e) {
            Util.logExceptionMessage(theTracer, 3, "Connection to Landscape Directory failed", e);
            return null;
        }
    }

    public static CIMClient getCIMClient(URL url, String user, String password, KeyStore keyStore) throws IOException, CIMClientException {
        CIMOMClient cimomclient = ClientFactory.newInstance().createClient(url, keyStore, user, password);
        if (cimomclient != null) {
            return new CIMClient(cimomclient);
        }
        return null;
    }

    public static InputStream getDevConfStream(String name, Shell shell) throws Throwable {
        CIMClient client = DevConfManager.getCIMClient(shell);
        SAP_DesignTimeConfigurationAccessor confAccessor = new SAP_DesignTimeConfigurationAccessor((CIMClientHandle)client);
        CIMInstancepathJavacimobject[] array = null;
        SAP_DesignTimeConfiguration obj = confAccessor.getInstance(name);
        array = confAccessor.associators((JavaCIMObject)obj, SAP_CMSMaintainedConfiguration.getClassname(), SAP_ChangeManagementServer.getClassname(), null, null, null);
        String url = null;
        if (array != null && array.length > 0) {
            SAP_ChangeManagementServer server = (SAP_ChangeManagementServer)array[0].getJavaCIMObject();
            url = server.getURL();
        }
        if (url == null) {
            return null;
        }
        CmsConfiguration clientAdapter = new CmsConfiguration();
        UserValidator.Data data = UserValidator.getDefaultServerData();
        String userName = data != null ? data.getUser() : "";
        String password = data != null ? data.getPassword() : "";
        java.net.URL cmsServer = new java.net.URL(url);
        InputStream stream = clientAdapter.getConfiguration(cmsServer, name, userName, password, UserValidator.getKeyStore());
        return stream;
    }

    private static void initDevConfFactory() {
        java.net.URL url;
        theTracer.debug("Init local archive pool for Development Configuration");
        Plugin plg = null;
        plg = Platform.getPlugin((String)"com.sap.tc.ap");
        if (plg != null && (url = plg.find((IPath)new Path("comp"))) != null) {
            try {
                DevelopmentConfigurationFactory.getInstance().setLocalArchiveRootPath(url.getFile());
            }
            catch (IOException e) {
                Util.logExceptionMessage(theTracer, 3, "Setting of local archive pool failed", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void freeDevConfs() {
        mEnum = ModelAccess.models();
        if (mEnum != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            obj = mEnum.nextElement();
            if (!(obj instanceof Model) || (subDomain = (model = (Model)obj).getUniqueName().getSubDomain()) != "com.sap.ide.eclipse.component.model" && subDomain != "com.sap.ide.eclipse.component.local.model" || !((object = ObjectUtil.getComponentObject((Element)model)) instanceof IDevelopmentConfiguration)) continue;
            devConf = (IDevelopmentConfiguration)object;
            DCProjectUtil.removeDevConfProjects(devConf);
            model.delete();
lbl9:
            // 3 sources

            ** while (mEnum.hasMoreElements())
        }
lbl10:
        // 1 sources

    }

    public static void addAtStartDeleteFolder(String devConfPath) {
        String value = "";
        if (ComponentProviderPlugin.getPlugin().getPluginPreferences().contains(TO_DELETE_DEV_CONF_FOLDER)) {
            value = ComponentProviderPlugin.getPlugin().getPluginPreferences().getString(TO_DELETE_DEV_CONF_FOLDER);
        }
        value = value + ";" + devConfPath;
        ComponentProviderPlugin.getPlugin().getPluginPreferences().setValue(TO_DELETE_DEV_CONF_FOLDER, value);
    }

    public static void removeNotDeletedFolders() {
        if (ComponentProviderPlugin.getPlugin().getPluginPreferences().contains(TO_DELETE_DEV_CONF_FOLDER)) {
            String value = ComponentProviderPlugin.getPlugin().getPluginPreferences().getString(TO_DELETE_DEV_CONF_FOLDER);
            ComponentProviderPlugin.getPlugin().getPluginPreferences().setValue(TO_DELETE_DEV_CONF_FOLDER, "");
            if (value != null && !"".equals(value)) {
                StringTokenizer tokonizer = new StringTokenizer(value, ";");
                while (tokonizer.hasMoreTokens()) {
                    File dir;
                    String path = tokonizer.nextToken();
                    if (path == null || "".equals(path) || !(dir = new File(path)).exists() || !dir.isDirectory() || dir.listFiles(new FilenameFilter(){

                        public boolean accept(File arg0, String name) {
                            return ".confdef".equalsIgnoreCase(name);
                        }
                    }).length != 0) continue;
                    DevConfRemoveAction.emptyContents(dir);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname != null && pathname.isDirectory();
        }
    }
}

