/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfServerData;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.login.UserValidator;
import com.sap.ide.ping.ServerData;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class DTRServerData
extends ServerData {
    protected static Map serverMap = new HashMap();
    protected DevConfServerData parentData;
    protected String myServer = null;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public DTRServerData(String DTRServer, DevConfServerData parentData) {
        this.myServer = DTRServer;
        this.parentData = parentData;
    }

    public static void clear() {
        Map map = serverMap;
        synchronized (map) {
            serverMap.clear();
        }
    }

    public boolean hasChildren() {
        return false;
    }

    public ServerData[] getChildren() {
        return new ServerData[0];
    }

    public ServerData getParent() {
        return this.parentData;
    }

    public void runCheck() {
        Map map = serverMap;
        synchronized (map) {
            Object obj = serverMap.get(this.myServer);
            if (obj instanceof DTRServerData) {
                DTRServerData data = (DTRServerData)((Object)obj);
                this.setState(data.getState());
                this.setResponseTime(data.getResponseTime());
                this.updateParent();
                return;
            }
        }
        UserValidator.Data userData = UserValidator.getDefaultServerData();
        if (!UserValidator.isDefaultServerOnline() || userData == null) {
            this.setState("unknown");
            this.setResponseTime(-1L);
            this.updateParent();
            return;
        }
        IDevelopmentConfiguration config = this.parentData.getDevConfig();
        ConnectionContext context = new ConnectionContext(userData.getUser(), userData.getPassword(), UserValidator.getKeyStore(), null);
        Date startTime = new Date();
        int result = 2;
        try {
            result = config.pingDTRServer(this.myServer, 3, 3000, (IConnectionContext)context);
        }
        catch (Throwable ex) {
            result = 2;
            Util.logExceptionMessage(this.theTracer, 2, "DTR Ping for " + this.myServer + " failed.", ex);
        }
        Date endTime = new Date();
        long time = endTime.getTime() - startTime.getTime();
        switch (result) {
            case 0: {
                this.setState("ok");
                this.setResponseTime(time);
                break;
            }
            case 1: {
                this.setState("unautorized");
                this.setResponseTime(time);
                break;
            }
            case 2: {
                this.setState("failed");
                this.setResponseTime(time);
                break;
            }
            default: {
                this.setState("unknown");
                this.setResponseTime(time);
            }
        }
        this.updateParent();
        Map map2 = serverMap;
        synchronized (map2) {
            serverMap.put(this.myServer, this);
        }
    }

    protected void updateParent() {
        if (this.getParent() == null) {
            return;
        }
        if ("ok".equals(this.getState())) {
            if ("unknown".equals(this.getParent().getState()) || this.getParent().getState() == null || "".equals(this.getParent().getState())) {
                this.getParent().setState("ok");
            }
        } else if ("unknown".equals(this.getState())) {
            if (!"failed".equals(this.getParent().getState()) && !"unautorized".equals(this.getParent().getState())) {
                this.getParent().setState("unknown");
            }
        } else if ("unautorized".equals(this.getState())) {
            if (!"failed".equals(this.getParent().getState())) {
                this.getParent().setState("unautorized");
            }
        } else if ("failed".equals(this.getState())) {
            this.getParent().setState("failed");
        }
        this.getParent().setResponseTime(-1L);
    }

    public String getName() {
        return this.myServer;
    }

    public Image getImage() {
        return ComponentCategoryImage.getImage("DTR Server");
    }
}

