/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.devconf;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DTRServerData;
import com.sap.ide.eclipse.component.devconf.DevConfServerData;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class BuildServerData
extends DTRServerData {
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public BuildServerData(String buildServer, DevConfServerData parentData) {
        super(buildServer, parentData);
    }

    public Image getImage() {
        return ComponentCategoryImage.getImage("CBS");
    }

    public void runCheck() {
        Map map = DTRServerData.serverMap;
        synchronized (map) {
            Object obj = DTRServerData.serverMap.get(this.myServer);
            if (obj instanceof DTRServerData) {
                BuildServerData data = (BuildServerData)((Object)obj);
                this.setState(data.getState());
                this.setResponseTime(data.getResponseTime());
                this.updateParent();
                return;
            }
        }
        long time = -1L;
        UserValidator.Data userData = UserValidator.getDefaultServerData();
        if (!UserValidator.isDefaultServerOnline() || userData == null) {
            this.setState("unknown");
            this.setResponseTime(-1L);
            this.updateParent();
            return;
        }
        IDevelopmentConfiguration config = this.parentData.getDevConfig();
        String password = userData.getPassword();
        String user = userData.getUser();
        int result = 2;
        try {
            long start = System.currentTimeMillis();
            ConnectionContext context = new ConnectionContext(user, password, UserValidator.getKeyStore(), null);
            result = config.pingBuildServer(3, 3000, (IConnectionContext)context);
            time = System.currentTimeMillis() - start;
        }
        catch (Throwable ex) {
            Util.logExceptionMessage(this.theTracer, 2, "ping Build Server " + this.myServer + " failed", ex);
            result = 2;
        }
        switch (result) {
            case 0: {
                this.setState("ok");
                this.setResponseTime(time);
                break;
            }
            case 1: {
                this.setState("unautorized");
                this.setResponseTime(time);
                break;
            }
            case 2: {
                this.setState("failed");
                this.setResponseTime(time);
                break;
            }
            default: {
                this.setState("unknown");
                this.setResponseTime(time);
            }
        }
        this.setResponseTime(time);
        this.updateParent();
        Map map2 = DTRServerData.serverMap;
        synchronized (map2) {
            DTRServerData.serverMap.put(this.myServer, this);
        }
    }
}

