/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.debug;

import com.sap.ide.eclipse.component.debug.CPListLabelProvider;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionPatternDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewSourceFolderDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class SelectSrcRootPage
extends WizardPage {
    public static final String NAME = "SelectSrcRootPage";
    private CheckedListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private IPath fProjPath;
    private Control fSWTControl;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fFoldersList;
    private StringDialogField fOutputLocationField;
    private SelectionButtonDialogField fUseFolderOutputs;
    private StringButtonDialogField fBuildPathDialogField;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    public SelectSrcRootPage() {
        super(NAME);
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.getString((String)"BuildPathsBlock.classpath.up.button"), NewWizardMessages.getString((String)"BuildPathsBlock.classpath.down.button"), null, NewWizardMessages.getString((String)"BuildPathsBlock.classpath.checkall.button"), NewWizardMessages.getString((String)"BuildPathsBlock.classpath.uncheckall.button")};
        CheckedListDialogField fClassPathList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        fClassPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        fClassPathList.setLabelText(NewWizardMessages.getString((String)"BuildPathsBlock.classpath.label"));
        fClassPathList.setUpButtonIndex(0);
        fClassPathList.setDownButtonIndex(1);
        fClassPathList.setCheckAllButtonIndex(3);
        fClassPathList.setUncheckAllButtonIndex(4);
        this.fBuildPathDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.getString((String)"BuildPathsBlock.buildpath.button"));
        this.fBuildPathDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.getString((String)"BuildPathsBlock.buildpath.label"));
        this.initJava(JavaPlugin.getWorkspace().getRoot(), fClassPathList, (StringDialogField)this.fBuildPathDialogField);
        this.setTitle(ComponentProviderMessages.getString("SelectSrcRootPage.title"));
        this.setDescription(ComponentProviderMessages.getString("SelectSrcRootPage.description"));
        this.setPageComplete(false);
    }

    public void initJava(IWorkspaceRoot root, CheckedListDialogField classPathList, StringDialogField outputLocationField) {
        this.fWorkspaceRoot = root;
        this.fClassPathList = classPathList;
        this.fOutputLocationField = outputLocationField;
        this.fSWTControl = null;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.add.button"), null, NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.edit.button"), NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.remove.button")};
        this.fFoldersList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.label"));
        this.fFoldersList.setViewerSorter((ViewerSorter)new CPListElementSorter());
        this.fFoldersList.enableButton(2, false);
        this.fUseFolderOutputs = new SelectionButtonDialogField(32);
        this.fUseFolderOutputs.setSelection(false);
        this.fUseFolderOutputs.setLabelText(NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.check"));
        this.fUseFolderOutputs.setDialogFieldListener((IDialogFieldListener)adapter);
    }

    private void updateFoldersList() {
        ArrayList<CPListElement> folders = new ArrayList<CPListElement>();
        boolean useFolderOutputs = false;
        List cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (cpe.getEntryKind() == 3) {
                boolean hasOutputFolder;
                folders.add(cpe);
                boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
                if (hasOutputFolder) {
                    useFolderOutputs = true;
                }
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        this.fUseFolderOutputs.setSelection(useFolderOutputs);
        int i2 = 0;
        while (i2 < folders.size()) {
            boolean hasOutputFolder;
            CPListElement cpe = (CPListElement)folders.get(i2);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
            if (patterns.length > 0 || hasOutputFolder) {
                this.fFoldersList.expandElement((Object)cpe, 3);
            }
            ++i2;
        }
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fFoldersList, this.fUseFolderOutputs}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fFoldersList.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectSrcRootPage.this.setPageComplete(SelectSrcRootPage.this.getSelectedPath() != null);
            }
        });
        this.fSWTControl = composite;
        List elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement elem = (CPListElement)elements.get(i);
            IPath[] patterns = (IPath[])elem.getAttribute("exclusion");
            IPath output = (IPath)elem.getAttribute("output");
            if (patterns.length > 0 || output != null) {
                this.fFoldersList.expandElement((Object)elem, 3);
            }
            ++i;
        }
        this.setControl((Control)composite);
    }

    protected void sourcePageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == 0) {
                ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(10);
                if (this.fCurrJProject.getProject().exists()) {
                    CPListElement[] srcentries = this.openSourceContainerDialog(null);
                    if (srcentries != null) {
                        int i = 0;
                        while (i < srcentries.length) {
                            elementsToAdd.add(srcentries[i]);
                            ++i;
                        }
                    }
                } else {
                    CPListElement entry = this.openNewSourceContainerDialog(null);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    CPListElement existing;
                    if (this.fFoldersList.getSize() == 1 && (existing = (CPListElement)this.fFoldersList.getElement(0)).getResource() instanceof IProject) {
                        this.askForChangingBuildPathDialog(existing);
                    }
                    HashSet modifiedElements = new HashSet();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fFoldersList.addElements(elementsToAdd);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        Iterator iter = modifiedElements.iterator();
                        while (iter.hasNext()) {
                            Object elem = iter.next();
                            this.fFoldersList.refresh(elem);
                            this.fFoldersList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement res = null;
        IResource resource = elem.getResource();
        if (resource.exists()) {
            CPListElement[] arr = this.openSourceContainerDialog(elem);
            if (arr != null) {
                res = arr[0];
            }
        } else {
            res = this.openNewSourceContainerDialog(elem);
        }
        if (res != null) {
            this.fFoldersList.replaceElement((Object)elem, (Object)res);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("output")) {
            CPListElement selElement = elem.getParent();
            OutputLocationDialog dialog = new OutputLocationDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("output", (Object)dialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (key.equals("exclusion")) {
            CPListElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", (Object)dialog.getExclusionPattern());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(selected));
        this.fFoldersList.enableButton(3, this.canRemove(selected));
    }

    private void removeEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = key.equals("exclusion") ? new Path[]{} : null;
                attrib.getParent().setAttribute(key, (Object)value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            CPListElementAttribute attrib;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((attrib = (CPListElementAttribute)elem).getKey().equals("exclusion") ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null) : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            return true;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fUseFolderOutputs) {
            if (!this.fUseFolderOutputs.isSelected()) {
                int nFolders = this.fFoldersList.getSize();
                int i = 0;
                while (i < nFolders) {
                    CPListElement cpe = (CPListElement)this.fFoldersList.getElement(i);
                    cpe.setAttribute("output", null);
                    ++i;
                }
            }
            this.fFoldersList.refresh();
        } else if (field == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        List cpelements = this.fClassPathList.getElements();
        List srcelements = this.fFoldersList.getElements();
        boolean changeDone = false;
        CPListElement lastSourceFolder = null;
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    changeDone = true;
                } else if (lastSourceFolder == null) {
                    lastSourceFolder = cpe;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertIndex = lastSourceFolder == null ? 0 : cpelements.indexOf(lastSourceFolder) + 1;
            cpelements.addAll(insertIndex, srcelements);
            changeDone = true;
        }
        if (changeDone) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement openNewSourceContainerDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.new.title") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.edit.title");
        IProject proj = this.fCurrJProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(NewWizardMessages.getFormattedString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.description", (Object)this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPSourceElement((IResource)folder);
        }
        return null;
    }

    private void askForChangingBuildPathDialog(CPListElement existing) {
        String message;
        Path outputFolder = new Path(this.fOutputLocationField.getText());
        IPath newOutputFolder = null;
        if (outputFolder.segmentCount() == 1) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            newOutputFolder = outputFolder.append(outputFolderName);
            message = NewWizardMessages.getFormattedString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.project_and_output.message", (Object)newOutputFolder);
        } else {
            message = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.project.message");
        }
        String title = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.title");
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            this.fFoldersList.removeElement((Object)existing);
            if (newOutputFolder != null) {
                this.fOutputLocationField.setText(newOutputFolder.toString());
            }
        }
    }

    private void askForAddingExclusionPatternsDialog(List newEntries, Set modifiedEntries) {
        int i = 0;
        while (i < newEntries.size()) {
            CPListElement curr = (CPListElement)newEntries.get(i);
            this.addExclusionPatterns(curr, modifiedEntries);
            ++i;
        }
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.exclusion_added.title");
            String message = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void addExclusionPatterns(CPListElement newEntry, Set modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        List existing = this.fFoldersList.getElements();
        int i = 0;
        while (i < existing.size()) {
            IPath[] exclusionFilters;
            CPListElement curr = (CPListElement)existing.get(i);
            IPath currPath = curr.getPath();
            if (currPath.isPrefixOf(entryPath) && !JavaModelUtil.isExcludedPath((IPath)entryPath, (IPath[])(exclusionFilters = (IPath[])curr.getAttribute("exclusion")))) {
                IPath pathToExclude = entryPath.removeFirstSegments(currPath.segmentCount()).addTrailingSeparator();
                IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
                System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
                newExclusionFilters[exclusionFilters.length] = pathToExclude;
                curr.setAttribute("exclusion", (Object)newExclusionFilters);
                modifiedEntries.add(curr);
            }
            ++i;
        }
    }

    private CPListElement[] openSourceContainerDialog(CPListElement existing) {
        Class[] acceptedClasses = new Class[]{class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = SelectSrcRootPage.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject, class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = SelectSrcRootPage.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null, (Collection)this.getExistingContainers(null));
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrJProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        String title = existing == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.title") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.title");
        String message = existing == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.description") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.description");
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrJProject.getProject().getParent());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (existing == null) {
            dialog.setInitialSelection((Object)this.fCurrJProject.getProject());
        } else {
            dialog.setInitialSelection((Object)existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPListElement[] res = new CPListElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPSourceElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List getExistingContainers(CPListElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        return res;
    }

    private CPListElement newCPSourceElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPListElement(this.fCurrJProject, 3, res.getFullPath(), res);
    }

    public void init(IJavaProject jproject) {
        IPath outputLocation = null;
        IClasspathEntry[] classpathEntries = null;
        this.fCurrJProject = jproject;
        boolean projectExists = false;
        List newClassPath = null;
        try {
            IProject project = this.fCurrJProject.getProject();
            boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
            if (projectExists) {
                if (outputLocation == null) {
                    outputLocation = this.fCurrJProject.getOutputLocation();
                }
                if (classpathEntries == null) {
                    classpathEntries = this.fCurrJProject.getRawClasspath();
                }
            }
            if (outputLocation == null) {
                outputLocation = this.getDefaultBuildPath(jproject);
            }
            if (classpathEntries != null) {
                newClassPath = this.getExistingEntries(classpathEntries);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        if (newClassPath == null) {
            newClassPath = this.getDefaultClassPath(jproject);
        }
        ArrayList<CPListElement> exportedEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < newClassPath.size()) {
            CPListElement curr = (CPListElement)newClassPath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fBuildPathDialogField.setText(outputLocation.makeRelative().toString());
        this.fBuildPathDialogField.enableButton(projectExists);
        this.fClassPathList.setElements(newClassPath);
        this.fClassPathList.setCheckedElements(exportedEntries);
        this.fCurrJProject = jproject;
        this.fProjPath = this.fCurrJProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] classpathEntries) {
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newClassPath;
    }

    private List getDefaultClassPath(IJavaProject jproj) {
        ArrayList<CPListElement> list = new ArrayList<CPListElement>();
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        String sourceFolderName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
        Object srcFolder = store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0 ? jproj.getProject().getFolder(sourceFolderName) : jproj.getProject();
        list.add(new CPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
        list.addAll(this.getExistingEntries(jreEntries));
        return list;
    }

    private IPath getDefaultBuildPath(IJavaProject jproj) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String outputLocationName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return jproj.getProject().getFullPath().append(outputLocationName);
        }
        return jproj.getProject().getFullPath();
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    public void persistSrcPaths(Shell shell, IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.internalConfigureJavaProject(this.fClassPathList.getElements(), (IPath)new Path(this.fOutputLocationField.getText()), shell, monitor);
    }

    private void internalConfigureJavaProject(List classPathEntries, IPath outputLocation, Shell shell, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IClasspathEntry[] originalCP = this.fCurrJProject.getRawClasspath();
        outputLocation = outputLocation.makeAbsolute();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < originalCP.length) {
            if (originalCP[i].getEntryKind() != 3) {
                list.add(originalCP[i]);
            }
            ++i;
        }
        monitor.worked(2);
        int nEntries = classPathEntries.size();
        IClasspathEntry[] classpath = new IClasspathEntry[nEntries];
        int i2 = 0;
        while (i2 < nEntries) {
            CPListElement entry = (CPListElement)classPathEntries.get(i2);
            IResource res = entry.getResource();
            if (res instanceof IFolder && !res.exists()) {
                CoreUtility.createFolder((IFolder)((IFolder)res), (boolean)true, (boolean)true, null);
            }
            if (entry.getEntryKind() == 3) {
                IPath folderOutput = (IPath)entry.getAttribute("output");
                if (folderOutput != null && folderOutput.segmentCount() > 1) {
                    IFolder folder = this.fWorkspaceRoot.getFolder(folderOutput);
                    CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
                }
                list.add(entry.getClasspathEntry());
            }
            ++i2;
        }
        monitor.worked(1);
        this.fCurrJProject.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    public IPath getSelectedPath() {
        Object obj;
        List list = this.fFoldersList.getSelectedElements();
        if (list != null && list.size() == 1 && (obj = list.get(0)) instanceof CPListElement) {
            CPListElement element = (CPListElement)obj;
            return element.getPath().removeFirstSegments(1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private BuildPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            SelectSrcRootPage.this.sourcePageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            SelectSrcRootPage.this.sourcePageSelectionChanged((DialogField)field);
        }

        public void doubleClicked(TreeListDialogField field) {
            SelectSrcRootPage.this.sourcePageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            SelectSrcRootPage.this.sourcePageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(!SelectSrcRootPage.this.fUseFolderOutputs.isSelected());
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            SelectSrcRootPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

