/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.debug;

import com.sap.ide.eclipse.component.core.SimpleComponentTreeViewer;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.filter.AddDebugSrcFilter;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.filter.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectDebugDCPage
extends WizardPage {
    public static final String NAME = "SelectDebugDCPage";
    private SimpleComponentTreeViewer componentTree;
    private boolean changeFlag = false;
    private boolean noValidate = false;
    private Composite treeComosite = null;

    public SelectDebugDCPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("SelectDebugDCPage.title"));
        this.setDescription(ComponentProviderMessages.getString("SelectDebugDCPage.description"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.changeFlag = false;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.buildComponentTree(container);
        this.setControl((Control)container);
    }

    private void buildComponentTree(Composite container) {
        this.treeComosite = new Composite(container, 2048);
        this.treeComosite.setLayoutData((Object)new GridData(1808));
        this.treeComosite.setLayout((Layout)new GridLayout());
        this.updateComponentTree();
    }

    private static List getAllConfigurations() {
        ArrayList<Model> lst = new ArrayList<Model>();
        PropertyMap[] models = ModelUtilPlugin.computeModels();
        if (models == null) {
            return lst;
        }
        int i = 0;
        while (i < models.length) {
            IDevelopmentConfiguration config;
            Model model;
            Object obj;
            if (models[i] instanceof Model && (obj = ObjectUtil.getComponentObject((Element)(model = (Model)models[i]))) instanceof IDevelopmentConfiguration && (config = (IDevelopmentConfiguration)obj).getBuildServer() != null) {
                lst.add(model);
            }
            ++i;
        }
        return lst;
    }

    private void updateComponentTree() {
        if (this.treeComosite != null) {
            List configRoots = SelectDebugDCPage.getAllConfigurations();
            this.componentTree = new SimpleComponentTreeViewer(this.treeComosite, false, 2);
            this.componentTree.setFilter((IFilter)new AddDebugSrcFilter());
            this.componentTree.setRoots(configRoots.toArray(new PropertyMap[configRoots.size()]));
            this.componentTree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectDebugDCPage.this.dialogChanged(false);
                }
            });
            if (configRoots == null || configRoots.isEmpty()) {
                this.setErrorMessage("No appropriate Development Configuration available");
            }
        }
        this.componentTree.getTree().setLayoutData((Object)new GridData(1808));
    }

    public Collection getSelectedDCs() {
        IStructuredSelection selection;
        ArrayList<Object> array = new ArrayList<Object>();
        if (this.componentTree != null && (selection = (IStructuredSelection)this.componentTree.getTreeViewer().getSelection()) != null && !selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if ("com.sap.ide.eclipse.component.DC".equals(element.getUniqueName().getSubDomain())) {
                    array.add(ObjectUtil.getComponentObject(element));
                    continue;
                }
                return null;
            }
            return array;
        }
        return null;
    }

    private void dialogChanged(boolean first) {
        if (this.noValidate) {
            return;
        }
        if (first) {
            return;
        }
        if (this.getSelectedDCs() == null) {
            this.updateStatus(ComponentProviderMessages.getString("errorNoSelectDTRPage"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.dialogChanged(true);
        }
        super.setVisible(visible);
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete();
    }

    public boolean isPageComplete() {
        if (!this.isCurrentPage()) {
            return true;
        }
        return super.isPageComplete();
    }
}

