/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.debug;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.debug.SelectDebugDCPage;
import com.sap.ide.eclipse.component.debug.SelectSrcRootPage;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.DefaultDCOperationHandler;
import com.sap.tc.devconf.IDCOperationHandler;
import com.sap.tc.devconf.IDCOperationResult;
import com.sap.tc.devconf.IDCUnsyncResult;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.MessageDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class DebugWizard
extends Wizard
implements IImportWizard {
    private IJavaProject prj = null;
    private SelectDebugDCPage selectDCPage;
    private SelectSrcRootPage selectRootPage;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$debug$DebugWizard == null ? (class$com$sap$ide$eclipse$component$debug$DebugWizard = DebugWizard.class$("com.sap.ide.eclipse.component.debug.DebugWizard")) : class$com$sap$ide$eclipse$component$debug$DebugWizard));
    static final int BUFFER = 2048;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$debug$DebugWizard;

    public DebugWizard() {
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.selectDCPage = new SelectDebugDCPage();
        this.addPage((IWizardPage)this.selectDCPage);
        this.selectRootPage = new SelectSrcRootPage();
        this.selectRootPage.init(this.prj);
        this.addPage((IWizardPage)this.selectRootPage);
        this.selectRootPage.init(this.prj);
    }

    public boolean performFinish() {
        Collection dcList = this.selectDCPage.getSelectedDCs();
        IPath path = this.selectRootPage.getSelectedPath();
        String projectpath = this.prj.getProject().getLocation().toOSString();
        String toUnzipPath = projectpath + path.toOSString();
        MultiStatus status = new MultiStatus("com.sap.ide.eclipse.component.provider", 0, "Status of Action", null);
        try {
            this.selectRootPage.persistSrcPaths(this.getShell(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            status.add((IStatus)new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Persisting of Source Paths failed", (Throwable)e1));
            Util.logExceptionMessage(theTracer, 2, "Persist Src Paths", e1);
        }
        catch (InterruptedException e1) {
            Util.logExceptionMessage(theTracer, 3, "Operation canceled", e1);
        }
        Collection zipFiles = this.collectZipFiles(dcList, this.getShell(), (IProgressMonitor)new NullProgressMonitor(), status);
        this.unzipZipFiles(toUnzipPath, zipFiles, status);
        IResource res = this.prj.getProject().findMember(path);
        if (res != null) {
            try {
                res.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 3, "Refresh Source Path failed", e);
                status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Refresh Source Path failed", (Throwable)e));
            }
        }
        if (!status.isOK()) {
            if (status.getSeverity() == 4) {
                MessageDialog.showError((String)"Error", (String)"Action completed with Errors", (String)this.getMessage(status));
            }
            if (status.getSeverity() == 2) {
                MessageDialog.showWarning((String)"Warning", (String)"Action completed with Warnings", (String)this.getMessage(status));
            }
        }
        return true;
    }

    private String getMessage(MultiStatus status) {
        String problems = "";
        IStatus[] children = status.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                switch (children[i].getSeverity()) {
                    case 4: {
                        problems = problems + "Error  : " + children[i].getMessage();
                        break;
                    }
                    case 2: {
                        problems = problems + "Warning: " + children[i].getMessage();
                        break;
                    }
                    case 1: {
                        problems = problems + "Info   : " + children[i].getMessage();
                        break;
                    }
                }
                Throwable ex = children[i].getException();
                if (ex != null) {
                    problems = problems + " (" + ex.getClass() + ": " + ex.getMessage() + ")";
                }
                problems = problems + '\n';
                ++i;
            }
        }
        return problems;
    }

    private void unzipZipFiles(String toUnzipPath, Collection zipFiles, MultiStatus status) {
        if (toUnzipPath == null || zipFiles == null) {
            return;
        }
        Iterator it = zipFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            this.unzip(file, toUnzipPath, status);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean unzip(File zipFfile, String goalPath, MultiStatus status) {
        if (goalPath == null) {
            return false;
        }
        if (!goalPath.endsWith(File.separator)) {
            goalPath = goalPath + File.separator;
        }
        try {
            BufferedOutputStream dest = null;
            BufferedInputStream is = null;
            ZipFile zipfile = new ZipFile(zipFfile);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                int count;
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) {
                    new File(goalPath + entry.getName()).mkdirs();
                    continue;
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(goalPath + entry.getName());
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    void var9_10;
                    dest.write(data, 0, (int)var9_10);
                }
                dest.flush();
                dest.close();
                is.close();
            }
        }
        catch (Exception e) {
            Util.logExceptionMessage(theTracer, 3, "unzip file failed", e);
            status.add((IStatus)new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Can not unzip " + zipFfile, (Throwable)e));
            return false;
        }
        return true;
    }

    private Collection collectZipFiles(Collection dcList, Shell shell, IProgressMonitor monitor, MultiStatus status) {
        ArrayList<IDevelopmentComponentNode> list;
        IDevelopmentConfiguration config;
        monitor.beginTask("Removing DC(s) from Client", 120);
        HashMap<IDevelopmentConfiguration, ArrayList<IDevelopmentComponentNode>> devConfMap = new HashMap<IDevelopmentConfiguration, ArrayList<IDevelopmentComponentNode>>();
        HashMap<IDevelopmentConfiguration, ArrayList<IDevelopmentComponentNode>> toUnsyncMap = new HashMap<IDevelopmentConfiguration, ArrayList<IDevelopmentComponentNode>>();
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)it.next();
            config = dcNode.getConfiguration();
            if (dcNode.isSynchedAsSource()) {
                try {
                    if (dcNode.getDCProxy().isAnythingCheckedOut()) {
                        status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Can not sync DC Archives.Some files of DC " + dcNode.getName() + " are checked out.", null));
                        continue;
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 3, "Anything Checked Out for DC " + dcNode.getName() + " failed", e);
                    status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Can not sync DC Archives.Some files of DC " + dcNode.getName() + " are checked out.", e));
                }
                IProject project = DCProjectUtil.getProject(dcNode);
                if (project != null && project.isOpen()) {
                    try {
                        project.close((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        Util.logExceptionMessage(theTracer, 3, "Close Project before remove from client failed", e);
                    }
                }
                if (project.isOpen()) {
                    status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Closing of Project " + project.getName() + " failed", null));
                    continue;
                }
                ArrayList<IDevelopmentComponentNode> toUnsyncList = (ArrayList<IDevelopmentComponentNode>)devConfMap.get(config);
                if (toUnsyncList == null) {
                    toUnsyncList = new ArrayList<IDevelopmentComponentNode>();
                    toUnsyncMap.put(config, toUnsyncList);
                }
                toUnsyncList.add(dcNode);
            }
            if ((list = (ArrayList<IDevelopmentComponentNode>)devConfMap.get(config)) == null) {
                list = new ArrayList<IDevelopmentComponentNode>();
                devConfMap.put(config, list);
            }
            list.add(dcNode);
        }
        Iterator it2 = toUnsyncMap.keySet().iterator();
        while (it2.hasNext()) {
            SyncException e;
            config = (IDevelopmentConfiguration)it2.next();
            list = (Collection)toUnsyncMap.get(config);
            IDCOperationResult[] dcresults = null;
            IDCUnsyncResult res = null;
            res = config.unsync(list.toArray(new IDevelopmentComponentNode[list.size()]), (IDCOperationHandler)new DefaultDCOperationHandler());
            dcresults = res.getResultsForDCs();
            if (dcresults != null) {
                int i = 0;
                while (i < dcresults.length) {
                    IDCOperationResult result = dcresults[i];
                    if (!IDCOperationResult.Status.OK.equals(result.getStatus())) {
                        ((Collection)devConfMap.get(config)).remove(result.getDCNode());
                        Exception ex = result.getException();
                        if (IDCOperationResult.Status.EXCEPTION.equals(result.getStatus())) {
                            Util.logExceptionMessage(theTracer, 3, "Remove from Client for the DC failed.", ex);
                        }
                    }
                    ++i;
                }
            }
            if ((e = res.getRemoveMountpointException()) != null) {
                status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Remove from Client failed", null));
                Util.logExceptionMessage(theTracer, 2, "Remove from Client failed.", e);
            }
            monitor.worked(100 / devConfMap.keySet().size());
            if (!monitor.isCanceled()) continue;
            return null;
        }
        ArrayList<File> zipFileList = new ArrayList<File>();
        Iterator it3 = devConfMap.keySet().iterator();
        while (it3.hasNext()) {
            IDevelopmentConfiguration config2 = (IDevelopmentConfiguration)it3.next();
            Collection list2 = (Collection)devConfMap.get(config2);
            Iterator iter = list2.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iter.next();
                try {
                    String buildVariant = Util.getBuildVariant(dcNode.getConfiguration(), dcNode.getCompartmentName());
                    if (!dcNode.isSynchedAsArchives()) {
                        dcNode.syncAsArchives(buildVariant, true);
                    }
                    File zipFile = DebugWizard.serachforZipFile(dcNode, buildVariant);
                    Collection ppZipFiles = DebugWizard.serachForPPZipFiles(dcNode, buildVariant);
                    if (zipFile != null) {
                        zipFileList.add(zipFile);
                    }
                    zipFileList.addAll(ppZipFiles);
                    if (zipFile != null || !ppZipFiles.isEmpty()) continue;
                    status.add((IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, "No src.zip for DC " + dcNode.getName() + " found. Check configured Build Variants of Software Components", null));
                }
                catch (Throwable e) {
                    status.add((IStatus)new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Syncing of Archives for DC " + dcNode.getName() + " failed.", null));
                    Util.logExceptionMessage(theTracer, 2, "Sync Archives failed for" + dcNode.getName(), e);
                }
            }
        }
        monitor.done();
        return zipFileList;
    }

    public static File getDeployZipFile(IDevelopmentComponentNode dcNode) {
        String buildVariant;
        try {
            buildVariant = Util.getBuildVariant(dcNode.getConfiguration(), dcNode.getCompartmentName());
        }
        catch (Exception e) {
            return null;
        }
        File zipFile = DebugWizard.serachforZipFile(dcNode, buildVariant);
        return zipFile;
    }

    public static Collection getPPZipFiles(IDevelopmentComponentNode dcNode) {
        String buildVariant;
        try {
            buildVariant = Util.getBuildVariant(dcNode.getConfiguration(), dcNode.getCompartmentName());
        }
        catch (Exception e) {
            return null;
        }
        return DebugWizard.serachForPPZipFiles(dcNode, buildVariant);
    }

    private static File serachforZipFile(IDevelopmentComponentNode dcNode, String buildVariant) {
        if (dcNode == null || !dcNode.isSynchedAsArchives()) {
            return null;
        }
        String path = dcNode.getComponentRootFolder() + "gen" + File.separator + buildVariant + File.separator + "src" + File.separator + "java" + File.separator + "src.zip";
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static Collection serachForPPZipFiles(IDevelopmentComponentNode dcNode, String buildVariant) {
        Map map;
        ArrayList<File> list = new ArrayList<File>();
        if (dcNode == null || !dcNode.isSynchedAsArchives()) {
            return list;
        }
        DevelopmentComponent dc = null;
        try {
            dc = dcNode.getDevelopmentComponent(true);
        }
        catch (RepositoryAccessException e) {
            Util.logExceptionMessage(theTracer, 3, "PP Read failed", e);
        }
        catch (InvalidDefinitionException e) {
            Util.logExceptionMessage(theTracer, 3, "PP Read failed", e);
        }
        if (dc != null && (map = dc.getPublicParts()) != null) {
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                String path;
                File file;
                PublicPart pp = (PublicPart)it.next();
                if (pp == null || !PublicPart.Purpose.ASSEMBLY.equals(pp.getPurpose()) || !(file = new File(path = dcNode.getComponentRootFolder() + "gen" + File.separator + buildVariant + File.separator + "public" + File.separator + pp.getName() + File.separator + "src" + File.separator + "java" + File.separator + "src.zip")).exists()) continue;
                list.add(file);
            }
        }
        return list;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(ComponentCategoryImage.getImageDescriptor("Development Component Wizard"));
        this.prj = null;
        Object obj = selection.getFirstElement();
        if (obj instanceof IProject) {
            IProject project = (IProject)obj;
            this.prj = JavaCore.create((IProject)project);
        } else if (obj instanceof IJavaProject) {
            this.prj = (IJavaProject)obj;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

