/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.debug;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.debug.DebugWizard;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class AddDebugSrcAction
implements IActionDelegate {
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private IStructuredSelection selectedProject = null;

    public void run(IAction action) {
        try {
            DebugWizard wizard = new DebugWizard();
            wizard.init(null, this.selectedProject);
            Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Open DC Wizard failed", e);
            Util.showException(e, null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        this.selectedProject = null;
        ArrayList list = new ArrayList();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        if (selection != null && selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
            Object obj = sel.getFirstElement();
            try {
                if (obj instanceof IJavaProject || obj instanceof IProject && ((IProject)obj).hasNature("org.eclipse.jdt.core.javanature")) {
                    this.selectedProject = sel;
                }
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 3, "getNature failed", e);
            }
        }
        action.setEnabled(this.selectedProject != null);
    }
}

