/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.view;

import com.sap.ide.eclipse.component.core.ComponentTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComboView;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.TextView;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EntityReferencesInputShellPage
extends ComponentWizardPage {
    private boolean triggeredByEdit;
    private int theCurrent;
    private IPPModel thePPModel;
    private IController theController;
    private Composite theComposite;
    private ComponentTreeViewer treeViewer;
    private TextView componentRefNameTextView;
    private TextView componentRefVendorTextView;
    private TextView componentRefScAliasTextView;
    private TextView publicPartRefTextView;
    private TextView entityNameTextView;
    private TextView entityPathTextView;
    private ComboView entityTypeComboView;
    private ComboView entitySubTypeComboView;
    private EntityReference theEntityReference;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public EntityReferencesInputShellPage(IPPModel aPPModel, EntityReference aEntityReference, IController pController, boolean pTriggeredByEdit, int pCurrent) {
        super(1001, "EntityReferencesInputShellPage", "EntityReferences", "EntityReferences.Help", pController);
        this.thePPModel = aPPModel;
        this.theEntityReference = aEntityReference;
        this.theCurrent = pCurrent;
        this.triggeredByEdit = pTriggeredByEdit;
        this.theController = pController;
        this.setMessage(this.getMessageUtil().getString("EntityReferences.InputHelp.Description"), 1);
        if (this.triggeredByEdit) {
            this.setTitle(this.getMessageUtil().getString("EntityReferences.InputHelp.Title.Edit") + ":");
        } else {
            this.setTitle(this.getMessageUtil().getString("EntityReferences.InputHelp.Title.Add") + ":");
        }
    }

    public void createControl(Composite parent) {
        this.theComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.theComposite.setLayout((Layout)gridLayout);
        this.setControl((Control)this.theComposite);
        this.createView();
        this.updateView();
        Shell shell = this.getShell();
        shell.pack();
        Rectangle rectangle = shell.getBounds();
        rectangle.width = 420;
        shell.setBounds(rectangle);
    }

    private void createView() {
        Composite theTreeComposite = new Composite(this.theComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 300;
        theTreeComposite.setLayoutData((Object)gridData);
        IDevelopmentConfiguration config = null;
        try {
            IDCExtendedProject dcProject = (IDCExtendedProject)this.thePPModel.getDCModel().getDCdefFile().getProject().getNature("com.sap.ide.eclipse.component.provider.dcnature");
            config = dcProject.getConfiguration();
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Get Configuration failed", e);
        }
        theTreeComposite.setLayout((Layout)new FillLayout());
        this.treeViewer = new ComponentTreeViewer(theTreeComposite, 8, config, config);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object theSelection;
                List list = EntityReferencesInputShellPage.this.treeViewer.getPathToSelectedObject();
                int size = list.size();
                Object v0 = theSelection = size == 0 ? null : list.get(list.size() - 1);
                if (theSelection instanceof PublicPart) {
                    Compartment aCompartment;
                    PublicPart aPP = theSelection;
                    String aPPRef = aPP.getName();
                    String dcName = "";
                    String dcVendor = "";
                    int thePpIndex = list.indexOf(aPP);
                    IDevelopmentComponentNode aDcNode = null;
                    while (--thePpIndex > -1 && !(list.get(thePpIndex) instanceof IDevelopmentComponentNode)) {
                    }
                    if (thePpIndex > -1) {
                        aDcNode = (IDevelopmentComponentNode)list.get(thePpIndex);
                    }
                    if (aDcNode != null) {
                        dcName = aDcNode.getName();
                        dcVendor = aDcNode.getVendor();
                    }
                    ICompartmentNode aCompNode = null;
                    while (--thePpIndex > -1 && !(list.get(thePpIndex) instanceof ICompartmentNode)) {
                    }
                    if (thePpIndex > -1) {
                        aCompNode = (ICompartmentNode)list.get(thePpIndex);
                    }
                    String compName = "";
                    String scAlias = "";
                    if (aCompNode != null && (aCompartment = aCompNode.getCompartment()) != null) {
                        compName = aCompartment.getName();
                        scAlias = EntityReferencesInputShellPage.this.thePPModel.getDCModel().getSCAlias(compName);
                    }
                    EntityReferencesInputShellPage.this.componentRefNameTextView.setText(dcName, true);
                    EntityReferencesInputShellPage.this.componentRefVendorTextView.setText(dcVendor, true);
                    EntityReferencesInputShellPage.this.componentRefScAliasTextView.setText(scAlias != null ? scAlias : "", true);
                    EntityReferencesInputShellPage.this.publicPartRefTextView.setText(aPPRef, true);
                    EntityReferencesInputShellPage.this.entityNameTextView.setText("", true);
                    EntityReferencesInputShellPage.this.entityPathTextView.setText("", true);
                    EntityReferencesInputShellPage.this.entityTypeComboView.setText("", true);
                    EntityReferencesInputShellPage.this.entitySubTypeComboView.setText("", true);
                } else if (theSelection instanceof Entity) {
                    Compartment aCompartment;
                    Entity anEntity = theSelection;
                    String anEntityRef = anEntity.getName();
                    String anEntityPath = anEntity.getPackageName();
                    String anEntityType = anEntity.getType();
                    String anEntitySubType = anEntity.getSubType();
                    String dcName = "";
                    String dcVendor = "";
                    int theEntRefIndex = list.indexOf(anEntity);
                    PublicPart aPpNode = null;
                    String aPPRef = "";
                    while (--theEntRefIndex > -1 && !(list.get(theEntRefIndex) instanceof PublicPart)) {
                    }
                    if (theEntRefIndex > -1) {
                        aPpNode = (PublicPart)list.get(theEntRefIndex);
                    }
                    if (aPpNode != null) {
                        aPPRef = aPpNode.getName();
                    }
                    IDevelopmentComponentNode aDcNode = null;
                    while (--theEntRefIndex > -1 && !(list.get(theEntRefIndex) instanceof IDevelopmentComponentNode)) {
                    }
                    if (theEntRefIndex > -1) {
                        aDcNode = (IDevelopmentComponentNode)list.get(theEntRefIndex);
                    }
                    if (aDcNode != null) {
                        dcName = aDcNode.getName();
                        dcVendor = aDcNode.getVendor();
                    }
                    ICompartmentNode aCompNode = null;
                    while (--theEntRefIndex > -1 && !(list.get(theEntRefIndex) instanceof ICompartmentNode)) {
                    }
                    if (theEntRefIndex > -1) {
                        aCompNode = (ICompartmentNode)list.get(theEntRefIndex);
                    }
                    String compName = "";
                    String scAlias = "";
                    if (aCompNode != null && (aCompartment = aCompNode.getCompartment()) != null) {
                        compName = aCompartment.getName();
                        scAlias = EntityReferencesInputShellPage.this.thePPModel.getDCModel().getSCAlias(compName);
                    }
                    EntityReferencesInputShellPage.this.componentRefNameTextView.setText(dcName, true);
                    EntityReferencesInputShellPage.this.componentRefVendorTextView.setText(dcVendor, true);
                    EntityReferencesInputShellPage.this.componentRefScAliasTextView.setText(scAlias != null ? scAlias : "", true);
                    EntityReferencesInputShellPage.this.publicPartRefTextView.setText(aPPRef, true);
                    EntityReferencesInputShellPage.this.entityNameTextView.setText(anEntityRef, true);
                    EntityReferencesInputShellPage.this.entityPathTextView.setText(anEntityPath, true);
                    EntityReferencesInputShellPage.this.entityTypeComboView.setText(anEntityType, true);
                    EntityReferencesInputShellPage.this.entitySubTypeComboView.setText(anEntitySubType, true);
                }
            }
        });
        Label dummy = new Label(this.theComposite, 0);
        Label parentDcComponentRefNameLabel = new Label(this.theComposite, 0);
        parentDcComponentRefNameLabel.setText(this.getMessageUtil().getString("EntityReferences.Name") + ":");
        Label parentDcComponentRefVendorLabel = new Label(this.theComposite, 0);
        parentDcComponentRefVendorLabel.setText(this.getMessageUtil().getString("EntityReferences.Vendor") + ":");
        Label parentDcComponentRefScAliasLabel = new Label(this.theComposite, 0);
        parentDcComponentRefScAliasLabel.setText(this.getMessageUtil().getString("EntityReferences.ScAlias") + ":");
        Label componentRefLabel = new Label(this.theComposite, 0);
        componentRefLabel.setText(this.getMessageUtil().getString("EntityReferences.InputHelp.Mandatory.ComponentRef") + ":");
        Text componentRefNameText = new Text(this.theComposite, 2052);
        this.componentRefNameTextView = new TextView(componentRefNameText, 1, "EntityReferences.InputHelp.Mandatory.ComponentRef.Name.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(1));
        this.addControlView(this.componentRefNameTextView);
        Text componentRefVendorText = new Text(this.theComposite, 2052);
        this.componentRefVendorTextView = new TextView(componentRefVendorText, 2, "EntityReferences.InputHelp.Mandatory.ComponentRef.Vendor.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(2));
        this.addControlView(this.componentRefVendorTextView);
        Text componentRefScAliasText = new Text(this.theComposite, 2052);
        this.componentRefScAliasTextView = new TextView(componentRefScAliasText, 3, "EntityReferences.InputHelp.Optional.ComponentRef.ScAlias.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(3));
        this.addControlView(this.componentRefScAliasTextView);
        Label publicPartRefLabel = new Label(this.theComposite, 0);
        publicPartRefLabel.setText(this.getMessageUtil().getString("EntityReferences.PublicPartRef") + ":");
        Text publicPartRefText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        publicPartRefText.setLayoutData((Object)gridData);
        this.publicPartRefTextView = new TextView(publicPartRefText, 4, "EntityReferences.InputHelp.Mandatory.PublicPartRef.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(4));
        this.addControlView(this.publicPartRefTextView);
        Label entityNameLabel = new Label(this.theComposite, 0);
        entityNameLabel.setText(this.getMessageUtil().getString("EntityReferences.EntityName") + ":");
        Text entityNameText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        entityNameText.setLayoutData((Object)gridData);
        this.entityNameTextView = new TextView(entityNameText, 5, "EntityReferences.InputHelp.Optional.EntityName.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(5));
        this.addControlView(this.entityNameTextView);
        Label entityPathLabel = new Label(this.theComposite, 0);
        entityPathLabel.setText(this.getMessageUtil().getString("EntityReferences.EntityPath") + ":");
        Text entityPathText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        entityPathText.setLayoutData((Object)gridData);
        this.entityPathTextView = new TextView(entityPathText, 6, "EntityReferences.InputHelp.Optional.EntityPath.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getTextViewModelAdapter(6));
        this.addControlView(this.entityPathTextView);
        Label entityTypeLabel = new Label(this.theComposite, 0);
        entityTypeLabel.setText(this.getMessageUtil().getString("EntityReferences.EntityType") + ":");
        Combo entityTypeCombo = new Combo(this.theComposite, 2060);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        entityTypeCombo.setLayoutData((Object)gridData);
        IPPModel.EntityType[] theTyps = this.thePPModel.getEntityTyps();
        String[] typeComboItems = new String[theTyps.length + 1];
        typeComboItems[0] = "";
        int i = 1;
        while (i < theTyps.length + 1) {
            typeComboItems[i] = theTyps[i - 1].toString();
            ++i;
        }
        entityTypeCombo.setItems(typeComboItems);
        this.entityTypeComboView = new ComboView(entityTypeCombo, 7, "EntityReferences.InputHelp.Optional.EntityType.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getComboViewModelAdapter(7));
        this.addControlView(this.entityTypeComboView);
        Label entitySubTypeLabel = new Label(this.theComposite, 0);
        entitySubTypeLabel.setText(this.getMessageUtil().getString("EntityReferences.EntitySubType") + ":");
        Combo entitySubTypeCombo = new Combo(this.theComposite, 2060);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        entitySubTypeCombo.setLayoutData((Object)gridData);
        String[] subTypeComboItems = new String[]{"Class", "Source"};
        entitySubTypeCombo.setItems(subTypeComboItems);
        this.entitySubTypeComboView = new ComboView(entitySubTypeCombo, 8, "EntityReferences.InputHelp.Optional.EntitySubType.Tooltip", "EntityReferences.Help", "EntityReferences", this.theController, this.theController.getComboViewModelAdapter(8));
        this.addControlView(this.entitySubTypeComboView);
    }

    private IDevelopmentComponentNode[] getDCNodeList() {
        IDevelopmentComponentNode theDCNode = null;
        IProject aDCProject = this.thePPModel.getPPFile().getProject();
        theDCNode = ComponentUtil.getDCNode((IProject)aDCProject);
        IDevelopmentComponentNode[] aListDCNodeList = new IDevelopmentComponentNode[]{};
        if (theDCNode != null) {
            try {
                List aListOfChildDcs = theDCNode.getChildren();
                if (aListOfChildDcs != null) {
                    aListDCNodeList = aListOfChildDcs.toArray(new IDevelopmentComponentNode[aListOfChildDcs.size()]);
                }
            }
            catch (RepositoryAccessException re) {
                Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.No.Children.For.DC"), re);
            }
            catch (InvalidDefinitionException ie) {
                Util.logExceptionMessage(this.theTracer, 2, this.getMessageUtil().getString("Exception.No.Children.For.DC"), ie);
            }
        } else {
            Util.logExceptionMessage(this.theTracer, 3, this.getMessageUtil().getString("Warning.No.DCNode.for.DCProject"), null);
        }
        return aListDCNodeList;
    }
}

