/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComboView;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmdcommons.view.TextView;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.FileSet;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EntitiesInputShellPage
extends ComponentWizardPage
implements IView {
    private boolean triggeredByEdit;
    private int theCurrentEntity = -1;
    private IPPModel theModel;
    private ArrayList thePackages;
    private ArrayList theClonedEntity;
    private IController theController;
    private Composite theComposite;
    private TextView entNameTextView;
    private ComboView entTypeComboView;
    private ComboView entSubTypeComboView;
    private ComboView entPackageComboView;
    private TextView entExcludesTextView;
    private TextView entIncludesTextView;
    private TextView entCaptionTextView;
    private TextView entDescriptionTextView;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public EntitiesInputShellPage(IPPModel pModel, IController aController, Set aSetOfPackages, ArrayList aListOfClonedEntity, int current, boolean pTriggeredByEdit) {
        super(1001, "EntitiesInputShellPage", "Entities", "Entities.Help", aController);
        this.theCurrentEntity = current;
        this.triggeredByEdit = pTriggeredByEdit;
        this.theController = aController;
        this.theModel = pModel;
        this.theClonedEntity = aListOfClonedEntity;
        this.thePackages = new ArrayList();
        this.thePackages.addAll(aSetOfPackages);
        Comparator aSecondComparator = new Comparator(){

            public int compare(Object aObject, Object aSecondObject) {
                String aPackageName = (String)aObject;
                String aSecondPackageName = (String)aSecondObject;
                Collator aCollator = Collator.getInstance();
                int result = aCollator.compare(aPackageName, aSecondPackageName);
                return result;
            }
        };
        Collections.sort(this.thePackages, aSecondComparator);
        this.setMessage(this.getMessageUtil().getString("Entities.InputHelp.Description"), 1);
        if (this.triggeredByEdit) {
            this.setTitle(this.getMessageUtil().getString("Entities.InputHelp.Title.Edit") + ":");
        } else {
            this.setTitle(this.getMessageUtil().getString("Entities.InputHelp.Title.Add") + ":");
        }
    }

    public void createControl(Composite parent) {
        this.theComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.theComposite.setLayout((Layout)gridLayout);
        this.setControl((Control)this.theComposite);
        this.createView();
        this.updateView();
        Shell shell = this.getShell();
        shell.pack();
        Rectangle rectangle = shell.getBounds();
        rectangle.width = 420;
        shell.setBounds(rectangle);
    }

    private void createView() {
        Label nameLabel = new Label(this.theComposite, 0);
        nameLabel.setText(this.getMessageUtil().getString("Entities.Name") + ":");
        Text nameText = new Text(this.theComposite, 2052);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        nameText.setLayoutData((Object)gridData);
        this.entNameTextView = new TextView(nameText, 1, "Entities.InputHelp.Mandatory.Name.Tooltip", "Entities.Help", "Entities", this.theController, new ITextViewModelAdapter(){

            public String getData() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getName() : "";
            }
        });
        this.addControlView(this.entNameTextView);
        Label typeLabel = new Label(this.theComposite, 0);
        typeLabel.setText(this.getMessageUtil().getString("Entities.Type") + ":");
        Combo typeCombo = new Combo(this.theComposite, 2060);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        typeCombo.setLayoutData((Object)gridData);
        IPPModel.EntityType[] theTyps = this.theModel.getEntityTyps();
        String[] typeComboItems = new String[theTyps.length];
        int i = 0;
        while (i < theTyps.length) {
            typeComboItems[i] = theTyps[i].toString();
            ++i;
        }
        typeCombo.setItems(typeComboItems);
        this.entTypeComboView = new ComboView(typeCombo, 2, "Entities.InputHelp.Mandatory.Type.Tooltip", "Entities.Help", "Entities", this.theController, new IComboViewModelAdapter(){

            public String getText() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getType() : "";
            }

            public String[] getItems() {
                return null;
            }
        });
        this.addControlView(this.entTypeComboView);
        Label subTypeLabel = new Label(this.theComposite, 0);
        subTypeLabel.setText(this.getMessageUtil().getString("Entities.SubType") + ":");
        Combo subTypeCombo = new Combo(this.theComposite, 2060);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        subTypeCombo.setLayoutData((Object)gridData);
        String[] subTypeComboItems = new String[]{};
        subTypeCombo.setItems(subTypeComboItems);
        this.entSubTypeComboView = new ComboView(subTypeCombo, 3, "Entities.InputHelp.Optional.SubType.Tooltip", "Entities.Help", "Entities", this.theController, new IComboViewModelAdapter(){

            public String getText() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getSubType() : "";
            }

            public String[] getItems() {
                IPPModel.EntityType theCurrentType;
                String[] theList = new String[]{};
                if (EntitiesInputShellPage.this.theClonedEntity.size() != 0 && (theCurrentType = EntitiesInputShellPage.this.theModel.getEntityType(((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getType())) != null) {
                    IPPModel.EntitySubType[] theSubTyps = theCurrentType.getSubTyps();
                    theList = new String[theSubTyps.length];
                    int i = 0;
                    while (i < theSubTyps.length) {
                        theList[i] = theSubTyps[i].toString();
                        ++i;
                    }
                }
                return theList;
            }
        });
        this.addControlView(this.entSubTypeComboView);
        Label packageLabel = new Label(this.theComposite, 0);
        packageLabel.setText(this.getMessageUtil().getString("Entities.Package") + ":");
        Combo packageCombo = new Combo(this.theComposite, 2060);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        packageCombo.setLayoutData((Object)gridData);
        packageCombo.setItems(this.thePackages.toArray(new String[this.thePackages.size()]));
        this.entPackageComboView = new ComboView(packageCombo, 4, "Entities.InputHelp.Optional.Package.Tooltip", "Entities.Help", "Entities", this.theController, new IComboViewModelAdapter(){

            public String getText() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getPackageName() : "";
            }

            public String[] getItems() {
                return null;
            }
        });
        this.addControlView(this.entPackageComboView);
        Label excludesLabel = new Label(this.theComposite, 0);
        excludesLabel.setText(this.getMessageUtil().getString("Entities.Excludes") + ":");
        Text excludesText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        excludesText.setLayoutData((Object)gridData);
        this.entExcludesTextView = new TextView(excludesText, 9, "Entities.Excludes.Optional.Caption.Tooltip", "Entities.Help", "Entities", this.theController, new ITextViewModelAdapter(){

            public String getData() {
                List aList;
                Entity anEnt;
                FileSet aFileSet;
                String result = "";
                if (EntitiesInputShellPage.this.theClonedEntity.size() != 0 && (aFileSet = (anEnt = (Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getFileSet()) != null && (aList = aFileSet.getExcludes()) != null) {
                    StringBuffer aBuffer = new StringBuffer();
                    Iterator anIter = aList.iterator();
                    while (anIter.hasNext()) {
                        aBuffer.append(anIter.next());
                        if (!anIter.hasNext()) continue;
                        aBuffer.append(",");
                    }
                    result = aBuffer.toString();
                }
                return result;
            }
        });
        this.addControlView(this.entExcludesTextView);
        Label includesLabel = new Label(this.theComposite, 0);
        includesLabel.setText(this.getMessageUtil().getString("Entities.Includes") + ":");
        Text includesText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        includesText.setLayoutData((Object)gridData);
        this.entIncludesTextView = new TextView(includesText, 10, "Entities.Includes.Optional.Caption.Tooltip", "Entities.Help", "Entities", this.theController, new ITextViewModelAdapter(){

            public String getData() {
                List aList;
                Entity anEnt;
                FileSet aFileSet;
                String result = "";
                if (EntitiesInputShellPage.this.theClonedEntity.size() != 0 && (aFileSet = (anEnt = (Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getFileSet()) != null && (aList = aFileSet.getIncludes()) != null) {
                    StringBuffer aBuffer = new StringBuffer();
                    Iterator anIter = aList.iterator();
                    while (anIter.hasNext()) {
                        aBuffer.append(anIter.next());
                        if (!anIter.hasNext()) continue;
                        aBuffer.append(",");
                    }
                    result = aBuffer.toString();
                }
                return result;
            }
        });
        this.addControlView(this.entIncludesTextView);
        Label captionLabel = new Label(this.theComposite, 0);
        captionLabel.setText(this.getMessageUtil().getString("Entities.Caption") + ":");
        Text captionText = new Text(this.theComposite, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        captionText.setLayoutData((Object)gridData);
        this.entCaptionTextView = new TextView(captionText, 5, "Entities.InputHelp.Optional.Caption.Tooltip", "Entities.Help", "Entities", this.theController, new ITextViewModelAdapter(){

            public String getData() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getCaption() : "";
            }
        });
        this.addControlView(this.entCaptionTextView);
        Label descriptionLabel = new Label(this.theComposite, 0);
        descriptionLabel.setText(this.getMessageUtil().getString("Entities.Description") + ":");
        Text descriptionText = new Text(this.theComposite, 2626);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        descriptionText.setLayoutData((Object)gridData);
        this.entDescriptionTextView = new TextView(descriptionText, 6, "Entities.InputHelp.Optional.Description.Tooltip", "Entities.Help", "Entities", this.theController, new ITextViewModelAdapter(){

            public String getData() {
                return EntitiesInputShellPage.this.theClonedEntity.size() != 0 ? ((Entity)EntitiesInputShellPage.this.theClonedEntity.get(0)).getDescription() : "";
            }
        });
        this.addControlView(this.entDescriptionTextView);
    }
}

