/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.view;

import com.sap.ide.eclipse.component.core.ComponentTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.view.ButtonView;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComboView;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.TextView;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DependenciesInputShellPage
extends ComponentWizardPage {
    private int theCurrent;
    private boolean triggeredByEdit;
    private IDCModel theModel;
    private IController theController;
    private Composite theComposite;
    private ComponentTreeViewer treeViewer;
    private TextView componentRefNameTextView;
    private TextView componentRefVendorTextView;
    private TextView componentRefScAliasTextView;
    private TextView publicPartRefTextView;
    private ButtonView atDesignTimeButtonView;
    private ButtonView atBuildTimeButtonView;
    private ButtonView atRunTimeButtonView;
    private ComboView atRunTimeQualifierComboView;
    private ButtonView atDeployTimeButtonView;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public DependenciesInputShellPage(IDCModel aDCModel, IController pController, int aCurrentIndex, boolean pTriggeredByEdit) {
        super(6001, "DependenciesInputShellPage", "Dependencies", "Dependencies.Help", pController);
        this.triggeredByEdit = pTriggeredByEdit;
        this.theController = pController;
        this.theModel = aDCModel;
        this.setMessage(this.getMessageUtil().getString("Dependencies.InputHelp.Description"), 1);
        if (this.triggeredByEdit) {
            this.setTitle(this.getMessageUtil().getString("Dependencies.InputHelp.Title.Edit") + ":");
        } else {
            this.setTitle(this.getMessageUtil().getString("Dependencies.InputHelp.Title.Add"));
        }
    }

    public void createControl(Composite parent) {
        this.theComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.theComposite.setLayout((Layout)gridLayout);
        this.setControl((Control)this.theComposite);
        this.createView();
        this.updateView();
        Shell shell = this.getShell();
        shell.pack();
        Rectangle rectangle = shell.getBounds();
        rectangle.width = 420;
        shell.setBounds(rectangle);
    }

    private void createView() {
        if (!this.triggeredByEdit) {
            Composite theTreeComposite = new Composite(this.theComposite, 0);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.heightHint = 200;
            theTreeComposite.setLayoutData((Object)gridData);
            IDevelopmentConfiguration config = null;
            try {
                IDCExtendedProject dcProject = (IDCExtendedProject)this.theModel.getDCdefFile().getProject().getNature("com.sap.ide.eclipse.component.provider.dcnature");
                config = dcProject.getConfiguration();
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "Get Configuration failed", e);
            }
            theTreeComposite.setLayout((Layout)new FillLayout());
            this.treeViewer = new ComponentTreeViewer(theTreeComposite, 8, config, config, false);
            final HashSet selSet = new HashSet();
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object obj;
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Element selEl = null;
                    Element removeEl = null;
                    boolean add = false;
                    if (sel.size() > selSet.size()) {
                        Iterator selI = sel.iterator();
                        while (selI.hasNext()) {
                            Element element = (Element)selI.next();
                            if (selSet.contains(element) || !((obj = ObjectUtil.getObject(element)) instanceof IDevelopmentComponentNode) && !(obj instanceof PublicPart)) continue;
                            add = true;
                            selSet.add(element);
                            selEl = element;
                            break;
                        }
                    } else {
                        HashSet tempSet = new HashSet(sel.toList());
                        Iterator selSetI = selSet.iterator();
                        while (selSetI.hasNext()) {
                            Element element = (Element)selSetI.next();
                            if (tempSet.contains(element)) continue;
                            add = false;
                            selSet.remove(element);
                            removeEl = element;
                            break;
                        }
                        Iterator selI = sel.iterator();
                        while (selI.hasNext()) {
                            Element element;
                            selEl = element = (Element)selI.next();
                        }
                    }
                    DCModel dcModel = (DCModel)DependenciesInputShellPage.this.theModel;
                    dcModel.setSelectedElement(selEl);
                    obj = ObjectUtil.getObject(selEl);
                    if (obj instanceof IDevelopmentComponentNode) {
                        Compartment aCompartment;
                        IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)obj;
                        String dcName = dcNode.getName();
                        String dcVendor = dcNode.getVendor();
                        ICompartmentNode aCompNode = null;
                        aCompNode = ComponentUtil.getParentCompartmentNode(selEl);
                        String compName = "";
                        String scAlias = "";
                        if (aCompNode != null && (aCompartment = aCompNode.getCompartment()) != null) {
                            compName = aCompartment.getName();
                            scAlias = DependenciesInputShellPage.this.theModel.getSCAlias(compName);
                        }
                        DependenciesInputShellPage.this.componentRefNameTextView.setText(dcName, true);
                        DependenciesInputShellPage.this.componentRefVendorTextView.setText(dcVendor, true);
                        DependenciesInputShellPage.this.componentRefScAliasTextView.setText(scAlias == null ? "" : scAlias, true);
                        DependenciesInputShellPage.this.publicPartRefTextView.setText("", true);
                        if (add) {
                            dcModel.addDependencyWrapper(selEl, aCompNode, dcNode);
                        } else {
                            dcModel.removeDependencyWrapper(removeEl);
                        }
                    } else if (obj instanceof PublicPart) {
                        Compartment aCompartment;
                        PublicPart aPP = (PublicPart)obj;
                        String aPPRef = aPP.getName();
                        String dcName = "";
                        String dcVendor = "";
                        IDevelopmentComponentNode dcNode = null;
                        dcNode = ComponentUtil.getParentDCNode(selEl);
                        if (dcNode != null) {
                            dcName = dcNode.getName();
                            dcVendor = dcNode.getVendor();
                        }
                        ICompartmentNode aCompNode = null;
                        aCompNode = ComponentUtil.getParentCompartmentNode(selEl);
                        String compName = "";
                        String scAlias = "";
                        if (aCompNode != null && (aCompartment = aCompNode.getCompartment()) != null) {
                            compName = aCompartment.getName();
                            scAlias = DependenciesInputShellPage.this.theModel.getSCAlias(compName);
                        }
                        DependenciesInputShellPage.this.componentRefNameTextView.setText(dcName, true);
                        DependenciesInputShellPage.this.componentRefVendorTextView.setText(dcVendor, true);
                        DependenciesInputShellPage.this.componentRefScAliasTextView.setText(scAlias == null ? "" : scAlias, true);
                        DependenciesInputShellPage.this.publicPartRefTextView.setText(aPPRef == null ? "" : aPPRef, true);
                        if (add) {
                            dcModel.addDependencyWrapper(selEl, aCompNode, dcNode);
                        } else {
                            dcModel.removeDependencyWrapper(removeEl);
                        }
                    }
                }
            });
        }
        new Label(this.theComposite, 0);
        Group referenceGroup = new Group(this.theComposite, 0);
        referenceGroup.setText(this.getMessageUtil().getString("Dependencies.InputHelp.Mandatory.ComponentRef"));
        referenceGroup.setLayout((Layout)new GridLayout(2, false));
        referenceGroup.setLayoutData((Object)new GridData(768));
        Label parentDcComponentRefNameLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefNameLabel.setText(this.getMessageUtil().getString("Dependencies.Name") + ":");
        Text componentRefNameText = new Text((Composite)referenceGroup, 4);
        componentRefNameText.setLayoutData((Object)new GridData(768));
        this.componentRefNameTextView = new TextView(componentRefNameText, 1, "Dependencies.InputHelp.Mandatory.ComponentRef.Name.Tooltip", "Dependencies.Help", "Dependencies", this.theController, this.theController.getTextViewModelAdapter(1));
        this.addControlView(this.componentRefNameTextView);
        Label parentDcComponentRefVendorLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefVendorLabel.setText(this.getMessageUtil().getString("Dependencies.Vendor") + ":");
        Text componentRefVendorText = new Text((Composite)referenceGroup, 4);
        componentRefVendorText.setLayoutData((Object)new GridData(768));
        this.componentRefVendorTextView = new TextView(componentRefVendorText, 2, "Dependencies.InputHelp.Mandatory.ComponentRef.Vendor.Tooltip", "Dependencies.Help", "Dependencies", this.theController, this.theController.getTextViewModelAdapter(2));
        this.addControlView(this.componentRefVendorTextView);
        Label parentDcComponentRefScAliasLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefScAliasLabel.setText(this.getMessageUtil().getString("Dependencies.ScAlias") + ":");
        Text componentRefScAliasText = new Text((Composite)referenceGroup, 4);
        componentRefScAliasText.setLayoutData((Object)new GridData(768));
        this.componentRefScAliasTextView = new TextView(componentRefScAliasText, 3, "EMPTY", "Dependencies.Help", "Dependencies", this.theController, this.theController.getTextViewModelAdapter(3));
        this.addControlView(this.componentRefScAliasTextView);
        Label publicPartRefLabel = new Label((Composite)referenceGroup, 0);
        publicPartRefLabel.setText(this.getMessageUtil().getString("Dependencies.PublicPartRef") + ":");
        Text publicPartRefText = new Text((Composite)referenceGroup, 4);
        publicPartRefText.setLayoutData((Object)new GridData(768));
        this.publicPartRefTextView = new TextView(publicPartRefText, 4, "Dependencies.InputHelp.Optional.PublicPartRef.Tooltip", "Dependencies.Help", "Dependencies", this.theController, this.theController.getTextViewModelAdapter(4));
        this.addControlView(this.publicPartRefTextView);
        new Label(this.theComposite, 0);
        Group buttonGroup = new Group(this.theComposite, 0);
        buttonGroup.setText("Dependency Type");
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.numColumns = 2;
        buttonGroup.setLayout((Layout)buttonGridLayout);
        buttonGroup.setLayoutData((Object)new GridData(768));
        Button atDesignTimeButton = new Button((Composite)buttonGroup, 32);
        atDesignTimeButton.setLayoutData((Object)new GridData(768));
        atDesignTimeButton.setText(this.getMessageUtil().getString("Dependencies.AtDesignTime"));
        this.atDesignTimeButtonView = new ButtonView(atDesignTimeButton, 6, "Dependencies.InputHelp.Optional.AtDesignTime.Tooltip", "Dependencies.Flags.Help", "Dependencies.Flags", this.theController, this.theController.getButtonViewModelAdapter(6));
        this.addControlView(this.atDesignTimeButtonView);
        Label designTimeHelp = new Label((Composite)buttonGroup, 0);
        designTimeHelp.setText("(needed for special editors only)");
        Button atBuildTimeButton = new Button((Composite)buttonGroup, 32);
        atBuildTimeButton.setSelection(true);
        atBuildTimeButton.setText(this.getMessageUtil().getString("Dependencies.AtBuildTime"));
        this.atBuildTimeButtonView = new ButtonView(atBuildTimeButton, 7, "Dependencies.InputHelp.Optional.AtBuildTime.Tooltip", "Dependencies.Flags.Help", "Dependencies.Flags", this.theController, this.theController.getButtonViewModelAdapter(7));
        this.addControlView(this.atBuildTimeButtonView);
        Label buildTimeHelp = new Label((Composite)buttonGroup, 0);
        buildTimeHelp.setText("(needed for compilation)");
        Button atDeployTimeButton = new Button((Composite)buttonGroup, 32);
        atDeployTimeButton.setSelection(true);
        atDeployTimeButton.setText(this.getMessageUtil().getString("Dependencies.AtDeployTime"));
        this.atDeployTimeButtonView = new ButtonView(atDeployTimeButton, 10, "Dependencies.InputHelp.Optional.AtRunTime.Tooltip", "Dependencies.Flags.Help", "Dependencies.Flags", this.theController, this.theController.getButtonViewModelAdapter(10));
        this.addControlView(this.atDeployTimeButtonView);
        Label deployTimeHelp = new Label((Composite)buttonGroup, 0);
        deployTimeHelp.setText("(refuses deployment if dependants missing)");
        Button atRunTimeButton = new Button((Composite)buttonGroup, 32);
        atRunTimeButton.setSelection(true);
        atRunTimeButton.setText(this.getMessageUtil().getString("Dependencies.AtRunTime"));
        this.atRunTimeButtonView = new ButtonView(atRunTimeButton, 8, "Dependencies.InputHelp.Optional.AtRunTime.Tooltip", "Dependencies.Flags.Help", "Dependencies.Flags", this.theController, this.theController.getButtonViewModelAdapter(8));
        this.addControlView(this.atRunTimeButtonView);
        Label runTimeHelp = new Label((Composite)buttonGroup, 0);
        runTimeHelp.setText("(if one deployable uses another one)");
        Combo atRunTimeQualifierCombo = new Combo((Composite)buttonGroup, 2060);
        String[] atRunitimeQualifierItems = new String[]{"", this.getMessageUtil().getString("Dependencies.AtRuntime.Qualifiers.Strong"), this.getMessageUtil().getString("Dependencies.AtRuntime.Qualifiers.Weak")};
        atRunTimeQualifierCombo.setItems(atRunitimeQualifierItems);
        this.atRunTimeQualifierComboView = new ComboView(atRunTimeQualifierCombo, 9, "Dependencies.InputHelp.Optional.AtRuntime.Qualifier.Tooltip", "Dependencies.Help", "Dependencies", this.theController, this.theController.getComboViewModelAdapter(9));
        this.addControlView(this.atRunTimeQualifierComboView);
        Label deployTimeQualifierHelp = new Label((Composite)buttonGroup, 0);
        deployTimeQualifierHelp.setText("(runtime time qualifier)");
    }
}

