/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.view;

import com.sap.ide.eclipse.component.core.ComponentTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComboView;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.TextView;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AccessControlListInputShellPage
extends ComponentWizardPage {
    private int theCurrent;
    private boolean triggeredByEdit;
    private IPPModel thePPModel;
    private IDCModel theDCModel;
    private ComponentReference theAccessControllClone;
    private IController theController;
    private Composite theComposite;
    private ComponentTreeViewer treeViewer;
    private int accessControlType;
    private TextView componentRefNameTextView;
    private TextView componentRefVendorTextView;
    private TextView componentRefScAliasTextView;
    private ComboView refTypeComboView;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public AccessControlListInputShellPage(IDCModel aDCModel, ComponentReference aAccessControll, IController pController, int aCurrent, boolean pTriggeredByEdit) {
        super(1001, "AccessControlListInputShellPage", "AccessControlList", "AccessControlList.DC.Help", pController);
        this.theDCModel = aDCModel;
        this.theAccessControllClone = aAccessControll;
        this.triggeredByEdit = pTriggeredByEdit;
        this.theCurrent = aCurrent;
        this.theController = pController;
        if (this.triggeredByEdit) {
            this.setTitle(this.getMessageUtil().getString("AccessControlList.InputHelp.Title.Edit") + ":");
        } else {
            this.setTitle(this.getMessageUtil().getString("AccessControlList.InputHelp.Title.Add") + ":");
        }
    }

    public AccessControlListInputShellPage(IPPModel aPPModel, ComponentReference aAccessControll, IController pController, int aCurrent, boolean pTriggeredByEdit) {
        super(1001, "AccessControlListInputShellPage", "AccessControlList", "AccessControlList.DC.Help", pController);
        this.thePPModel = aPPModel;
        this.theDCModel = this.thePPModel.getDCModel();
        this.theAccessControllClone = aAccessControll;
        this.triggeredByEdit = pTriggeredByEdit;
        this.theCurrent = aCurrent;
        this.theController = pController;
        if (this.triggeredByEdit) {
            this.setTitle(this.getMessageUtil().getString("AccessControlList.InputHelp.Title.Edit") + ":");
        } else {
            this.setTitle(this.getMessageUtil().getString("AccessControlList.InputHelp.Title.Add") + ":");
        }
    }

    public void createControl(Composite parent) {
        this.theComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.theComposite.setLayout((Layout)gridLayout);
        this.setControl((Control)this.theComposite);
        this.createView();
        this.updateView();
        Shell shell = this.getShell();
        shell.pack();
        Rectangle rectangle = shell.getBounds();
        rectangle.width = 420;
        shell.setBounds(rectangle);
    }

    private void createView() {
        Composite theTreeComposite = new Composite(this.theComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 200;
        theTreeComposite.setLayoutData((Object)gridData);
        IDevelopmentConfiguration config = null;
        try {
            IDCExtendedProject dcProject = (IDCExtendedProject)this.theDCModel.getDCdefFile().getProject().getNature("com.sap.ide.eclipse.component.provider.dcnature");
            config = dcProject.getConfiguration();
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Get Configuration failed", e);
        }
        theTreeComposite.setLayout((Layout)new FillLayout());
        this.treeViewer = new ComponentTreeViewer(theTreeComposite, 2, config, config, true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object theSelection;
                List list = AccessControlListInputShellPage.this.treeViewer.getPathToSelectedObject();
                int size = list.size();
                Iterator anIter = list.iterator();
                Object v0 = theSelection = size == 0 ? null : list.get(list.size() - 1);
                if (theSelection instanceof ICompartmentNode) {
                    ICompartmentNode aCompartmentNode = theSelection;
                    String scName = "";
                    String scVendor = "";
                    String scAlias = "";
                    scName = aCompartmentNode.getSCName();
                    scVendor = aCompartmentNode.getSCVendor();
                    scAlias = AccessControlListInputShellPage.this.theDCModel.getSCAlias(scName);
                    AccessControlListInputShellPage.this.refTypeComboView.setText("SC", true);
                    AccessControlListInputShellPage.this.componentRefNameTextView.setText(scName, true);
                    AccessControlListInputShellPage.this.componentRefVendorTextView.setText(scVendor, true);
                    AccessControlListInputShellPage.this.componentRefScAliasTextView.setText(scAlias, true);
                } else if (theSelection instanceof IDevelopmentComponentNode) {
                    Compartment aCompartment;
                    IDevelopmentComponentNode developmentComponentNode = theSelection;
                    String dcName = developmentComponentNode.getName();
                    String dcVendor = developmentComponentNode.getVendor();
                    int theDcIndex = list.indexOf(developmentComponentNode);
                    ICompartmentNode aCompNode = null;
                    while (--theDcIndex > -1 && !(list.get(theDcIndex) instanceof ICompartmentNode)) {
                    }
                    if (theDcIndex > -1) {
                        aCompNode = (ICompartmentNode)list.get(theDcIndex);
                    }
                    String compartmentName = "";
                    String scAlias = "";
                    if (aCompNode != null && (aCompartment = aCompNode.getCompartment()) != null) {
                        compartmentName = aCompartment.getName();
                        scAlias = AccessControlListInputShellPage.this.theDCModel.getSCAlias(compartmentName);
                    }
                    AccessControlListInputShellPage.this.refTypeComboView.setText("DC", true);
                    AccessControlListInputShellPage.this.componentRefNameTextView.setText(dcName, true);
                    AccessControlListInputShellPage.this.componentRefVendorTextView.setText(dcVendor, true);
                    AccessControlListInputShellPage.this.componentRefScAliasTextView.setText(scAlias, true);
                }
            }
        });
        new Label(this.theComposite, 0);
        Group referenceGroup = new Group(this.theComposite, 0);
        referenceGroup.setText(this.getMessageUtil().getString("AccessControlList.InputHelp.Mandatory.ComponentRef"));
        referenceGroup.setLayout((Layout)new GridLayout(2, false));
        referenceGroup.setLayoutData((Object)new GridData(768));
        Label parentDcComponentRefNameLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefNameLabel.setText(this.getMessageUtil().getString("AccessControlList.Name") + ":");
        Text componentRefNameText = new Text((Composite)referenceGroup, 2052);
        componentRefNameText.setLayoutData((Object)new GridData(768));
        this.componentRefNameTextView = new TextView(componentRefNameText, 2, "AccessControlList.InputHelp.Mandatory.ComponentRef.Name.Tooltip", "AccessControlList.DC.Help", "AccessControlList", this.theController, this.theController.getTextViewModelAdapter(2));
        this.addControlView(this.componentRefNameTextView);
        Label parentDcComponentRefVendorLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefVendorLabel.setText(this.getMessageUtil().getString("AccessControlList.Vendor") + ":");
        Text componentRefVendorText = new Text((Composite)referenceGroup, 2052);
        componentRefVendorText.setLayoutData((Object)new GridData(768));
        this.componentRefVendorTextView = new TextView(componentRefVendorText, 3, "AccessControlList.InputHelp.Mandatory.ComponentRef.Vendor.Tooltip", "AccessControlList.DC.Help", "AccessControlList", this.theController, this.theController.getTextViewModelAdapter(3));
        this.addControlView(this.componentRefVendorTextView);
        Label parentDcComponentRefScAliasLabel = new Label((Composite)referenceGroup, 0);
        parentDcComponentRefScAliasLabel.setText(this.getMessageUtil().getString("AccessControlList.ScAlias") + ":");
        Text componentRefScAliasText = new Text((Composite)referenceGroup, 2052);
        componentRefScAliasText.setLayoutData((Object)new GridData(768));
        this.componentRefScAliasTextView = new TextView(componentRefScAliasText, 4, "AccessControlList.InputHelp.Optional.ComponentRef.ScAlias.Tooltip", "AccessControlList.DC.Help", "AccessControlList", this.theController, this.theController.getTextViewModelAdapter(4));
        this.addControlView(this.componentRefScAliasTextView);
        Label refTypeLabel = new Label((Composite)referenceGroup, 0);
        refTypeLabel.setText(this.getMessageUtil().getString("AccessControlList.Type") + ":");
        Combo refTypeCombo = new Combo((Composite)referenceGroup, 4);
        refTypeCombo.setLayoutData((Object)new GridData(768));
        String[] refTypeItems = new String[]{"SC", "DC"};
        refTypeCombo.setItems(refTypeItems);
        this.refTypeComboView = new ComboView(refTypeCombo, 1, "AccessControlList.InputHelp.Mandatory.ComponentRef.Type.Tooltip", "AccessControlList.DC.Help", "AccessControlList", this.theController, this.theController.getComboViewModelAdapter(1));
        this.addControlView(this.refTypeComboView);
    }
}

