/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.model;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.model.IModelListener;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModelInitException;
import com.sap.ide.eclipse.component.dcmetadata.model.EntityComparator;
import com.sap.ide.eclipse.component.dcmetadata.model.GrantComparator;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModelInitException;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartInputProvider;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartOutputProvider;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.FileSet;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;

public class PPModel
implements IPPModel {
    public static final int ACCESSCONTROLTYPE_DCREF = 0;
    public static final int ACCESSCONTROLTYPE_SCREF = 1;
    private static IPPModel.EntityType[] theTyps = new IPPModel.EntityType[]{IPPModel.EntityType.JAVA_CLASS, IPPModel.EntityType.JAVA_PACKAGE, IPPModel.EntityType.JAVA_PACKAGE_TREE, IPPModel.EntityType.SQLJ_CLASS, IPPModel.EntityType.FILE, IPPModel.EntityType.FOLDER, IPPModel.EntityType.FOLDER_TREE, IPPModel.EntityType.DICTIONARY_DATABASE_TABLE, IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE, IPPModel.EntityType.DICTIONARY_STRUCTURE, IPPModel.EntityType.WAR, IPPModel.EntityType.EJB_JAR, IPPModel.EntityType.EJB_CLIENT_JAR, IPPModel.EntityType.WEB_DYNPRO_COMPONENT, IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION, IPPModel.EntityType.COMMON_MODEL, IPPModel.EntityType.WEB_SERVICE_DEFINITION, IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT, IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT};
    private static IPPModel.EntitySubType[] theSubTyps = new IPPModel.EntitySubType[]{IPPModel.EntitySubType.CLASS, IPPModel.EntitySubType.SOURCE};
    private boolean isUnsaved = false;
    private PublicPart publicPart;
    private String theSchemaVersion;
    private IFile thePPFile;
    private DCModel theDCModel;
    private Vector modelListeners;
    private MessageUtil theMessageUtil;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public PPModel(DCModel aDCModel, MessageUtil aMessageUtil) {
        this.theMessageUtil = aMessageUtil;
        this.publicPart = ComponentFactory.createPublicPart();
        this.theSchemaVersion = "1.0.2";
        this.theDCModel = aDCModel;
        this.modelListeners = new Vector();
    }

    public PPModel(String initialName, DCModel theOwnerDc, boolean associate, MessageUtil aMessageUtil) {
        this.theMessageUtil = aMessageUtil;
        this.theDCModel = theOwnerDc;
        this.thePPFile = theOwnerDc.getDCdefFile().getProject().getFolder("def").getFile(initialName + ".pp");
        if (this.theTracer.debug()) {
            this.theTracer.debug("Working with pp file:" + this.thePPFile.getLocation());
        }
        if (associate) {
            DCModel dCModel = theOwnerDc;
            synchronized (dCModel) {
                Map theExistingPPs = this.theDCModel.getPPs();
                if (theExistingPPs != null) {
                    Map map = theExistingPPs;
                    synchronized (map) {
                        this.publicPart = (PublicPart)theExistingPPs.get(initialName);
                        if (this.publicPart == null) {
                            this.publicPart = ComponentFactory.createPublicPart((String)initialName, (DevelopmentComponent)this.theDCModel.getDC());
                        }
                        this.theSchemaVersion = "1.0.2";
                    }
                } else {
                    this.publicPart = ComponentFactory.createPublicPart((String)initialName, (DevelopmentComponent)this.theDCModel.getDC());
                    this.theSchemaVersion = "1.0.2";
                }
            }
        } else {
            this.publicPart = ComponentFactory.createPublicPart();
            this.theSchemaVersion = "1.0.2";
            this.publicPart.setName(initialName);
            this.isUnsaved = true;
        }
        this.modelListeners = new Vector();
    }

    public PPModel(String initialName, DCModel theOwnerDc, MessageUtil aMessageUtil) {
        this(initialName, theOwnerDc, true, aMessageUtil);
    }

    public static IPPModel getPublicPartModel(IFile aPPFile) throws PPModelInitException {
        DCModel theDCModel;
        MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
        if (!"pp".equals(aPPFile.getFileExtension())) {
            throw new PPModelInitException(theMessageUtil.getString("Error.Unkown.File.Extension"));
        }
        PPModel model = null;
        Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
        IProject aProject = aPPFile.getProject();
        String aName = aPPFile.getName().substring(0, aPPFile.getName().length() - 3);
        try {
            theDCModel = new DCModel(aProject, theMessageUtil);
        }
        catch (DCModelInitException e) {
            throw new PPModelInitException(e.getMessage());
        }
        model = new PPModel(aName, theDCModel, theMessageUtil);
        return model;
    }

    public IFile getPPFile() {
        return this.thePPFile;
    }

    public IPPModel cloneData() {
        PPModel aClone = new PPModel("initalName", this.theDCModel, false, this.theMessageUtil);
        PublicPartOutputProvider aOutput = new PublicPartOutputProvider();
        try {
            this.publicPart.serialize((PPOutputProvider)aOutput);
        }
        catch (IOException ioe) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ioe);
            return null;
        }
        catch (ProviderException pe) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), pe);
            return null;
        }
        ByteArrayOutputStream aPPAsByteArray = aOutput.getOutput();
        PublicPartInputProvider aInput = new PublicPartInputProvider(aPPAsByteArray.toByteArray());
        aClone.readModelFrom(aInput);
        return aClone;
    }

    public boolean updateData(IPPModel aModel) {
        PublicPartOutputProvider aOutput = new PublicPartOutputProvider();
        aModel.writeModelTo(aOutput);
        ByteArrayOutputStream aPPAsByteArray = aOutput.getOutput();
        PublicPartInputProvider aInput = new PublicPartInputProvider(aPPAsByteArray.toByteArray());
        try {
            this.publicPart.initialize((PPInputProvider)aInput);
        }
        catch (IOException ioe) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ioe);
            return false;
        }
        catch (XMLException xe) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), xe);
            return false;
        }
        catch (ProviderException pe) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), pe);
            return false;
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return true;
    }

    public IPPModel.EntityType[] getEntityTyps() {
        return theTyps;
    }

    public IPPModel.EntityType getEntityType(String aKey) {
        IPPModel.EntityType result = null;
        int i = 0;
        while (i < theTyps.length) {
            if (theTyps[i].toString().equals(aKey)) {
                result = theTyps[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public IPPModel.EntitySubType getEntitySubType(String aKey) {
        IPPModel.EntitySubType result = null;
        int i = 0;
        while (i < theSubTyps.length) {
            if (theSubTyps[i].toString().equals(aKey)) {
                result = theSubTyps[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public IDCModel getDCModel() {
        return this.theDCModel;
    }

    public void setDCModel(IDCModel aDCModel) {
        this.theDCModel = (DCModel)aDCModel;
    }

    void fireModelChange(ModelChangeEvent aChangeEvent) {
        Vector modelListenersClone;
        PPModel pPModel = this;
        synchronized (pPModel) {
            modelListenersClone = (Vector)this.modelListeners.clone();
        }
        int modelListenersIndex = 0;
        while (modelListenersIndex < modelListenersClone.size()) {
            IModelListener modelListener = (IModelListener)modelListenersClone.elementAt(modelListenersIndex);
            modelListener.handleModelChange(aChangeEvent);
            ++modelListenersIndex;
        }
    }

    public void addModelListener(IModelListener pModelListener) {
        this.modelListeners.addElement(pModelListener);
    }

    public void removeModelListener(IModelListener pModelListener) {
        this.modelListeners.removeElement(pModelListener);
    }

    public void validate() throws ValidationException {
        this.publicPart.validate();
    }

    public ActionStatus writeModelTo(PPOutputProvider pPPOutputProvider) {
        ActionStatus result = ActionStatus.OKAY;
        try {
            this.publicPart.serialize(pPPOutputProvider, this.theSchemaVersion);
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured.Method") + "writeModelTo", e);
            Exception anException = e;
            result = new ActionStatus(false, anException.getMessage(), anException);
        }
        if (this.theDCModel.getDCNode() != null) {
            this.theDCModel.getDCNode().refresh();
        }
        return result;
    }

    public ActionStatus writeModelTo(IFile aFile) {
        ActionStatus result = ActionStatus.OKAY;
        Map thePPs = this.theDCModel.getPPs();
        PublicPart aReference = (PublicPart)thePPs.get(this.publicPart.getName());
        if (aReference == null) {
            thePPs.put(this.publicPart.getName(), this.publicPart);
        }
        PublicPartOutputProvider aOutPutProvider = new PublicPartOutputProvider();
        this.writeModelTo(aOutPutProvider);
        ByteArrayOutputStream aBuffer = aOutPutProvider.getOutput();
        ByteArrayInputStream anInBuffer = new ByteArrayInputStream(aBuffer.toByteArray());
        try {
            if (!aFile.exists()) {
                aFile.create((InputStream)anInBuffer, true, null);
            } else {
                aFile.setContents((InputStream)anInBuffer, true, false, null);
            }
        }
        catch (CoreException ce) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ce);
            result = new ActionStatus(false, ce.getMessage(), (Exception)((Object)ce));
        }
        this.reload();
        if (this.theDCModel.getDCNode() != null) {
            this.theDCModel.getDCNode().refresh();
        }
        return result;
    }

    public void reload() {
        PublicPart aNewPublicPart = null;
        aNewPublicPart = this.theDCModel.reloadPublicPart(this.publicPart.getName());
        if (aNewPublicPart != null) {
            this.publicPart = aNewPublicPart;
        }
    }

    public boolean readModelFrom(PPInputProvider pPPInputProvider) {
        boolean valid = true;
        try {
            this.publicPart.initialize(pPPInputProvider);
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured.Method") + "readModelFrom", e);
            valid = false;
        }
        return valid;
    }

    public String getName() {
        return this.publicPart.getName();
    }

    public void setName(String aName) {
        this.setName(aName, true);
    }

    public void setName(String pName, boolean save) {
        this.publicPart.setName(pName);
        if (save) {
            try {
                IDCProxy aDCProxy;
                IDevelopmentComponentNode aDCNode = this.theDCModel.getDCNode();
                if (aDCNode != null && (aDCProxy = aDCNode.getDCProxy()) != null) {
                    aDCProxy.serializePPDefinition(this.getName());
                }
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getPurpose() {
        return this.publicPart.getPurpose() != null ? this.publicPart.getPurpose().toString() : "";
    }

    public void setPurpose(String pPurpose) {
        this.setPurpose(pPurpose, true);
    }

    public void setPurpose(String pPurpose, boolean save) {
        this.publicPart.setPurpose(PublicPart.Purpose.valueOf((String)pPurpose));
        if (save) {
            try {
                IDCProxy aDCProxy;
                IDevelopmentComponentNode aDCNode = this.theDCModel.getDCNode();
                if (aDCNode != null && (aDCProxy = aDCNode.getDCProxy()) != null) {
                    aDCProxy.serializePPDefinition(this.getName());
                }
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getCaption() {
        return this.publicPart.getCaption();
    }

    public void setCaption(String pCaption) {
        this.setCaption(pCaption, true);
    }

    public void setCaption(String pCaption, boolean save) {
        this.publicPart.setCaption(pCaption);
        if (save) {
            try {
                IDCProxy aDCProxy;
                IDevelopmentComponentNode aDCNode = this.theDCModel.getDCNode();
                if (aDCNode != null && (aDCProxy = aDCNode.getDCProxy()) != null) {
                    aDCProxy.serializePPDefinition(this.getName());
                }
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getDescription() {
        return this.publicPart.getDescription();
    }

    public void setDescription(String pDescription) {
        this.setDescription(pDescription, true);
    }

    public void setDescription(String pDescription, boolean save) {
        this.publicPart.setDescription(pDescription);
        if (save) {
            try {
                this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public int getEntitiesLength() {
        if (this.publicPart.getEntities() == null) {
            return 0;
        }
        List entitiesList = this.publicPart.getEntities();
        return entitiesList.size();
    }

    public Entity getEntity(int pIndex) {
        List entitiesList = this.publicPart.getEntities();
        return (Entity)entitiesList.get(pIndex);
    }

    public int contains(Entity pEntity) {
        int result = -1;
        List entitiesList = this.publicPart.getEntities();
        if (entitiesList == null) {
            return -1;
        }
        Iterator anIter = entitiesList.iterator();
        while (anIter.hasNext()) {
            Entity anEntity = (Entity)anIter.next();
            if (!EntityComparator.equals(anEntity, pEntity)) continue;
            result = entitiesList.indexOf(anEntity);
            break;
        }
        return result;
    }

    public static final Entity cloneEntity(Entity anEntityToBeCloned) {
        Entity aClone = ComponentFactory.createEntity();
        aClone.setCaption(anEntityToBeCloned.getCaption());
        aClone.setDescription(anEntityToBeCloned.getDescription());
        FileSet aFileSet = anEntityToBeCloned.getFileSet();
        if (aFileSet != null) {
            List aListOfIncludes;
            StringBuffer aBuffer;
            FileSet aClonedFileSet = new FileSet();
            List aListOfExcludes = aFileSet.getExcludes();
            if (aListOfExcludes != null) {
                Iterator aSetIter = aListOfExcludes.iterator();
                aBuffer = new StringBuffer();
                while (aSetIter.hasNext()) {
                    aBuffer.append(aSetIter.next());
                    if (!aSetIter.hasNext()) continue;
                    aBuffer.append(",");
                }
                aClonedFileSet.setExcludes(aBuffer.toString());
            }
            if ((aListOfIncludes = aFileSet.getIncludes()) != null) {
                aBuffer = new StringBuffer();
                Iterator aSetIter = aListOfIncludes.iterator();
                while (aSetIter.hasNext()) {
                    aBuffer.append(aSetIter.next());
                    if (!aSetIter.hasNext()) continue;
                    aBuffer.append(",");
                }
                aClonedFileSet.setIncludes(aBuffer.toString());
            }
            aClone.setFileSet(aClonedFileSet);
        }
        aClone.setName(anEntityToBeCloned.getName());
        aClone.setPackageName(anEntityToBeCloned.getPackageName());
        aClone.setSubType(anEntityToBeCloned.getSubType());
        aClone.setType(anEntityToBeCloned.getType());
        return aClone;
    }

    public ArrayList cloneEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        List entitiesList = this.publicPart.getEntities();
        if (entitiesList == null) {
            return result;
        }
        Iterator anIter = entitiesList.iterator();
        while (anIter.hasNext()) {
            Entity anEntity = (Entity)anIter.next();
            result.add(PPModel.cloneEntity(anEntity));
        }
        return result;
    }

    public int contains(EntityReference pEntRef) {
        List entityRefsList = this.publicPart.getImportedEntities();
        if (entityRefsList == null) {
            return -1;
        }
        int size = entityRefsList.size();
        int i = 0;
        while (i < size) {
            EntityReference anEntRef = (EntityReference)entityRefsList.get(i);
            if (anEntRef.equals((Object)pEntRef)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ActionStatus addEntity(Entity pEntity) {
        block5: {
            try {
                pEntity.validate();
            }
            catch (ValidationException e) {
                return new ActionStatus(false, this.theMessageUtil.getString("Warning.Could.Not.Create.Entity"), (Exception)((Object)e));
            }
            if (this.contains(pEntity) != -1) {
                return new ActionStatus(false, this.theMessageUtil.getString("Warning.Tried.To.Add.Entity.Twice"), null);
            }
            Entity theNewEntity = ComponentFactory.createEntity((String)pEntity.getName(), (String)pEntity.getType(), (PublicPart)this.publicPart);
            theNewEntity.setCaption(pEntity.getCaption());
            theNewEntity.setDescription(pEntity.getDescription());
            theNewEntity.setFileSet(pEntity.getFileSet());
            theNewEntity.setPackageName(pEntity.getPackageName());
            theNewEntity.setSubType(pEntity.getSubType());
            try {
                this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
            }
            catch (DevConfigException e) {
                if (this.isUnsaved) break block5;
                Util.logException(this.theTracer, e);
            }
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return ActionStatus.OKAY;
    }

    public ActionStatus editEntity(int pIndex, Entity pEntity) {
        try {
            pEntity.validate();
        }
        catch (ValidationException e) {
            return new ActionStatus(false, this.theMessageUtil.getString("Warning.Could.Not.Create.Entity"), (Exception)((Object)e));
        }
        if (this.contains(pEntity) != pIndex) {
            return new ActionStatus(false, this.theMessageUtil.getString("Warning.Tried.To.Add.Entity.Twice"), null);
        }
        List entitiesList = this.publicPart.getEntities();
        Entity theCurrent = (Entity)entitiesList.get(pIndex);
        theCurrent.setCaption(pEntity.getCaption());
        theCurrent.setDescription(pEntity.getDescription());
        theCurrent.setFileSet(pEntity.getFileSet());
        theCurrent.setName(pEntity.getName());
        theCurrent.setPackageName(pEntity.getPackageName());
        theCurrent.setSubType(pEntity.getSubType());
        theCurrent.setType(pEntity.getType());
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return ActionStatus.OKAY;
    }

    public void removeAllEntities() {
        List entitiesList = this.publicPart.getEntities();
        if (entitiesList == null || entitiesList.size() <= 0) {
            return;
        }
        this.publicPart.emptyEntities();
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public ActionStatus removeEntity(Entity anEntity) {
        ActionStatus result = ActionStatus.OKAY;
        int theIndex = this.contains(anEntity);
        List entitiesList = this.publicPart.getEntities();
        if (theIndex != -1) {
            entitiesList.remove(theIndex);
            try {
                this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            this.fireModelChange(new ModelChangeEvent(this));
        } else {
            result = new ActionStatus(false, "Entity not in PP!", null);
        }
        return result;
    }

    public int getEntityReferencesLength() {
        if (this.publicPart.getImportedEntities() == null) {
            return 0;
        }
        List entityReferencesList = this.publicPart.getImportedEntities();
        return entityReferencesList.size();
    }

    public EntityReference getEntityReference(int pIndex) {
        List entityReferencesList = this.publicPart.getImportedEntities();
        return (EntityReference)entityReferencesList.get(pIndex);
    }

    public ActionStatus isEntityReferenceAllowed(EntityReference pEntityReference) {
        ActionStatus result = ActionStatus.OKAY;
        try {
            pEntityReference.validate();
        }
        catch (ValidationException ve) {
            return new ActionStatus(false, ve.getMessage(), (Exception)((Object)ve));
        }
        int index = this.contains(pEntityReference);
        if (index != -1) {
            result = new ActionStatus(false, this.theMessageUtil.getString("EntityReferences.InputHelp.Contains.Dublicated.EntityReference"), null);
            return result;
        }
        int numberOfUsedDCs = this.getDCModel().getDependenciesLength();
        if (numberOfUsedDCs == 0) {
            result = new ActionStatus(false, this.theMessageUtil.getString("EntityReferences.InputHelp.Has.No.Valid.Usage.Ralation"), null);
            return result;
        }
        int i = 0;
        while (i < numberOfUsedDCs) {
            Dependency aDep = this.getDCModel().getDependency(i);
            String aDCName = aDep.getComponent().getName();
            String aDCVendor = aDep.getComponent().getVendor();
            String aSCAlias = aDep.getComponent().getSCAlias();
            if (!(!aDCName.equals(pEntityReference.getComponent().getName()) || !aDCVendor.equals(pEntityReference.getComponent().getVendor()) || aSCAlias != null && aSCAlias.equals(pEntityReference.getComponent().getSCAlias()) || aSCAlias == null && pEntityReference.getComponent().getSCAlias() != null)) {
                String aPP = aDep.getPublicPart();
                if (aPP == null) {
                    return result;
                }
                if (aPP.equals(pEntityReference.getPublicPart())) {
                    return result;
                }
            }
            ++i;
        }
        result = new ActionStatus(false, this.theMessageUtil.getString("EntityReferences.InputHelp.Has.No.Valid.Usage.Ralation"), null);
        return result;
    }

    public ActionStatus addEntityReference(EntityReference pEntityReference) {
        String anEntSubType;
        String anEntType;
        String anEntPath;
        ActionStatus result = ActionStatus.OKAY;
        result = this.isEntityReferenceAllowed(pEntityReference);
        if (!result.getStatus()) {
            return result;
        }
        List entityReferencesList = this.publicPart.getImportedEntities();
        if (entityReferencesList == null) {
            entityReferencesList = this.publicPart.emptyImportedEntities();
        }
        EntityReference entityReference = new EntityReference();
        entityReference.setComponent(new DCReference());
        entityReference.getComponent().setName(pEntityReference.getComponent().getName());
        entityReference.getComponent().setVendor(pEntityReference.getComponent().getVendor());
        String scAlias = pEntityReference.getComponent().getSCAlias();
        if (scAlias != null && !scAlias.trim().equals("")) {
            entityReference.getComponent().setSCAlias(scAlias);
        } else {
            entityReference.getComponent().setSCAlias(null);
        }
        entityReference.setPublicPart(pEntityReference.getPublicPart());
        String anEntName = pEntityReference.getName();
        if (anEntName != null && !anEntName.trim().equals("")) {
            entityReference.setName(anEntName);
        }
        if ((anEntPath = pEntityReference.getPackageName()) != null && !anEntPath.trim().equals("")) {
            entityReference.setPackageName(anEntPath);
        }
        if ((anEntType = pEntityReference.getType()) != null && !anEntType.trim().equals("")) {
            entityReference.setType(anEntType);
        }
        if ((anEntSubType = pEntityReference.getSubType()) != null && !anEntSubType.trim().equals("")) {
            entityReference.setSubType(anEntSubType);
        }
        entityReferencesList.add(entityReference);
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus editEntityReference(int pIndex, EntityReference pEntityReference) {
        ActionStatus result = this.isEntityReferenceAllowed(pEntityReference);
        if (!result.getStatus()) {
            return result;
        }
        EntityReference entityReference = this.getEntityReference(pIndex);
        entityReference.getComponent().setName(pEntityReference.getComponent().getName());
        entityReference.getComponent().setVendor(pEntityReference.getComponent().getVendor());
        String scAlias = pEntityReference.getComponent().getSCAlias();
        if (scAlias != null && !scAlias.trim().equals("")) {
            entityReference.getComponent().setSCAlias(scAlias);
        } else {
            entityReference.getComponent().setSCAlias(null);
        }
        entityReference.setPublicPart(pEntityReference.getPublicPart());
        String anEntName = pEntityReference.getName();
        if (anEntName != null && !anEntName.trim().equals("")) {
            entityReference.setName(anEntName);
        } else {
            entityReference.setName(null);
        }
        String anEntType = pEntityReference.getType();
        if (anEntType != null && !anEntType.trim().equals("")) {
            entityReference.setType(anEntType);
        } else {
            entityReference.setType(null);
        }
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus removeEntityReference(EntityReference anEntityRef) {
        ActionStatus result = ActionStatus.OKAY;
        List entityRefsList = this.publicPart.getImportedEntities();
        int theIndex = this.contains(anEntityRef);
        if (theIndex != -1) {
            entityRefsList.remove(theIndex);
            try {
                this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            this.fireModelChange(new ModelChangeEvent(this));
        } else {
            result = new ActionStatus(false, "EntityRef not in PP!", null);
        }
        return result;
    }

    public int getAccessControlListLength() {
        if (this.publicPart.getGrants() == null) {
            return 0;
        }
        List accessControlList = this.publicPart.getGrants();
        return accessControlList.size();
    }

    public ComponentReference getAccessControl(int pIndex) {
        List accessControlList = this.publicPart.getGrants();
        return (ComponentReference)accessControlList.get(pIndex);
    }

    public int contains(ComponentReference aNewGrant) {
        List aListOfGrants = this.publicPart.getGrants();
        if (aListOfGrants == null) {
            return -1;
        }
        Iterator anIter = aListOfGrants.iterator();
        while (anIter.hasNext()) {
            ComponentReference aGrant = (ComponentReference)anIter.next();
            if (!GrantComparator.equals(aGrant, aNewGrant)) continue;
            return aListOfGrants.indexOf(aGrant);
        }
        return -1;
    }

    public ActionStatus isGrantAllowed(ComponentReference aNewGrant) {
        ActionStatus result = ActionStatus.OKAY;
        try {
            aNewGrant.validate();
        }
        catch (ValidationException ve) {
            return new ActionStatus(false, ve.getMessage(), (Exception)((Object)ve));
        }
        String aNewName = aNewGrant.getName();
        String aNewVendor = aNewGrant.getVendor();
        boolean isNewDCGrant = aNewGrant instanceof DCReference;
        if (isNewDCGrant && aNewVendor.equals(this.theDCModel.getVendor()) && aNewName.equals(this.theDCModel.getName())) {
            result = new ActionStatus(false, this.theMessageUtil.getString("Warring.Grant.To.Your.Self"), null);
            return result;
        }
        if (this.contains(aNewGrant) != -1) {
            result = new ActionStatus(false, this.theMessageUtil.getString("Warring.You.Can.Grant.Twice"), null);
            return result;
        }
        return result;
    }

    public ActionStatus addAccessControl(ComponentReference pAccessControl) {
        ActionStatus result = ActionStatus.OKAY;
        result = this.isGrantAllowed(pAccessControl);
        if (!result.getStatus()) {
            return result;
        }
        List accessControlList = this.publicPart.getGrants();
        if (accessControlList == null) {
            accessControlList = this.publicPart.emptyGrants();
        }
        accessControlList.add(pAccessControl);
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus editAccessControl(int pIndex, ComponentReference pAccessControl) {
        ActionStatus result = this.isGrantAllowed(pAccessControl);
        if (!result.getStatus()) {
            return result;
        }
        List accessControlList = this.publicPart.getGrants();
        accessControlList.set(pIndex, pAccessControl);
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public boolean removeAccessControl(ComponentReference aCompRef) {
        boolean result = true;
        int theIndex = this.contains(aCompRef);
        if (theIndex == -1) {
            return false;
        }
        List accessControlList = this.publicPart.getGrants();
        accessControlList.remove(theIndex);
        try {
            this.theDCModel.getDCNode().getDCProxy().serializePPDefinition(this.getName());
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public String getSchemaVersion() {
        return this.theSchemaVersion;
    }

    public void setSchemaVersion(String pVersion) {
        String[] allPossibleVersions = this.getSchemaVersions();
        int i = 0;
        while (i < allPossibleVersions.length) {
            if (pVersion.equals(allPossibleVersions[i])) {
                this.theSchemaVersion = pVersion;
            }
            ++i;
        }
    }

    public String[] getSchemaVersions() {
        return ComponentFactory.getSchemaVersions();
    }

    public boolean isSchemaVersionAllowed() {
        return this.publicPart.isSchemaAllowed(this.theSchemaVersion);
    }
}

