/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.model;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.model.IModelListener;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModelInitException;
import com.sap.ide.eclipse.component.dcmetadata.model.DependencyWrapper;
import com.sap.ide.eclipse.component.dcmetadata.model.GrantComparator;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.IllegalDependencyException;
import com.sap.tc.devconf.SyncException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DCModel
implements IDCModel {
    private IProject theProject;
    private IFile theDCDefFile;
    private IDCProxy theProxy = null;
    private ICompartmentNode theAncestorCompartment = null;
    private IDevelopmentComponentNode theDCNode;
    ActionStatus result;
    private Element selEl;
    private Dependency tempDependency;
    private HashMap dependencyWrapperMap = new HashMap();
    private Vector modelListeners;
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$dcmetadata$model$DCModel == null ? (class$com$sap$ide$eclipse$component$dcmetadata$model$DCModel = DCModel.class$("com.sap.ide.eclipse.component.dcmetadata.model.DCModel")) : class$com$sap$ide$eclipse$component$dcmetadata$model$DCModel));
    private MessageUtil theMessageUtil;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$dcmetadata$model$DCModel;

    public DCModel(IProject aProject, MessageUtil aMessageUtil) throws DCModelInitException {
        this.theMessageUtil = aMessageUtil;
        this.theProject = aProject;
        this.theDCDefFile = aProject.getFile(".dcdef");
        if (this.theTracer.debug()) {
            this.theTracer.debug("Working with dcdef file:" + this.theDCDefFile.getLocation());
        }
        this.theDCNode = com.sap.ide.eclipse.dii.component.ComponentUtil.getDCNode((IProject)aProject);
        if (this.theDCNode != null) {
            try {
                this.theProxy = this.theDCNode.getDCProxy();
            }
            catch (DevConfigException e) {
                throw new DCModelInitException(e.getMessage());
            }
        } else {
            String aWarning = this.theMessageUtil.getString("Warning.Component.Not.Associated.With.Component.Infrastructure");
            Util.logExceptionMessage(this.theTracer, 3, aWarning, null);
            throw new DCModelInitException(aWarning);
        }
        this.modelListeners = new Vector();
    }

    public static IDCModel getDevelopmentComponentModel(IFile aDCFile) {
        MessageUtil aMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
        DCModel result = null;
        if (aDCFile == null || !"dcdef".equals(aDCFile.getFileExtension())) {
            return null;
        }
        IProject theProject = aDCFile.getProject();
        try {
            result = new DCModel(theProject, aMessageUtil);
        }
        catch (DCModelInitException e) {
            Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openError((Shell)theShell, (String)aMessageUtil.getString("Development.Component.Editor"), (String)aMessageUtil.getString("Warning.Could.Not.Connect.To.Backend.Server"));
            result = null;
        }
        return result;
    }

    private DevelopmentComponent getDevelopmentComponent() {
        return this.theProxy.getComponent();
    }

    public String getSCAlias(String targetCompartmentname) {
        String result = "";
        if (this.theAncestorCompartment == null) {
            this.theAncestorCompartment = com.sap.ide.eclipse.dii.component.ComponentUtil.getParentCompartmentNode((IProject)this.theProject);
            if (this.theAncestorCompartment != null) {
                result = this.theAncestorCompartment.getCompartment().getSCAlias(targetCompartmentname);
            }
        }
        return result != null ? result : "";
    }

    public void synchronizeDCProject(IProgressMonitor aMonitor) {
        if (this.theProject != null) {
            ProjectConsistencyManager aConsistencyManager = ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)com.sap.ide.eclipse.dii.component.ComponentUtil.getParentDevConf((IProject)this.theProject));
            aConsistencyManager.synchronizeProject(this.getDevelopmentComponent(), aMonitor);
        }
    }

    public DevelopmentComponent getDC() {
        return this.getDevelopmentComponent();
    }

    public Map getPPs() {
        Map thePPs = this.getDevelopmentComponent().getPublicParts();
        if (thePPs == null) {
            thePPs = this.getDevelopmentComponent().emptyPublicParts();
        }
        return thePPs;
    }

    public DCNodeSyncMode getSyncMode() {
        DCNodeSyncMode result = DCNodeSyncMode.UNKNOWN;
        if (this.theProxy != null) {
            result = this.theProxy.getDCSyncMode();
        }
        return result;
    }

    public IDCProxy getProxy() {
        return this.theProxy;
    }

    private void setFile(IFile aFile) {
        this.theDCDefFile = aFile;
    }

    private void setProxy(IDCProxy aProxy) {
        this.theProxy = aProxy;
    }

    private void setProject(IProject aProject) {
        this.theProject = aProject;
    }

    void fireModelChange(ModelChangeEvent theEvent) {
        Vector modelListenersClone;
        DCModel dCModel = this;
        synchronized (dCModel) {
            modelListenersClone = (Vector)this.modelListeners.clone();
        }
        int modelListenersIndex = 0;
        while (modelListenersIndex < modelListenersClone.size()) {
            IModelListener modelListener = (IModelListener)modelListenersClone.elementAt(modelListenersIndex);
            modelListener.handleModelChange(theEvent);
            ++modelListenersIndex;
        }
    }

    public void addModelListener(IModelListener pModelListener) {
        this.modelListeners.addElement(pModelListener);
    }

    public void removeModelListener(IModelListener pModelListener) {
        this.modelListeners.removeElement(pModelListener);
    }

    public PublicPart reloadPublicPart(String aPPName) {
        PublicPart aNewPPModel = null;
        try {
            if (this.theProxy != null) {
                this.theProxy.reloadPPDefinition(aPPName);
                DevelopmentComponent theDC = this.theProxy.getComponent();
                Map thePPs = theDC.getPublicParts();
                aNewPPModel = (PublicPart)thePPs.get(aPPName);
            }
        }
        catch (Exception e) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.format("Exception.Occured.See.Logs", new Object[]{e.getMessage()}), e);
            Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Reload.Failed"), null);
        }
        return aNewPPModel;
    }

    public String getName() {
        return this.getDevelopmentComponent().getName();
    }

    public void setName(String pName) {
        this.getDevelopmentComponent().setName(pName);
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getVendor() {
        return this.getDevelopmentComponent().getVendor();
    }

    public ComponentType getComponentType() {
        return this.getDevelopmentComponent().getComponentType();
    }

    public ActionStatus setComponentType(ComponentType pComponentType) {
        try {
            pComponentType.validate();
        }
        catch (ValidationException e) {
            return new ActionStatus(false, this.theMessageUtil.getString("Waring.Could.Not.Set.ComponentType"), (Exception)((Object)e));
        }
        this.getDevelopmentComponent().setComponentType(pComponentType);
        this.fireModelChange(new ModelChangeEvent(this));
        return ActionStatus.OKAY;
    }

    public DCReference getParentDcComponentRef() {
        DCReference aParentDCRef = this.getDevelopmentComponent().getEnclosingComponent();
        if (aParentDCRef == null) {
            aParentDCRef = new DCReference("", "");
        }
        return aParentDCRef;
    }

    public String getCaption() {
        return this.getDevelopmentComponent().getCaption();
    }

    public void setCaption(String pCaption) {
        this.getDevelopmentComponent().setCaption(pCaption);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getDescription() {
        return this.getDevelopmentComponent().getDescription();
    }

    public void setDescription(String pDescription) {
        this.getDevelopmentComponent().setDescription(pDescription);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public boolean getExternal() {
        return this.getDevelopmentComponent().isExternal();
    }

    public void setExternal(boolean pExternal) {
        this.getDevelopmentComponent().setExternal(pExternal);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public boolean getInternal() {
        return this.getDevelopmentComponent().isInternal();
    }

    public void setInternal(boolean pInternal) {
        this.getDevelopmentComponent().setInternal(pInternal);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
    }

    public String getBuildPluginComponentRefName() {
        DCReference dcReference;
        String buildPluginComponentRefName = null;
        PPReference ppReference = this.getDevelopmentComponent().getBuildPlugin();
        if (ppReference != null && (dcReference = ppReference.getComponent()) != null) {
            buildPluginComponentRefName = dcReference.getName();
        }
        return buildPluginComponentRefName;
    }

    public String getBuildPluginComponentRefVendor() {
        DCReference dcReference;
        String buildPluginComponentRefVendor = null;
        PPReference ppReference = this.getDevelopmentComponent().getBuildPlugin();
        if (ppReference != null && (dcReference = ppReference.getComponent()) != null) {
            buildPluginComponentRefVendor = dcReference.getVendor();
        }
        return buildPluginComponentRefVendor;
    }

    public String getBuildPluginComponentRefScAlias() {
        DCReference dcReference;
        String buildPluginComponentRefScAlias = null;
        PPReference ppReference = this.getDevelopmentComponent().getBuildPlugin();
        if (ppReference != null && (dcReference = ppReference.getComponent()) != null) {
            buildPluginComponentRefScAlias = dcReference.getSCAlias();
        }
        return buildPluginComponentRefScAlias;
    }

    public String getBuildPluginPublicPartRef() {
        String buildPluginPublicPartRef = null;
        PPReference ppReference = this.getDevelopmentComponent().getBuildPlugin();
        if (ppReference != null) {
            buildPluginPublicPartRef = ppReference.getName();
        }
        return buildPluginPublicPartRef;
    }

    public int getAccessControlListLength() {
        if (this.getDevelopmentComponent().getGrants() == null) {
            return 0;
        }
        List accessControlList = this.getDevelopmentComponent().getGrants();
        return accessControlList.size();
    }

    public ComponentReference getAccessControl(int pIndex) {
        List accessControlList = this.getDevelopmentComponent().getGrants();
        return (ComponentReference)accessControlList.get(pIndex);
    }

    public IFile getDCdefFile() {
        return this.theDCDefFile;
    }

    public int contains(ComponentReference aRef) {
        List accessControlList = this.getDevelopmentComponent().getGrants();
        if (accessControlList == null || accessControlList.size() <= 0) {
            return -1;
        }
        Iterator anIter = accessControlList.iterator();
        while (anIter.hasNext()) {
            ComponentReference anOtherRef = (ComponentReference)anIter.next();
            if (!GrantComparator.equals(aRef, anOtherRef)) continue;
            return accessControlList.indexOf(anOtherRef);
        }
        return -1;
    }

    public ActionStatus addAccessControl(ComponentReference aRef) {
        ActionStatus result = ActionStatus.OKAY;
        try {
            aRef.validate();
        }
        catch (ValidationException ve) {
            return new ActionStatus(false, ve.getMessage(), (Exception)((Object)ve));
        }
        List accessControlList = this.getDevelopmentComponent().getGrants();
        if (accessControlList == null) {
            accessControlList = this.getDevelopmentComponent().emptyGrants();
        }
        accessControlList.add(aRef);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus editAccessControl(int pIndex, ComponentReference pAccessControl) {
        ActionStatus result = ActionStatus.OKAY;
        try {
            pAccessControl.validate();
        }
        catch (ValidationException ve) {
            return new ActionStatus(false, ve.getMessage(), (Exception)((Object)ve));
        }
        List accessControlList = this.getDevelopmentComponent().getGrants();
        accessControlList.set(pIndex, pAccessControl);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public int getPackageFoldersLength() {
        if (this.getDevelopmentComponent().getPackageFolders() == null) {
            return 0;
        }
        List packageFoldersList = this.getDevelopmentComponent().getPackageFolders();
        return packageFoldersList.size();
    }

    public String getPackageFolder(int pfIndex) {
        List packageFoldersList = this.getDevelopmentComponent().getPackageFolders();
        return (String)packageFoldersList.get(pfIndex);
    }

    public ActionStatus addPackageFolder(String pfPackage) {
        ActionStatus result = ActionStatus.OKAY;
        if (pfPackage == null) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error:Precondition.Violated.No.Null"), null);
        }
        List packageFoldersList = this.getDevelopmentComponent().getPackageFolders();
        if (packageFoldersList == null) {
            packageFoldersList = this.getDevelopmentComponent().emptyPackageFolders();
        }
        if (packageFoldersList.contains(pfPackage)) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.No.Duclicates"), null);
        }
        packageFoldersList.add(pfPackage);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus editPackageFolder(int pIndex, String pfPackage) {
        ActionStatus result = ActionStatus.OKAY;
        if (pfPackage == null || pIndex < 0 || pIndex >= this.getPackageFoldersLength()) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.Invalid.Index"), null);
        }
        List packageFoldersList = this.getDevelopmentComponent().getPackageFolders();
        packageFoldersList.set(pIndex, pfPackage);
        if (packageFoldersList.contains(pfPackage)) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.No.Duclicates"), null);
        }
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public boolean removePackageFolder(String aFolder) {
        boolean result = false;
        List packageFoldersList = this.getDevelopmentComponent().getPackageFolders();
        if (packageFoldersList != null && packageFoldersList.contains(aFolder)) {
            packageFoldersList.remove(aFolder);
            try {
                this.theProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            this.fireModelChange(new ModelChangeEvent(this));
            result = true;
        }
        return result;
    }

    public int getSourceFoldersLength() {
        if (this.getDevelopmentComponent().getSourceFolders() == null) {
            return 0;
        }
        List sourceFoldersList = this.getDevelopmentComponent().getSourceFolders();
        return sourceFoldersList.size();
    }

    public String getSourceFolder(int pfIndex) {
        List sourceFoldersList = this.getDevelopmentComponent().getSourceFolders();
        return (String)sourceFoldersList.get(pfIndex);
    }

    public ActionStatus addSourceFolder(String pfSource) {
        ActionStatus result = ActionStatus.OKAY;
        if (pfSource == null) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error:Precondition.Violated.No.Null"), null);
        }
        List sourceFoldersList = this.getDevelopmentComponent().getSourceFolders();
        if (sourceFoldersList == null) {
            sourceFoldersList = this.getDevelopmentComponent().emptySourceFolders();
        }
        if (sourceFoldersList.contains(pfSource)) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.No.Duclicates"), null);
        }
        sourceFoldersList.add(pfSource);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public ActionStatus editSourceFolder(int pIndex, String pfSource) {
        ActionStatus result = ActionStatus.OKAY;
        if (pfSource == null || pIndex < 0 || pIndex >= this.getSourceFoldersLength()) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.Invalid.Index"), null);
        }
        List sourceFoldersList = this.getDevelopmentComponent().getSourceFolders();
        if (sourceFoldersList.contains(pfSource)) {
            return new ActionStatus(false, this.theMessageUtil.getString("Error.No.Duplicates"), null);
        }
        sourceFoldersList.set(pIndex, pfSource);
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        this.fireModelChange(new ModelChangeEvent(this));
        return result;
    }

    public boolean removeSourceFolder(String aFolder) {
        boolean result = false;
        List sourceFoldersList = this.getDevelopmentComponent().getSourceFolders();
        if (sourceFoldersList != null && sourceFoldersList.contains(aFolder)) {
            sourceFoldersList.remove(aFolder);
            try {
                this.theProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            this.fireModelChange(new ModelChangeEvent(this));
            result = true;
        }
        return result;
    }

    public int getDependenciesLength() {
        if (this.getDevelopmentComponent().getDependencies() == null) {
            return 0;
        }
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        return dependenciesList.size();
    }

    public Dependency getDependency(int pIndex) {
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        return (Dependency)dependenciesList.get(pIndex);
    }

    public int contains(Dependency aDedendency) {
        List ofDeps = this.getDevelopmentComponent().getDependencies();
        if (ofDeps == null || ofDeps.size() == 0) {
            return -1;
        }
        return ofDeps.indexOf(aDedendency);
    }

    public void setSelectedElement(Element element) {
        this.selEl = element;
    }

    public Element getSelectedElement() {
        return this.selEl;
    }

    public void setTempDependency(Dependency dependency) {
        this.tempDependency = dependency;
    }

    public Dependency getTempDependency() {
        return this.tempDependency;
    }

    public void addDependencyWrapper(Element element, ICompartmentNode compNode, IDevelopmentComponentNode dcNode) {
        ActionStatus result = ActionStatus.OKAY;
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        if (dependenciesList == null) {
            dependenciesList = this.getDevelopmentComponent().emptyDependencies();
        }
        if (this.contains(this.tempDependency) > -1) {
            return;
        }
        Dependency dependency = this.createDependencyFromDO(this.tempDependency);
        result = this.isDependencyAllowed(compNode, dependency);
        if (result.getStatus()) {
            this.dependencyWrapperMap.put(element, new DependencyWrapper(compNode, dcNode, dependency));
        } else {
            dependenciesList.remove(dependency);
        }
    }

    public boolean containsDependencyWrapper(Element element) {
        return this.dependencyWrapperMap.containsKey(element);
    }

    public void removeDependencyWrapper(Element element) {
        DependencyWrapper dw;
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        if (dependenciesList != null && (dw = (DependencyWrapper)this.dependencyWrapperMap.get(element)) != null) {
            dependenciesList.remove(dw.getDependency());
        }
        this.dependencyWrapperMap.remove(element);
    }

    public ActionStatus finalizeDependencyWrappers() {
        this.result = ActionStatus.OKAY;
        Shell shell = ComponentProviderPlugin.getPlugin().getMyShell();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Sync of used DCs", 100);
                try {
                    DCModel.this.theProxy.serializeDefinition();
                    monitor.worked(10);
                }
                catch (DevConfigException e) {
                    DCModel.this.result = new ActionStatus(false, e.getMessage(), (Exception)((Object)e));
                    Util.logException(DCModel.this.theTracer, e);
                }
                IDevelopmentConfiguration devConf = com.sap.ide.eclipse.dii.component.ComponentUtil.getParentDevConf((IProject)DCModel.this.theProject);
                monitor.worked(15);
                if (!devConf.isInOfflineMode()) {
                    Collection dwCollection = DCModel.this.dependencyWrapperMap.values();
                    ArrayList<IDevelopmentComponentNode> dcCollection = new ArrayList<IDevelopmentComponentNode>();
                    Iterator it = dwCollection.iterator();
                    while (it.hasNext()) {
                        DependencyWrapper dw = (DependencyWrapper)it.next();
                        dcCollection.add(dw.getDcNode());
                    }
                    DCModel.this.result = ComponentUtil.syncDCsAsArchive(monitor, dcCollection, false);
                    DCModel.this.fireModelChange(new ModelChangeEvent((Object)this));
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Util.logExceptionMessage(this.theTracer, 2, "Sync Dependency problems", e);
        }
        catch (InterruptedException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Operation was canceled by user", e);
        }
        return this.result;
    }

    public ActionStatus addDependency(Dependency pDependencyDO) {
        Dependency dependency;
        ActionStatus result = ActionStatus.OKAY;
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        if (dependenciesList == null) {
            dependenciesList = this.getDevelopmentComponent().emptyDependencies();
        }
        if ((result = this.isDependencyAllowed(dependency = this.createDependencyFromDO(pDependencyDO))).getStatus()) {
            try {
                this.theProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            String theBuildVariant = com.sap.ide.eclipse.dii.component.ComponentUtil.getBuildVariant((IProject)this.theProject);
            try {
                if (!this.theProxy.getDevelopmentConfiguration().isInOfflineMode()) {
                    this.theProxy.syncUsedComponents(theBuildVariant, false);
                }
            }
            catch (SyncException se) {
                Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Sync.Of.Used.CDs.Failed"), se);
            }
            this.fireModelChange(new ModelChangeEvent(this));
        } else {
            dependenciesList.remove(dependency);
        }
        return result;
    }

    private Dependency createDependencyFromDO(Dependency pDependencyDO) {
        Dependency dependency = null;
        DCReference aDODCRef = pDependencyDO.getComponent();
        DCReference aNewDCRef = null;
        aNewDCRef = aDODCRef.getSCAlias() != null && aDODCRef.getSCAlias().trim().intern() != "".intern() ? new DCReference(aDODCRef.getName(), aDODCRef.getVendor(), aDODCRef.getSCAlias()) : new DCReference(aDODCRef.getName(), aDODCRef.getVendor());
        if (pDependencyDO.getPublicPart() != null && pDependencyDO.getPublicPart().trim().intern() != "".intern()) {
            PPReference aNewPPRef = new PPReference(pDependencyDO.getPublicPart(), aNewDCRef);
            dependency = ComponentFactory.createDependency((PPReference)aNewPPRef, (DevelopmentComponent)this.getDevelopmentComponent());
        } else {
            dependency = ComponentFactory.createDependency((DCReference)aNewDCRef, (DevelopmentComponent)this.getDevelopmentComponent());
        }
        dependency.setForChildrenOnly(pDependencyDO.isForChildrenOnly());
        dependency.setAtDesignTime(pDependencyDO.isAtDesignTime());
        dependency.setAtBuildTime(pDependencyDO.isAtBuildTime());
        dependency.setAtRunTime(pDependencyDO.isAtRunTime(), pDependencyDO.getRuntimeQuialifier());
        dependency.setAtDeployTime(pDependencyDO.isAtDeployTime());
        return dependency;
    }

    public ActionStatus isGrantAllowed(ComponentReference aNewGrant) {
        ActionStatus result = ActionStatus.OKAY;
        String aNewName = aNewGrant.getName();
        String aNewVendor = aNewGrant.getVendor();
        boolean isNewDCGrant = aNewGrant instanceof DCReference;
        if (isNewDCGrant && aNewVendor.equals(this.getVendor()) && aNewName.equals(this.getName())) {
            result = new ActionStatus(false, this.theMessageUtil.getString("Warring.Grant.To.Your.Self"), null);
            return result;
        }
        List aListOfGrants = this.getDevelopmentComponent().getGrants();
        if (aListOfGrants != null) {
            Iterator anIter = aListOfGrants.iterator();
            while (anIter.hasNext()) {
                ComponentReference aGrant = (ComponentReference)anIter.next();
                boolean aDCGrant = aGrant instanceof DCReference;
                if ((!aDCGrant || !isNewDCGrant) && (aDCGrant || isNewDCGrant) || !aGrant.getVendor().equals(aNewVendor) || !aGrant.getName().equals(aNewName)) continue;
                result = new ActionStatus(false, this.theMessageUtil.getString("Warring.You.Can.Grant.Twice"), null);
                return result;
            }
        }
        return result;
    }

    public ActionStatus isDependencyAllowed(Dependency aNewDendency) {
        return this.isDependencyAllowed((ICompartmentNode)null, aNewDendency);
    }

    public ActionStatus isDependencyAllowed(Element element, Dependency aNewDendency) {
        ICompartmentNode compNode = com.sap.ide.eclipse.dii.component.ComponentUtil.getParentCompartmentNode((Element)element);
        if (compNode != null) {
            return this.isDependencyAllowed(compNode, aNewDendency);
        }
        return this.isDependencyAllowed((ICompartmentNode)null, aNewDendency);
    }

    private ActionStatus isDependencyAllowed(ICompartmentNode compNode, Dependency aNewDendency) {
        ActionStatus result = new ActionStatus(false, this.theMessageUtil.getString("No.Proxy.Available.for.Action"), null);
        if (this.theProxy != null) {
            DCReference aDCRef = aNewDendency.getComponent();
            PPReference aPPRef = aNewDendency.getPublicPartDependency();
            if (aPPRef != null && aPPRef.getName() != null) {
                try {
                    if (compNode != null) {
                        this.theProxy.checkReferenceAllowed(compNode.getCompartment().getName(), aPPRef);
                    } else {
                        this.theProxy.checkReferenceAllowed(aPPRef);
                    }
                    result = new ActionStatus(true, null, null);
                }
                catch (SyncException se) {
                    result = new ActionStatus(false, se.getMessage(), (Exception)((Object)se));
                    Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Synchronize.Dependency.Change.Across.DCs"), se);
                }
                catch (IllegalDependencyException ide) {
                    result = new ActionStatus(false, ide.getMessage(), (Exception)((Object)ide));
                    Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Synchronize.Dependency.Change.Across.DCs"), ide);
                }
            } else {
                try {
                    if (compNode != null) {
                        this.theProxy.checkReferenceAllowed(compNode.getCompartment().getName(), aDCRef);
                    } else {
                        this.theProxy.checkReferenceAllowed(aDCRef);
                    }
                    result = new ActionStatus(true, null, null);
                }
                catch (SyncException se) {
                    result = new ActionStatus(false, se.getMessage(), (Exception)((Object)se));
                    Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Synchronize.Dependency.Change.Across.DCs"), se);
                }
                catch (IllegalDependencyException ide) {
                    result = new ActionStatus(false, ide.getMessage(), (Exception)((Object)ide));
                    Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Synchronize.Dependency.Change.Across.DCs"), ide);
                }
            }
        } else {
            Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Synchronize.Dependency.Change.Across.DCs"), null);
        }
        return result;
    }

    public ActionStatus editDependency(int pIndex, Dependency pDependencyDO) {
        ActionStatus result = ActionStatus.OKAY;
        this.removeDependency(pDependencyDO);
        Dependency dependency = this.createDependencyFromDO(pDependencyDO);
        result = this.isDependencyAllowed(dependency);
        if (result.getStatus()) {
            List theListOfDependencies = this.getDevelopmentComponent().getDependencies();
            theListOfDependencies.remove(dependency);
            theListOfDependencies.set(pIndex, dependency);
            try {
                this.theProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
            this.fireModelChange(new ModelChangeEvent(this));
        } else {
            List theListOfDependencies = this.getDevelopmentComponent().getDependencies();
            theListOfDependencies.remove(dependency);
        }
        return result;
    }

    public boolean removeDependency(Dependency aDep) {
        boolean result = true;
        List dependenciesList = this.getDevelopmentComponent().getDependencies();
        int aIndex = dependenciesList.lastIndexOf(aDep);
        if (aIndex != -1) {
            dependenciesList.remove(aIndex);
            try {
                this.theProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                Util.logException(this.theTracer, e);
            }
        } else {
            result = false;
        }
        if (result) {
            this.fireModelChange(new ModelChangeEvent(this));
        }
        return result;
    }

    public boolean removeAccessControl(ComponentReference aCompRef) {
        boolean result = true;
        List grantList = this.getDevelopmentComponent().getGrants();
        int aIndex = this.contains(aCompRef);
        if (aIndex != -1) {
            grantList.remove(aIndex);
        } else {
            result = false;
        }
        try {
            this.theProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logException(this.theTracer, e);
        }
        if (result) {
            this.fireModelChange(new ModelChangeEvent(this));
        }
        return result;
    }

    public IDevelopmentComponentNode getDCNode() {
        return this.theDCNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

