/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.EntityReference;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class EntityReferencesWizardController
implements IWizardController {
    public static final int ENTITYREFERENCES_WIZARD = 1000;
    public static final int ENTITYREFERENCES_WIZARD_PAGE = 1001;
    public static final int ENTITYREFERENCES_INPUTHELP_MANDATORY_COMPONENTREF_NAME_TEXT_KEY = 1;
    public static final int ENTITYREFERENCES_INPUTHELP_MANDATORY_COMPONENTREF_VENDOR_TEXT_KEY = 2;
    public static final int ENTITYREFERENCES_INPUTHELP_OPTIONAL_COMPONENTREF_SCALIAS_TEXT_KEY = 3;
    public static final int ENTITYREFERENCES_INPUTHELP_MANDATORY_PUBLICPARTREF_TEXT_KEY = 4;
    public static final int ENTITYREFERENCES_INPUTHELP_OPTIONAL_ENTITYNAME_TEXT_KEY = 5;
    public static final int ENTITYREFERENCES_INPUTHELP_OPTIONAL_ENTITYPATH_TEXT_KEY = 6;
    public static final int ENTITYREFERENCES_INPUTHELP_OPTIONAL_ENTITYTYPE_COMBO_KEY = 7;
    public static final int ENTITYREFERENCES_INPUTHELP_OPTIONAL_ENTITYSUBTYPE_COMBO_KEY = 8;
    private int[] theControllIDs = new int[]{1000, 1001, 1, 2, 3, 4, 5, 6, 7, 8};
    private IPPModel thePPModel;
    private EntityReference theEntityReference;
    private boolean isEdit;
    private int theCurrent;
    private IView theView;
    private MessageUtil theMessageUtil;
    private String theMessage;
    private int theIcon;
    private boolean canFinish;
    private int canFinishCounter;
    private HashMap theModelAdapters = new HashMap();

    public EntityReferencesWizardController(IPPModel aPPModel, boolean pTriggerByEdit, int pCurrent, IView pView, MessageUtil aMessageUtil) {
        this.thePPModel = aPPModel;
        this.theCurrent = pCurrent;
        this.isEdit = pTriggerByEdit;
        this.theView = pView;
        this.theMessageUtil = aMessageUtil;
        if (this.isEdit) {
            this.theEntityReference = new EntityReference();
            EntityReference toBeEdited = this.thePPModel.getEntityReference(this.theCurrent);
            DCReference aDCRefr = new DCReference();
            this.theEntityReference.setComponent(aDCRefr);
            aDCRefr.setName(toBeEdited.getComponent().getName());
            aDCRefr.setVendor(toBeEdited.getComponent().getVendor());
            aDCRefr.setSCAlias(toBeEdited.getComponent().getSCAlias());
            this.theEntityReference.setName(toBeEdited.getName());
            this.theEntityReference.setPackageName(toBeEdited.getPackageName());
            this.theEntityReference.setType(toBeEdited.getType());
            this.theEntityReference.setSubType(toBeEdited.getSubType());
            this.theEntityReference.setPublicPart(toBeEdited.getPublicPart());
        } else {
            this.theEntityReference = new EntityReference();
            DCReference aDCRefr = new DCReference();
            this.theEntityReference.setComponent(aDCRefr);
        }
        this.initModelAdapters();
    }

    private void initModelAdapters() {
        this.theModelAdapters.put(new Integer(1), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getComponent().getName();
            }
        });
        this.theModelAdapters.put(new Integer(2), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getComponent().getVendor();
            }
        });
        this.theModelAdapters.put(new Integer(3), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getComponent().getSCAlias();
            }
        });
        this.theModelAdapters.put(new Integer(4), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getPublicPart();
            }
        });
        this.theModelAdapters.put(new Integer(5), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getName();
            }
        });
        this.theModelAdapters.put(new Integer(6), new ITextViewModelAdapter(){

            public String getData() {
                return EntityReferencesWizardController.this.theEntityReference.getPackageName();
            }
        });
        this.theModelAdapters.put(new Integer(7), new IComboViewModelAdapter(){

            public String getText() {
                return EntityReferencesWizardController.this.theEntityReference.getType();
            }

            public String[] getItems() {
                return null;
            }
        });
        this.theModelAdapters.put(new Integer(8), new IComboViewModelAdapter(){

            public String getText() {
                return EntityReferencesWizardController.this.theEntityReference.getSubType();
            }

            public String[] getItems() {
                return null;
            }
        });
    }

    public EntityReference getEnityReference() {
        return this.theEntityReference;
    }

    public int[] getSuscribedContollIDs() {
        return this.theControllIDs;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return null;
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        return (IComboViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        return (ITextViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public boolean isEnabled(int pViewKey) {
        boolean result = true;
        if (!this.viewIsAButton(pViewKey) && !this.viewIsACombo(pViewKey)) {
            return result;
        }
        if (this.thePPModel.getPPFile().isReadOnly()) {
            result = false;
        } else if (pViewKey == 7 || pViewKey == 8) {
            result = false;
        }
        return result;
    }

    private boolean viewIsACombo(int pViewKey) {
        boolean result = false;
        if (pViewKey == 7 || pViewKey == 8) {
            result = true;
        }
        return result;
    }

    private boolean viewIsAButton(int pViewKey) {
        boolean result = false;
        return result;
    }

    public boolean isEditable(int pViewKey) {
        boolean result = true;
        if (!this.isEnabled(pViewKey)) {
            return false;
        }
        boolean isReadOnly = this.thePPModel.getPPFile().isReadOnly();
        if (isReadOnly) {
            return false;
        }
        if (pViewKey == 1 || pViewKey == 2 || pViewKey == 4 || pViewKey == 3 || pViewKey == 5 || pViewKey == 6) {
            result = false;
        }
        return result;
    }

    public boolean canFinish() {
        if (this.canFinishCounter <= 0) {
            ++this.canFinishCounter;
            return false;
        }
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        return this.canFinish();
    }

    public ComponentWizardPage getNextPage(int pKey) {
        return null;
    }

    public boolean performFinish() {
        ActionStatus result = ActionStatus.OKAY;
        result = this.isEdit ? this.thePPModel.editEntityReference(this.theCurrent, this.theEntityReference) : this.thePPModel.addEntityReference(this.theEntityReference);
        if (!result.getStatus()) {
            Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openError((Shell)theShell, (String)this.theMessageUtil.getString("Public.Part.Editor"), (String)this.theMessageUtil.getString("Warning.Could.Not.Create.EntityReference"));
        }
        return result.getStatus();
    }

    public boolean performCancel() {
        return true;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public void refresh() {
        ActionStatus result = this.thePPModel.isEntityReferenceAllowed(this.theEntityReference);
        if (result.getStatus()) {
            this.theMessage = this.getMessageUtil().getString("EntityReferences.InputHelp.Description");
            this.theIcon = 1;
            this.canFinish = true;
        } else {
            this.theIcon = 3;
            this.theMessage = result.getMessage();
            this.canFinish = false;
        }
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent selectionModelEvent, int n) {
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
    }

    public void handleTextViewChange(String string, int pKey) {
        switch (pKey) {
            case 1: {
                this.theEntityReference.getComponent().setName(string);
                break;
            }
            case 2: {
                this.theEntityReference.getComponent().setVendor(string);
                break;
            }
            case 3: {
                this.theEntityReference.getComponent().setSCAlias(string);
                break;
            }
            case 4: {
                this.theEntityReference.setPublicPart(string);
                break;
            }
            case 5: {
                this.theEntityReference.setName(string);
                break;
            }
            case 6: {
                this.theEntityReference.setPackageName(string);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleComboViewChange(String string, int pKey) {
        switch (pKey) {
            case 7: {
                this.theEntityReference.setType(string);
                break;
            }
            case 8: {
                if (string != null && !string.trim().equals("")) {
                    this.theEntityReference.setSubType(string);
                    break;
                }
                this.theEntityReference.setSubType(null);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
    }

    public void handleButtonViewPressed(boolean flag, int n) {
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }
}

