/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.FileSet;
import com.sap.tc.complib.validate.ValidationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class EditEntityWizardController
implements IWizardController {
    public static final int ENTITIES_WIZARD = 1000;
    public static final int ENTITIES_WIZARD_PAGE = 1001;
    public static final int ENTITIES_SELECTION_WIZARD_PAGE = 1002;
    public static final int ENTITIES_INPUTHELP_MANDATORY_NAME_TEXT_KEY = 1;
    public static final int ENTITIES_INPUTHELP_MANDATORY_TYPE_COMBO_KEY = 2;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_SUBTYPE_COMBO_KEY = 3;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_PACKAGE_COMBO_KEY = 4;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_CAPTION_TEXT_KEY = 5;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_DESCRIPTION_TEXT_KEY = 6;
    public static final int ENTITIES_INPUTHELP_SELECTION_ENTITY_TYPE_LIST_KEY = 7;
    public static final int ENTITIES_INPUTHELP_SELECTION_ENTITIES_LIST_KEY = 8;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_EXCLUDES_TEXT_KEY = 9;
    public static final int ENTITIES_INPUTHELP_OPTIONAL_INCLUDES_TEXT_KEY = 10;
    private int[] theControllIDs = new int[]{1000, 1001, 1002, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private IView theView;
    private IPPModel thePPModel;
    private IDCExtendedProject theEntityService;
    private ArrayList theEntityClones = new ArrayList();
    private ArrayList theEntityTypeItems = new ArrayList();
    private ArrayList theEntityTypeSelection = new ArrayList();
    private ArrayList theEntityItems = new ArrayList();
    private ArrayList theEntitySelection = new ArrayList();
    private Set thePackages;
    private boolean isEdit;
    private int theCurrent;
    private boolean canFinish;
    private int canFinishCounter;
    private MessageUtil theMessageUtil;
    private String theMessage;
    private int theIcon;

    public EditEntityWizardController(IPPModel aPPmodel, IDCExtendedProject aEntityService, Set aSetOfPackages, boolean pTriggerByEdit, int pCurrent, IView aView, MessageUtil aMessageUtil) {
        this.thePPModel = aPPmodel;
        this.theEntityService = aEntityService;
        this.isEdit = pTriggerByEdit;
        this.theCurrent = pCurrent;
        this.thePackages = aSetOfPackages;
        this.theView = aView;
        this.theMessageUtil = aMessageUtil;
        if (this.isEdit) {
            Entity aClone = ComponentFactory.createEntity();
            this.theEntityClones.add(aClone);
            Entity theEntity = this.thePPModel.getEntity(this.theCurrent);
            aClone.setCaption(theEntity.getCaption());
            aClone.setDescription(theEntity.getDescription());
            aClone.setFileSet(theEntity.getFileSet());
            aClone.setName(theEntity.getName());
            aClone.setPackageName(theEntity.getPackageName());
            aClone.setSubType(theEntity.getSubType());
            aClone.setType(theEntity.getType());
        } else {
            ArrayList aList = new ArrayList();
            Iterator anIter = this.theEntityService.getEntityTyps();
            while (anIter.hasNext()) {
                aList.add(anIter.next());
            }
            this.theEntityTypeItems.addAll(aList);
        }
        this.theMessage = this.theMessageUtil.getString(this.theCurrent != -1 ? "Entities.InputHelp.Title.Edit" : "Entities.InputHelp.Selection.Message");
        this.theIcon = 1;
    }

    public void setEntityService(IDCExtendedProject aEntityService) {
        this.theEntityService = aEntityService;
    }

    public ArrayList getEntities() {
        return this.theEntityClones;
    }

    public ArrayList getEntityTypeSelection() {
        return this.theEntityTypeSelection;
    }

    public ArrayList getEntityTypeItems() {
        return this.theEntityTypeItems;
    }

    public ArrayList getEntitySelection() {
        return this.theEntitySelection;
    }

    public ArrayList getEntityItems() {
        return this.theEntityItems;
    }

    public int[] getSuscribedContollIDs() {
        return this.theControllIDs;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return null;
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return null;
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        return null;
    }

    public boolean isEnabled(int pViewKey) {
        boolean result = true;
        if (!this.viewIsAButton(pViewKey) && !this.viewIsACombo(pViewKey)) {
            return result;
        }
        if (this.thePPModel.getPPFile().isReadOnly()) {
            result = false;
        }
        return result;
    }

    private boolean viewIsACombo(int pViewKey) {
        boolean result = false;
        if (pViewKey == 2 || pViewKey == 4 || pViewKey == 3) {
            result = true;
        }
        return result;
    }

    private boolean viewIsAButton(int pViewKey) {
        boolean result = false;
        return result;
    }

    public boolean isEditable(int pViewKey) {
        boolean result = true;
        if (!this.isEnabled(pViewKey)) {
            return false;
        }
        boolean isReadOnly = this.thePPModel.getPPFile().isReadOnly();
        if (isReadOnly) {
            return false;
        }
        return result;
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public boolean canFinish() {
        if (this.canFinishCounter <= 0) {
            ++this.canFinishCounter;
            return false;
        }
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        if (pKey == 1002) {
            return this.theEntityClones.size() > 0;
        }
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        if (pKey == 1002) {
            return this.theEntityClones.size() == 1;
        }
        return false;
    }

    public ComponentWizardPage getNextPage(int pKey) {
        if (pKey == 1002) {
            return (ComponentWizardPage)this.theView.getView(1001);
        }
        return null;
    }

    public boolean performFinish() {
        boolean aResult = true;
        if (this.isEdit) {
            ActionStatus result = this.thePPModel.editEntity(this.theCurrent, (Entity)this.theEntityClones.get(0));
            aResult = result.getStatus();
            if (!aResult) {
                Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
                MessageDialog.openError((Shell)theShell, (String)this.theMessageUtil.getString("Public.Part.Editor"), (String)this.theMessageUtil.getString("Warning.Could.Not.Edit.Entity"));
            }
        } else {
            ActionStatus result = ActionStatus.OKAY;
            int size = this.theEntityClones.size();
            int i = 0;
            while (i < size) {
                result = this.thePPModel.addEntity((Entity)this.theEntityClones.get(i));
                if (!result.getStatus()) {
                    Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
                    MessageDialog.openError((Shell)theShell, (String)this.theMessageUtil.getString("Public.Part.Editor"), (String)this.theMessageUtil.getString("Warning.Could.Not.Create.Entity"));
                }
                aResult = aResult && result.getStatus();
                ++i;
            }
        }
        return aResult;
    }

    public boolean performCancel() {
        return true;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent selectionModelEvent, int n) {
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
    }

    public void handleTextViewChange(String string, int pKey) {
        switch (pKey) {
            case 1: {
                ((Entity)this.theEntityClones.get(0)).setName(string);
                break;
            }
            case 5: {
                ((Entity)this.theEntityClones.get(0)).setCaption(string);
                break;
            }
            case 6: {
                ((Entity)this.theEntityClones.get(0)).setDescription(string);
                break;
            }
            case 9: {
                if (string.endsWith(",")) {
                    this.theMessage = this.theMessageUtil.getString("Entities.InputHelp.Excludes.Not.Complete");
                    this.theIcon = 3;
                    this.canFinish = false;
                    IView aComponentWizard = this.theView.getView(1001);
                    ((ComponentWizardPage)aComponentWizard).updateWizardPage();
                    return;
                }
                Entity anEntity = (Entity)this.theEntityClones.get(0);
                FileSet aFileSet = anEntity.getFileSet();
                if (aFileSet == null) {
                    aFileSet = new FileSet();
                    anEntity.setFileSet(aFileSet);
                }
                aFileSet.setExcludes(string);
                break;
            }
            case 10: {
                if (string.endsWith(",")) {
                    this.theMessage = this.theMessageUtil.getString("Entities.InputHelp.Includes.Not.Complete");
                    this.theIcon = 3;
                    this.canFinish = false;
                    IView aComponentWizard = this.theView.getView(1001);
                    ((ComponentWizardPage)aComponentWizard).updateWizardPage();
                    return;
                }
                Entity anEntity = (Entity)this.theEntityClones.get(0);
                FileSet aFileSet = anEntity.getFileSet();
                if (aFileSet == null) {
                    aFileSet = new FileSet();
                    anEntity.setFileSet(aFileSet);
                }
                aFileSet.setIncludes(string);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleComboViewChange(String string, int pKey) {
        switch (pKey) {
            case 2: {
                ((Entity)this.theEntityClones.get(0)).setType(string);
                break;
            }
            case 4: {
                ((Entity)this.theEntityClones.get(0)).setPackageName(string);
                break;
            }
            case 3: {
                ((Entity)this.theEntityClones.get(0)).setSubType(string);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void refresh() {
        if (this.theEntityClones.size() == 0) {
            this.theMessage = this.theMessageUtil.getString("Entities.InputHelp.Selection.No.Entity");
            this.theIcon = 3;
            this.canFinish = false;
            return;
        }
        try {
            ((Entity)this.theEntityClones.get(0)).validate();
            this.canFinish = true;
            this.theMessage = this.theMessageUtil.getString(this.theCurrent != -1 ? "Entities.InputHelp.Title.Edit" : "Entities.InputHelp.Selection.Message");
            this.theIcon = 1;
        }
        catch (ValidationException e) {
            this.theMessage = e.getMessage();
            this.theIcon = 3;
            this.canFinish = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
        switch (pKey) {
            case 7: {
                theSelectionPage = this.theView.getView(1002);
                theObject = (List)aListSelection.getSource();
                aTypeSelection = theObject.getSelectionIndices();
                EditEntityWizardController.intToArrayList(this.theEntityTypeSelection, aTypeSelection);
                theEntityType = (String)this.theEntityTypeItems.get(aTypeSelection[0]);
                if (this.theEntityService == null) break;
                aList = new ArrayList<Entity>();
                anIter = this.theEntityService.getEntities(theEntityType);
                while (anIter.hasNext()) {
                    anEnt = (Entity)anIter.next();
                    if (this.thePPModel.contains(anEnt) != -1) continue;
                    aList.add(anEnt);
                }
                availableEntities = aList.toArray(new Entity[aList.size()]);
                EditEntityWizardController.toStringArray(this.theEntityItems, availableEntities);
                if (availableEntities.length <= 0) ** GOTO lbl30
                while (!this.theEntityClones.isEmpty()) {
                    this.theEntityClones.remove(0);
                }
                this.theEntityClones.add(availableEntities[0]);
                EditEntityWizardController.intToArrayList(this.theEntitySelection, new int[]{0});
                break;
lbl-1000:
                // 1 sources

                {
                    this.theEntityClones.remove(0);
lbl30:
                    // 2 sources

                    ** while (!this.theEntityClones.isEmpty())
                }
lbl31:
                // 1 sources

                EditEntityWizardController.intToArrayList(this.theEntitySelection, new int[0]);
                break;
            }
            case 8: {
                theObject = (List)aListSelection.getSource();
                aEntitySelection = theObject.getSelectionIndices();
                EditEntityWizardController.intToArrayList(this.theEntitySelection, aEntitySelection);
                if (aEntitySelection.length <= 0) break;
                aList = new ArrayList<E>();
                aTypeSelection = (Integer)this.theEntityTypeSelection.get(0);
                aEntityType = (String)this.theEntityTypeItems.get(aTypeSelection);
                anIter = this.theEntityService.getEntities(aEntityType);
                while (anIter.hasNext()) {
                    aList.add(anIter.next());
                }
                while (!this.theEntityClones.isEmpty()) {
                    this.theEntityClones.remove(0);
                }
                i = 0;
                while (i < aEntitySelection.length) {
                    this.theEntityClones.add(aList.get(aEntitySelection[i]));
                    ++i;
                }
                break;
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    private static void intToArrayList(ArrayList aListOfIntegers, int[] aListOfInts) {
        while (!aListOfIntegers.isEmpty()) {
            aListOfIntegers.remove(0);
        }
        int i = 0;
        while (i < aListOfInts.length) {
            aListOfIntegers.add(new Integer(aListOfInts[i]));
            ++i;
        }
    }

    private static void toStringArray(ArrayList aListOfStrings, Entity[] anEntityArray) {
        while (!aListOfStrings.isEmpty()) {
            aListOfStrings.remove(0);
        }
        int size = anEntityArray.length;
        String[] result = new String[size];
        StringBuffer aBuffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            aBuffer.setLength(0);
            String aSubType = anEntityArray[i].getSubType();
            if (aSubType != null) {
                aBuffer.append("SubType: ").append(aSubType);
            }
            aBuffer.append(" Name: ").append(anEntityArray[i].getName());
            String aPackageName = anEntityArray[i].getPackageName();
            if (aPackageName != null) {
                aBuffer.append(" (").append(aPackageName).append(")");
            }
            aListOfStrings.add(aBuffer.toString());
            ++i;
        }
    }

    public void handleButtonViewPressed(boolean flag, int n) {
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }
}

