/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.DCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.DependencyWrapper;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.validate.ValidationException;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class DependenciesWizardController
implements IWizardController {
    public static final int WIZARD_DEPENDENCIES = 6000;
    public static final int WIZARD_PAGE_EDIT_DEPENDENCY = 6001;
    public static final int DEPENDENCIES_INPUTHELP_MANDATORY_COMPONENTREF_NAME_TEXT_KEY = 1;
    public static final int DEPENDENCIES_INPUTHELP_MANDATORY_COMPONENTREF_VENDOR_TEXT_KEY = 2;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_COMPONENTREF_SCALIAS_TEXT_KEY = 3;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_PUBLICPARTREF_TEXT_KEY = 4;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_FORCHILDREN_BUTTON_KEY = 5;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_ATDESIGNTIME_BUTTON_KEY = 6;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_ATBUILDTIME_BUTTON_KEY = 7;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_ATRUNTIME_BUTTON_KEY = 8;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_ATRUNTIME_QUALIFIER_COMBO_KEY = 9;
    public static final int DEPENDENCIES_INPUTHELP_OPTIONAL_ATDEPLOYTIME_BUTTON_KEY = 10;
    private static int[] theControllIDs = new int[]{6000, 6001, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private MessageUtil theMessageUtil;
    private IDCModel theModel;
    private DCModel dcModel;
    private boolean isEdit;
    private int theCurrent;
    private IView theView;
    private int canFinishCounter = 0;
    private DependencyWrapper dependencyWrapper;
    private Dependency theDependency;
    private boolean canFinish = false;
    private String theMessage;
    private int theIcon;
    private HashMap theModelAdapters = new HashMap();

    public DependenciesWizardController(IDCModel aDCModel, boolean triggeredByEdit, int aCurrent, IView aView, MessageUtil aUtil) {
        this.theModel = aDCModel;
        this.dcModel = (DCModel)this.theModel;
        this.theMessageUtil = aUtil;
        this.theView = aView;
        this.theCurrent = aCurrent;
        this.isEdit = triggeredByEdit;
        if (this.isEdit) {
            Dependency aDependency = this.theModel.getDependency(this.theCurrent);
            this.theDependency = ComponentFactory.createDependency();
            this.dcModel.setTempDependency(this.theDependency);
            DCReference aDCRef = new DCReference();
            aDCRef.setName(aDependency.getComponent().getName());
            aDCRef.setVendor(aDependency.getComponent().getVendor());
            aDCRef.setSCAlias(aDependency.getComponent().getSCAlias());
            this.theDependency.setComponent(aDCRef);
            this.theDependency.setAtBuildTime(aDependency.isAtBuildTime());
            this.theDependency.setAtDeployTime(aDependency.isAtDeployTime());
            this.theDependency.setAtDesignTime(aDependency.isAtDesignTime());
            this.theDependency.setAtRunTime(aDependency.isAtRunTime(), aDependency.getRuntimeQuialifier());
            this.theDependency.setForChildrenOnly(aDependency.isForChildrenOnly());
            this.theDependency.setPublicPart(aDependency.getPublicPart());
        } else {
            this.theDependency = ComponentFactory.createDependency();
            this.dcModel.setTempDependency(this.theDependency);
            DCReference aDCRef = new DCReference();
            aDCRef.setName("");
            aDCRef.setVendor("");
            aDCRef.setSCAlias("");
            this.theDependency.setComponent(aDCRef);
            this.theDependency.setAtBuildTime(true);
            this.theDependency.setAtDeployTime(false);
            this.theDependency.setAtDesignTime(false);
            this.theDependency.setAtRunTime(false, "");
        }
        this.theIcon = 1;
        this.theMessage = this.theMessage = this.getMessageUtil().getString("Dependencies.InputHelp.Description");
        this.initModelAdapters();
    }

    private void initModelAdapters() {
        this.theModelAdapters.put(new Integer(1), new ITextViewModelAdapter(){

            public String getData() {
                return DependenciesWizardController.this.theDependency.getComponent().getName();
            }
        });
        this.theModelAdapters.put(new Integer(2), new ITextViewModelAdapter(){

            public String getData() {
                return DependenciesWizardController.this.theDependency.getComponent().getVendor();
            }
        });
        this.theModelAdapters.put(new Integer(3), new ITextViewModelAdapter(){

            public String getData() {
                return DependenciesWizardController.this.theDependency.getComponent().getSCAlias();
            }
        });
        this.theModelAdapters.put(new Integer(4), new ITextViewModelAdapter(){

            public String getData() {
                return DependenciesWizardController.this.theDependency.getPublicPart();
            }
        });
        this.theModelAdapters.put(new Integer(5), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return DependenciesWizardController.this.theDependency.isForChildrenOnly();
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(6), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return DependenciesWizardController.this.theDependency.isAtDesignTime();
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(7), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return DependenciesWizardController.this.theDependency.isAtBuildTime();
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(10), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return DependenciesWizardController.this.theDependency.isAtDeployTime();
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(8), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return DependenciesWizardController.this.theDependency.isAtRunTime();
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(9), new IComboViewModelAdapter(){

            public String getText() {
                return DependenciesWizardController.this.theDependency.getRuntimeQuialifier();
            }

            public String[] getItems() {
                return null;
            }
        });
    }

    public int[] getSuscribedContollIDs() {
        return theControllIDs;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return null;
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        return (IComboViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return (IButtonViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        return (ITextViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public boolean isEnabled(int pViewKey) {
        boolean result = true;
        if (!this.viewIsAButton(pViewKey) && !this.viewIsACombo(pViewKey)) {
            return result;
        }
        if (this.theModel.getDCdefFile().isReadOnly()) {
            result = false;
        }
        return result;
    }

    private boolean viewIsAButton(int pViewKey) {
        boolean result = false;
        if (pViewKey == 5 || pViewKey == 6 || pViewKey == 7 || pViewKey == 8 || pViewKey == 9 || pViewKey == 10) {
            result = true;
        }
        return result;
    }

    private boolean viewIsACombo(int pViewKey) {
        boolean result = false;
        return result;
    }

    public boolean isEditable(int pViewKey) {
        boolean result = false;
        return result;
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public void refresh() {
        int aIndex;
        try {
            this.theDependency.validate();
            this.theMessage = this.getMessageUtil().getString("Dependencies.InputHelp.Description");
            this.theIcon = 1;
            this.canFinish = true;
        }
        catch (ValidationException ve) {
            this.theMessage = ve.getMessage();
            this.theIcon = 3;
            this.canFinish = false;
            return;
        }
        if (this.isEdit) {
            return;
        }
        if (!this.dcModel.containsDependencyWrapper(this.dcModel.getSelectedElement()) && (aIndex = this.theModel.contains(this.theDependency)) != -1) {
            this.theMessage = this.getMessageUtil().getString("Warning.Dependencies.Dublicated");
            this.theIcon = 3;
            this.canFinish = false;
            return;
        }
        ActionStatus status = this.dcModel.isDependencyAllowed(this.dcModel.getSelectedElement(), this.theDependency);
        if (!status.getStatus()) {
            this.theMessage = status.getMessage();
            this.theIcon = 3;
            this.canFinish = false;
            return;
        }
        this.theMessage = this.getMessageUtil().getString("Dependencies.InputHelp.Description");
        this.theIcon = 1;
        this.canFinish = true;
    }

    public boolean canFinish() {
        if (this.canFinishCounter <= 0) {
            ++this.canFinishCounter;
            return false;
        }
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        return this.canFinish();
    }

    public ComponentWizardPage getNextPage(int pKey) {
        return null;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public boolean performFinish() {
        ActionStatus result = ActionStatus.OKAY;
        result = this.isEdit ? this.theModel.editDependency(this.theCurrent, this.theDependency) : this.dcModel.finalizeDependencyWrappers();
        if (!result.getStatus()) {
            Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openError((Shell)theShell, (String)this.theMessageUtil.getString("Development.Component.Editor"), (String)this.theMessageUtil.getString("Warning.Could.Not.Create.Dependency"));
        }
        return result.getStatus();
    }

    public boolean performCancel() {
        return true;
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent selectionModelEvent, int n) {
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
    }

    public void handleTextViewChange(String string, int pKey) {
        switch (pKey) {
            case 1: {
                this.theDependency.getComponent().setName(string);
                break;
            }
            case 2: {
                this.theDependency.getComponent().setVendor(string);
                break;
            }
            case 3: {
                this.theDependency.getComponent().setSCAlias(string);
                break;
            }
            case 4: {
                this.theDependency.setPublicPart(string != null && string.trim().intern() != "".intern() ? string : null);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleComboViewChange(String string, int pKey) {
        switch (pKey) {
            case 9: {
                this.theDependency.setRuntimeQualifier(string);
                break;
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
    }

    public void handleButtonViewPressed(boolean flag, int pKey) {
        switch (pKey) {
            case 5: {
                this.theDependency.setForChildrenOnly(flag);
                break;
            }
            case 6: {
                this.theDependency.setAtDesignTime(flag);
                break;
            }
            case 7: {
                this.theDependency.setAtBuildTime(flag);
                break;
            }
            case 8: {
                this.theDependency.setAtRunTime(flag);
                break;
            }
            case 10: {
                this.theDependency.setAtDeployTime(flag);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }
}

