/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.validate.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class CreatePPController
implements IWizardController {
    public static final int CREATE_NEW_PP_WIZARD = 1000;
    public static final int CREATE_NEW_PP_WIZARD_PAGE = 1001;
    public static final int NEW_PUBLIC_PART_WIZARD_NAME_TEXT_KEY = 1;
    public static final int NEW_PUBLIC_PART_WIZARD_SCHEMA_VERSION_COMBO_KEY = 2;
    public static final int NEW_PUBLIC_PART_WIZARD_FILE_NAME_TEXT_KEY = 3;
    public static final int NEW_PUBLIC_PART_WIZARD_CAPTION_TEXT_KEY = 4;
    public static final int NEW_PUBLIC_PART_WIZARD_DESCRIPTION_TEXT_KEY = 5;
    public static final int NEW_PUBLIC_PART_WIZARD_PURPOSE_RADIO_BUTTON_COMPILATION_KEY = 6;
    public static final int NEW_PUBLIC_PART_WIZARD_PURPOSE_RADIO_BUTTON_ASSEMBLY_KEY = 7;
    public static final int NEW_PUBLIC_PART_WIZARD_PURPOSE_RADIO_BUTTON_INFRASTRUCTURE_KEY = 8;
    private static int[] theControllIDS = new int[]{1000, 1001, 1, 3, 4, 5, 6, 7, 8};
    private IFolder theDefFolder;
    private IFile thePPFile;
    private PPModel thePPModel;
    private IView theView;
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    private String theMessage = this.theMessageUtil.getString("NewPp.Information.Required");
    private int theIcon = 1;
    private boolean canFinish = false;
    private int canFinishCounter = 0;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private HashMap theModelApapters = new HashMap();

    public CreatePPController(IView aView, PPModel aModel, IFolder aDefFolder) {
        this.theView = aView;
        this.theDefFolder = aDefFolder;
        this.thePPModel = aModel;
        this.initModelAdapters();
    }

    private void initModelAdapters() {
        this.theModelApapters.put(new Integer(1), new ITextViewModelAdapter(){

            public String getData() {
                return CreatePPController.this.thePPModel.getName();
            }
        });
        this.theModelApapters.put(new Integer(2), new IComboViewModelAdapter(){

            public String getText() {
                return CreatePPController.this.thePPModel.getSchemaVersion();
            }

            public String[] getItems() {
                return null;
            }
        });
        this.theModelApapters.put(new Integer(6), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return CreatePPController.this.thePPModel.getPurpose().intern() == PublicPart.Purpose.COMPILATION.toString().intern();
            }

            public boolean isVisible() {
                String theTypeVendor = CreatePPController.this.thePPModel.getDCModel().getComponentType().getVendor();
                String theType = CreatePPController.this.thePPModel.getDCModel().getComponentType().getType();
                boolean isInfrastructure = false;
                if (theTypeVendor.equals("sap.com") && (theType.equals("Build Infrastructure") || theType.equals("Build Plugin"))) {
                    isInfrastructure = true;
                }
                return !isInfrastructure;
            }
        });
        this.theModelApapters.put(new Integer(7), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return CreatePPController.this.thePPModel.getPurpose().intern() == PublicPart.Purpose.ASSEMBLY.toString().intern();
            }

            public boolean isVisible() {
                String theTypeVendor = CreatePPController.this.thePPModel.getDCModel().getComponentType().getVendor();
                String theType = CreatePPController.this.thePPModel.getDCModel().getComponentType().getType();
                boolean isInfrastructure = false;
                if (theTypeVendor.equals("sap.com") && (theType.equals("Build Infrastructure") || theType.equals("Build Plugin"))) {
                    isInfrastructure = true;
                }
                return !isInfrastructure;
            }
        });
        this.theModelApapters.put(new Integer(8), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return CreatePPController.this.thePPModel.getPurpose().intern() == PublicPart.Purpose.INFRASTRUCTURE.toString().intern();
            }

            public boolean isVisible() {
                String theTypeVendor = CreatePPController.this.thePPModel.getDCModel().getComponentType().getVendor();
                String theType = CreatePPController.this.thePPModel.getDCModel().getComponentType().getType();
                boolean isInfrastructure = false;
                if (theTypeVendor.equals("sap.com") && (theType.equals("Build Infrastructure") || theType.equals("Build Plugin"))) {
                    isInfrastructure = true;
                }
                return isInfrastructure;
            }
        });
        this.theModelApapters.put(new Integer(5), new ITextViewModelAdapter(){

            public String getData() {
                return CreatePPController.this.thePPModel.getDescription();
            }
        });
        this.theModelApapters.put(new Integer(4), new ITextViewModelAdapter(){

            public String getData() {
                return CreatePPController.this.thePPModel.getCaption();
            }
        });
        this.theModelApapters.put(new Integer(3), new ITextViewModelAdapter(){

            public String getData() {
                return CreatePPController.this.thePPModel.getName() + ".pp";
            }
        });
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int[] getSuscribedContollIDs() {
        return theControllIDS;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return null;
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        return null;
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return (IButtonViewModelAdapter)this.theModelApapters.get(new Integer(pViewKey));
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        return (ITextViewModelAdapter)this.theModelApapters.get(new Integer(pViewKey));
    }

    public boolean isEnabled(int pViewKey) {
        return true;
    }

    public boolean isEditable(int pViewKey) {
        boolean result = true;
        switch (pViewKey) {
            case 3: {
                result = false;
            }
        }
        return result;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        return this.canFinish();
    }

    public ComponentWizardPage getNextPage(int pKey) {
        return null;
    }

    private void refresh() {
        boolean exists;
        IResource aResource = this.theDefFolder.findMember(this.thePPModel.getName() + ".pp");
        boolean bl = exists = aResource == null ? false : aResource.exists();
        if (exists) {
            this.canFinish = false;
            this.theMessage = this.theMessageUtil.getString("NewPp.Error.FileName");
            this.theIcon = 3;
            return;
        }
        try {
            this.thePPModel.validate();
            this.canFinish = true;
            this.theMessage = this.theMessageUtil.getString("NewPp.Information.CanFinish");
            this.theIcon = 1;
        }
        catch (ValidationException e) {
            this.canFinish = false;
            this.theMessage = e.getMessage();
            this.theIcon = 3;
        }
    }

    public String getMessage() {
        return this.theMessage;
    }

    public IFile getNewPPFile() {
        return this.thePPFile;
    }

    public void handleModelChange(ModelChangeEvent aChangeEvent) {
    }

    public boolean performFinish() {
        boolean result = true;
        this.thePPFile = this.theDefFolder.getFile(this.thePPModel.getName() + ".pp");
        try {
            if (!this.theDefFolder.exists()) {
                this.theDefFolder.create(true, true, null);
            }
        }
        catch (CoreException ce) {
            Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ce);
            Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
            String title = this.theMessageUtil.getString("Public.Part.Editor");
            String message = this.theMessageUtil.getString("Error.Could.Not.Create.PP.Folder");
            MessageDialog.openError((Shell)aShell, (String)title, (String)message);
            return false;
        }
        ActionStatus actionResult = this.thePPModel.writeModelTo(this.thePPFile);
        if (!actionResult.getStatus()) {
            ProgressMonitorDialog aDialog;
            result = false;
            Shell aShell = ComponentProviderPlugin.getPlugin().getMyShell();
            String title = this.theMessageUtil.getString("Public.Part.Editor");
            String message = this.theMessageUtil.getString("Error.Could.Not.Create.PublicPart");
            MessageDialog.openError((Shell)aShell, (String)title, (String)message);
            try {
                IRunnableWithProgress aFileRefresh = new IRunnableWithProgress(){

                    public void run(IProgressMonitor aMon) {
                        try {
                            CreatePPController.this.thePPFile.refreshLocal(0, aMon);
                        }
                        catch (Exception e) {
                            Util.logExceptionMessage(CreatePPController.this.theTracer, 2, CreatePPController.this.theMessageUtil.getString("Exception.Occured"), e);
                        }
                    }
                };
                aDialog = new ProgressMonitorDialog(aShell);
                aDialog.run(false, false, aFileRefresh);
            }
            catch (Exception ce) {
                Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ce);
            }
            if (this.thePPFile.exists()) {
                try {
                    IRunnableWithProgress aDelete = new IRunnableWithProgress(){

                        public void run(IProgressMonitor aMon) {
                            try {
                                CreatePPController.this.thePPFile.delete(true, false, aMon);
                            }
                            catch (Exception e) {
                                Util.logExceptionMessage(CreatePPController.this.theTracer, 2, CreatePPController.this.theMessageUtil.getString("Exception.Occured"), e);
                            }
                        }
                    };
                    aDialog = new ProgressMonitorDialog(aShell);
                    aDialog.run(false, false, aDelete);
                }
                catch (Exception ce) {
                    Util.logExceptionMessage(this.theTracer, 2, this.theMessageUtil.getString("Exception.Occured"), ce);
                    aShell = ComponentProviderPlugin.getPlugin().getMyShell();
                    title = this.theMessageUtil.getString("Public.Part.Editor");
                    message = this.theMessageUtil.getString("Error.Could.Not.Delete.PublicPart.File");
                    MessageDialog.openError((Shell)aShell, (String)title, (String)message);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean performCancel() {
        return true;
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent selectionModelEvent, int n) {
    }

    public void handleTextViewChange(String pTextString, int pKey) {
        switch (pKey) {
            case 1: {
                this.thePPModel.setName(pTextString, false);
                break;
            }
            case 4: {
                this.thePPModel.setCaption(pTextString, false);
                break;
            }
            case 5: {
                this.thePPModel.setDescription(pTextString, false);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleComboViewChange(String pComboTextString, int pKey) {
    }

    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
    }

    public void handleButtonViewPressed(boolean flag, int pKey) {
        switch (pKey) {
            case 7: {
                if (!flag) break;
                this.thePPModel.setPurpose(PublicPart.Purpose.ASSEMBLY.toString());
                break;
            }
            case 6: {
                if (!flag) break;
                this.thePPModel.setPurpose(PublicPart.Purpose.COMPILATION.toString());
                break;
            }
            case 8: {
                if (!flag) break;
                this.thePPModel.setPurpose(PublicPart.Purpose.INFRASTRUCTURE.toString());
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }
}

