/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelInitException;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.EntityComparator;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PPModel;
import com.sap.ide.eclipse.component.dcmetadata.view.AddEditAdvancedEntitiesInputShell;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.Entity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.text.Collator;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class AddEditEntityWizardController
implements IWizardController {
    public static final int ENTITIES_ADD_EDIT_WIZARD = 2000;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE = 2001;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_ENTITY_TYPE_LIST_KEY = 11;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_ENTITY_TYPE_TABLE_KEY = 12;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_ENTITY_TREE_KEY = 13;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_ENTITY_NAME_TEXT_KEY = 14;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_AS_CLASS_BUTTON_KEY = 15;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_AS_SOURCE_BUTTON_KEY = 16;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_ADVANCED_BUTTON_KEY = 17;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_FLAT_LAYOUT_BUTTON_KEY = 18;
    public static final int ENTITIES_ADD_EDIT_WIZARD_PAGE_HIERARCHICAL_LAYOUT_BUTTON_KEY = 19;
    private static int[] theControllIDs = new int[]{2000, 2001, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private IView theView;
    private IPPModel thePPModel;
    private IDCExtendedProject theEntityService;
    private ArrayList thePublicPartEntitiesList;
    private ArrayList theEntityTypeItems = new ArrayList();
    private int theEntityTypeSelection = -1;
    private ArrayList theEntityItems = new ArrayList();
    private HashMap theTree = new HashMap();
    private boolean isFlatt = true;
    private String theEntityPathSelection = null;
    private EntitiesContentProvider theTreeContentProvider = new EntitiesContentProvider();
    private EntityTypesContentProvider theEntityTypesContentProvider = new EntityTypesContentProvider();
    private EntitiesLabelProvider theTreeLabelProvider = new EntitiesLabelProvider();
    private EntityTypesLabelProvider theEntityTypesLableProvider = new EntityTypesLabelProvider();
    private EntitiesPathSorter theTreeSorter = new EntitiesPathSorter();
    private boolean canFinish;
    private int canFinishCounter;
    private MessageUtil theMessageUtil;
    private String theMessage;
    private int theIcon;
    private HashMap theModelAdapters = new HashMap();
    private EntitiesSorter theEntitiesComparator = new EntitiesSorter();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public AddEditEntityWizardController(IView aView, IPPModel aPPmodel, IDCExtendedProject aEntityService, Entity pCurrent, MessageUtil aMessageUtil) {
        this.thePPModel = aPPmodel;
        this.theEntityService = aEntityService;
        this.theView = aView;
        this.theMessageUtil = aMessageUtil;
        this.theMessage = this.theMessageUtil.getString(pCurrent != null ? "Entities.InputHelp.Title.Edit" : "Entities.InputHelp.Selection.Message");
        this.theIcon = 1;
        this.canFinish = true;
        ArrayList aList = new ArrayList();
        Iterator anIter = this.theEntityService.getEntityTyps();
        while (anIter.hasNext()) {
            aList.add(anIter.next());
        }
        this.theEntityTypeItems.addAll(aList);
        this.thePublicPartEntitiesList = this.thePPModel.cloneEntities();
        if (pCurrent != null) {
            String aType = pCurrent.getType();
            int index = this.theEntityTypeItems.indexOf(aType);
            if (index == -1) {
                Util.logExceptionMessage(this.theTracer, 3, this.theMessageUtil.getString("Warning.Could.Not.Find.Entity"), null);
            } else {
                this.theEntityTypeSelection = index;
                if (this.theEntityService != null) {
                    this.theEntityItems.clear();
                    anIter = this.theEntityService.getEntities(aType);
                    while (anIter.hasNext()) {
                        Entity anEnt = (Entity)anIter.next();
                        this.theEntityItems.add(anEnt);
                    }
                    Collections.sort(this.theEntityItems, this.theEntitiesComparator);
                    this.buildTreeItems();
                }
                this.theEntityPathSelection = AddEditEntityWizardController.getEntityPath(pCurrent);
            }
        }
        this.initModelAdapters();
    }

    private static int countPathSeparators(String aPath) {
        int count = 0;
        int index = -1;
        while ((index = aPath.indexOf("/", index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static String getEntityPath(Entity anEnt) {
        String entPath = "";
        IPPModel.EntityType entType = IPPModel.EntityType.toType(anEnt.getType());
        if (entType == IPPModel.EntityType.FOLDER || entType == IPPModel.EntityType.ABSOLUTE_FOLDER || entType == IPPModel.EntityType.FOLDER_TREE || entType == IPPModel.EntityType.ABSOLUTE_FOLDER_TREE || entType == IPPModel.EntityType.FILE || entType == IPPModel.EntityType.ABSOLUTE_FILE) {
            entPath = anEnt.getName();
            entPath = entPath.intern() == "/".intern() ? "" : "/" + anEnt.getName();
        }
        if ((entType == IPPModel.EntityType.DICTIONARY_DATABASE_TABLE || entType == IPPModel.EntityType.DICTIONARY_DATABASE_VIEW || entType == IPPModel.EntityType.WAR || entType == IPPModel.EntityType.EJB_CLIENT_JAR || entType == IPPModel.EntityType.EJB_JAR) && (entPath = anEnt.getName()).length() > 0 && entPath.indexOf("/") != 0) {
            entPath = "/" + entPath;
        }
        if ((entType == IPPModel.EntityType.JAVA_PACKAGE || entType == IPPModel.EntityType.JAVA_PACKAGE_TREE || entType == IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT || entType == IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT) && (entPath = anEnt.getPackageName()).length() > 0 && entPath.indexOf("/") != 0) {
            entPath = "/" + entPath;
        }
        if ((entType == IPPModel.EntityType.JAVA_CLASS || entType == IPPModel.EntityType.SQLJ_CLASS || entType == IPPModel.EntityType.COMMON_MODEL || entType == IPPModel.EntityType.WEB_DYNPRO_COMPONENT || entType == IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION || entType == IPPModel.EntityType.WEB_SERVICE_DEFINITION || entType == IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE || entType == IPPModel.EntityType.DICTIONARY_STRUCTURE) && (entPath = anEnt.getPackageName() + "/" + anEnt.getName()).length() > 0 && entPath.indexOf("/") != 0) {
            entPath = "/" + entPath;
        }
        return entPath;
    }

    public static Image getEntityTypeImage(String anEntityType) {
        Image aImage = anEntityType != null && anEntityType.intern() == IPPModel.EntityType.JAVA_PACKAGE.toString().intern() ? ComponentCategoryImage.getImage("Entity type: Java Package") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.JAVA_PACKAGE_TREE.toString().intern() ? ComponentCategoryImage.getImage("Entity type: Java Package Tree") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern() ? ComponentCategoryImage.getImage("Entity type: Java Class") : (anEntityType != null && (anEntityType.intern() == IPPModel.EntityType.FILE.toString().intern() || anEntityType.intern() == IPPModel.EntityType.ABSOLUTE_FILE.toString().intern()) ? ComponentCategoryImage.getImage("Entity type: File") : (anEntityType != null && (anEntityType.intern() == IPPModel.EntityType.FOLDER.toString().intern() || anEntityType.intern() == IPPModel.EntityType.ABSOLUTE_FOLDER.toString().intern()) ? ComponentCategoryImage.getImage("Entity type: Folder") : (anEntityType != null && (anEntityType.intern() == IPPModel.EntityType.FOLDER_TREE.toString().intern() || anEntityType.intern() == IPPModel.EntityType.ABSOLUTE_FOLDER_TREE.toString().intern()) ? ComponentCategoryImage.getImage("Entity type: Folder Tree") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.WEB_DYNPRO_COMPONENT.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Web Dynpro Component") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Web Dynpro Component Interface Definition") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.COMMON_MODEL.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Common Model") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.WEB_SERVICE_DEFINITION.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Web service definition") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Web service deployable client") : (anEntityType != null && anEntityType.intern() == IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT.toString().intern() ? ComponentCategoryImage.getImage("Entity type:  Web service standalone client") : ComponentCategoryImage.getImage("Public Part Entity"))))))))))));
        return aImage;
    }

    private static Entity getEntity(ArrayList aListOfEntities, Entity pEntity, String pSubType) {
        Entity result = null;
        Iterator anIter = ((AbstractList)aListOfEntities).iterator();
        while (anIter.hasNext()) {
            boolean subtypeEquality;
            Entity anEntity = (Entity)anIter.next();
            String aSubType = anEntity.getSubType();
            boolean bl = subtypeEquality = aSubType == null && pSubType == null || aSubType != null && aSubType.equals(pSubType);
            if (!EntityComparator.equals(anEntity, pEntity, true) || !subtypeEquality) continue;
            result = anEntity;
            break;
        }
        return result;
    }

    private void initModelAdapters() {
        this.theModelAdapters.put(new Integer(11), new IListViewModelAdapter(){

            public String[] getDefaultItems() {
                return AddEditEntityWizardController.this.theEntityTypeItems.toArray(new String[AddEditEntityWizardController.this.theEntityTypeItems.size()]);
            }

            public int[] getSelection() {
                return new int[]{AddEditEntityWizardController.this.theEntityTypeSelection};
            }

            public String[] getItems() {
                return null;
            }
        });
        this.theModelAdapters.put(new Integer(12), new ITableModelAdapter(){

            public String[] getColumnLables() {
                return new String[]{"Entity Types"};
            }

            public IStructuredContentProvider getContentProvider() {
                return AddEditEntityWizardController.this.theEntityTypesContentProvider;
            }

            public ViewerSorter getSorter() {
                return null;
            }

            public ITableLabelProvider getLabelProvider() {
                return AddEditEntityWizardController.this.theEntityTypesLableProvider;
            }

            public Object getInput() {
                return AddEditEntityWizardController.this.theEntityTypeItems;
            }

            public List getSelectedElements() {
                ArrayList result = new ArrayList();
                if (AddEditEntityWizardController.this.theEntityTypeSelection > -1 && AddEditEntityWizardController.this.theEntityTypeSelection < AddEditEntityWizardController.this.theEntityTypeItems.size()) {
                    result.add(AddEditEntityWizardController.this.theEntityTypeItems.get(AddEditEntityWizardController.this.theEntityTypeSelection));
                }
                return result;
            }

            public ViewerFilter[] getFilters() {
                return new ViewerFilter[0];
            }
        });
        this.theModelAdapters.put(new Integer(13), new ITreeModelAdapter(){

            public ITreeContentProvider getContentProvider() {
                return AddEditEntityWizardController.this.theTreeContentProvider;
            }

            public ViewerSorter getSorter() {
                return AddEditEntityWizardController.this.theTreeSorter;
            }

            public LabelProvider getLabelProvider() {
                return AddEditEntityWizardController.this.theTreeLabelProvider;
            }

            public Object getInput() {
                return AddEditEntityWizardController.this.theTreeContentProvider.getInput();
            }

            public Object[] getCheckedElements() {
                return AddEditEntityWizardController.this.theTreeContentProvider.getCheckedElements();
            }

            public List getSelectedElements() {
                ArrayList<String> result = new ArrayList<String>();
                if (AddEditEntityWizardController.this.theEntityPathSelection != null) {
                    result.add(AddEditEntityWizardController.this.theEntityPathSelection);
                }
                return result;
            }

            public Object[] getGrayedElements() {
                return AddEditEntityWizardController.this.theTreeContentProvider.getGrayedElements();
            }

            public ViewerFilter[] getFilters() {
                return AddEditEntityWizardController.this.theTreeContentProvider.getFilters();
            }
        });
        this.theModelAdapters.put(new Integer(14), new ITextViewModelAdapter(){

            public String getData() {
                Entity theEntityPathSelection = AddEditEntityWizardController.this.getEntitySelectionInstance();
                if (theEntityPathSelection != null) {
                    return theEntityPathSelection.getName();
                }
                return "";
            }
        });
        this.theModelAdapters.put(new Integer(15), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                Entity thePPEntitySelection = AddEditEntityWizardController.this.getPPEntitySelectionInstance(IPPModel.EntitySubType.CLASS);
                return thePPEntitySelection != null;
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(16), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                Entity thePPEntitySelection = AddEditEntityWizardController.this.getPPEntitySelectionInstance(IPPModel.EntitySubType.SOURCE);
                return thePPEntitySelection != null;
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(18), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return true;
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.theModelAdapters.put(new Integer(19), new IButtonViewModelAdapter(){

            public boolean getSelection() {
                return true;
            }

            public boolean isVisible() {
                return true;
            }
        });
    }

    private Entity[] getPPEntities(String aPath) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        Iterator anIter = ((AbstractList)this.thePublicPartEntitiesList).iterator();
        String theType = (String)this.theEntityTypeItems.get(this.theEntityTypeSelection);
        while (anIter.hasNext()) {
            Entity anEntity = (Entity)anIter.next();
            String anEntPath = AddEditEntityWizardController.getEntityPath(anEntity);
            if (anEntity.getType().intern() != theType.intern() || aPath.intern() != anEntPath.intern()) continue;
            result.add(anEntity);
        }
        return result.toArray(new Entity[result.size()]);
    }

    private Entity getEntitySelectionInstance() {
        Entity result = null;
        List theEntitiesList = (List)this.theTree.get(this.theEntityPathSelection);
        if (theEntitiesList != null) {
            result = (Entity)theEntitiesList.get(0);
        }
        return result;
    }

    private Entity getEntitySelectionInstance(IPPModel.EntitySubType aSubType) {
        Entity result = null;
        List theEntitiesList = (List)this.theTree.get(this.theEntityPathSelection);
        if (theEntitiesList != null) {
            Iterator anIter = theEntitiesList.iterator();
            while (anIter.hasNext()) {
                Entity anEnt = (Entity)anIter.next();
                String aSubtype = anEnt.getSubType();
                if (aSubtype == null || aSubtype.intern() != aSubType.toString().intern()) continue;
                result = anEnt;
                break;
            }
        }
        return result;
    }

    private Entity getPPEntitySelectionInstance(IPPModel.EntitySubType aSubType) {
        Entity result = null;
        String sSubTypeAsString = aSubType.toString();
        if (this.theEntityPathSelection != null) {
            Entity[] listOfPPEntities = this.getPPEntities(this.theEntityPathSelection);
            int i = 0;
            while (i < listOfPPEntities.length) {
                String aSubTypeString = listOfPPEntities[i].getSubType();
                if (aSubTypeString != null && aSubTypeString.equals(sSubTypeAsString)) {
                    result = listOfPPEntities[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private Entity getPPEntitySelectionInstance() {
        Entity[] listOfPPEntities;
        Entity result = null;
        if (this.theEntityPathSelection != null && (listOfPPEntities = this.getPPEntities(this.theEntityPathSelection)).length > 0) {
            result = listOfPPEntities[0];
        }
        return result;
    }

    public int[] getSuscribedContollIDs() {
        return theControllIDs;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return (IListViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return (ITreeModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return (ITableModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        return null;
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return (IButtonViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        return (ITextViewModelAdapter)this.theModelAdapters.get(new Integer(pViewKey));
    }

    public boolean isEnabled(int pViewKey) {
        boolean result = true;
        block0 : switch (pViewKey) {
            case 17: {
                result = this.getPPEntitySelectionInstance() != null;
                break;
            }
            case 14: {
                result = false;
                break;
            }
            case 15: {
                if (this.theEntityTypeSelection != -1) {
                    result = false;
                    String aTypeSelection = (String)this.theEntityTypeItems.get(this.theEntityTypeSelection);
                    IPPModel.EntityType theType = IPPModel.EntityType.toType(aTypeSelection);
                    IPPModel.EntitySubType[] theSubTypes = theType.getSubTyps();
                    int size = theSubTypes.length;
                    int i = 0;
                    while (i < size) {
                        if (theSubTypes[i] == IPPModel.EntitySubType.CLASS) {
                            result = this.getEntitySelectionInstance() != null;
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                result = false;
                break;
            }
            case 16: {
                if (this.theEntityTypeSelection != -1) {
                    result = false;
                    String aTypeSelection = (String)this.theEntityTypeItems.get(this.theEntityTypeSelection);
                    IPPModel.EntityType theType = IPPModel.EntityType.toType(aTypeSelection);
                    IPPModel.EntitySubType[] theSubTypes = theType.getSubTyps();
                    int size = theSubTypes.length;
                    int i = 0;
                    while (i < size) {
                        if (theSubTypes[i] == IPPModel.EntitySubType.SOURCE) {
                            result = this.getEntitySelectionInstance() != null;
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isEditable(int pViewKey) {
        return this.isEnabled(pViewKey);
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public boolean canFinish() {
        if (this.canFinishCounter <= 0) {
            ++this.canFinishCounter;
            return false;
        }
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        return false;
    }

    public ComponentWizardPage getNextPage(int pKey) {
        return null;
    }

    public boolean performFinish() {
        boolean aResult = true;
        this.thePPModel.removeAllEntities();
        this.cleanupStaleEntities(this.thePublicPartEntitiesList);
        Iterator anIter = ((AbstractList)this.thePublicPartEntitiesList).iterator();
        while (anIter.hasNext()) {
            this.thePPModel.addEntity((Entity)anIter.next());
        }
        return aResult;
    }

    private void cleanupStaleEntities(ArrayList thePublicPartEntitiesList) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        Iterator aniter = ((AbstractList)thePublicPartEntitiesList).iterator();
        EntityComparator anCompartaor = new EntityComparator();
        while (aniter.hasNext()) {
            Entity anEntity = (Entity)aniter.next();
            String aType = anEntity.getType();
            String aSubType = anEntity.getSubType();
            Iterator anEntityIter = this.theEntityService.getEntities(aType);
            boolean found = false;
            while (anEntityIter.hasNext()) {
                Entity oneOfAll = (Entity)anEntityIter.next();
                if (!EntityComparator.equals(anEntity, oneOfAll)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(anEntity);
        }
        ((AbstractCollection)thePublicPartEntitiesList).removeAll(result);
    }

    public boolean performCancel() {
        return true;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
        switch (pKey) {
            case 12: {
                if (this.theTracer.debug()) {
                    this.theTracer.debug("Handling table-selection event");
                }
                if (pSelectionChangedEvent.getSelection().isEmpty()) {
                    this.theEntityPathSelection = null;
                    return;
                }
                if (!(pSelectionChangedEvent.getSelection() instanceof IStructuredSelection)) break;
                this.theEntityPathSelection = null;
                IStructuredSelection aStructuredSelection = (IStructuredSelection)pSelectionChangedEvent.getSelection();
                String aTypeSelection = (String)aStructuredSelection.getFirstElement();
                this.theEntityTypeSelection = this.theEntityTypeItems.indexOf(aTypeSelection);
                if (this.theEntityService == null) break;
                this.theEntityItems.clear();
                Iterator anIter = this.theEntityService.getEntities(aTypeSelection);
                while (anIter.hasNext()) {
                    Entity anEnt = (Entity)anIter.next();
                    this.theEntityItems.add(anEnt);
                }
                Collections.sort(this.theEntityItems, this.theEntitiesComparator);
                this.buildTreeItems();
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Handling tree-selection event");
        }
        if (pSelectionChangedEvent.getSelection().isEmpty()) {
            this.theEntityPathSelection = null;
            return;
        }
        if (pSelectionChangedEvent.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection aStructuredSelection = (IStructuredSelection)pSelectionChangedEvent.getSelection();
            this.theEntityPathSelection = (String)aStructuredSelection.getFirstElement();
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
        String aPath;
        if (this.theTracer.debug()) {
            this.theTracer.debug("Handling checked changed event");
        }
        if (!this.theTreeContentProvider.isChecked(aPath = (String)pCheckChangedEvent.getElement())) {
            this.addToPPEntitiesList(aPath);
            this.theEntityPathSelection = aPath;
        } else {
            this.removeFromPPEntitiesList(aPath);
            this.theEntityPathSelection = null;
        }
        this.refresh();
        this.theView.updateView();
    }

    private void addToPPEntitiesList(String anEntPath) {
        Entity anEnt;
        List aListOfEnities = (List)this.theTree.get(anEntPath);
        if (aListOfEnities != null && (anEnt = (Entity)aListOfEnities.get(0)) != null) {
            this.addToPPEntitiesList(anEnt, null);
        }
    }

    private void addToPPEntitiesList(Entity anEnt, IPPModel.EntitySubType aSubType) {
        Entity aClone = PPModel.cloneEntity(anEnt);
        if (aSubType != null) {
            aClone.setSubType(aSubType.toString());
        }
        Iterator anIter = ((AbstractList)this.thePublicPartEntitiesList).iterator();
        while (anIter.hasNext()) {
            Entity aPPEntity = (Entity)anIter.next();
            if (!EntityComparator.equals(aPPEntity, aClone)) continue;
            Util.logExceptionMessage(this.theTracer, 3, "Tried to add an entity to a list that already is in the list of entities!", null);
            return;
        }
        this.thePublicPartEntitiesList.add(aClone);
    }

    private void removeFromPPEntitiesList(String anPath) {
        List aListOfEntities = (List)this.theTree.get(anPath);
        if (aListOfEntities != null) {
            int i = 0;
            while (i < aListOfEntities.size()) {
                Entity anEnt = (Entity)aListOfEntities.get(i);
                Iterator anIter = ((AbstractList)this.thePublicPartEntitiesList).iterator();
                while (anIter.hasNext()) {
                    Entity aPPEntity = (Entity)anIter.next();
                    if (!EntityComparator.equals(aPPEntity, anEnt, true)) continue;
                    anIter.remove();
                }
                ++i;
            }
        }
    }

    public void handleTextViewChange(String string, int pKey) {
    }

    public void handleComboViewChange(String string, int pKey) {
    }

    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
        switch (pKey) {
            case 11: {
                this.theEntityPathSelection = null;
                org.eclipse.swt.widgets.List theObject = (org.eclipse.swt.widgets.List)aListSelection.getSource();
                int[] aTypeSelection = theObject.getSelectionIndices();
                this.theEntityTypeSelection = aTypeSelection[0];
                String theEntityType = (String)this.theEntityTypeItems.get(this.theEntityTypeSelection);
                if (this.theEntityService == null) break;
                this.theEntityItems.clear();
                Iterator anIter = this.theEntityService.getEntities(theEntityType);
                while (anIter.hasNext()) {
                    Entity anEnt = (Entity)anIter.next();
                    this.theEntityItems.add(anEnt);
                }
                Collections.sort(this.theEntityItems, this.theEntitiesComparator);
                this.buildTreeItems();
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    private void buildTreeItems() {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Start building tree!");
        }
        this.theTree.clear();
        Iterator anIter = ((AbstractList)this.theEntityItems).iterator();
        while (anIter.hasNext()) {
            Entity anEnt = (Entity)anIter.next();
            String aPath = AddEditEntityWizardController.getEntityPath(anEnt);
            if (this.theTree.containsKey(aPath)) {
                ArrayList<Entity> aListOfEntities = (ArrayList<Entity>)this.theTree.get(aPath);
                if (aListOfEntities == null) {
                    aListOfEntities = new ArrayList<Entity>();
                    this.theTree.put(aPath, aListOfEntities);
                }
                aListOfEntities.add(anEnt);
                continue;
            }
            ArrayList<Entity> aNewList = new ArrayList<Entity>();
            aNewList.add(anEnt);
            this.theTree.put(aPath, aNewList);
            if (this.theTracer.debug()) {
                this.theTracer.debug("--->Added tree key->" + aPath + "<-");
            }
            String anAncestor = aPath.lastIndexOf("/") != -1 ? aPath.substring(0, aPath.lastIndexOf("/")) : null;
            while (anAncestor != null) {
                if (!this.theTree.containsKey(anAncestor)) {
                    this.theTree.put(anAncestor, null);
                    if (this.theTracer.debug()) {
                        this.theTracer.debug("--->Added tree key->" + anAncestor + "<-");
                    }
                }
                String string = anAncestor = anAncestor.lastIndexOf("/") != -1 ? anAncestor.substring(0, anAncestor.lastIndexOf("/")) : null;
            }
        }
        if (this.theTracer.debug()) {
            this.theTracer.debug("End building tree!");
        }
    }

    public void refresh() {
    }

    private static void intToArrayList(ArrayList aListOfIntegers, int[] aListOfInts) {
        while (!aListOfIntegers.isEmpty()) {
            aListOfIntegers.remove(0);
        }
        int i = 0;
        while (i < aListOfInts.length) {
            aListOfIntegers.add(new Integer(aListOfInts[i]));
            ++i;
        }
    }

    private static void toStringArray(ArrayList aListOfStrings, Entity[] anEntityArray) {
        while (!aListOfStrings.isEmpty()) {
            aListOfStrings.remove(0);
        }
        int size = anEntityArray.length;
        String[] result = new String[size];
        StringBuffer aBuffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            aBuffer.setLength(0);
            String aSubType = anEntityArray[i].getSubType();
            if (aSubType != null) {
                aBuffer.append("SubType: ").append(aSubType);
            }
            aBuffer.append(" Name: ").append(anEntityArray[i].getName());
            String aPackageName = anEntityArray[i].getPackageName();
            if (aPackageName != null) {
                aBuffer.append(" (").append(aPackageName).append(")");
            }
            aListOfStrings.add(aBuffer.toString());
            ++i;
        }
    }

    public void handleButtonViewPressed(boolean flag, int pKey) {
        switch (pKey) {
            case 17: {
                AddEditAdvancedEntitiesInputShell inputShell;
                try {
                    Entity pSourceSelection = this.getPPEntitySelectionInstance(IPPModel.EntitySubType.SOURCE);
                    Entity pClassSelection = this.getPPEntitySelectionInstance(IPPModel.EntitySubType.CLASS);
                    if (pSourceSelection == null && pClassSelection == null) {
                        pSourceSelection = this.getPPEntitySelectionInstance();
                    }
                    inputShell = new AddEditAdvancedEntitiesInputShell(pSourceSelection, pClassSelection);
                }
                catch (ModelInitException e) {
                    Util.logException(this.theTracer, e);
                    return;
                }
                Shell shell = new Shell(ComponentProviderPlugin.getPlugin().getMyShell(), 65648);
                WizardDialog theWizardDialog = new WizardDialog(shell, (IWizard)inputShell);
                int aReturnCode = theWizardDialog.open();
                if (aReturnCode != 0 || !this.theTracer.debug()) break;
                this.theTracer.debug("Added new entity");
                break;
            }
            case 16: {
                Entity theEntitySelection = this.getEntitySelectionInstance(IPPModel.EntitySubType.SOURCE);
                if (flag && this.theEntityPathSelection != null) {
                    this.addToPPEntitiesList(theEntitySelection, IPPModel.EntitySubType.SOURCE);
                } else {
                    Entity thePPEntitySelection = this.getPPEntitySelectionInstance(IPPModel.EntitySubType.SOURCE);
                    ((AbstractCollection)this.thePublicPartEntitiesList).remove(thePPEntitySelection);
                }
                this.refresh();
                this.theView.updateView();
                break;
            }
            case 15: {
                Entity theEntitySelection = this.getEntitySelectionInstance(IPPModel.EntitySubType.CLASS);
                if (flag && theEntitySelection != null) {
                    this.addToPPEntitiesList(theEntitySelection, IPPModel.EntitySubType.CLASS);
                } else {
                    Entity thePPEntitySelection = this.getPPEntitySelectionInstance(IPPModel.EntitySubType.CLASS);
                    ((AbstractCollection)this.thePublicPartEntitiesList).remove(thePPEntitySelection);
                }
                this.refresh();
                this.theView.updateView();
                break;
            }
            case 18: {
                this.isFlatt = true;
                this.refresh();
                this.theView.updateView();
                break;
            }
            case 19: {
                this.isFlatt = false;
                this.refresh();
                this.theView.updateView();
            }
        }
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }

    public static void main(String[] args) {
        System.out.println("0xyz4xyz89xyz".indexOf("xyz", 10));
    }

    public class EntitiesContentProvider
    implements ITreeContentProvider {
        private TracerI theTracer = TracingManager.getTracer(this.getClass());

        public Object getInput() {
            return AddEditEntityWizardController.this.theTree;
        }

        public ViewerFilter[] getFilters() {
            return new ViewerFilter[0];
        }

        public Object[] getCheckedElements() {
            ArrayList<String> result = new ArrayList<String>();
            Iterator anIter = AddEditEntityWizardController.this.theTree.keySet().iterator();
            while (anIter.hasNext()) {
                String anPath = (String)anIter.next();
                if (!this.isChecked(anPath)) continue;
                result.add(anPath);
            }
            return result.toArray();
        }

        public Object[] getGrayedElements() {
            ArrayList<String> result = new ArrayList<String>();
            Iterator anIter = AddEditEntityWizardController.this.theTree.keySet().iterator();
            while (anIter.hasNext()) {
                String anPath = (String)anIter.next();
                if (!this.isGrayed(anPath)) continue;
                result.add(anPath);
            }
            return result.toArray();
        }

        public boolean isChecked(String anPath) {
            return AddEditEntityWizardController.this.getPPEntities(anPath).length > 0;
        }

        public boolean isGrayed(String anPath) {
            return AddEditEntityWizardController.this.theTree.get(anPath) == null;
        }

        private Entity getPPEntity(Entity pEntity, boolean ignoreSubtyps) {
            Entity result = null;
            Iterator anIter = ((AbstractList)AddEditEntityWizardController.this.thePublicPartEntitiesList).iterator();
            while (anIter.hasNext()) {
                Entity anEntity = (Entity)anIter.next();
                if (!EntityComparator.equals(anEntity, pEntity, ignoreSubtyps)) continue;
                result = anEntity;
                break;
            }
            return result;
        }

        private Entity getPPEntity(Entity pEntity, String pSubType) {
            Entity result = null;
            Iterator anIter = ((AbstractList)AddEditEntityWizardController.this.thePublicPartEntitiesList).iterator();
            while (anIter.hasNext()) {
                boolean subtypeEquality;
                Entity anEntity = (Entity)anIter.next();
                String aSubType = anEntity.getSubType();
                boolean bl = subtypeEquality = aSubType == null && pSubType == null || aSubType != null && aSubType.equals(pSubType);
                if (!EntityComparator.equals(anEntity, pEntity, true) || !subtypeEquality) continue;
                result = anEntity;
                break;
            }
            return result;
        }

        private Object[] getPathChildren(Object parentElement) {
            ArrayList<String> result = new ArrayList<String>();
            String aParentPath = (String)parentElement;
            if (this.theTracer.debug()) {
                this.theTracer.debug("Start looking for children of :->" + aParentPath + "<-");
            }
            Set theKeys = AddEditEntityWizardController.this.theTree.keySet();
            Iterator anIter = theKeys.iterator();
            while (anIter.hasNext()) {
                String anotherPath = (String)anIter.next();
                if (!anotherPath.startsWith(aParentPath + "/") || AddEditEntityWizardController.countPathSeparators(anotherPath) != AddEditEntityWizardController.countPathSeparators(aParentPath) + 1) continue;
                if (this.theTracer.debug()) {
                    this.theTracer.debug("----->Found child  :->" + anotherPath + "<-" + "of  parent ->" + aParentPath + "<-");
                }
                result.add(anotherPath);
            }
            if (this.theTracer.debug()) {
                this.theTracer.debug("End looking for children of :->" + aParentPath + "<-");
            }
            return result.toArray(new Object[result.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (AddEditEntityWizardController.this.isFlatt) {
                return this.getChildrenForFlattTree(parentElement);
            }
            return this.getChildrenForHierarchicalTree(parentElement);
        }

        private Object[] getChildrenForHierarchicalTree(Object parentElement) {
            String anEntPath = (String)parentElement;
            return this.getPathChildren(anEntPath);
        }

        private Object[] getChildrenForFlattTree(Object parentElement) {
            ArrayList<Object> theChildren;
            block4: {
                boolean isFileOrClass;
                block3: {
                    String currentType = (String)AddEditEntityWizardController.this.theEntityTypeItems.get(AddEditEntityWizardController.this.theEntityTypeSelection);
                    isFileOrClass = currentType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern() || currentType.intern() == IPPModel.EntityType.ABSOLUTE_FILE.toString().intern() || currentType.intern() == IPPModel.EntityType.FILE.toString().intern();
                    theChildren = new ArrayList<Object>();
                    if (!parentElement.equals("")) break block3;
                    Iterator anIter = AddEditEntityWizardController.this.theTree.keySet().iterator();
                    while (anIter.hasNext()) {
                        String anEntPath = (String)anIter.next();
                        if (AddEditEntityWizardController.countPathSeparators(anEntPath) <= 0 || !(isFileOrClass ? this.isGrayed(anEntPath) : true)) continue;
                        theChildren.add(anEntPath);
                    }
                    break block4;
                }
                if (!isFileOrClass) break block4;
                Object[] thePathChildren = this.getPathChildren(parentElement);
                int i = 0;
                while (i < thePathChildren.length) {
                    if (!this.isGrayed((String)thePathChildren[i])) {
                        theChildren.add(thePathChildren[i]);
                    }
                    ++i;
                }
            }
            return theChildren.toArray();
        }

        private Object getPathParent(Object aChildElement) {
            String result = null;
            String aChildPath = (String)aChildElement;
            int index = aChildPath.lastIndexOf("/");
            if (index != -1) {
                result = aChildPath.substring(0, index);
            }
            if (!AddEditEntityWizardController.this.theTree.containsKey(result)) {
                result = null;
            }
            if (this.theTracer.debug()) {
                this.theTracer.debug("Found Parent  :->" + result + "<-" + "of  child ->" + aChildPath + "<-");
            }
            return result;
        }

        public Object getParent(Object pElement) {
            if (AddEditEntityWizardController.this.isFlatt) {
                return this.getParentForFlattTree(pElement);
            }
            return this.getParentForHierarchialTree(pElement);
        }

        private Object getParentForHierarchialTree(Object pElement) {
            String anEntPath = (String)pElement;
            return this.getPathParent(anEntPath);
        }

        private Object getParentForFlattTree(Object pElement) {
            boolean isFileOrClass;
            String currentType = (String)AddEditEntityWizardController.this.theEntityTypeItems.get(AddEditEntityWizardController.this.theEntityTypeSelection);
            boolean bl = isFileOrClass = currentType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern() || currentType.intern() == IPPModel.EntityType.ABSOLUTE_FILE.toString().intern() || currentType.intern() == IPPModel.EntityType.FILE.toString().intern();
            if (!isFileOrClass) {
                String anEntPath = (String)pElement;
                if (anEntPath.equals("")) {
                    return null;
                }
                return "";
            }
            String anEntPath = (String)pElement;
            if (this.isGrayed(anEntPath)) {
                return "";
            }
            return this.getParentForHierarchialTree(pElement);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == AddEditEntityWizardController.this.theTree && !AddEditEntityWizardController.this.theTree.isEmpty()) {
                return new Object[]{""};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class EntityTypesContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object anInput) {
            return AddEditEntityWizardController.this.theEntityTypeItems.toArray(new Object[AddEditEntityWizardController.this.theEntityTypeItems.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class EntitiesLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            Image aImage = null;
            String anEntityPath = (String)element;
            String currentType = (String)AddEditEntityWizardController.this.theEntityTypeItems.get(AddEditEntityWizardController.this.theEntityTypeSelection);
            if (AddEditEntityWizardController.this.theTree.get(anEntityPath) == null) {
                if (currentType.intern() == IPPModel.EntityType.FILE.toString().intern() || currentType.intern() == IPPModel.EntityType.ABSOLUTE_FILE.toString().intern()) {
                    aImage = AddEditEntityWizardController.getEntityTypeImage(IPPModel.EntityType.FOLDER.toString());
                }
                if (currentType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern()) {
                    aImage = AddEditEntityWizardController.getEntityTypeImage(IPPModel.EntityType.JAVA_PACKAGE.toString());
                }
            } else {
                aImage = AddEditEntityWizardController.getEntityTypeImage(currentType);
            }
            return aImage;
        }

        public String getText(Object element) {
            if (element instanceof String && ((String)element).trim().length() > 0) {
                String currentType = (String)AddEditEntityWizardController.this.theEntityTypeItems.get(AddEditEntityWizardController.this.theEntityTypeSelection);
                String anEntityPath = (String)element;
                if (!AddEditEntityWizardController.this.isFlatt) {
                    return this.getHierarchicalText(anEntityPath);
                }
                return this.getFlattText(currentType, anEntityPath);
            }
            return "";
        }

        private String getFlattText(String currentType, String anEntityPath) {
            if (currentType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern() || currentType.intern() == IPPModel.EntityType.JAVA_PACKAGE.toString().intern() || currentType.intern() == IPPModel.EntityType.JAVA_PACKAGE_TREE.toString().intern()) {
                anEntityPath = anEntityPath.replace('/', '.');
            }
            if (anEntityPath.startsWith(".")) {
                anEntityPath = anEntityPath.substring(1);
            }
            return anEntityPath;
        }

        private String getHierarchicalText(String anEntityPath) {
            int indexOflastPathSeparator = anEntityPath.lastIndexOf("/");
            return anEntityPath.substring(indexOflastPathSeparator + 1);
        }
    }

    public class EntityTypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image aImage = null;
            String anEntityType = (String)element;
            if (AddEditEntityWizardController.this.theEntityTypeItems.contains(anEntityType)) {
                aImage = AddEditEntityWizardController.getEntityTypeImage(anEntityType);
            }
            return aImage;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }

    class EntitiesSorter
    implements Comparator {
        EntitiesSorter() {
        }

        public int compare(Object one, Object two) {
            if (one == null || two == null || !(one instanceof Entity) || !(two instanceof Entity)) {
                throw new RuntimeException("Wrong usage of comparator");
            }
            Entity entOne = (Entity)one;
            Entity entTwo = (Entity)two;
            if (entOne.getType().intern() != entTwo.getType().intern()) {
                throw new RuntimeException("Wrong usage of comparator");
            }
            IPPModel.EntityType entType = IPPModel.EntityType.toType(entOne.getType());
            String entOnePath = AddEditEntityWizardController.getEntityPath(entOne);
            String entTwoPath = AddEditEntityWizardController.getEntityPath(entTwo);
            Collator aCollator = Collator.getInstance();
            int result = aCollator.compare(entOnePath != null ? entOnePath : "", entTwoPath != null ? entTwoPath : "");
            if (result == 0) {
                String subTypeOne = entOne.getSubType();
                String subTypeTwo = entTwo.getSubType();
                return aCollator.compare(subTypeOne != null ? subTypeOne : "", subTypeTwo != null ? subTypeTwo : "");
            }
            return result;
        }
    }

    public class EntitiesPathSorter
    extends ViewerSorter {
    }
}

