/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmetadata.controller;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ActionStatus;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComponentWizardPage;
import com.sap.ide.eclipse.component.dcmdcommons.view.IButtonViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IListViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.sap.ide.eclipse.component.dcmetadata.model.IDCModel;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.SCReference;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class AccessListWizardController
implements IWizardController {
    public static final int WIZARD_ACCESS_LIST = 1000;
    public static final int WIZARD_PAGE_ACCESS_CONTROLL_LIST = 1001;
    public static final int ACCESSCONTROLLIST_INPUTHELP_MANDATORY_COMPONENTREF_TYPE_COMBO_KEY = 1;
    public static final int ACCESSCONTROLLIST_INPUTHELP_MANDATORY_COMPONENTREF_NAME_TEXT_KEY = 2;
    public static final int ACCESSCONTROLLIST_INPUTHELP_MANDATORY_COMPONENTREF_VENDOR_TEXT_KEY = 3;
    public static final int ACCESSCONTROLLIST_INPUTHELP_OPTIONAL_COMPONENTREF_SCALIAS_TEXT_KEY = 4;
    private static int[] theControllIDs = new int[]{1000, 1001, 1, 2, 3, 4};
    private MessageUtil theMessageUtil;
    private IPPModel thePPModel;
    private IDCModel theDCModel;
    private boolean isEdit;
    private int theCurrent;
    private IView theView;
    private int canFinishCounter = 0;
    private ComponentReference theAccessControllClone;
    private boolean canFinish = false;
    private String theMessage;
    private int theIcon;

    public AccessListWizardController(IDCModel aDCModel, boolean triggeredByEdit, int aCurrent, IView aView, MessageUtil aUtil) {
        this.theMessageUtil = aUtil;
        this.theDCModel = aDCModel;
        this.isEdit = triggeredByEdit;
        this.theCurrent = aCurrent;
        this.theView = aView;
        if (this.isEdit) {
            ComponentReference aRef = this.theDCModel.getAccessControl(this.theCurrent);
            if (aRef instanceof DCReference) {
                this.theAccessControllClone = new DCReference();
                this.theAccessControllClone.setName(aRef.getName());
                this.theAccessControllClone.setVendor(aRef.getVendor());
                this.theAccessControllClone.setSCAlias(aRef.getSCAlias());
            } else {
                this.theAccessControllClone = new SCReference();
                this.theAccessControllClone.setName(aRef.getName());
                this.theAccessControllClone.setVendor(aRef.getVendor());
                this.theAccessControllClone.setSCAlias(aRef.getSCAlias());
            }
        } else {
            this.theAccessControllClone = new DCReference("", "");
        }
        this.theIcon = 1;
        this.theMessage = this.theMessage = this.getMessageUtil().getString("AccessControlList.InputHelp.Description");
    }

    public AccessListWizardController(IPPModel aPPModel, boolean triggeredByEdit, int aCurrent, IView aView, MessageUtil aUtil) {
        this.theMessageUtil = aUtil;
        this.thePPModel = aPPModel;
        this.theDCModel = this.thePPModel.getDCModel();
        this.isEdit = triggeredByEdit;
        this.theCurrent = aCurrent;
        this.theView = aView;
        this.theAccessControllClone = this.isEdit ? this.thePPModel.getAccessControl(this.theCurrent) : new DCReference();
        this.theIcon = 1;
        this.theMessage = this.theMessage = this.getMessageUtil().getString("AccessControlList.InputHelp.Description");
    }

    public ComponentReference getAccessControlRef() {
        return this.theAccessControllClone;
    }

    public int[] getSuscribedContollIDs() {
        return theControllIDs;
    }

    public IListViewModelAdapter getListViewModelAdapter(int pViewKey) {
        return null;
    }

    public IComboViewModelAdapter getComboViewModelAdapter(int pViewKey) {
        IComboViewModelAdapter result = null;
        switch (pViewKey) {
            case 1: {
                result = new IComboViewModelAdapter(){

                    public String getText() {
                        String result = "DC";
                        result = AccessListWizardController.this.theAccessControllClone instanceof DCReference ? "DC" : "SC";
                        return result;
                    }

                    public String[] getItems() {
                        return null;
                    }
                };
            }
        }
        return result;
    }

    public IButtonViewModelAdapter getButtonViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITableModelAdapter getTableViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITreeModelAdapter getTreeViewModelAdapter(int pViewKey) {
        return null;
    }

    public ITextViewModelAdapter getTextViewModelAdapter(int pViewKey) {
        ITextViewModelAdapter result = null;
        switch (pViewKey) {
            case 2: {
                result = new ITextViewModelAdapter(){

                    public String getData() {
                        return AccessListWizardController.this.theAccessControllClone.getName();
                    }
                };
                break;
            }
            case 3: {
                result = new ITextViewModelAdapter(){

                    public String getData() {
                        return AccessListWizardController.this.theAccessControllClone.getVendor();
                    }
                };
                break;
            }
            case 4: {
                result = new ITextViewModelAdapter(){

                    public String getData() {
                        return AccessListWizardController.this.theAccessControllClone.getSCAlias();
                    }
                };
            }
        }
        return result;
    }

    public boolean isEnabled(int pViewKey) {
        boolean result = true;
        if (!this.viewIsAButton(pViewKey) && !this.viewIsACombo(pViewKey)) {
            return result;
        }
        if (this.theDCModel != null && this.theDCModel.getDCdefFile().isReadOnly() || this.thePPModel != null && this.thePPModel.getPPFile().isReadOnly()) {
            result = false;
        } else if (pViewKey == 1) {
            result = true;
        }
        return result;
    }

    private boolean viewIsAButton(int pViewKey) {
        boolean result = false;
        return result;
    }

    private boolean viewIsACombo(int pViewKey) {
        boolean result = false;
        if (pViewKey == 1) {
            result = true;
        }
        return result;
    }

    public boolean isEditable(int pViewKey) {
        boolean result = true;
        return result;
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public boolean canFinish() {
        if (this.canFinishCounter <= 0) {
            ++this.canFinishCounter;
            return false;
        }
        return this.canFinish;
    }

    public boolean isPageComplete(int pKey) {
        return this.canFinish();
    }

    public boolean canFlipToNextPage(int pKey) {
        return this.canFinish();
    }

    public ComponentWizardPage getNextPage(int pKey) {
        return null;
    }

    public boolean performFinish() {
        boolean result = false;
        if (this.isEdit) {
            result = this.thePPModel == null ? this.theDCModel.editAccessControl(this.theCurrent, this.theAccessControllClone).getStatus() : this.thePPModel.editAccessControl(this.theCurrent, this.theAccessControllClone).getStatus();
        } else {
            boolean bl = result = this.thePPModel == null ? this.theDCModel.addAccessControl(this.theAccessControllClone).getStatus() : this.thePPModel.addAccessControl(this.theAccessControllClone).getStatus();
        }
        if (!result) {
            Shell theShell = ComponentProviderPlugin.getPlugin().getMyShell();
            MessageDialog.openError((Shell)theShell, (String)this.theMessageUtil.getString("Development.Component.Editor"), (String)this.theMessageUtil.getString("Warning.Could.Not.Create.AccessControll"));
        }
        return result;
    }

    public boolean performCancel() {
        return true;
    }

    public String getCurrentMessage(int pKey) {
        return this.theMessage;
    }

    public int getCurrentIcon(int pKey) {
        return this.theIcon;
    }

    public void handleTableViewSelectionChanged(SelectionChangedEvent selectionModelEvent, int n) {
    }

    public void handleTreeViewSelectionChange(SelectionChangedEvent pSelectionChangedEvent, int pKey) {
    }

    public void handleTreeViewCheckChange(CheckStateChangedEvent pCheckChangedEvent, int pKey) {
    }

    public void handleTextViewChange(String string, int pKey) {
        switch (pKey) {
            case 2: {
                this.theAccessControllClone.setName(string);
                break;
            }
            case 3: {
                this.theAccessControllClone.setVendor(string);
                break;
            }
            case 4: {
                this.theAccessControllClone.setName(string);
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void handleComboViewChange(String string, int pKey) {
        switch (pKey) {
            case 1: {
                SCReference theOldOne;
                if (string.equals("DC") && !(this.theAccessControllClone instanceof DCReference)) {
                    theOldOne = (SCReference)this.theAccessControllClone;
                    this.theAccessControllClone = new DCReference();
                    this.theAccessControllClone.setName(theOldOne.getName());
                    this.theAccessControllClone.setVendor(theOldOne.getVendor());
                    this.theAccessControllClone.setSCAlias(theOldOne.getSCAlias());
                }
                if (!string.equals("SC") || this.theAccessControllClone instanceof SCReference) break;
                theOldOne = (DCReference)this.theAccessControllClone;
                this.theAccessControllClone = new SCReference();
                this.theAccessControllClone.setName(theOldOne.getName());
                this.theAccessControllClone.setVendor(theOldOne.getVendor());
                this.theAccessControllClone.setSCAlias(theOldOne.getSCAlias());
            }
        }
        this.refresh();
        this.theView.updateView();
    }

    public void refresh() {
        ActionStatus result = ActionStatus.OKAY;
        boolean isFirstGrant = false;
        if (this.theDCModel != null && this.thePPModel == null) {
            result = this.theDCModel.isGrantAllowed(this.theAccessControllClone);
            isFirstGrant = this.theDCModel.getAccessControlListLength() <= 0;
        } else {
            result = this.thePPModel.isGrantAllowed(this.theAccessControllClone);
            boolean bl = isFirstGrant = this.thePPModel.getAccessControlListLength() <= 0;
        }
        if (result.getStatus()) {
            this.canFinish = true;
            if (isFirstGrant) {
                this.theMessage = this.getMessageUtil().getString("Warning.Add.First.Grant");
                this.theIcon = 2;
            } else {
                this.theMessage = this.getMessageUtil().getString("AccessControlList.InputHelp.Description");
                this.theIcon = 1;
            }
        } else {
            this.canFinish = false;
            this.theMessage = result.getMessage();
            this.theIcon = 3;
        }
    }

    public void handleButtonViewPressed(boolean flag, int n) {
    }

    public void handleListSelection(SelectionEvent aListSelection, int pKey) {
    }

    public void handleWizardClosed(int n) {
    }

    public void handleWizardCanceled(int n) {
    }
}

