/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITextViewModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.TextViewHandler;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextView
extends TextViewHandler {
    private ITextViewModelAdapter theModel;

    public TextView(Text pText, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController) {
        super(pKey, aTTKey, aHKey, aHIKey, (Control)pText, pController);
        Text aText = this.getSWTText();
        aText.addModifyListener((ModifyListener)this);
    }

    public TextView(Text pText, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController, ITextViewModelAdapter aModelAdapter) {
        this(pText, pKey, aTTKey, aHKey, aHIKey, pController);
        this.theModel = aModelAdapter;
    }

    private Text getSWTText() {
        return (Text)this.getControl();
    }

    public void setText(String aText) {
        this.setText(aText, false);
    }

    public void setText(String aText, boolean fire) {
        Text aSWTText;
        if (aText == null) {
            aText = "";
        }
        if (!fire) {
            this.setUserInput(false);
        }
        Text text = aSWTText = this.getSWTText();
        synchronized (text) {
            String current = aSWTText.getText();
            if (current.intern() != aText.intern()) {
                aSWTText.setText(aText);
            }
        }
        if (!fire) {
            this.setUserInput(true);
        }
    }

    public String getText() {
        return this.getSWTText().getText();
    }

    public void updateView() {
        Text text = this.getSWTText();
        IController controller = this.getController();
        int key = this.getKey();
        if (text != null && !text.isDisposed()) {
            text.setEnabled(controller.isEnabled(key));
            text.setEditable(controller.isEditable(key));
        }
        if (this.theModel != null) {
            this.setText(this.theModel.getData());
        }
    }

    public void handleModelChange(ModelChangeEvent aEvent) {
        if (this.theModel != null) {
            this.updateView();
        }
    }
}

