/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITableModelAdapter;
import com.sap.ide.eclipse.component.dcmdcommons.view.TableViewHandler;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableView
extends TableViewHandler
implements ISelectionChangedListener {
    private TableViewer theTableViewer;
    private ITableModelAdapter theModel;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public TableView(TableViewer pTableViewer, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController, ITableModelAdapter aModel) {
        super(pKey, aTTKey, aHKey, aHIKey, (Control)pTableViewer.getTable(), pController);
        this.theTableViewer = pTableViewer;
        Table theTable = this.theTableViewer.getTable();
        String[] theColumnsLabels = aModel.getColumnLables();
        int i = 0;
        while (i < theColumnsLabels.length) {
            TableColumn aColumn = new TableColumn(theTable, 16384);
            aColumn.setText(theColumnsLabels[i]);
            aColumn.setWidth(200);
            ++i;
        }
        this.theTableViewer.setSorter(aModel.getSorter());
        this.theTableViewer.setContentProvider((IContentProvider)aModel.getContentProvider());
        this.theTableViewer.setLabelProvider((IBaseLabelProvider)aModel.getLabelProvider());
        this.theTableViewer.setInput(aModel.getInput());
        this.theTableViewer.setColumnProperties(theColumnsLabels);
        this.theModel = aModel;
        this.theTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private Table getSWTTable() {
        return (Table)this.getControl();
    }

    public void selectionChanged(SelectionChangedEvent aSelectionChangedEvent) {
        if (this.theTracer.debug()) {
            this.theTracer.debug(aSelectionChangedEvent.toString());
        }
        if (this.isUserInput()) {
            this.fireTableViewSelected(aSelectionChangedEvent, this.getKey());
        }
    }

    public void updateView() {
    }

    public void handleModelChange(ModelChangeEvent aEvent) {
        this.updateView();
    }
}

