/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.IControlView;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ControlViewHandler
implements IControlView,
ModifyListener,
HelpListener,
MouseTrackListener,
MouseMoveListener,
MouseListener,
DisposeListener,
SelectionListener {
    private Shell tooltipShell;
    private Point tooltipPosition;
    private int theKey;
    private String theToolTipKey;
    private String theHelpItemKey;
    private String theHelpKey;
    private Control theSWTControl;
    private IController theIDCController;
    private MessageUtil theMessageUtil;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());
    public static final int HELP_SHELL_WIDTH = 300;

    public ControlViewHandler(int aKey, String aToolTipKey, String aHelpKey, String aHelpItemKey, Control aSWTControl, IController aIDCController) {
        this.theKey = aKey;
        this.theToolTipKey = aToolTipKey;
        this.theHelpKey = aHelpKey;
        this.theHelpItemKey = aHelpItemKey;
        this.theIDCController = aIDCController;
        this.theMessageUtil = this.theIDCController.getMessageUtil();
        this.theSWTControl = aSWTControl;
        this.theSWTControl.addMouseMoveListener((MouseMoveListener)this);
        this.theSWTControl.addMouseTrackListener((MouseTrackListener)this);
        this.theSWTControl.addHelpListener((HelpListener)this);
        this.theSWTControl.addDisposeListener((DisposeListener)this);
        if (this.theTracer.debug()) {
            this.theTracer.debug("Created Control:" + this.getKey());
        }
    }

    public IView getView(int pKey) {
        ControlViewHandler result = null;
        if (pKey == this.theKey) {
            result = this;
        }
        return result;
    }

    public Iterator getChildViews() {
        return ((AbstractList)new ArrayList()).iterator();
    }

    public IControlView getControlView(int aKey) {
        ControlViewHandler result = null;
        if (aKey == this.theKey) {
            result = this;
        }
        return result;
    }

    public Iterator getChildControlViews() {
        return ((AbstractList)new ArrayList()).iterator();
    }

    public void widgetDisposed(DisposeEvent aEvent) {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Disposed Control:" + this.getKey());
        }
    }

    public String getTooltipText() {
        return this.theMessageUtil.getString(this.theToolTipKey);
    }

    public String getHelpItem() {
        return this.theMessageUtil.getString(this.theHelpItemKey);
    }

    public String getHelpText() {
        return this.theMessageUtil.getString(this.theHelpKey);
    }

    public int getKey() {
        return this.theKey;
    }

    public Control getControl() {
        return this.theSWTControl;
    }

    public IController getController() {
        return this.theIDCController;
    }

    public void modifyText(ModifyEvent e) {
        this.setTooltipShellInvisible();
    }

    public void widgetSelected(SelectionEvent aSelection) {
        this.setTooltipShellInvisible();
    }

    public void widgetDefaultSelected(SelectionEvent aSelection) {
        this.setTooltipShellInvisible();
    }

    public void helpRequested(HelpEvent e) {
        this.setTooltipShellInvisible();
        Shell helpShell = new Shell(this.getControl().getShell(), 65632);
        helpShell.setLayout((Layout)new FillLayout());
        helpShell.setImage(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_MESSAGE_QUESTION));
        Color foreground = helpShell.getDisplay().getSystemColor(28);
        Color background = helpShell.getDisplay().getSystemColor(29);
        helpShell.setBackground(background);
        helpShell.setText(this.theMessageUtil.getString("HelpShell.Title") + ": " + this.getHelpItem());
        StyledText helpStyledText = new StyledText((Composite)helpShell, 66);
        helpStyledText.setForeground(foreground);
        helpStyledText.setBackground(background);
        helpStyledText.setText(this.getHelpText());
        Point position = e.display.getCursorLocation();
        Rectangle helpShellBounds = helpShell.getBounds();
        helpShellBounds.width = 300;
        helpShellBounds.x = position.x - helpShellBounds.width;
        helpShellBounds.y = position.y;
        helpShell.setBounds(helpShellBounds);
        helpShell.pack();
        helpShell.setVisible(true);
    }

    public void mouseEnter(MouseEvent e) {
        if (this.tooltipShell == null) {
            this.tooltipShell = new Shell(this.getControl().getShell(), 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 2;
            this.tooltipShell.setLayout((Layout)gridLayout);
            Color foreground = this.tooltipShell.getDisplay().getSystemColor(28);
            Color background = this.tooltipShell.getDisplay().getSystemColor(29);
            this.tooltipShell.setBackground(background);
            Label tooltipLabelImage = new Label((Composite)this.tooltipShell, 0);
            tooltipLabelImage.setForeground(foreground);
            tooltipLabelImage.setBackground(background);
            tooltipLabelImage.setLayoutData((Object)new GridData(772));
            tooltipLabelImage.setImage(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_INFORMATION));
            Label tooltipLabelText = new Label((Composite)this.tooltipShell, 0);
            tooltipLabelText.setForeground(foreground);
            tooltipLabelText.setBackground(background);
            tooltipLabelText.setLayoutData((Object)new GridData(772));
            tooltipLabelText.setText(this.getTooltipText());
        }
    }

    public void mouseExit(MouseEvent e) {
        this.setTooltipShellInvisible();
    }

    public void mouseHover(MouseEvent e) {
        Point pt = new Point(e.x, e.y);
        this.tooltipPosition = this.getControl().toDisplay(pt);
        ControlViewHandler.setHoverLocation(this.tooltipShell, this.tooltipPosition);
        this.tooltipShell.pack();
        this.tooltipShell.setVisible(true);
    }

    public void mouseMove(MouseEvent e) {
        Point pt = new Point(e.x, e.y);
        this.tooltipPosition = this.getControl().toDisplay(pt);
    }

    public void mouseDown(MouseEvent e) {
        this.setTooltipShellInvisible();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void setTooltipShellInvisible() {
        if (this.tooltipShell != null && this.tooltipShell.isVisible()) {
            this.tooltipShell.setVisible(false);
        }
    }

    private static void setHoverLocation(Shell pShell, Point pPosition) {
        pShell.pack();
        Rectangle displayBounds = pShell.getDisplay().getBounds();
        Rectangle shellBounds = pShell.getBounds();
        shellBounds.x = Math.max(Math.min(pPosition.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(pPosition.y + 16, displayBounds.height - shellBounds.height), 0);
        pShell.setBounds(shellBounds);
    }

    public abstract void updateView();

    public abstract void handleModelChange(ModelChangeEvent var1);
}

