/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.controller.IWizardController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmdcommons.view.IControlView;
import com.sap.ide.eclipse.component.dcmdcommons.view.IView;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ComponentWizardPage
extends WizardPage
implements IView {
    private int theKey;
    private String theHelpItemKey;
    private String theHelpTextKey;
    private IWizardController theController;
    private MessageUtil theMessageUtil;
    private HashMap theViews = new HashMap();
    private HashMap theChildControlViews = new HashMap();
    protected static final int INPUTHELP_SHELL_WIDTH = 420;

    public ComponentWizardPage(int aKey, String aPageName, String aHelpItemKey, String aHelpTextKey, IController aController) {
        super(aPageName);
        this.theKey = aKey;
        this.theController = (IWizardController)aController;
        this.theMessageUtil = this.theController.getMessageUtil();
        this.theHelpItemKey = aHelpItemKey;
        this.theHelpTextKey = aHelpTextKey;
        this.setPageComplete(false);
    }

    public int getKey() {
        return this.theKey;
    }

    public IView getView(int aKey) {
        IView result = null;
        result = aKey == this.getKey() ? this : this.getControlView(aKey);
        return result;
    }

    public void addControlView(IControlView aChildControlView) {
        this.theChildControlViews.put(new Integer(aChildControlView.getKey()), aChildControlView);
    }

    public IControlView getControlView(int akey) {
        Integer aObKey = new Integer(akey);
        return (IControlView)this.theChildControlViews.get(aObKey);
    }

    public Iterator getChildViews() {
        return this.getChildControlViews();
    }

    public Iterator getChildControlViews() {
        Set aSetOfEntries = this.theChildControlViews.entrySet();
        Iterator anEntrySetIterator = aSetOfEntries.iterator();
        Iterator anIter = new Iterator(anEntrySetIterator){
            private Iterator theEntrySetIterator;
            private final /* synthetic */ Iterator val$anEntrySetIterator;
            {
                this.theEntrySetIterator = this.val$anEntrySetIterator = val$anEntrySetIterator;
            }

            public boolean hasNext() {
                return this.theEntrySetIterator.hasNext();
            }

            public Object next() {
                Map.Entry anEntry = (Map.Entry)this.theEntrySetIterator.next();
                return anEntry.getValue();
            }

            public void remove() {
                this.theEntrySetIterator.remove();
            }
        };
        return anIter;
    }

    public void handleModelChange(ModelChangeEvent aChangeEvent) {
    }

    public MessageUtil getMessageUtil() {
        return this.theMessageUtil;
    }

    public void performHelp() {
        Shell helpShell = new Shell(this.getContainer().getShell(), 65632);
        helpShell.setLayout((Layout)new FillLayout());
        helpShell.setImage(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_MESSAGE_QUESTION));
        Color foreground = helpShell.getDisplay().getSystemColor(28);
        Color background = helpShell.getDisplay().getSystemColor(29);
        String helpItem = this.theMessageUtil.getString(this.theHelpItemKey);
        helpShell.setBackground(background);
        helpShell.setText(this.theMessageUtil.getString("HelpShell.Title") + ": " + helpItem);
        StyledText helpStyledText = new StyledText((Composite)helpShell, 66);
        helpStyledText.setForeground(foreground);
        helpStyledText.setBackground(background);
        helpStyledText.setText(this.theMessageUtil.getString(this.theHelpTextKey));
        Rectangle containerBounds = this.getContainer().getShell().getBounds();
        Rectangle helpShellBounds = helpShell.getBounds();
        helpShellBounds.width = 300;
        int deltaX = containerBounds.width / 2 - helpShellBounds.width / 2;
        helpShellBounds.x = containerBounds.x + deltaX;
        helpShellBounds.y = containerBounds.y;
        helpShell.setBounds(helpShellBounds);
        helpShell.pack();
        helpShell.setVisible(true);
    }

    public void updateView() {
        this.updateWizardPage();
        Iterator anIter = this.getChildControlViews();
        while (anIter.hasNext()) {
            IControlView aControlView = (IControlView)anIter.next();
            aControlView.updateView();
        }
    }

    public IWizardPage getNextPage() {
        ComponentWizardPage aPage = this.theController.getNextPage(this.getKey());
        if (aPage != null) {
            aPage.updateView();
        }
        return aPage;
    }

    public void updateWizardPage() {
        this.setMessage(this.theController.getCurrentMessage(this.getKey()), this.theController.getCurrentIcon(this.getKey()));
    }

    public boolean isPageComplete() {
        return this.theController.isPageComplete(this.getKey());
    }

    public boolean canFlipToNextPage() {
        return this.theController.canFlipToNextPage(this.getKey());
    }
}

