/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.view.ComboViewHandler;
import com.sap.ide.eclipse.component.dcmdcommons.view.IComboViewModelAdapter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class ComboView
extends ComboViewHandler {
    private IComboViewModelAdapter theModel;

    public ComboView(Combo pCombo, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController) {
        super(pKey, aTTKey, aHKey, aHIKey, (Control)pCombo, pController);
        Combo aCombo = this.getSWTCombo();
        aCombo.setEnabled(this.getController().isEnabled(this.getKey()));
        aCombo.addModifyListener((ModifyListener)this);
    }

    public ComboView(Combo pCombo, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController, IComboViewModelAdapter aModel) {
        this(pCombo, pKey, aTTKey, aHKey, aHIKey, pController);
        this.theModel = aModel;
    }

    private Combo getSWTCombo() {
        return (Combo)this.getControl();
    }

    public String getText() {
        return this.getSWTCombo().getText();
    }

    public void setText(String aText) {
        this.setText(aText, false);
    }

    public void setText(String aSelectionText, boolean fire) {
        if (aSelectionText == null) {
            aSelectionText = "";
        }
        if (!fire) {
            this.setUserInput(false);
        }
        this.getSWTCombo().setText(aSelectionText);
        if (!fire) {
            this.setUserInput(true);
        }
    }

    public void setItems(String[] items) {
        this.setUserInput(false);
        Combo combo = this.getSWTCombo();
        String[] theCurrentItems = combo.getItems();
        if (items.length != theCurrentItems.length) {
            combo.setItems(items);
        } else {
            boolean equal = true;
            int i = 0;
            while (i < items.length) {
                if (!items[i].equals(theCurrentItems[i])) {
                    equal = false;
                    break;
                }
                ++i;
            }
            if (!equal) {
                combo.setItems(items);
            }
        }
        this.setUserInput(true);
    }

    public void updateView() {
        Combo combo = this.getSWTCombo();
        IController controller = this.getController();
        int key = this.getKey();
        if (combo != null && !combo.isDisposed()) {
            combo.setEnabled(controller.isEnabled(key));
        }
        if (this.theModel != null) {
            String[] theItems = this.theModel.getItems();
            if (theItems != null) {
                this.setItems(theItems);
            }
            this.setText(this.theModel.getText());
        }
    }

    public void handleModelChange(ModelChangeEvent aEvent) {
        if (this.theModel != null) {
            this.updateView();
        }
    }
}

