/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.model.ModelChangeEvent;
import com.sap.ide.eclipse.component.dcmdcommons.view.CheckboxTreeViewHandler;
import com.sap.ide.eclipse.component.dcmdcommons.view.ITreeModelAdapter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeView
extends CheckboxTreeViewHandler
implements ISelectionChangedListener,
ICheckStateListener {
    private CheckboxTreeViewer theTreeViewer;
    private ITreeModelAdapter theModel;
    private TracerI theTracer = TracingManager.getTracer(this.getClass());

    public CheckboxTreeView(CheckboxTreeViewer pTreeViewer, int pKey, String aTTKey, String aHKey, String aHIKey, IController pController, ITreeModelAdapter aModel) {
        super(pKey, aTTKey, aHKey, aHIKey, (Control)pTreeViewer.getTree(), pController);
        this.theTreeViewer = pTreeViewer;
        this.theTreeViewer.setSorter(aModel.getSorter());
        this.theTreeViewer.setContentProvider((IContentProvider)aModel.getContentProvider());
        this.theTreeViewer.setLabelProvider((IBaseLabelProvider)aModel.getLabelProvider());
        this.theTreeViewer.setInput(aModel.getInput());
        this.theModel = aModel;
        this.theTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.theTreeViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private Tree getSWTTree() {
        return (Tree)this.getControl();
    }

    public void selectionChanged(SelectionChangedEvent aSelectionChangedEvent) {
        if (this.theTracer.debug()) {
            this.theTracer.debug(aSelectionChangedEvent.toString());
        }
        if (this.isUserInput()) {
            this.fireTreeViewSelected(aSelectionChangedEvent, this.getKey());
        }
    }

    public void checkStateChanged(CheckStateChangedEvent aCheckedChangedEvent) {
        if (this.theTracer.debug()) {
            this.theTracer.debug(aCheckedChangedEvent.toString());
        }
        if (this.isUserInput()) {
            this.fireTreeViewChecked(aCheckedChangedEvent, this.getKey());
        }
    }

    public void updateView() {
        if (this.theTracer.debug()) {
            this.theTracer.debug("CheckboxTreeView.updateView()");
        }
        boolean old = this.isUserInput();
        this.setUserInput(false);
        this.theTreeViewer.refresh();
        this.theTreeViewer.setCheckedElements(this.theModel.getCheckedElements());
        this.theTreeViewer.setGrayedElements(this.theModel.getGrayedElements());
        this.theTreeViewer.setSelection((ISelection)new StructuredSelection(this.theModel.getSelectedElements()));
        this.setUserInput(old);
    }

    public void handleModelChange(ModelChangeEvent aEvent) {
        this.updateView();
    }
}

