/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.dcmdcommons.view;

import com.sap.ide.eclipse.component.dcmdcommons.controller.IController;
import com.sap.ide.eclipse.component.dcmdcommons.view.ControlViewHandler;
import com.sap.ide.eclipse.component.dcmdcommons.view.IControlEventListener;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Vector;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

abstract class ButtonViewHandler
extends ControlViewHandler {
    private Vector viewListeners = new Vector();
    private boolean isUserInput = true;
    private TracerI theTracer = TracingManager.getTracer((String)this.getClass().getName());

    public ButtonViewHandler(int aKey, String aTTKey, String aHKey, String aHIKey, Control aSWTControl, IController aIDCController) {
        super(aKey, aTTKey, aHKey, aHIKey, aSWTControl, aIDCController);
        this.addViewListener(aIDCController);
    }

    public boolean isUserInput() {
        return this.isUserInput;
    }

    public void setUserInput(boolean aUserInput) {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Setting user input :" + aUserInput);
        }
        this.isUserInput = aUserInput;
    }

    public void addViewListener(IControlEventListener pViewListener) {
        this.viewListeners.addElement(pViewListener);
    }

    public void removeViewListener(IControlEventListener pViewListener) {
        this.viewListeners.removeElement(pViewListener);
    }

    private void fireButtonViewPressed(boolean pSelection, int pKey) {
        int viewListenersIndex = 0;
        while (viewListenersIndex < this.viewListeners.size()) {
            IControlEventListener viewListener = (IControlEventListener)this.viewListeners.elementAt(viewListenersIndex);
            viewListener.handleButtonViewPressed(pSelection, pKey);
            ++viewListenersIndex;
        }
    }

    public void mouseUp(MouseEvent e) {
        super.mouseUp(e);
        if (!this.isUserInput) {
            return;
        }
        int key = this.getKey();
        Button button = (Button)this.getControl();
        this.fireButtonViewPressed(button.getSelection(), key);
    }
}

