/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.ExceptionDialog;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.dii.component.IAskForSaveEditor;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dii.component.DCUtil;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Util {
    private static String BUILDVARIANT_TAG = "compartment";
    private static String NAME_ATTR = "name";
    private static String VARIANT_ATTR = "variant";
    public static final String BUILD_VARIANT_FILE = "buildvariant.config";
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$core$Util == null ? (class$com$sap$ide$eclipse$component$core$Util = Util.class$("com.sap.ide.eclipse.component.core.Util")) : class$com$sap$ide$eclipse$component$core$Util));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$core$Util;

    public static DocumentBuilder createNewDocumentBuilder() throws ParserConfigurationException {
        return new DocumentBuilderFactoryImpl().newDocumentBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveBuildVariants(IDevelopmentConfiguration config, Map buildVariants) {
        if (config == null || buildVariants == null) {
            return false;
        }
        Document doc = null;
        try {
            doc = Util.createNewDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            Util.logExceptionMessage(theTracer, 3, "Save build Variants failed.", e);
        }
        catch (FactoryConfigurationError e) {
            Util.logExceptionMessage(theTracer, 3, "Save build Variants failed.", e);
        }
        if (doc == null) {
            return false;
        }
        Element rootElement = doc.createElement("info");
        doc.appendChild(rootElement);
        Iterator it = buildVariants.keySet().iterator();
        while (it.hasNext()) {
            String compartment = (String)it.next();
            String buildVariant = null;
            Object obj = buildVariants.get(compartment);
            if (obj instanceof Combo) {
                Combo combo = (Combo)obj;
                int index = combo.getSelectionIndex();
                if (index < 0) {
                    index = 0;
                }
                buildVariant = combo.getItems()[index];
            } else {
                buildVariant = obj.toString();
            }
            Element element = doc.createElement(BUILDVARIANT_TAG);
            element.setAttribute(NAME_ATTR, compartment);
            element.setAttribute(VARIANT_ATTR, buildVariant);
            rootElement.appendChild(doc.createTextNode("\n\t"));
            rootElement.appendChild(element);
        }
        rootElement.appendChild(doc.createTextNode("\n"));
        FileOutputStream stream = null;
        File file = new File(config.getConfigurationRootFolder() + BUILD_VARIANT_FILE);
        try {
            try {
                file.createNewFile();
                stream = new FileOutputStream(file);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 2, "Save Build Variants File failed", e);
                boolean bl = false;
                Object var11_14 = null;
                if (stream == null) return bl;
                try {
                    ((OutputStream)stream).close();
                    return bl;
                }
                catch (IOException e1) {
                    Util.logExceptionMessage(theTracer, 3, "Close stream failed.", e1);
                }
                return bl;
            }
            Util.serializeDom(doc, stream);
            Object var11_15 = null;
            if (stream == null) return true;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (stream == null) throw throwable;
            try {
                ((OutputStream)stream).close();
                throw throwable;
            }
            catch (IOException e1) {
                Util.logExceptionMessage(theTracer, 3, "Close stream failed.", e1);
            }
            throw throwable;
        }
        try {
            ((OutputStream)stream).close();
            return true;
        }
        catch (IOException e1) {
            Util.logExceptionMessage(theTracer, 3, "Close stream failed.", e1);
        }
        return true;
    }

    private static String serializeDom(Document doc, OutputStream outStream) {
        OutputFormat outputFormat = new OutputFormat(doc);
        outputFormat.setPreserveEmptyAttributes(true);
        outputFormat.setPreserveSpace(true);
        XMLSerializer xmlSerializer = new XMLSerializer(outStream, outputFormat);
        try {
            xmlSerializer.serialize(doc);
        }
        catch (Throwable ex) {
            Util.logExceptionMessage(theTracer, 2, "XML Serializer Error", ex);
        }
        String retString = outStream.toString();
        return retString;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getBuildVariantDocument(IDevelopmentConfiguration config) throws Exception {
        fileName = config.getConfigurationRootFolder() + "buildvariant.config";
        file = new File(fileName);
        if (file == null) throw new Exception(fileName + " is missing");
        if (!file.exists()) {
            throw new Exception(fileName + " is missing");
        }
        stream = null;
        try {
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Util.logExceptionMessage(Util.theTracer, 2, fileName + " is missing", e);
                var5_7 = null;
                var7_9 = null;
                try {
                    if (stream == null) return var5_7;
                    stream.close();
                    return var5_7;
                }
                catch (IOException e) {
                    Util.logExceptionMessage(Util.theTracer, 3, "Close stream failed", e);
                }
                return var5_7;
            }
            try {
                e = Util.createNewDocumentBuilder().parse(stream);
                var7_10 = null;
            }
            catch (Throwable e) {
                var5_8 = null;
                var7_11 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 161->172)] { 
lbl33:
                // 1 sources

                if (stream == null) return var5_8;
                stream.close();
                return var5_8;
lbl36:
                // 1 sources

                catch (IOException e) {
                    Util.logExceptionMessage(Util.theTracer, 3, "Close stream failed", e);
                }
                return var5_8;
            }
        }
        catch (Throwable var6_17) {
            var7_12 = null;
            try {}
            catch (IOException e) {
                Util.logExceptionMessage(Util.theTracer, 3, "Close stream failed", e);
                throw var6_17;
            }
            if (stream == null) throw var6_17;
            stream.close();
            throw var6_17;
        }
        ** try [egrp 3[TRYBLOCK] [3 : 161->172)] { 
lbl51:
        // 1 sources

        if (stream == null) return e;
        stream.close();
        return e;
lbl54:
        // 1 sources

        catch (IOException e) {
            Util.logExceptionMessage(Util.theTracer, 3, "Close stream failed", e);
        }
        return e;
    }

    public static String getBuildVariant(IDevelopmentConfiguration config, String compartmentName) throws Exception {
        Document doc = Util.getBuildVariantDocument(config);
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName(BUILDVARIANT_TAG);
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            if (list.item(i) instanceof Element && compartmentName.equals((element = (Element)list.item(i)).getAttribute(NAME_ATTR))) {
                return element.getAttribute(VARIANT_ATTR);
            }
            ++i;
        }
        return null;
    }

    public static void initBuildVariant(IDevelopmentConfiguration config) {
        Document doc = null;
        try {
            doc = Util.getBuildVariantDocument(config);
        }
        catch (Exception e1) {
            Util.logExceptionMessage(theTracer, 2, "Initializing of Development configuration " + config.getConfigurationRootFolder() + " failed", e1);
        }
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName(BUILDVARIANT_TAG);
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Element element = (Element)list.item(i);
                String compartmentName = element.getAttribute(NAME_ATTR);
                String buildVariant = element.getAttribute(VARIANT_ATTR);
                if (compartmentName != null && buildVariant != null) {
                    try {
                        config.setDefaultBuildVariant(compartmentName, buildVariant);
                    }
                    catch (DevConfigException e) {
                        Util.logExceptionMessage(theTracer, 2, "Setting Build Variant " + buildVariant + " for " + compartmentName + " failed", e);
                    }
                }
            }
            ++i;
        }
    }

    public static int showException(Throwable e, Shell shell) {
        return Util.showException(e, "Error", "Action failed", shell);
    }

    public static int showException(final Throwable e, final String title, final String text, final Shell shell) {
        final int[] ret = new int[]{0};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell myShell = shell;
                if (myShell == null) {
                    myShell = ComponentProviderPlugin.getPlugin().getMyShell();
                }
                StringWriter myStringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(myStringWriter));
                String message = null;
                if (e instanceof SyncException) {
                    message = ComponentProviderMessages.getSyncExceptionText((SyncException)e);
                }
                if (message == null) {
                    message = e.getMessage();
                }
                ExceptionDialog dialog = new ExceptionDialog(myShell, title, text, message, myStringWriter.toString());
                ret[0] = dialog.open();
            }
        });
        return ret[0];
    }

    public static void showUserOutputViewer() {
        IWorkbench workbench = ComponentProviderPlugin.getPlugin().getWorkbench();
        boolean planB = false;
        if (workbench == null) {
            planB = true;
        } else {
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                planB = true;
            } else {
                IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                if (page == null) {
                    return;
                }
                IViewPart theLogger = page.findView("com.tssap.tools.ui.views.UserOutView");
                if (theLogger == null) {
                    try {
                        page.showView("com.tssap.tools.ui.views.UserOutView");
                    }
                    catch (PartInitException pie) {
                        Util.logExceptionMessage(theTracer, 2, "Logger View is not available", pie);
                    }
                } else {
                    page.activate((IWorkbenchPart)theLogger);
                }
            }
        }
        if (planB) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow actWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (actWindow == null) {
                        return;
                    }
                    IWorkbenchPage actPage = actWindow.getActivePage();
                    if (actPage == null) {
                        return;
                    }
                    try {
                        actPage.showView("com.tssap.tools.ui.views.UserOutView");
                    }
                    catch (PartInitException x) {
                        Util.logExceptionMessage(theTracer, 2, "Logger View is not available", x);
                    }
                }
            });
        }
    }

    public static void updateGenFolder(IProject[] projects) {
        try {
            if (projects == null) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                projects = workspace.getRoot().getProjects();
            }
            int i = 0;
            while (i < projects.length) {
                IFolder folder;
                if (DCUtil.isDCProject((IProject)projects[i]) && (folder = projects[i].getFolder("gen")) != null && folder.exists()) {
                    WorkspaceMonitor.getInstance().setMonitorResource((IResource)folder, false, -1);
                    folder.refreshLocal(2, null);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Util.logExceptionMessage(theTracer, 3, "Update GEN folder failed", e);
        }
    }

    public static boolean saveSensitiveEditors(Collection devConfSet) {
        if (devConfSet == null || devConfSet.isEmpty()) {
            return true;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            ArrayList<IEditorPart> toSaveEditors = new ArrayList<IEditorPart>();
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && editor instanceof IAskForSaveEditor) {
                        IFile inputFile = ((IFileEditorInput)input).getFile();
                        IProject project = inputFile.getProject();
                        try {
                            IDCExtendedProject dcPrj;
                            if (DCProjectInfo.isDCProject((IProject)project) && devConfSet.contains((dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")).getConfiguration())) {
                                toSaveEditors.add(editor);
                            }
                        }
                        catch (CoreException e) {
                            Util.logExceptionMessage(theTracer, 3, "Save Editors has Problems", e);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            if (!toSaveEditors.isEmpty()) {
                return EditorManager.saveAll(toSaveEditors, (boolean)true, (IWorkbenchWindow)windows[i]);
            }
            ++i;
        }
        return true;
    }

    public static boolean saveSensitiveEditors(IDevelopmentConfiguration config) {
        ArrayList<IDevelopmentConfiguration> list = new ArrayList<IDevelopmentConfiguration>(1);
        if (config != null) {
            list.add(config);
        }
        return Util.saveSensitiveEditors(list);
    }

    public static void logExceptionMessage(TracerI tracer, int severity, String msg, Throwable t) {
        if (t != null) {
            msg = msg + ": " + t.getMessage();
            tracer.log(severity, msg, t);
        } else {
            tracer.log(severity, msg);
        }
        tracer.userOut(severity, msg);
    }

    public static void logException(TracerI tracer, Throwable t) {
        tracer.error(t.getMessage(), t);
        tracer.userOut(2, t.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

