/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.provider.ui.filter.BuildPluginFilter;
import com.sap.ide.eclipse.component.provider.ui.filter.ConfigurableFilter;
import com.sap.ide.eclipse.component.provider.ui.filter.ModificationAllowedFilter;
import com.sap.ide.eclipse.component.provider.ui.filter.SyncAllowedFilter;
import com.sap.ide.eclipse.component.provider.ui.label.DCGenericLabelProvider;
import com.sap.ide.eclipse.component.provider.ui.label.DCMetaDataLabelProvider;
import com.sap.ide.eclipse.component.provider.ui.label.StructureLabelProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.ui.LabelProviderContainer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class SimpleComponentTreeViewer
extends GenericDataModelFilteredTreeViewer {
    private IMutableFilterSet componentViewFilterSet = null;
    private int visibleLevel = 2;

    public int getVisibleLevel() {
        return this.visibleLevel;
    }

    public void setVisibleLevel(int pVisibleLevel) {
        this.visibleLevel = pVisibleLevel;
    }

    public SimpleComponentTreeViewer(Composite parent, boolean singleSelection, int level) {
        super(parent, ModelUtilPlugin.computeModels(), FilterFactory.createDefaultYesManFilter(), false, singleSelection);
        this.setVisibleLevel(level);
        this.setOptimisticChildrenCheck(true);
        this.setDissolveReferences(true);
        this.setSkipReferenceCollections(true);
        this.setSkipReferences(true);
        LabelProviderContainer labelManager = new LabelProviderContainer();
        labelManager.addLabelProvider((ILabelProvider)new StructureLabelProvider());
        labelManager.addLabelProvider((ILabelProvider)new DCGenericLabelProvider());
        labelManager.addLabelProvider((ILabelProvider)new DCMetaDataLabelProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)labelManager);
        ConfigurableFilter componentFilter = new ConfigurableFilter(level);
        componentFilter.setName("ConfigurableFilter");
        if ((level & 0x1F0) != 0) {
            this.componentViewFilterSet = FilterFactory.createAndFilterSet();
            this.componentViewFilterSet.addFilter((IFilter)componentFilter);
            this.componentViewFilterSet.setName("ComponentTreeFilterSet");
            if ((level & 0x10) != 0) {
                ModificationAllowedFilter allowedFilter = new ModificationAllowedFilter();
                allowedFilter.setName("ModificationAllowedFilter");
                this.componentViewFilterSet.addFilter((IFilter)allowedFilter);
            }
            if ((level & 0x20) != 0) {
                BuildPluginFilter buildPluginFilter = new BuildPluginFilter();
                buildPluginFilter.setName("BuildPluginFilter");
                this.componentViewFilterSet.addFilter((IFilter)buildPluginFilter);
            }
            if ((level & 0x40) != 0) {
                SyncAllowedFilter syncAllowedFilter = new SyncAllowedFilter();
                syncAllowedFilter.setName("SyncAllowedFilter");
                this.componentViewFilterSet.addFilter((IFilter)syncAllowedFilter);
            }
            if ((level & 0x80) != 0) {
                ActiveFilter onlyActiveFilter = new ActiveFilter();
                onlyActiveFilter.setName("OnlyActiveFilter");
                this.componentViewFilterSet.addFilter((IFilter)onlyActiveFilter);
            } else if ((level & 0x100) != 0) {
                InactiveFilter onlyInactiveFilter = new InactiveFilter();
                onlyInactiveFilter.setName("OnlyInActiveFilter");
                this.componentViewFilterSet.addFilter((IFilter)onlyInactiveFilter);
            }
            this.setFilter((IFilter)this.componentViewFilterSet);
        } else {
            this.setFilter((IFilter)componentFilter);
        }
    }

    public boolean isTreeEmpty() {
        if (this.getTreeViewer() != null && this.getTreeViewer().getTree() != null) {
            return this.getTreeViewer().getTree().getItemCount() == 0;
        }
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().addSelectionChangedListener(listener);
    }

    public Element getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection != null && selection.getFirstElement() != null && selection.getFirstElement() instanceof Element) {
            return (Element)selection.getFirstElement();
        }
        return null;
    }

    public static class InactiveFilter
    extends YesManFilter {
        public boolean isAvailable(PropertyMap propertyMap) {
            Element element;
            String sd;
            return !(propertyMap instanceof Element) || !(sd = (element = (Element)propertyMap).getUniqueName().getSubDomain()).equals("com.sap.ide.eclipse.component.SC.active");
        }
    }

    public static class ActiveFilter
    extends YesManFilter {
        public boolean isAvailable(PropertyMap propertyMap) {
            Element element;
            String sd;
            return !(propertyMap instanceof Element) || !(sd = (element = (Element)propertyMap).getUniqueName().getSubDomain()).equals("com.sap.ide.eclipse.component.SC.inactive");
        }
    }
}

