/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.actions.dc.DcCreateProjectAction;
import com.sap.ide.eclipse.component.provider.ui.label.DCGenericDecoratorProvider;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class SelectDCsDialog
extends ListSelectionDialog {
    private boolean invertCheckbox = false;
    private String warningText = null;
    private String checkBoxText = null;
    protected Collection _selectedDCs = null;
    protected Button box = null;
    boolean optionChecked = true;
    protected Composite warnings = null;
    private Collection _staticSelectedDCs;

    public static SelectDCsDialog newSelectDCsDialog(Shell shell, String title, String message, Collection dcList, Collection selectedDcs, Collection staticSelectedDCs) {
        SelectDCsDialog dialog = null;
        if (shell == null) {
            shell = ComponentProviderPlugin.getPlugin().getMyShell();
        }
        DCContentProvider cProvider = new DCContentProvider(selectedDcs);
        DCLabelProvider lProvider = new DCLabelProvider();
        dialog = new SelectDCsDialog(shell, title, message, dcList, selectedDcs, staticSelectedDCs, cProvider, lProvider);
        return dialog;
    }

    protected SelectDCsDialog(Shell shell, String title, String message, Collection dcList, Collection selectedDCs, Collection staticSelectedDCs, DCContentProvider cProvider, DCLabelProvider lProvider) {
        super(shell, (Object)dcList, (IStructuredContentProvider)cProvider, (ILabelProvider)lProvider, message);
        this._staticSelectedDCs = staticSelectedDCs;
        this._selectedDCs = selectedDCs;
        if (this._selectedDCs == null) {
            this._selectedDCs = new ArrayList();
        }
        if (this._staticSelectedDCs == null) {
            this._staticSelectedDCs = new ArrayList();
        }
        this.setTitle(title);
    }

    public void initializeOptions(String checkBoxText, boolean initState, String warningText, boolean visiableInverted) {
        this.checkBoxText = checkBoxText;
        this.optionChecked = initState;
        this.warningText = warningText;
        this.invertCheckbox = visiableInverted;
    }

    protected Control createDialogArea(Composite parent) {
        Button deselectAllButton;
        Composite ctrl = (Composite)super.createDialogArea(parent);
        if (this.checkBoxText != null) {
            this.box = new Button(ctrl, 32);
            this.box.setText(this.checkBoxText);
            this.box.setSelection(this.optionChecked);
            this.box.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (SelectDCsDialog.this.box != null) {
                        SelectDCsDialog.this.optionChecked = SelectDCsDialog.this.box.getSelection();
                    }
                    if (SelectDCsDialog.this.warnings != null) {
                        SelectDCsDialog.this.warnings.setVisible(SelectDCsDialog.this.invertCheckbox ? !SelectDCsDialog.this.optionChecked : SelectDCsDialog.this.optionChecked);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.warningText != null) {
                this.warnings = this.createWarning(ctrl);
                this.warnings.setVisible(this.invertCheckbox ? !this.optionChecked : this.optionChecked);
            }
        }
        final CheckboxTableViewer viewer = this.getViewer();
        SelectDCsDialog.initializeSelection(viewer, this._selectedDCs, this._staticSelectedDCs);
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (SelectDCsDialog.this._staticSelectedDCs.contains(checkStateChangedEvent.getElement())) {
                    ICheckable checkable = checkStateChangedEvent.getCheckable();
                    checkable.setChecked(checkStateChangedEvent.getElement(), true);
                }
            }
        });
        if (this._staticSelectedDCs != null) {
            // empty if block
        }
        if ((deselectAllButton = this.getButton(19)) != null) {
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectDCsDialog.initializeSelection(viewer, new ArrayList(), SelectDCsDialog.this._staticSelectedDCs);
                }
            });
        }
        return ctrl;
    }

    public static void initializeSelection(CheckboxTableViewer viewer, Collection selectedDCs, Collection staticSelectedDCs) {
        TableItem[] children = viewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object obj = item.getData();
            if (staticSelectedDCs != null && staticSelectedDCs.contains(obj)) {
                item.setGrayed(true);
                item.setBackground(Display.getCurrent().getSystemColor(19));
                item.setChecked(true);
            } else if (selectedDCs != null && selectedDCs.contains(obj)) {
                item.setBackground(Display.getCurrent().getSystemColor(19));
            }
            ++i;
        }
    }

    private Composite createWarning(Composite ctrl) {
        Composite labels = new Composite(ctrl, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labels.setLayout((Layout)layout);
        GridData data = new GridData();
        labels.setLayoutData((Object)data);
        Label label = new Label(labels, 64);
        label.setImage(JFaceResources.getImageRegistry().get("dialog_messasge_warning_image"));
        data = new GridData(768);
        label.setLayoutData((Object)data);
        Label tLabel = new Label(labels, 64);
        tLabel.setText(this.warningText);
        data = new GridData(768);
        tLabel.setLayoutData((Object)data);
        return labels;
    }

    public boolean isOptionSelected() {
        return this.optionChecked;
    }

    public static class DCLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private TracerI theTracer = TracingManager.getTracer(this.getClass());

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex > 1) {
                return null;
            }
            if (element instanceof IDevelopmentComponentNode || element instanceof IDCProxy) {
                boolean dirty = false;
                boolean broken = false;
                DCNodeSyncMode mode = null;
                DCNodeSyncState state = null;
                if (element instanceof IDevelopmentComponentNode) {
                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)element;
                    mode = dcNode.getNodeSyncMode();
                    state = dcNode.getNodeSyncState();
                    dirty = dcNode.isDirty();
                    broken = dcNode.isBroken();
                }
                if (element instanceof IDCProxy) {
                    IDCProxy dcProxy = (IDCProxy)element;
                    mode = dcProxy.getDCSyncMode();
                    state = dcProxy.getDCSyncState();
                    dirty = dcProxy.isDirty();
                    broken = dcProxy.isBroken();
                }
                Image image = null;
                if (element instanceof IDCProxy) {
                    element = ((IDCProxy)element).toNode();
                }
                if (element instanceof IDevelopmentComponentNode) {
                    IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)element;
                    if (dcNode.IsInactive()) {
                        if (mode == DCNodeSyncMode.NOT_SYNCHED && DcCreateProjectAction.canSyncArchive(dcNode)) {
                            image = ComponentCategoryImage.getImage("Development Component (active)");
                        }
                        if (image == null) {
                            image = ComponentCategoryImage.getImage("Development Component (inactive)");
                        }
                    } else {
                        image = ComponentCategoryImage.getImage("Development Component (active)");
                    }
                } else {
                    image = ComponentCategoryImage.getImage("Development Component");
                }
                return DCGenericDecoratorProvider.getDecoratedImage(image, mode, state, dirty, broken);
            }
            if (element instanceof DCReference || element instanceof Dependency) {
                return ComponentCategoryImage.getImage("Development Component");
            }
            return null;
        }

        private static String generateDCName(String dcName, String dcVendor, String status) {
            return dcName + (status != null ? " <" + status + ">" : "");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IDevelopmentComponentNode) {
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)element;
                switch (columnIndex) {
                    case 0: {
                        return DCLabelProvider.generateDCName(dcNode.getName(), dcNode.getVendor(), dcNode.isSynchedAsActiveSource() ? "source" : null);
                    }
                    case 1: {
                        return dcNode.getName();
                    }
                    case 2: {
                        return dcNode.getVendor();
                    }
                }
                return "";
            }
            if (element instanceof IDCProxy) {
                IDCProxy dcProxy = (IDCProxy)element;
                switch (columnIndex) {
                    case 0: {
                        DCNodeSyncMode mode = dcProxy.getDCSyncMode();
                        String status = DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE.equals(mode) ? "source" : null;
                        return DCLabelProvider.generateDCName(dcProxy.getName(), dcProxy.getVendor(), status);
                    }
                    case 1: {
                        return dcProxy.getName();
                    }
                    case 2: {
                        return dcProxy.getVendor();
                    }
                }
                return "";
            }
            if (element instanceof DevelopmentComponent) {
                DevelopmentComponent dc = (DevelopmentComponent)element;
                switch (columnIndex) {
                    case 0: {
                        return DCLabelProvider.generateDCName(dc.getName(), dc.getVendor(), null);
                    }
                    case 1: {
                        return dc.getName();
                    }
                    case 2: {
                        return dc.getVendor();
                    }
                }
                return "";
            }
            if (element instanceof Dependency) {
                Dependency dependency = (Dependency)element;
                element = dependency.getComponent();
            }
            if (element instanceof DCReference) {
                DCReference dcRef = (DCReference)element;
                switch (columnIndex) {
                    case 0: {
                        return DCLabelProvider.generateDCName(dcRef.getName(), dcRef.getVendor(), null);
                    }
                    case 1: {
                        return dcRef.getName();
                    }
                    case 2: {
                        return dcRef.getVendor();
                    }
                }
                return "";
            }
            if (element != null) {
                element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 1);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 1);
        }
    }

    public static class DCContentProvider
    implements IStructuredContentProvider {
        Collection sortToTop = null;

        public DCContentProvider() {
        }

        public DCContentProvider(Collection sortToTop) {
            this.sortToTop = sortToTop;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection list = (Collection)inputElement;
                return this.sort(list);
            }
            return null;
        }

        private Object[] sort(Collection list) {
            if (list == null) {
                return new Object[0];
            }
            Object[] sorted = list.toArray();
            Arrays.sort(sorted, new Comparator(this){
                private final /* synthetic */ DCContentProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean equals(Object obj) {
                    return false;
                }

                public int compare(Object o1, Object o2) {
                    boolean o2Top;
                    boolean o1Top = this.this$0.sortToTop != null && this.this$0.sortToTop.contains(o1);
                    boolean bl = o2Top = this.this$0.sortToTop != null && this.this$0.sortToTop.contains(o2);
                    if (o1Top ^ o2Top) {
                        return o1Top ? -1 : 1;
                    }
                    return DCContentProvider.access$000(this.this$0, o1).compareTo(DCContentProvider.access$000(this.this$0, o2));
                }
            });
            return sorted;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private String getName(Object element) {
            if (element instanceof IDevelopmentComponentNode) {
                return ((IDevelopmentComponentNode)element).getName();
            }
            if (element instanceof IDCProxy) {
                return ((IDCProxy)element).getName();
            }
            if (element instanceof DevelopmentComponent) {
                return ((DevelopmentComponent)element).getName();
            }
            if (element instanceof Dependency) {
                Dependency dependency = (Dependency)element;
                element = dependency.getComponent();
            }
            if (element instanceof DCReference) {
                ((DCReference)element).getName();
            }
            return "";
        }

        static /* synthetic */ String access$000(DCContentProvider x0, Object x1) {
            return x0.getName(x1);
        }
    }
}

