/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IPPEntityServiceExtension;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JDTPPEntityService
implements IPPEntityServiceExtension {
    private IProject theProject;
    private IJavaProject theJavaDCProject;
    private DevelopmentComponent theDC;
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$core$JDTPPEntityService == null ? (class$com$sap$ide$eclipse$component$core$JDTPPEntityService = JDTPPEntityService.class$("com.sap.ide.eclipse.component.core.JDTPPEntityService")) : class$com$sap$ide$eclipse$component$core$JDTPPEntityService));
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    private String[] theEntityTyps;
    private ArrayList thePackageTreeEntitiesList;
    private ArrayList thePackageEntitiesList;
    private ArrayList theClassEntitiesList;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$core$JDTPPEntityService;

    public JDTPPEntityService() {
        this.theEntityTyps = new String[]{IPPModel.EntityType.JAVA_PACKAGE_TREE.toString(), IPPModel.EntityType.JAVA_PACKAGE.toString(), IPPModel.EntityType.JAVA_CLASS.toString()};
    }

    public JDTPPEntityService(IProject aProject) {
        this.theProject = aProject;
        this.theEntityTyps = new String[]{IPPModel.EntityType.JAVA_PACKAGE_TREE.toString(), IPPModel.EntityType.JAVA_PACKAGE.toString(), IPPModel.EntityType.JAVA_CLASS.toString()};
    }

    public void setProject(IProject aProject) {
        this.theProject = aProject;
    }

    private boolean init() {
        if (this.theJavaDCProject != null && this.theDC != null) {
            return true;
        }
        if (this.theJavaDCProject == null) {
            boolean hasJavaNature = false;
            try {
                hasJavaNature = this.theProject.hasNature("org.eclipse.jdt.core.javanature");
                if (hasJavaNature) {
                    this.theJavaDCProject = JavaCore.create((IProject)this.theProject);
                }
            }
            catch (CoreException ce) {
                Util.logExceptionMessage(this.theTracer, 3, "Could not init JDT entity service", ce);
                return false;
            }
        }
        if (this.theDC == null) {
            Object aDC = null;
            IDevelopmentComponentNode aDCNode = null;
            try {
                aDCNode = ComponentUtil.getDCNode((IProject)this.theProject);
                if (aDCNode != null) {
                    this.theDC = aDCNode.getDevelopmentComponent(true);
                }
            }
            catch (Exception e) {
                Util.logExceptionMessage(this.theTracer, 3, "Could not init JDT entity service", e);
                return false;
            }
        }
        return this.theJavaDCProject != null && this.theDC != null;
    }

    public String[] getTypes() {
        ArrayList<String> theNotEmptyTyps = new ArrayList<String>();
        int size = this.theEntityTyps.length;
        int i = 0;
        while (i < size) {
            Iterator anIter = this.getEntities(this.theEntityTyps[i]);
            if (anIter.hasNext()) {
                theNotEmptyTyps.add(this.theEntityTyps[i]);
            }
            ++i;
        }
        return theNotEmptyTyps.toArray(new String[theNotEmptyTyps.size()]);
    }

    public synchronized Iterator getEntities(String aType) {
        Iterator anIter = ((AbstractList)new ArrayList()).iterator();
        if (aType.intern() == IPPModel.EntityType.JAVA_PACKAGE_TREE.toString().intern()) {
            if (this.thePackageTreeEntitiesList == null || !this.canUseCached()) {
                this.buildJavaNatureEntities(IPPModel.EntityType.JAVA_PACKAGE_TREE);
            }
            anIter = ((AbstractList)this.thePackageTreeEntitiesList).iterator();
        }
        if (aType.intern() == IPPModel.EntityType.JAVA_PACKAGE.toString().intern()) {
            if (this.thePackageEntitiesList == null || !this.canUseCached()) {
                this.buildJavaNatureEntities(IPPModel.EntityType.JAVA_PACKAGE);
            }
            anIter = ((AbstractList)this.thePackageEntitiesList).iterator();
        }
        if (aType.intern() == IPPModel.EntityType.JAVA_CLASS.toString().intern()) {
            if (this.theClassEntitiesList == null || !this.canUseCached()) {
                this.buildJavaNatureEntities(IPPModel.EntityType.JAVA_CLASS);
            }
            anIter = ((AbstractList)this.theClassEntitiesList).iterator();
        }
        return anIter;
    }

    private boolean canUseCached() {
        return false;
    }

    private void buildJavaNatureEntities(IPPModel.EntityType aType) {
        if (!this.init()) {
            if (aType == IPPModel.EntityType.JAVA_PACKAGE_TREE && this.thePackageTreeEntitiesList == null) {
                this.thePackageTreeEntitiesList = new ArrayList();
            }
            if (aType == IPPModel.EntityType.JAVA_PACKAGE && this.thePackageEntitiesList == null) {
                this.thePackageEntitiesList = new ArrayList();
            }
            if (aType == IPPModel.EntityType.JAVA_CLASS && this.theClassEntitiesList == null) {
                this.theClassEntitiesList = new ArrayList();
            }
            return;
        }
        ArrayList<IPackageFragment> theSourcePackages = new ArrayList<IPackageFragment>();
        try {
            IPackageFragment[] thePackageFragments = this.theJavaDCProject.getPackageFragments();
            int size = thePackageFragments.length;
            int i = 0;
            while (i < size) {
                if (thePackageFragments[i].getKind() == 1 && this.isDCRelevant(thePackageFragments[i].getPath())) {
                    theSourcePackages.add(thePackageFragments[i]);
                }
                ++i;
            }
            if (this.theTracer.debug()) {
                this.debugPackageFragments(theSourcePackages.toArray(new IPackageFragment[theSourcePackages.size()]));
            }
        }
        catch (JavaModelException cme) {
            String aMessage = this.theMessageUtil.getString("Exception.Occurred.During.BuildUp.EntityList");
            Util.logExceptionMessage(this.theTracer, 2, aMessage, cme);
        }
        if (aType == IPPModel.EntityType.JAVA_PACKAGE_TREE) {
            this.buildJavaPackageTreeEntities(theSourcePackages.toArray(new IPackageFragment[theSourcePackages.size()]));
        }
        if (aType == IPPModel.EntityType.JAVA_PACKAGE) {
            this.buildJavaPackageEntities(theSourcePackages.toArray(new IPackageFragment[theSourcePackages.size()]));
        }
        if (aType == IPPModel.EntityType.JAVA_CLASS) {
            this.buildJavaClassEntities(theSourcePackages.toArray(new IPackageFragment[theSourcePackages.size()]));
        }
    }

    private boolean isDCRelevant(IPath aSourceFilePath) {
        boolean result = false;
        String aDCRelativePath = aSourceFilePath.removeFirstSegments(1).toString();
        List thePackageFolders = this.theDC.getPackageFolders();
        if (thePackageFolders != null) {
            Iterator anIter = thePackageFolders.iterator();
            while (anIter.hasNext()) {
                String aPath = (String)anIter.next();
                result = aDCRelativePath.startsWith(aPath);
                if (!result) {
                    continue;
                }
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void buildJavaPackageTreeEntities(IPackageFragment[] thePackageFragments) {
        this.thePackageTreeEntitiesList = new ArrayList();
        int size = thePackageFragments.length;
        int i = 0;
        while (i < size) {
            String aName = thePackageFragments[i].getElementName();
            String aPackage = aName.replace('.', '/');
            if (aName.trim().equals("")) {
                aName = "(Default)";
                aPackage = "";
            }
            Entity aClassEntity = ComponentFactory.createEntity();
            aClassEntity.setType(IPPModel.EntityType.JAVA_PACKAGE_TREE.toString());
            aClassEntity.setSubType(IPPModel.EntitySubType.CLASS.toString());
            aClassEntity.setName(aName);
            aClassEntity.setPackageName(aPackage);
            aClassEntity.setCaption(aName);
            aClassEntity.setDescription(aName);
            Entity aSourceEntity = ComponentFactory.createEntity();
            aSourceEntity.setType(IPPModel.EntityType.JAVA_PACKAGE_TREE.toString());
            aSourceEntity.setSubType(IPPModel.EntitySubType.SOURCE.toString());
            aSourceEntity.setName(aName);
            aSourceEntity.setPackageName(aPackage);
            aSourceEntity.setCaption(aName);
            aSourceEntity.setDescription(aName);
            this.thePackageTreeEntitiesList.add(aClassEntity);
            this.thePackageTreeEntitiesList.add(aSourceEntity);
            ++i;
        }
    }

    private void buildJavaPackageEntities(IPackageFragment[] thePackageFragments) {
        this.thePackageEntitiesList = new ArrayList();
        int size = thePackageFragments.length;
        int i = 0;
        while (i < size) {
            String aName = thePackageFragments[i].getElementName();
            String aPackage = aName.replace('.', '/');
            if (aName.trim().equals("")) {
                aName = "(Default)";
                aPackage = "";
            }
            Entity aClassEntity = ComponentFactory.createEntity();
            aClassEntity.setType(IPPModel.EntityType.JAVA_PACKAGE.toString());
            aClassEntity.setSubType(IPPModel.EntitySubType.CLASS.toString());
            aClassEntity.setName(aName);
            aClassEntity.setPackageName(aPackage);
            aClassEntity.setCaption(aName);
            aClassEntity.setDescription(aName);
            Entity aSourceEntity = ComponentFactory.createEntity();
            aSourceEntity.setType(IPPModel.EntityType.JAVA_PACKAGE.toString());
            aSourceEntity.setSubType(IPPModel.EntitySubType.SOURCE.toString());
            aSourceEntity.setName(aName);
            aSourceEntity.setPackageName(aPackage);
            aSourceEntity.setCaption(aName);
            aSourceEntity.setDescription(aName);
            this.thePackageEntitiesList.add(aClassEntity);
            this.thePackageEntitiesList.add(aSourceEntity);
            ++i;
        }
    }

    private void buildJavaClassEntities(IPackageFragment[] thePackageFragments) {
        this.theClassEntitiesList = new ArrayList();
        int size = thePackageFragments.length;
        int i = 0;
        while (i < size) {
            ICompilationUnit[] theSourceFiles = new ICompilationUnit[]{};
            try {
                theSourceFiles = thePackageFragments[i].getCompilationUnits();
            }
            catch (JavaModelException jme) {
                break;
            }
            int noOfClasses = theSourceFiles.length;
            int j = 0;
            while (j < noOfClasses) {
                String aName = theSourceFiles[j].getElementName();
                aName = aName.substring(0, aName.length() - 5);
                String aPackage = thePackageFragments[i].getElementName();
                aPackage = aPackage.replace('.', '/');
                Entity aClassEntity = ComponentFactory.createEntity();
                aClassEntity.setType(IPPModel.EntityType.JAVA_CLASS.toString());
                aClassEntity.setSubType(IPPModel.EntitySubType.CLASS.toString());
                aClassEntity.setName(aName);
                aClassEntity.setPackageName(aPackage);
                aClassEntity.setCaption(aName);
                aClassEntity.setDescription(aName);
                Entity aSourceEntity = ComponentFactory.createEntity();
                aSourceEntity.setType(IPPModel.EntityType.JAVA_CLASS.toString());
                aSourceEntity.setSubType(IPPModel.EntitySubType.SOURCE.toString());
                aSourceEntity.setName(aName);
                aSourceEntity.setPackageName(aPackage);
                aSourceEntity.setCaption(aName);
                aSourceEntity.setDescription(aName);
                this.theClassEntitiesList.add(aClassEntity);
                this.theClassEntitiesList.add(aSourceEntity);
                ++j;
            }
            ++i;
        }
    }

    private void debugPackageFragments(IPackageFragment[] thePackageFragments) {
        int size = thePackageFragments.length;
        StringBuffer aBuffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            aBuffer.setLength(0);
            aBuffer.append("Found source package fragment: ");
            aBuffer.append(thePackageFragments[i].getPath().toString());
            this.theTracer.debug(aBuffer.toString());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

