/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IPPEntityServiceExtension;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FilesAndFolderPPEntityService
implements IPPEntityServiceExtension {
    private IProject theProject;
    private DevelopmentComponent theDC;
    private TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$core$FilesAndFolderPPEntityService == null ? (class$com$sap$ide$eclipse$component$core$FilesAndFolderPPEntityService = FilesAndFolderPPEntityService.class$("com.sap.ide.eclipse.component.core.FilesAndFolderPPEntityService")) : class$com$sap$ide$eclipse$component$core$FilesAndFolderPPEntityService));
    private MessageUtil theMessageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    private String[] theEntityTyps;
    private ArrayList theFilesEntitiesList;
    private ArrayList theFolderEntitiesList;
    private ArrayList theFolderTreeEntitiesList;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$core$FilesAndFolderPPEntityService;

    public FilesAndFolderPPEntityService() {
        this.theEntityTyps = new String[]{IPPModel.EntityType.FILE.toString(), IPPModel.EntityType.FOLDER.toString(), IPPModel.EntityType.FOLDER_TREE.toString()};
    }

    public FilesAndFolderPPEntityService(IProject aProject) {
        this.theProject = aProject;
        this.theEntityTyps = new String[]{IPPModel.EntityType.FILE.toString(), IPPModel.EntityType.FOLDER.toString(), IPPModel.EntityType.FOLDER_TREE.toString()};
    }

    public void setProject(IProject aProject) {
        this.theProject = aProject;
    }

    public String[] getTypes() {
        ArrayList<String> theNotEmptyTyps = new ArrayList<String>();
        int size = this.theEntityTyps.length;
        int i = 0;
        while (i < size) {
            Iterator anIter = this.getEntities(this.theEntityTyps[i]);
            if (anIter.hasNext()) {
                theNotEmptyTyps.add(this.theEntityTyps[i]);
            }
            ++i;
        }
        return theNotEmptyTyps.toArray(new String[theNotEmptyTyps.size()]);
    }

    public synchronized Iterator getEntities(String aType) {
        Iterator anIter = ((AbstractList)new ArrayList()).iterator();
        if (aType.intern() == IPPModel.EntityType.FILE.toString().intern()) {
            if (this.theFilesEntitiesList == null || !this.canUseCached()) {
                this.buildFilesAndFoldersEntities(IPPModel.EntityType.FILE);
            }
            anIter = ((AbstractList)this.theFilesEntitiesList).iterator();
        }
        if (aType.intern() == IPPModel.EntityType.FOLDER.toString().intern()) {
            if (this.theFolderEntitiesList == null || !this.canUseCached()) {
                this.buildFilesAndFoldersEntities(IPPModel.EntityType.FOLDER);
            }
            anIter = ((AbstractList)this.theFolderEntitiesList).iterator();
        }
        if (aType.intern() == IPPModel.EntityType.FOLDER_TREE.toString().intern()) {
            if (this.theFolderTreeEntitiesList == null || !this.canUseCached()) {
                this.buildFilesAndFoldersEntities(IPPModel.EntityType.FOLDER_TREE);
            }
            anIter = ((AbstractList)this.theFolderTreeEntitiesList).iterator();
        }
        return anIter;
    }

    private void buildFilesAndFoldersEntities(IPPModel.EntityType aType) {
        ArrayList aList;
        IFolder aTopFolder;
        Iterator anIter;
        HashMap tempFilesMap = new HashMap();
        HashMap tempFolderMap = new HashMap();
        HashMap tempFolderTreeMap = new HashMap();
        if (!this.init()) {
            if (aType == IPPModel.EntityType.FILE && this.theFilesEntitiesList == null) {
                this.theFilesEntitiesList = new ArrayList();
            }
            if (aType == IPPModel.EntityType.FOLDER && this.theFolderEntitiesList == null) {
                this.theFolderEntitiesList = new ArrayList();
            }
            if (aType == IPPModel.EntityType.FOLDER_TREE && this.theFolderTreeEntitiesList == null) {
                this.theFolderTreeEntitiesList = new ArrayList();
            }
            return;
        }
        List theListOfDCRelativeSourceFolders = this.theDC.getSourceFolders();
        List theListOfDCRelativePackageFolders = this.theDC.getPackageFolders();
        if (aType == IPPModel.EntityType.FILE) {
            this.theFilesEntitiesList = new ArrayList();
            if (theListOfDCRelativeSourceFolders != null) {
                anIter = theListOfDCRelativeSourceFolders.iterator();
                while (anIter.hasNext()) {
                    aTopFolder = this.theProject.getFolder((String)anIter.next());
                    aList = this.buildFileEntities(aTopFolder, aTopFolder, null);
                    this.addWithoutDublicates(tempFilesMap, aList);
                }
            }
            if (theListOfDCRelativePackageFolders != null) {
                anIter = theListOfDCRelativePackageFolders.iterator();
                while (anIter.hasNext()) {
                    aTopFolder = this.theProject.getFolder((String)anIter.next());
                    aList = this.buildFileEntities(aTopFolder, aTopFolder, ".java");
                    this.theFilesEntitiesList.addAll(aList);
                    this.addWithoutDublicates(tempFilesMap, aList);
                }
            }
            this.theFilesEntitiesList.addAll(tempFilesMap.values());
        }
        if (aType == IPPModel.EntityType.FOLDER || aType == IPPModel.EntityType.FOLDER_TREE) {
            this.theFolderEntitiesList = new ArrayList();
            this.theFolderTreeEntitiesList = new ArrayList();
            if (theListOfDCRelativeSourceFolders != null) {
                anIter = theListOfDCRelativeSourceFolders.iterator();
                while (anIter.hasNext()) {
                    aTopFolder = this.theProject.getFolder((String)anIter.next());
                    aList = this.buildFolderEntities(aTopFolder, aTopFolder, aType);
                    if (aType == IPPModel.EntityType.FOLDER) {
                        this.addWithoutDublicates(tempFolderMap, aList);
                    }
                    if (aType != IPPModel.EntityType.FOLDER_TREE) continue;
                    this.addWithoutDublicates(tempFolderTreeMap, aList);
                }
            }
            if (theListOfDCRelativePackageFolders != null) {
                anIter = theListOfDCRelativePackageFolders.iterator();
                while (anIter.hasNext()) {
                    aTopFolder = this.theProject.getFolder((String)anIter.next());
                    aList = this.buildFolderEntities(aTopFolder, aTopFolder, aType);
                    if (aType == IPPModel.EntityType.FOLDER) {
                        this.addWithoutDublicates(tempFolderMap, aList);
                    }
                    if (aType != IPPModel.EntityType.FOLDER_TREE) continue;
                    this.addWithoutDublicates(tempFolderTreeMap, aList);
                }
            }
            if (aType == IPPModel.EntityType.FOLDER) {
                this.theFolderEntitiesList.addAll(tempFolderMap.values());
            }
            if (aType == IPPModel.EntityType.FOLDER_TREE) {
                this.theFolderTreeEntitiesList.addAll(tempFolderTreeMap.values());
            }
        }
    }

    private void addWithoutDublicates(HashMap aMapWithEntities, ArrayList aListToBeAdded) {
        Iterator anIter = ((AbstractList)aListToBeAdded).iterator();
        while (anIter.hasNext()) {
            Entity anEnt = (Entity)anIter.next();
            String aPath = anEnt.getName();
            aMapWithEntities.put(aPath, anEnt);
        }
    }

    private ArrayList buildFileEntities(IFolder aRoot, IFolder aStartFolder, String excludes) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        IResource[] members = new IResource[]{};
        try {
            members = aStartFolder.members();
        }
        catch (CoreException ce) {
            Util.logException(this.theTracer, ce);
        }
        int size = members.length;
        int i = 0;
        while (i < size) {
            if (members[i] instanceof IFolder) {
                ArrayList aResult = this.buildFileEntities(aRoot, (IFolder)members[i], excludes);
                result.addAll(aResult);
            }
            if (members[i] instanceof IFile) {
                IFile aFile = (IFile)members[i];
                if (excludes == null || !aFile.getName().endsWith(excludes)) {
                    Entity aFileEntity = ComponentFactory.createEntity();
                    aFileEntity.setType(IPPModel.EntityType.FILE.toString());
                    String aProjectRelativePathToTheRoot = aRoot.getProjectRelativePath().toString();
                    String aProjectRelativePath = aFile.getProjectRelativePath().toString();
                    String aRootRelativePath = aProjectRelativePath.substring(aProjectRelativePathToTheRoot.length() + 1);
                    aFileEntity.setName(aRootRelativePath);
                    result.add(aFileEntity);
                }
            }
            ++i;
        }
        return result;
    }

    private ArrayList buildFolderEntities(IFolder aRoot, IFolder aStartFolder, IPPModel.EntityType aType) {
        String aRootRelativePath;
        String aProjectRelativePath;
        String aProjectRelativePathToTheRoot;
        ArrayList<Entity> result = new ArrayList<Entity>();
        if (aType == IPPModel.EntityType.FOLDER) {
            Entity aFolderEntity = ComponentFactory.createEntity();
            aFolderEntity.setType(IPPModel.EntityType.FOLDER.toString());
            aProjectRelativePathToTheRoot = aRoot.getProjectRelativePath().toString();
            aProjectRelativePath = aStartFolder.getProjectRelativePath().toString();
            aRootRelativePath = "";
            if (!aProjectRelativePathToTheRoot.equals(aProjectRelativePath)) {
                aRootRelativePath = aProjectRelativePath.substring(aProjectRelativePathToTheRoot.length() + 1);
            }
            aFolderEntity.setName(aRootRelativePath.intern() == "".intern() ? "/" : aRootRelativePath);
            result.add(aFolderEntity);
        }
        if (aType == IPPModel.EntityType.FOLDER_TREE) {
            Entity aFolderTreeEntity = ComponentFactory.createEntity();
            aFolderTreeEntity.setType(IPPModel.EntityType.FOLDER_TREE.toString());
            aProjectRelativePathToTheRoot = aRoot.getProjectRelativePath().toString();
            aProjectRelativePath = aStartFolder.getProjectRelativePath().toString();
            aRootRelativePath = "";
            if (!aProjectRelativePathToTheRoot.equals(aProjectRelativePath)) {
                aRootRelativePath = aProjectRelativePath.substring(aProjectRelativePathToTheRoot.length() + 1);
            }
            aFolderTreeEntity.setName(aRootRelativePath.intern() == "".intern() ? "/" : aRootRelativePath);
            result.add(aFolderTreeEntity);
        }
        IResource[] members = new IResource[]{};
        try {
            members = aStartFolder.members();
        }
        catch (CoreException ce) {
            Util.logException(this.theTracer, ce);
        }
        int size = members.length;
        int i = 0;
        while (i < size) {
            if (members[i] instanceof IFolder) {
                ArrayList aResult = this.buildFolderEntities(aRoot, (IFolder)members[i], aType);
                result.addAll(aResult);
            }
            ++i;
        }
        return result;
    }

    private boolean init() {
        if (this.theDC != null) {
            return true;
        }
        if (this.theDC == null) {
            Object aDC = null;
            IDevelopmentComponentNode aDCNode = null;
            try {
                aDCNode = ComponentUtil.getDCNode((IProject)this.theProject);
                if (aDCNode != null) {
                    this.theDC = aDCNode.getDevelopmentComponent(true);
                }
            }
            catch (Exception e) {
                Util.logExceptionMessage(this.theTracer, 3, "Could not init files and folder entity service", e);
                return false;
            }
        }
        return this.theDC != null;
    }

    private boolean canUseCached() {
        return false;
    }

    private boolean isDCRelevant(IPath aPath) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

