/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDialog
extends Dialog {
    private static final int DEFAULT_WITH = 350;
    protected Text errorField;
    protected Text stackTraceField;
    protected Composite myComposite;
    protected String errorMessage = null;
    protected String errorDetails = null;
    protected String title = null;
    protected String message = null;
    private Button detailsButton;

    public ExceptionDialog(Shell parentShell, String title, String message, String errorMessage, String errorDetails) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.setErrorMessage(errorMessage);
        this.setErrorDetails(errorDetails);
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        point.x = 350;
        return point;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = parent;
        Image image = JFaceResources.getImageRegistry().get("dialog_error_image");
        if (this.message != null && this.message.length() > 0) {
            Composite labels = new Composite(main, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            labels.setLayout((Layout)layout);
            GridData data = new GridData();
            labels.setLayoutData((Object)data);
            Label label = new Label(labels, 64);
            if (image != null) {
                label.setImage(image);
            }
            data = new GridData(768);
            label.setLayoutData((Object)data);
            Label tLabel = new Label(labels, 64);
            tLabel.setText(this.message);
            data = new GridData(768);
            tLabel.setLayoutData((Object)data);
        }
        this.createErrorField(main);
        return main;
    }

    protected void createErrorField(Composite parent) {
        this.errorField = new Text(parent, 2050);
        this.errorField.setEditable(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.errorField.setLayoutData((Object)data);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            this.errorField.setText(this.errorMessage);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected Control createContents(Composite comp) {
        Control cont = super.createContents(comp);
        this.myComposite = (Composite)cont;
        return cont;
    }

    protected Control createButtonBar(Composite comp) {
        Control control = super.createButtonBar(comp);
        this.detailsButton = this.createButton((Composite)control, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        if (this.errorDetails == null || this.errorDetails.length() <= 0) {
            this.detailsButton.setEnabled(false);
        }
        this.detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ExceptionDialog.this.stackTraceField != null) {
                    ExceptionDialog.this.stackTraceField.dispose();
                    ExceptionDialog.this.stackTraceField = null;
                    this.updateShell();
                    ExceptionDialog.this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                } else if (ExceptionDialog.this.errorDetails != null) {
                    ExceptionDialog.this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                    ExceptionDialog.this.stackTraceField = new Text(ExceptionDialog.this.myComposite, 2818);
                    GridData gd = new GridData(1808);
                    ExceptionDialog.this.stackTraceField.setEditable(false);
                    gd.horizontalSpan = 3;
                    ExceptionDialog.this.stackTraceField.setLayoutData((Object)gd);
                    ExceptionDialog.this.stackTraceField.setText("\n\n\n\n\n\n\n\n\n\n");
                    this.updateShell();
                    ExceptionDialog.this.stackTraceField.setText(ExceptionDialog.this.errorDetails);
                }
            }

            private void updateShell() {
                Shell myShell = ExceptionDialog.this.myComposite.getShell();
                Point oldSize = myShell.getSize();
                myShell.pack();
                Point location = myShell.getLocation();
                Point size = myShell.getSize();
                ExceptionDialog.this.myComposite.getShell().setBounds(location.x, location.y, oldSize.x, size.y);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return control;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        if (this.detailsButton != null && !this.detailsButton.isDisposed()) {
            this.detailsButton.setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

