/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;

public class DeleteProjectHelper {
    private boolean deleteConfirmed = false;
    private int dialogCode = 0;
    private Shell shell;
    private boolean deleteContent = false;
    private boolean forceOutOfSyncDelete = false;
    private List projects = null;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$core$DeleteProjectHelper;

    public DeleteProjectHelper(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.shell = shell;
    }

    public void setProjectList(List projects) {
        this.projects = projects;
    }

    private List getSelectedResources() {
        if (this.projects == null) {
            this.projects = new ArrayList();
        }
        return this.projects;
    }

    boolean canDelete() {
        List resources = this.getSelectedResources();
        if (resources.size() == 0) {
            return false;
        }
        Iterator e = resources.iterator();
        while (e.hasNext()) {
            IResource next = (IResource)e.next();
            if (!next.isPhantom()) continue;
            return false;
        }
        return true;
    }

    boolean containsLinkedResource() {
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource resource = (IResource)iterator.next();
            if (!resource.isLinked()) continue;
            return true;
        }
        return false;
    }

    public boolean confirmDelete() {
        if (this.deleteConfirmed) {
            return this.dialogCode == 0;
        }
        List resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return true;
        }
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shell, resources.toArray(new IResource[resources.size()]));
        this.dialogCode = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        this.deleteConfirmed = true;
        return this.dialogCode == 0;
    }

    public boolean isCanceled() {
        return this.dialogCode == 1;
    }

    void delete(IResource[] resourcesToDelete, IProgressMonitor monitor) throws CoreException {
        this.forceOutOfSyncDelete = false;
        monitor.beginTask("", resourcesToDelete.length);
        int i = 0;
        while (i < resourcesToDelete.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.delete(resourcesToDelete[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            ++i;
        }
        monitor.done();
    }

    void delete(IResource resourceToDelete, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        try {
            if (resourceToDelete.getType() == 4) {
                IProject project = (IProject)resourceToDelete;
                project.delete(this.deleteContent, force, monitor);
            } else {
                resourceToDelete.delete(2, monitor);
            }
        }
        catch (CoreException exception) {
            if (resourceToDelete.getType() == 1) {
                IStatus[] children = exception.getStatus().getChildren();
                if (children.length == 1 && children[0].getCode() == 274) {
                    if (this.forceOutOfSyncDelete) {
                        resourceToDelete.delete(3, monitor);
                    } else {
                        int result = this.queryDeleteOutOfSync(resourceToDelete);
                        if (result == 2) {
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 4) {
                            this.forceOutOfSyncDelete = true;
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                throw exception;
            }
            throw exception;
        }
    }

    public boolean execute(IProgressMonitor monitor) throws CoreException {
        if (!this.confirmDelete()) {
            return false;
        }
        IResource[] resourcesToDelete = this.getResourcesToDelete();
        if (resourcesToDelete.length == 0) {
            return false;
        }
        this.delete(resourcesToDelete, monitor);
        return true;
    }

    IResource[] getResourcesToDelete() {
        IResource[] selectedResources = this.getSelectedResources().toArray(new IResource[this.getSelectedResources().size()]);
        if (!this.deleteContent) {
            return selectedResources;
        }
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.shell, WorkbenchMessages.getString((String)"DeleteResourceAction.title1"), WorkbenchMessages.getString((String)"DeleteResourceAction.readOnlyQuestion"));
        return checker.checkReadOnlyResources(selectedResources);
    }

    private int queryDeleteOutOfSync(IResource resource) {
        final MessageDialog dialog = new MessageDialog(this.shell, WorkbenchMessages.getString((String)"DeleteResourceAction.messageTitle"), null, WorkbenchMessages.format((String)"DeleteResourceAction.outOfSyncQuestion", (Object[])new Object[]{resource.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    public static void handleException(Throwable t, Shell shell) {
        if (t instanceof CoreException) {
            CoreException exception = (CoreException)t;
            IStatus status = exception.getStatus();
            IStatus[] children = status.getChildren();
            boolean outOfSyncError = false;
            int i = 0;
            while (i < children.length) {
                if (children[i].getCode() == 274) {
                    outOfSyncError = true;
                    break;
                }
                ++i;
            }
            if (outOfSyncError) {
                ErrorDialog.openError((Shell)shell, (String)WorkbenchMessages.getString((String)"DeleteResourceAction.errorTitle"), (String)WorkbenchMessages.getString((String)"DeleteResourceAction.outOfSyncError"), (IStatus)status);
            } else {
                ErrorDialog.openError((Shell)shell, (String)WorkbenchMessages.getString((String)"DeleteResourceAction.errorTitle"), null, (IStatus)status);
            }
        } else {
            WorkbenchPlugin.log((String)MessageFormat.format("Exception in {0}.excute: {1}", (class$com$sap$ide$eclipse$component$core$DeleteProjectHelper == null ? (class$com$sap$ide$eclipse$component$core$DeleteProjectHelper = DeleteProjectHelper.class$("com.sap.ide.eclipse.component.core.DeleteProjectHelper")) : class$com$sap$ide$eclipse$component$core$DeleteProjectHelper).getClass().getName(), t));
            MessageDialog.openError((Shell)shell, (String)WorkbenchMessages.getString((String)"DeleteResourceAction.messageTitle"), (String)WorkbenchMessages.format((String)"DeleteResourceAction.internalError", (Object[])new Object[]{t.getMessage()}));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private IResource[] projects;
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ DeleteProjectDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$002(this.this$0, button == DeleteProjectDialog.access$100(this.this$0));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IResource[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
        }

        static String getTitle(IResource[] projects) {
            if (projects.length == 1) {
                return WorkbenchMessages.getString((String)"DeleteResourceAction.titleProject1");
            }
            return WorkbenchMessages.getString((String)"DeleteResourceAction.titleProjectN");
        }

        static String getMessage(IResource[] projects) {
            if (projects.length == 1) {
                IProject project = (IProject)projects[0];
                return WorkbenchMessages.format((String)"DeleteResourceAction.confirmProject1", (Object[])new Object[]{project.getName()});
            }
            return WorkbenchMessages.format((String)"DeleteResourceAction.confirmProjectN", (Object[])new Object[]{new Integer(projects.length)});
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.length == 1 ? ((project = (IProject)this.projects[0]) == null || project.getLocation() == null ? WorkbenchMessages.getString((String)"DeleteResourceAction.deleteContentsN") : WorkbenchMessages.format((String)"DeleteResourceAction.deleteContents1", (Object[])new Object[]{project.getLocation().toOSString()})) : WorkbenchMessages.getString((String)"DeleteResourceAction.deleteContentsN");
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = WorkbenchMessages.getString((String)"DeleteResourceAction.doNotDeleteContents");
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ boolean access$002(DeleteProjectDialog x0, boolean x1) {
            x0.deleteContent = x1;
            return x0.deleteContent;
        }

        static /* synthetic */ Button access$100(DeleteProjectDialog x0) {
            return x0.radio1;
        }
    }
}

