/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IPPEntityService;
import com.sap.ide.eclipse.dii.component.IPPEntityServiceExtension;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.DCChangeListener;
import com.tssap.dii.component.IDCProject;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;

public class DCProject
extends PlatformObject
implements IProjectNature,
IDCExtendedProject {
    private IDCProxy _dcProxy;
    public static final String EXT_POINT_ENTITY_SERVICES = "com.sap.ide.eclipse.dii.ppentityservices";
    private IProject project;
    private IDevelopmentConfiguration configuration = null;
    private ICompartmentNode compartmentNode = null;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());
    private ArrayList thePPEntityServiceProviders = new ArrayList();
    private boolean basicEntityServicesInitialized = false;
    private List dcsyncListenerList = null;

    public DCProject() {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Creating DC nature!: " + (Object)((Object)this));
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Iterator getEntityTyps() {
        if (!this.basicEntityServicesInitialized) {
            this.initBasicEntitiesServices();
            this.basicEntityServicesInitialized = true;
        }
        ArrayList<String> theListOfCurrentTyps = new ArrayList<String>();
        Iterator anIter = ((AbstractList)this.thePPEntityServiceProviders).iterator();
        while (anIter.hasNext()) {
            IPPEntityService anEntityService = (IPPEntityService)anIter.next();
            String[] aCurrentSetOfTyps = anEntityService.getTypes();
            if (aCurrentSetOfTyps == null) continue;
            int size = aCurrentSetOfTyps.length;
            int i = 0;
            while (i < size) {
                if (!theListOfCurrentTyps.contains(aCurrentSetOfTyps[i])) {
                    theListOfCurrentTyps.add(aCurrentSetOfTyps[i]);
                }
                ++i;
            }
        }
        return ((AbstractList)theListOfCurrentTyps).iterator();
    }

    public synchronized Iterator getEntities(String anEntityType) {
        if (!this.basicEntityServicesInitialized) {
            this.initBasicEntitiesServices();
            this.basicEntityServicesInitialized = true;
        }
        Iterator anIter = ((AbstractList)new ArrayList()).iterator();
        Iterator anIterOverServiceProviders = ((AbstractList)this.thePPEntityServiceProviders).iterator();
        while (anIterOverServiceProviders.hasNext()) {
            IPPEntityService anEntityService = (IPPEntityService)anIterOverServiceProviders.next();
            Iterator anEntityIter = anEntityService.getEntities(anEntityType);
            if (!anEntityIter.hasNext()) continue;
            anIter = anEntityIter;
            break;
        }
        return anIter;
    }

    public synchronized void addPPEntityService(IPPEntityService anEntityService) {
        this.thePPEntityServiceProviders.add(anEntityService);
    }

    public synchronized void removePPEntityService(IPPEntityService anEntityService) {
        if (this.thePPEntityServiceProviders.contains(anEntityService)) {
            ((AbstractCollection)this.thePPEntityServiceProviders).remove(anEntityService);
        }
    }

    private void initBasicEntitiesServices() {
        String theDCVendor = null;
        String theDCType = null;
        String theDCSubType = null;
        try {
            IDCProxy dcProxy = this.getDCProxy();
            if (dcProxy != null) {
                DevelopmentComponent aDC = dcProxy.getComponent();
                theDCVendor = aDC.getComponentType().getVendor();
                theDCType = aDC.getComponentType().getType();
                theDCSubType = aDC.getComponentType().getSubType();
            }
        }
        catch (Exception e) {
            Util.logException(this.theTracer, e);
        }
        IPluginRegistry theReg = Platform.getPluginRegistry();
        IExtensionPoint anExtensionPoint = theReg.getExtensionPoint(EXT_POINT_ENTITY_SERVICES);
        IExtension[] allExtensions = anExtensionPoint.getExtensions();
        int size = allExtensions.length;
        ArrayList<Object> theEntityServices = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            IConfigurationElement[] allConfiurationElements = allExtensions[i].getConfigurationElements();
            int numOfConfigElements = allConfiurationElements.length;
            int j = 0;
            while (j < numOfConfigElements) {
                boolean useExtension = false;
                IConfigurationElement[] theDCTyps = allConfiurationElements[j].getChildren();
                if (theDCTyps.length > 0) {
                    if (theDCVendor != null && theDCType != null) {
                        int numberOfDCTyps = theDCTyps.length;
                        int k = 0;
                        while (k < numberOfDCTyps) {
                            String subType = theDCTyps[k].getAttribute("subType");
                            boolean subTypeMatch = false;
                            if (subType == null && theDCSubType == null || subType != null && theDCSubType != null && subType.equals(theDCSubType)) {
                                subTypeMatch = true;
                            }
                            if (theDCTyps[k].getAttribute("vendor").equals(theDCVendor) && theDCTyps[k].getAttribute("type").equals(theDCType) && subTypeMatch) {
                                useExtension = true;
                                break;
                            }
                            ++k;
                        }
                    }
                } else {
                    useExtension = true;
                }
                if (useExtension) {
                    try {
                        Object anEntityService = allConfiurationElements[j].createExecutableExtension("class");
                        if (anEntityService instanceof IPPEntityServiceExtension) {
                            IPPEntityServiceExtension anEntityServiceExtension = (IPPEntityServiceExtension)anEntityService;
                            anEntityServiceExtension.setProject(this.project);
                            theEntityServices.add(anEntityService);
                        }
                    }
                    catch (CoreException ce) {
                        Util.logExceptionMessage(this.theTracer, 3, "Failed to created executable extension", ce);
                    }
                }
                ++j;
            }
            ++i;
        }
        Iterator anIter = ((AbstractList)theEntityServices).iterator();
        while (anIter.hasNext()) {
            IPPEntityService anEntityService = (IPPEntityService)anIter.next();
            this.addPPEntityService(anEntityService);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                return;
            }
            ++i;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
        if (this.theTracer.debug()) {
            this.theTracer.debug("DC Project has been furnished with the project :" + project.getName());
        }
    }

    public void configure() throws CoreException {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Configuring DC nature!: " + (Object)((Object)this));
        }
    }

    public void deconfigure() throws CoreException {
        if (this.theTracer.debug()) {
            this.theTracer.debug("Deconfiguring DC nature!: " + (Object)((Object)this));
        }
    }

    public IDevelopmentConfiguration getConfiguration() {
        if (this.configuration != null) {
            return this.configuration;
        }
        if (this.project == null) {
            return null;
        }
        if (this.getDCProxy() != null) {
            return this.getDCProxy().getDevelopmentConfiguration();
        }
        return null;
    }

    public String getConfigurationName() {
        IDevelopmentConfiguration config = this.getConfiguration();
        if (config != null && config.getConfigurationData() != null) {
            return config.getConfigurationData().getName();
        }
        return null;
    }

    public ICompartmentNode getCompartmentNode() {
        if (this.compartmentNode != null) {
            return this.compartmentNode;
        }
        if (this.project == null) {
            return null;
        }
        this.compartmentNode = ComponentUtil.getParentCompartmentNode((IProject)this.project);
        return this.compartmentNode;
    }

    public String getCompartmentName() {
        IDCProxy dcProxy = this.getDCProxy();
        if (dcProxy != null) {
            return dcProxy.getCompartment().getName();
        }
        return null;
    }

    public IDCProxy getDCProxy() {
        if (this._dcProxy != null && !this._dcProxy.isValidInstance()) {
            this._dcProxy = null;
        }
        if (this._dcProxy == null) {
            if (this.project == null) {
                return null;
            }
            IFile file = this.project.getFile(".dcdef");
            if (!file.exists()) {
                try {
                    file.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    this.theTracer.warning("refreshing DCDEF file failed", (Throwable)e);
                }
            }
            if (file.exists()) {
                try {
                    this._dcProxy = DevelopmentConfigurationFactory.getInstance().getDCFromFile(file.getLocation().toFile());
                    if (this._dcProxy == null) {
                        Util.logExceptionMessage(this.theTracer, 2, "No DC Proxy for File" + file.getLocation() + "found", null);
                        return null;
                    }
                }
                catch (DevConfigException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "No DC PRoxy for " + this.project.getName() + "found", e);
                }
            }
        }
        return this._dcProxy;
    }

    public IDevelopmentComponentNode getDCNode() {
        if (this.getDCProxy() != null) {
            return this.getDCProxy().toNode();
        }
        return null;
    }

    public String getDCName() {
        IDCProxy dc = this.getDCProxy();
        if (dc != null) {
            return dc.getName();
        }
        return null;
    }

    public String getDCVendor() {
        IDCProxy dc = this.getDCProxy();
        if (dc != null) {
            return dc.getVendor();
        }
        return null;
    }

    public String getDomain() {
        IDCProxy dcProxy = this.getDCProxy();
        if (dcProxy != null) {
            PropertyElement pe;
            Property p;
            DevelopmentComponent dComp;
            try {
                dComp = dcProxy.getComponent();
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 3, "Getting DC failed", e);
                return null;
            }
            if (dComp != null && (p = dComp.getProperty("localization", "http://xml.sap.com/2003/06/Localization")) != null && (pe = p.getChild("domain")) != null) {
                return pe.getValue();
            }
        }
        return null;
    }

    public String getLanguage() {
        IDCProxy dcProxy = this.getDCProxy();
        if (dcProxy != null) {
            DevelopmentComponent dComp;
            try {
                dComp = dcProxy.getComponent();
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 3, "Getting DC failed", e);
                return null;
            }
            if (dComp != null) {
                PropertyElement pe;
                Property p = dComp.getProperty("localization", "http://xml.sap.com/2003/06/Localization");
                if (p != null && (pe = p.getChild("originalLocale")) != null) {
                    return pe.getValue();
                }
                Property prop = dComp.getProperty(ProjectWizard.LANGUAGE_PROPERTY);
                if (prop != null) {
                    return prop.getValue();
                }
            }
        }
        return null;
    }

    public String getBuildVariant() {
        IDevelopmentConfiguration conf = this.getConfiguration();
        String compartmentName = this.getCompartmentName();
        if (conf == null || compartmentName == null) {
            this.theTracer.warning("Can not get Build Variant for Project " + this.getProject().getName() + "\n Dev. Configuration:" + conf + "  Compartment name: " + compartmentName);
            return null;
        }
        try {
            return Util.getBuildVariant(conf, compartmentName);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "Getting Build Variant failed.", e);
            return null;
        }
    }

    public List getUsedCompilationPathList() {
        ArrayList list = new ArrayList(1);
        IDCProxy proxy = this.getDCProxy();
        if (proxy != null) {
            return proxy.getUsedCompilationPathList(this.getBuildVariant());
        }
        return list;
    }

    public boolean isModifiable() {
        IDevelopmentComponentNode node = this.getDCNode();
        if (node == null) {
            return false;
        }
        return node.isLocalOnlySource() || node.isSynchedAsModifiableSource();
    }

    public void init(IDCProxy dcProxy) {
        if (dcProxy != null) {
            this.configuration = dcProxy.getDevelopmentConfiguration();
        }
        this._dcProxy = dcProxy;
    }

    public boolean isLocal() {
        IDevelopmentComponentNode node = this.getDCNode();
        if (node == null) {
            return true;
        }
        return node.isLocalOnlySource();
    }

    public void addDCChangeListener(DCChangeListener listener) {
        if (this.dcsyncListenerList == null) {
            this.dcsyncListenerList = new ArrayList();
        }
        this.dcsyncListenerList.add(listener);
    }

    public void removeDCChangeListener(DCChangeListener listener) {
        if (this.dcsyncListenerList != null) {
            this.dcsyncListenerList.remove(listener);
        }
    }

    public void notifySync() {
        if (this.dcsyncListenerList != null) {
            Iterator it = this.dcsyncListenerList.iterator();
            while (it.hasNext()) {
                DCChangeListener listener = (DCChangeListener)it.next();
                listener.dcSynced((IDCProject)this);
            }
        }
    }

    public void notifyBuild() {
        if (this.dcsyncListenerList != null) {
            Iterator it = this.dcsyncListenerList.iterator();
            while (it.hasNext()) {
                DCChangeListener listener = (DCChangeListener)it.next();
                listener.dcBuilt((IDCProject)this);
            }
        }
    }
}

