/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.ComponentNameChecker;
import com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.provider.NamereservationUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.DCWizardUtil;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.namereservation.NameServerManager;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.DevelopmentComponentSyntaxChecker;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.core.types.DomainType;
import com.sap.s2x.core.types.LangType;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.CreateException;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.tssap.dii.component.IDCProject;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DCController {
    private IDevelopmentComponentNode parent;
    private IProject project;
    private List changeListenerList = new ArrayList();
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private IProjectDescription description = null;
    ICompartmentNode compartmentNode;
    IDevelopmentConfiguration devConfig;
    String defaultVendor = null;
    String defaultName = null;
    String defaultNamePostfix = null;
    String defaultCaption = null;
    String defaultLanguage = null;
    String defaultDomain = null;
    ComponentType defaultDCType = null;
    Boolean localOnly = null;
    Boolean defaultSyncUsedDC = null;
    String parentDCName = null;
    String parentDCVendor = null;
    private NameAllocator nameAllocator = null;
    private UIAgency uiAgent = new UIAgency(this);
    private DCController patternController = null;

    public DCController(IDCProject project) {
        this();
        if (project == null) {
            return;
        }
        IDCExtendedProject dcPrj = (IDCExtendedProject)project;
        try {
            this.setDefaultInfrastructure(dcPrj.getCompartmentNode(), dcPrj.getConfiguration());
        }
        catch (Throwable e1) {
            Util.logExceptionMessage(this.theTracer, 2, "set Infrostructure", e1);
        }
        this.defaultVendor = dcPrj.getDCVendor();
        this.defaultLanguage = dcPrj.getLanguage();
        try {
            DevelopmentComponent dc = dcPrj.getDCNode().getDevelopmentComponent(false);
            this.defaultDCType = dc.getComponentType();
            this.defaultCaption = dc.getCaption();
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "get DevelopmentComponent from " + project.getProject().getName() + " failed.", e);
        }
    }

    public DCController(IDevelopmentComponentNode dcNode) {
        this();
        if (dcNode == null) {
            return;
        }
        String compartmentName = dcNode.getCompartmentName();
        ICompartmentNode selectedCNode = null;
        Iterator it = dcNode.getConfiguration().getCompartmentNodes().iterator();
        while (it.hasNext()) {
            ICompartmentNode cNode = (ICompartmentNode)it.next();
            Compartment compartment = cNode.getCompartment();
            if (compartment == null || !compartment.getName().equals(compartmentName)) continue;
            selectedCNode = cNode;
            break;
        }
        try {
            this.setDefaultInfrastructure(selectedCNode, dcNode.getConfiguration());
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "set Default Infrostucture failed", e);
        }
        this.defaultVendor = dcNode.getVendor();
        try {
            DevelopmentComponent dc = dcNode.getDevelopmentComponent(false);
            this.defaultDCType = dc.getComponentType();
            this.defaultCaption = dc.getCaption();
            Property p = dc.getProperty("localization", "http://xml.sap.com/2003/06/Localization");
            if (p != null && p.getChild("originalLocale") != null) {
                PropertyElement pe = p.getChild("originalLocale");
                this.defaultLanguage = pe.getValue();
            } else {
                Property prop = dc.getProperty(ProjectWizard.LANGUAGE_PROPERTY);
                if (prop != null) {
                    this.defaultLanguage = prop.getValue();
                }
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 3, "get DevelopmentComponent from " + dcNode.getName() + " failed.", e);
        }
    }

    public DCController(DCController controller) {
        this();
        this.patternController = controller;
        try {
            this.setDefaultInfrastructure(controller.getCompartmentNode(), controller.getDevConfiguration());
        }
        catch (Throwable e1) {
            Util.logExceptionMessage(this.theTracer, 2, "set Infrostructure", e1);
        }
    }

    public DCController() {
        MessageUtil messageUtil = MessageUtil.getInstance("com.sap.ide.eclipse.component.dcmdcommons.resources.messages");
    }

    public void setLocalOnly(boolean value) {
        this.localOnly = new Boolean(value);
    }

    public boolean isForLocalDevelopment() {
        if (this.uiAgent.createLocalDC != null) {
            return this.uiAgent.createLocalDC.getSelection();
        }
        if (this.localOnly != null) {
            return this.localOnly;
        }
        if (this.patternController != null) {
            return this.patternController.isForLocalDevelopment();
        }
        return true;
    }

    public void setDefaultInfrastructure(ICompartmentNode compartmentNode, IDevelopmentConfiguration devConfig) throws Throwable {
        boolean differentCompartment = this.compartmentNode != compartmentNode;
        this.compartmentNode = compartmentNode;
        if (differentCompartment) {
            String _domain = null;
            String _language = null;
            Property p = this.compartmentNode.getCompartment().getProperty("terminology_domain", "http://xml.sap.com/2004/08/DevelopmentConfiguration/Configuration-Controller");
            if (p != null && "".equals(_domain = p.getValue())) {
                _domain = null;
            }
            if ((p = this.compartmentNode.getCompartment().getProperty("original_language", "http://xml.sap.com/2004/08/DevelopmentConfiguration/Configuration-Controller")) != null) {
                if (p != null) {
                    _language = p.getValue();
                }
                if ("".equals(_language)) {
                    _language = null;
                }
            }
            if (_domain != null && !_domain.equals(this.defaultDomain) || _domain != this.defaultDomain) {
                this.defaultDomain = _domain;
                this.uiAgent.initilizeDomain();
            }
            if (_language != null && !_language.equals(this.defaultLanguage) || _language != this.defaultLanguage) {
                this.defaultLanguage = _language;
                this.uiAgent.initilizeLanguage();
            }
        }
        boolean differentConfig = this.devConfig != devConfig;
        this.devConfig = devConfig;
        if (differentConfig) {
            this.update();
        }
    }

    private boolean hasNameServer() {
        String nsURL = NameServerUtil.getNameserverURL((IDevelopmentConfiguration)this.devConfig);
        return nsURL != null && nsURL.length() > 0;
    }

    private void update() throws CommunicationFailureException, MalformedURLException {
        this.nameAllocator = null;
        if (this.devConfig != null) {
            String nsURL = NameServerUtil.getNameserverURL((IDevelopmentConfiguration)this.devConfig);
            this.nameAllocator = NameServerManager.getNameserver((String)nsURL);
        }
        this.uiAgent.update();
        Iterator it = this.changeListenerList.iterator();
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.update(this);
        }
    }

    public UIAgency getUIAgent() {
        return this.uiAgent;
    }

    public String getCaption() {
        if (this.uiAgent.caption != null) {
            String value = this.uiAgent.caption.getText();
            if (value == null) {
                return "";
            }
            return value;
        }
        if (this.defaultCaption != null) {
            return this.defaultCaption;
        }
        if (this.patternController != null) {
            return this.patternController.getCaption();
        }
        return null;
    }

    public ComponentType getDCType() {
        if (this.uiAgent.typeTree != null && this.uiAgent.typeTree.isSelectable() && this.uiAgent.typeTree.getVendor() != null && this.uiAgent.typeTree.getType() != null) {
            ComponentType type = new ComponentType(this.uiAgent.typeTree.getVendor(), this.uiAgent.typeTree.getType());
            if (this.uiAgent.typeTree.getSubType() != null) {
                type.setSubType(this.uiAgent.typeTree.getSubType());
            }
            return type;
        }
        if (this.defaultDCType != null) {
            return this.defaultDCType;
        }
        if (this.patternController != null) {
            return this.patternController.getDCType();
        }
        return null;
    }

    public String getLanguage() {
        if (this.uiAgent.languages != null) {
            int index = this.uiAgent.languages.getSelectionIndex();
            if (index < 0) {
                return null;
            }
            return this.uiAgent.langTypes[index].getXLIFFValue();
        }
        if (this.defaultLanguage != null) {
            return this.defaultLanguage;
        }
        if (this.patternController != null) {
            return this.patternController.getLanguage();
        }
        return null;
    }

    public String getDomain() {
        if (this.uiAgent.domains != null) {
            int index = this.uiAgent.domains.getSelectionIndex();
            if (index < 0) {
                return null;
            }
            return this.uiAgent.domainTypes[index].getSAPInternalValue();
        }
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        if (this.patternController != null) {
            return this.patternController.getDomain();
        }
        return null;
    }

    public String getVendor() {
        if (this.uiAgent.vendor != null && this.uiAgent.cVendor != null) {
            if (((UIAgency)this.uiAgent).stackLayout.topControl.equals(this.uiAgent.vendor)) {
                return this.uiAgent.vendor.getText();
            }
            return this.uiAgent.cVendor.getText();
        }
        if (this.defaultVendor != null) {
            return this.defaultVendor;
        }
        if (this.patternController != null) {
            return this.patternController.getVendor();
        }
        return null;
    }

    public IDevelopmentComponentNode getParentDC() {
        return this.parent;
    }

    public void setParentDC(IDevelopmentComponentNode parent) throws Throwable {
        this.parent = parent;
        if (parent != null) {
            if (parent != null) {
                DCNodeSyncMode mode = parent.getNodeSyncMode();
                if (!DCNodeSyncMode.UNKNOWN.equals(mode)) {
                    this.setLocalOnly(DCNodeSyncMode.LOCAL_ONLY.equals(mode));
                }
            } else if (!UserValidator.isDefaultServerOnline()) {
                this.setLocalOnly(true);
            }
            try {
                DevelopmentComponent dc = parent.getDevelopmentComponent(false);
                if (dc == null) {
                    return;
                }
                this.parentDCName = dc.getName();
                this.parentDCVendor = dc.getVendor();
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "Initialize Wizard failed", e);
            }
        } else {
            this.parentDCName = "";
            this.parentDCVendor = "";
        }
    }

    public void setDefaultCaption(String caption) {
        this.defaultCaption = caption;
    }

    public void setDefaultDCType(ComponentType type) {
        this.defaultDCType = type;
    }

    public void setDefaultLanguage(String language) {
        this.defaultLanguage = language;
    }

    public void setDefaultDomain(String domain) {
        this.defaultDomain = domain;
    }

    public void setDefaultVendor(String vendor) {
        this.defaultVendor = vendor;
    }

    public String getName() {
        if (this.uiAgent.name != null) {
            String text = this.uiAgent.name.getText();
            if (text != null) {
                text = text.trim();
            }
            if (text != null && text.length() > 0) {
                String prefix = this.uiAgent.prefix != null && this.uiAgent.prefix.getText() != null ? this.uiAgent.prefix.getText() : "";
                return prefix + text;
            }
        }
        if (this.defaultName != null) {
            return this.defaultName;
        }
        if (this.defaultNamePostfix != null) {
            return this.getPrefix().concat(this.defaultNamePostfix);
        }
        return null;
    }

    private String getPrefix() {
        if (this.uiAgent.prefix != null) {
            String prefix = this.uiAgent.prefix.getText() != null ? this.uiAgent.prefix.getText() : "";
            return prefix;
        }
        if (this.patternController != null) {
            return this.patternController.getPrefix();
        }
        return "";
    }

    public IProjectDescription getProjectDescription() {
        if (this.description == null) {
            this.description = this.generateProjectDescription();
        }
        return this.description;
    }

    public List getNatures() {
        List<String> list = new ArrayList();
        list = this.uiAgent.typeTree != null ? this.uiAgent.typeTree.getNatures() : ComponentTypeTreeViewer.getNatures(this.getDCType());
        list.add(0, "com.sap.ide.eclipse.component.provider.dcnature");
        return list;
    }

    public void setDefaultName(String dcName) {
        this.defaultName = dcName;
    }

    public void setDefaultNamePostfix(String dcNamePostfix) {
        this.defaultNamePostfix = dcNamePostfix;
    }

    public IStatus validate() {
        String nsURL;
        if (this.devConfig == null) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("devlopmentConfigurationRequied"), null);
        }
        if (this.compartmentNode == null) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("compartmentRequied"), null);
        }
        if (this.uiAgent.name != null && (this.getName() == null || this.getName().length() <= 0)) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameRequied"), null);
        }
        if (this.getName().length() > 40) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameToLong"), null);
        }
        if (!ComponentNameChecker.checkDCName(this.getName()).getStatus()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameInvalid"), null);
        }
        if (this.getVendor() == null || this.getVendor().length() <= 0) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("vendorRequied"), null);
        }
        if (!ComponentNameChecker.checkVendorName(this.getVendor()).getStatus()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("vendorInvalid"), null);
        }
        IStatus status = this.validateEclipseResource();
        if (status.getSeverity() == 4) {
            return status;
        }
        if (this.getDCType() == null) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("typeRequied"), null);
        }
        if (UserValidator.isDefaultServerOnline() && this.getNameAllocator() == null && (nsURL = this.devConfig.getConfigurationData().getNameServer()) != null && nsURL.length() > 0) {
            if (this.isForLocalDevelopment()) {
                return new Status(2, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("nameService.unavailable.warning"), null);
            }
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("nameService.unavailable.error"), null);
        }
        if (this.getVendor() != null && this.getName().length() + this.getVendor().length() > 40) {
            return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Total length of Name + Vendor is too long.The length over 40 signs is not recommended. ", null);
        }
        StringTokenizer tokonizer = new StringTokenizer(this.getName(), "/");
        while (tokonizer.hasMoreTokens()) {
            String token = tokonizer.nextToken();
            if (token.length() <= 8) continue;
            return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "The segment '" + token + "' of DC Name is too long.The length over 8 signs is not recommended", null);
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    public NameAllocator getNameAllocator() {
        return this.nameAllocator;
    }

    private IStatus validateEclipseResource() {
        this.reset();
        if (this.getProjectDescription() == null) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("createProjectDescription.error"), null);
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectDescription().getName());
        if (proj.exists()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.format("errorProjectExists", new Object[]{this.getProjectDescription().getName()}), null);
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    private void reset() {
        this.description = null;
    }

    private IStatus validateDCName(String dcName) {
        if (dcName == null || "".equals(dcName)) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameRequied"), null);
        }
        String dcVendor = this.getVendor();
        if (dcName.length() > 40) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameToLong"), null);
        }
        if (!ComponentNameChecker.checkDCName(dcName).getStatus()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("componentNameInvalid"), null);
        }
        IStatus status = this.validateDCName(dcName, this.getParentDCName(), this.getParentDCVendor());
        if (status.getSeverity() != 0) {
            return status;
        }
        String projName = ComponentUtil.createProjectName((String)this.devConfig.getConfigurationData().getName(), (String)dcName, (String)dcVendor);
        IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (prj != null && prj.exists()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Project " + projName + " for " + dcName + " already exists.", null);
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    private IStatus validateDCName(String dcName, String parentName, String parentVendor) {
        block16: {
            if (this.devConfig == null || this.compartmentNode == null) {
                return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "No Configuration or Compartment are available.", null);
            }
            String dcVendor = this.getVendor();
            String compartmentName = this.compartmentNode.getCompartment().getName();
            try {
                if (this.isForLocalDevelopment()) {
                    this.devConfig.checkCreateLocalComponentConditions(compartmentName, dcVendor, dcName, parentVendor, parentName);
                } else {
                    this.devConfig.checkCreateComponentConditions(compartmentName, dcVendor, dcName, parentVendor, parentName);
                }
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 3, "Name check failed", e);
                return new Status(4, "com.sap.ide.eclipse.component.provider", 0, e.getMessage() != null ? e.getMessage() : e.getClass().getName(), null);
            }
            String generatedName = NameServerUtil.getDCReservationName((String)dcVendor, (String)dcName);
            if (UserValidator.isDefaultServerOnline()) {
                try {
                    if (this.nameAllocator == null) break block16;
                    try {
                        this.nameAllocator.checkName("SAP_DevelopmentComponentName", generatedName);
                    }
                    catch (NameSyntaxViolation e1) {
                        return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.format("nameSyntax.error", new Object[]{generatedName, e1.getMessage() != null ? ": " + e1.getMessage() : ""}), null);
                    }
                    if (NameServerUtil.isDCReserved((String)generatedName, (NameAllocator)this.nameAllocator)) {
                        return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.format("nameReserved.error", new Object[]{generatedName}), null);
                    }
                }
                catch (CommunicationFailureException e) {
                    Util.logExceptionMessage(this.theTracer, 3, "Name Reservation Warning", e);
                }
            } else {
                DevelopmentComponentSyntaxChecker syntaxChecker = new DevelopmentComponentSyntaxChecker();
                Properties props = new Properties();
                ((Hashtable)props).put("jndi.syntax.separator", "/");
                ((Hashtable)props).put("jndi.syntax.direction", "left_to_right");
                CompoundName compoundName = null;
                try {
                    compoundName = new CompoundName(generatedName, props);
                }
                catch (InvalidNameException e1) {
                    Util.logExceptionMessage(this.theTracer, 2, "Creating of DC CompoundName failed ", e1);
                }
                try {
                    syntaxChecker.checkSyntax(compoundName);
                }
                catch (NameSyntaxViolation e) {
                    return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.format("nameSyntax.error", new Object[]{generatedName, e.getMessage() != null ? ": " + e.getMessage() : ""}), null);
                }
            }
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    public IStatus validateDCName() {
        return this.validateDCName(this.getName());
    }

    private IProjectDescription generateProjectDescription() {
        String projName = null;
        projName = ComponentUtil.createProjectName((String)this.devConfig.getConfigurationData().getName(), (String)this.getName(), (String)this.getVendor());
        String location = this.devConfig.getConfigurationRootFolder();
        return this.initializeProjectDescription(projName, location);
    }

    private IProjectDescription initializeProjectDescription(String projectName, String location) {
        IProjectDescription projDescr = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projDescr.setComment(ComponentProviderMessages.getString("eclipseProject.comment"));
        if (location != null) {
            projDescr.setLocation((IPath)new Path(this.getPathForComponent((DevelopmentConfiguration)this.devConfig, this.compartmentNode.getCompartment().getName(), this.getVendor(), this.getName())));
        }
        List collection = this.getNatures();
        projDescr.setNatureIds(collection.toArray(new String[collection.size()]));
        return projDescr;
    }

    private String getPathForComponent(DevelopmentConfiguration configuratin, String scName, String vendor, String dcName) {
        FileSystemLayout fileSystem = new FileSystemLayout(configuratin, scName, vendor, dcName);
        return fileSystem.getRootFolder();
    }

    public boolean isOnlyLocalWizard() {
        if (!UserValidator.isDefaultServerOnline()) {
            return true;
        }
        if (this.devConfig == null) {
            return true;
        }
        return this.devConfig.isLocalConfiguration();
    }

    public boolean isWithBuildServer() {
        if (!UserValidator.isDefaultServerOnline()) {
            return false;
        }
        if (this.devConfig == null) {
            return true;
        }
        return this.devConfig.isWithBuildServer();
    }

    public String getParentDCName() {
        if (this.parentDCName != null) {
            return "".equals(this.parentDCName) ? null : this.parentDCName;
        }
        if (this.patternController != null) {
            return this.patternController.getParentDCName();
        }
        return null;
    }

    public String getParentDCVendor() {
        if (this.parentDCVendor != null) {
            return "".equals(this.parentDCVendor) ? null : this.parentDCVendor;
        }
        if (this.patternController != null) {
            return this.patternController.getParentDCVendor();
        }
        return null;
    }

    public IDevelopmentConfiguration getDevConfiguration() {
        return this.devConfig;
    }

    public ICompartmentNode getCompartmentNode() {
        return this.compartmentNode;
    }

    public Compartment getCompartment() {
        if (this.compartmentNode == null) {
            return null;
        }
        return this.compartmentNode.getCompartment();
    }

    public IStatus createComponent(Properties props, IProject project, IVfsActivity activity) {
        ICompartmentNode compNode;
        Status status = null;
        Compartment node = this.getCompartment();
        IDCProxy dcProxy = null;
        String resName = null;
        if (this.isForLocalDevelopment()) {
            try {
                dcProxy = this.devConfig.createLocalComponent(node.getName(), this.getVendor(), this.getName(), this.getParentDCVendor(), this.getParentDCName());
            }
            catch (NameCheckException e) {
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
                Util.logExceptionMessage(this.theTracer, 2, "Failed to check the name", e);
            }
            catch (SyncException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Failed to create dc", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
            catch (CreateException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Failed to create dc", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
        } else {
            AllocationState nameState = null;
            if (activity == null) {
                return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Activity is missing", (Throwable)new Exception("Activity is missing for non local DC"));
            }
            resName = NameServerUtil.getDCReservationName((String)this.getVendor(), (String)this.getName());
            if (this.nameAllocator != null) {
                try {
                    if (NamereservationUtil.isDCReserved(resName, this.nameAllocator)) {
                        return new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("NameReservationError.title"), (Throwable)new Exception(ComponentProviderMessages.format("AllreadyReserved.error", new Object[]{resName})));
                    }
                }
                catch (CommunicationFailureException e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Name Reservation", e);
                    return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
                }
                try {
                    if (this.nameAllocator != null && resName != null) {
                        nameState = NamereservationUtil.reserveDC(resName, this.nameAllocator);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Name Reservation", e);
                    return new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", e);
                }
            }
            try {
                dcProxy = this.devConfig.createComponent(node.getName(), this.getVendor(), this.getName(), this.getParentDCVendor(), this.getParentDCName(), activity);
            }
            catch (NameCheckException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Name Reservation", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
            catch (SyncException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Create DC failed", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
            catch (CreateException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Create DC failed", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
            catch (CheckoutException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Create DC failed", e);
                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "DC Creation failed", (Throwable)e);
            }
            boolean nameinDtrReserved = false;
            if (status == null && this.nameAllocator != null && nameState != null) {
                try {
                    IVfsFile dcdefFile = dcProxy.getComponentDefinitionVfsFile();
                    if (dcdefFile == null) {
                        status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Can not access .dcdef File", null);
                    } else {
                        nameinDtrReserved = NamereservationUtil.reserveDCinDTR(dcdefFile, resName, nameState, this.nameAllocator, activity);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Name Reservation Error", e);
                    status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Name Reservation failed", e);
                }
            }
            if (status != null && !status.isOK() || !nameinDtrReserved) {
                try {
                    if (this.nameAllocator != null && resName != null) {
                        NamereservationUtil.revertDCReservation(resName, this.nameAllocator);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Revert Name Reservation Error", e);
                }
                if (status != null && !status.isOK()) {
                    return status;
                }
            }
        }
        if (dcProxy == null || dcProxy.getComponent() == null) {
            return this.addStatus((IStatus)status, (IStatus)new Status(4, "com.sap.ide.eclipse.component.provider", 0, ComponentProviderMessages.getString("unexpectedError.title"), (Throwable)new Exception(ComponentProviderMessages.getString("developmentComponentCreation.error"))));
        }
        DCWizardUtil.preFillDC(dcProxy.getComponent(), props, this.getVendor(), this.getLanguage(), this.getDomain(), this.getCaption(), this.getDCType());
        try {
            dcProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logExceptionMessage(this.theTracer, 2, ".dcdef Serialisation failed", e);
            status = this.addStatus((IStatus)status, (IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": .dcdef Serialisation failed", (Throwable)e));
        }
        DCWizardUtil.postFillDC(dcProxy.getComponent(), props, this.devConfig);
        if (this.hasToSyncUsedDC()) {
            try {
                dcProxy.syncUsedComponents(this.getBuildVariant(), false);
            }
            catch (SyncException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Sync used DCs failed", e);
                status = this.addStatus((IStatus)status, (IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": sync used DC's failed", (Throwable)e));
            }
        }
        DCWizardUtil.checkInDefFolder(dcProxy, activity);
        if (activity != null) {
            try {
                String clientDefName = activity.getWorkspace().getContext().getClientName();
                BluebirdPlugin.getDefault().associateProjectWithDTR(project, clientDefName);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "DTR Association failed", e);
            }
        }
        if ((compNode = ComponentUtil.getParentCompartmentNode((IProject)project)) != null) {
            compNode.getInactiveSCNode().refresh();
        }
        if (status != null) {
            return status;
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    public String getBuildVariant() {
        return DCWizardUtil.getBuildVariant(this.devConfig, this.getCompartment());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus fillProject(IProject project, Properties properties, IVfsActivity activity, IProgressMonitor monitor) {
        block12: {
            IStatus iStatus;
            block13: {
                IStatus iStatus2;
                block11: {
                    Status status;
                    block10: {
                        if (project == null) return new Status(4, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Project doesn't exist", null);
                        if (!project.exists()) {
                            return new Status(4, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Project doesn't exist", null);
                        }
                        this.setProject(project);
                        try {
                            monitor.beginTask(ComponentProviderMessages.getString("progressMonitor.nameReservation"), 10);
                            if (this.nameAllocator == null && this.hasNameServer() && !this.isForLocalDevelopment()) {
                                monitor.done();
                                status = new Status(4, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Name Allocation for DC failed", null);
                                Object var9_7 = null;
                                if (monitor == null) return status;
                                break block10;
                            }
                            monitor.worked(1);
                            monitor.setTaskName(ComponentProviderMessages.getString("progressMonitor.DCCreation"));
                            IStatus status2 = this.createComponent(properties, project, activity);
                            if (!status2.isOK() && status2.getSeverity() == 4) {
                                monitor.done();
                                iStatus2 = status2;
                                break block11;
                            }
                            monitor.worked(5);
                            monitor.setTaskName(ComponentProviderMessages.getString("progressMonitor.update"));
                            try {
                                DCWizardUtil.addDescription(project, this.getProjectDescription());
                            }
                            catch (Throwable e) {
                                Util.logExceptionMessage(this.theTracer, 2, "Failed to add description", e);
                                status2 = this.addStatus(status2, (IStatus)new Status(2, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Set Description", e));
                            }
                            monitor.worked(1);
                            monitor.setTaskName(ComponentProviderMessages.getString("progressMonitor.refreshing"));
                            DCWizardUtil.createGenfolder(project);
                            IDCExtendedProject dcPrj = null;
                            try {
                                dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                            }
                            catch (CoreException e1) {
                                Util.logExceptionMessage(this.theTracer, 3, "get DC Project failed", e1);
                            }
                            if (dcPrj != null) {
                                status2 = this.addStatus(status2, this.checkAllDependencies(dcPrj.getDCNode()));
                            }
                            monitor.done();
                            if (status2 == null) break block12;
                            iStatus = status2;
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            if (monitor == null) throw throwable;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return status;
                }
                Object var9_8 = null;
                if (monitor == null) return iStatus2;
                monitor.done();
                return iStatus2;
            }
            Object var9_9 = null;
            if (monitor == null) return iStatus;
            monitor.done();
            return iStatus;
        }
        Object var9_10 = null;
        if (monitor == null) return new Status(0, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Fill Project Succes", null);
        monitor.done();
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, this.getName() + ": Fill Project Succes", null);
    }

    private IStatus checkAllDependencies(IDevelopmentComponentNode dcNode) {
        if (dcNode != null && dcNode.getConfiguration() != null && !dcNode.getConfiguration().isLocalConfiguration()) {
            Collection col;
            IDCNodeResult dcNodeResult = null;
            try {
                dcNodeResult = dcNode.listUsedDCs(new DCUsageFilter(true, true, true, true, false), false);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 3, "list used DCs failed", e);
            }
            if (dcNodeResult != null && !(col = dcNodeResult.getExceptions()).isEmpty()) {
                return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Some used DCs are not available locally.\nYou have to sync used DCs for this project.", null);
            }
            try {
                dcNodeResult = dcNode.listUsedInfrastructureDCs();
            }
            catch (SyncException e) {
                Util.logExceptionMessage(this.theTracer, 3, "list used DCs failed", e);
                if (e.getErrorCode() == 22) {
                    return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Some build DCs are not available locally.\nYou have to sync used DCs for this project.", (Throwable)e);
                }
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 3, "list used DCs failed", e);
            }
            if (dcNodeResult != null && !(col = dcNodeResult.getExceptions()).isEmpty()) {
                return new Status(2, "com.sap.ide.eclipse.component.provider", 0, "Some build DCs are not available locally.\nYou have to sync used DCs for this project.", null);
            }
        }
        return null;
    }

    private IStatus addStatus(IStatus status, IStatus stat) {
        if (status == null) {
            return stat;
        }
        if (stat == null) {
            return status;
        }
        if (!status.isMultiStatus()) {
            if (status.getSeverity() == 0) {
                return stat;
            }
            return new MultiStatus("com.sap.ide.eclipse.component.provider", 0, new IStatus[]{status, stat}, "DC Creation failed", null);
        }
        ((MultiStatus)status).add(stat);
        return status;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean hasToSyncUsedDC() {
        if (this.uiAgent.syncUsedDCs != null) {
            return this.uiAgent.syncUsedDCs.getSelection();
        }
        if (this.defaultSyncUsedDC != null) {
            return this.defaultSyncUsedDC;
        }
        if (this.patternController != null) {
            return this.patternController.hasToSyncUsedDC();
        }
        return false;
    }

    public void setDefaultSyncUsedDC(boolean value) {
        this.defaultSyncUsedDC = new Boolean(value);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    static /* synthetic */ NameAllocator access$1600(DCController x0) {
        return x0.nameAllocator;
    }

    public static interface ChangeListener {
        public void update(DCController var1);
    }

    public static class UIAgency {
        private Text name;
        private Text vendor;
        private Combo cVendor;
        private Text caption;
        private Combo prefix;
        private Combo languages;
        private Combo domains;
        private ComponentTypeTreeViewer typeTree;
        private Button createLocalDC;
        private Button syncUsedDCs;
        private StackLayout stackLayout;
        private DCController dcController;
        private LangType[] langTypes;
        private DomainType[] domainTypes;
        private Map prefixMap = new HashMap();
        private boolean syncUsedDCSelected = true;
        private TracerI theTracer = TracingManager.getTracer(this.getClass());

        public UIAgency(DCController dcController) {
            this.dcController = dcController;
        }

        public void initilizeLanguage() {
            if (this.languages == null || this.languages.isDisposed()) {
                return;
            }
            LangType[] lLangTypes = this.getValidLanguages();
            String defaultLanguage = "en";
            if (this.dcController.defaultLanguage != null) {
                defaultLanguage = this.dcController.defaultLanguage;
            }
            int selected = 0;
            if (lLangTypes != null && lLangTypes.length > 0) {
                String[] items = new String[lLangTypes.length];
                int i = 0;
                while (i < lLangTypes.length) {
                    LangType info = lLangTypes[i];
                    items[i] = info.getDescription();
                    if (defaultLanguage.equals(info.getXLIFFValue())) {
                        selected = i;
                    }
                    ++i;
                }
                this.languages.setItems(items);
            }
            this.languages.select(selected);
        }

        public void initilizeDomain() {
            if (this.domains == null || this.domains.isDisposed()) {
                return;
            }
            DomainType[] lDomainTypes = this.getValidDomains();
            String defaultDomain = "BC";
            if (this.dcController.defaultDomain != null) {
                defaultDomain = this.dcController.defaultDomain;
            }
            int selected = 0;
            if (lDomainTypes != null && lDomainTypes.length > 0) {
                String[] items = new String[lDomainTypes.length];
                int i = 0;
                while (i < lDomainTypes.length) {
                    DomainType info = lDomainTypes[i];
                    items[i] = info.getDescription();
                    if (defaultDomain.equals(info.getSAPInternalValue())) {
                        selected = i;
                    }
                    ++i;
                }
                this.domains.setItems(items);
            }
            this.domains.select(selected);
        }

        public Text createCaptionControl(Composite container, int style) {
            this.caption = new Text(container, style);
            if (this.dcController.defaultCaption != null) {
                this.caption.setText(this.dcController.defaultCaption);
            }
            return this.caption;
        }

        public TreeViewer createDCTypeControl(Composite container, int style) {
            this.typeTree = new ComponentTypeTreeViewer(container, style);
            if (this.dcController.defaultDCType != null) {
                this.typeTree.setActiveType(this.dcController.defaultDCType);
            }
            return this.typeTree;
        }

        public Combo createDomainControl(Composite container, int style) {
            this.domains = new Combo(container, style | 4 | 8);
            this.initilizeDomain();
            return this.domains;
        }

        protected DomainType[] getValidDomains() {
            if (this.domainTypes == null) {
                S2XDocument lDocument = null;
                try {
                    lDocument = new S2XDocument();
                }
                catch (Exception ex) {
                    return null;
                }
                if (lDocument != null) {
                    ArrayList lDomains = lDocument.getS2XTypes().getDomainTypes();
                    this.domainTypes = lDomains.toArray(new DomainType[0]);
                }
            }
            Arrays.sort(this.domainTypes, new Comparator(this){
                private final /* synthetic */ UIAgency this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean equals(Object obj) {
                    return false;
                }

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null) {
                        if (o1 == null) {
                            if (o2 == null) {
                                return 0;
                            }
                            return 1;
                        }
                        return -1;
                    }
                    String str1 = ((DomainType)o1).getDescription();
                    if (str1 == null) {
                        return -1;
                    }
                    String str2 = ((DomainType)o2).getDescription();
                    return str1.compareTo(str2);
                }
            });
            return this.domainTypes;
        }

        public Combo createLanguageControl(Composite container, int style) {
            this.languages = new Combo(container, style | 4 | 8);
            this.initilizeLanguage();
            return this.languages;
        }

        protected LangType[] getValidLanguages() {
            if (this.langTypes == null) {
                S2XDocument lDocument = null;
                try {
                    lDocument = new S2XDocument();
                }
                catch (Exception ex) {
                    return null;
                }
                if (lDocument != null) {
                    ArrayList lLangTypes = lDocument.getS2XTypes().getLangTypes();
                    this.langTypes = lLangTypes.toArray(new LangType[0]);
                }
            }
            Arrays.sort(this.langTypes, new Comparator(this){
                private final /* synthetic */ UIAgency this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean equals(Object obj) {
                    return false;
                }

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null) {
                        if (o1 == null) {
                            if (o2 == null) {
                                return 0;
                            }
                            return 1;
                        }
                        return -1;
                    }
                    String str1 = ((LangType)o1).getDescription();
                    if (str1 == null) {
                        return -1;
                    }
                    String str2 = ((LangType)o2).getDescription();
                    return str1.compareTo(str2);
                }
            });
            return this.langTypes;
        }

        public Composite createVendorControl(Composite container, int style) {
            Composite composite = new Composite(container, 0);
            this.stackLayout = new StackLayout();
            composite.setLayout((Layout)this.stackLayout);
            this.vendor = new Text(composite, style | 4);
            this.cVendor = new Combo(composite, style | 4 | 8);
            this.stackLayout.topControl = this.vendor;
            this.vendor.setTextLimit(20);
            this.cVendor.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ UIAgency this$0;
                {
                    this.this$0 = this$0;
                }

                public void modifyText(ModifyEvent e) {
                    String selectedVendor = UIAgency.access$900(this.this$0).getText();
                    if (UIAgency.access$1200(this.this$0) != null) {
                        UIAgency.access$1200(this.this$0).removeAll();
                        List list = (List)UIAgency.access$1400(this.this$0).get(selectedVendor);
                        if (list != null) {
                            // empty if block
                        }
                        UIAgency.access$1200(this.this$0).setEnabled(false);
                        if (list != null && !list.isEmpty()) {
                            String[] array = list.toArray(new String[list.size()]);
                            if (array != null) {
                                Arrays.sort(array, String.CASE_INSENSITIVE_ORDER);
                            }
                            UIAgency.access$1200(this.this$0).setItems(array);
                            UIAgency.access$1200(this.this$0).select(0);
                            UIAgency.access$1200(this.this$0).setEnabled(list.size() > 1);
                            UIAgency.access$1200(this.this$0).getParent().layout();
                        }
                    }
                }
            });
            this.updatePrefixes();
            return composite;
        }

        public Composite createDCNameControl(Composite container, int style) {
            Composite couple = new Composite(container, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            couple.setLayout((Layout)gridLayout);
            GridData gd = new GridData(768);
            couple.setLayoutData((Object)gd);
            this.prefix = new Combo(couple, style | 4 | 8);
            this.name = new Text(couple, style | 4);
            this.name.setTextLimit(40);
            this.name.setLayoutData((Object)new GridData(768));
            this.updatePrefixes();
            return couple;
        }

        public Button createForLocalControl(Composite container, int style) {
            this.createLocalDC = new Button(container, style | 0x20);
            this.createLocalDC.setText(ComponentProviderMessages.getString("createLocalDC"));
            this.updateCreateLocalDC();
            return this.createLocalDC;
        }

        public Button createSyncUsedControl(Composite container, int style) {
            this.syncUsedDCs = new Button(container, style | 0x20);
            this.updateSyncUsesDCs();
            return this.syncUsedDCs;
        }

        private void update() {
            this.updateCreateLocalDC();
            this.updateSyncUsesDCs();
            this.updatePrefixes();
        }

        private void updateSyncUsesDCs() {
            if (this.syncUsedDCs == null || this.dcController.getDevConfiguration() == null) {
                return;
            }
            if (this.dcController.isOnlyLocalWizard() || !this.dcController.isWithBuildServer()) {
                if (this.syncUsedDCs.isEnabled()) {
                    this.syncUsedDCSelected = this.syncUsedDCs.getSelection();
                    this.syncUsedDCs.setEnabled(false);
                }
                this.syncUsedDCs.setSelection(false);
            } else {
                if (!this.syncUsedDCs.isEnabled()) {
                    this.syncUsedDCs.setSelection(this.syncUsedDCSelected);
                }
                this.syncUsedDCs.setEnabled(true);
            }
        }

        private void updateCreateLocalDC() {
            if (this.createLocalDC != null) {
                if (this.dcController.localOnly != null) {
                    this.createLocalDC.setSelection(this.dcController.localOnly.booleanValue());
                    this.createLocalDC.setEnabled(false);
                } else if (this.dcController.isOnlyLocalWizard()) {
                    this.createLocalDC.setSelection(true);
                    this.createLocalDC.setEnabled(false);
                } else {
                    this.createLocalDC.setSelection(false);
                    this.createLocalDC.setEnabled(true);
                }
            }
        }

        private void updatePrefixes() {
            if (this.prefix != null || this.vendor != null) {
                String defaultVendor = this.dcController.defaultVendor;
                if (defaultVendor == null) {
                    defaultVendor = "sap.com";
                }
                this.prefixMap.clear();
                Object[] wrapper = new Object[1];
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, wrapper){
                    private final /* synthetic */ Object[] val$wrapper;
                    private final /* synthetic */ UIAgency this$0;
                    {
                        this.this$0 = this$0;
                        this.val$wrapper = val$wrapper;
                    }

                    public void run() {
                        this.val$wrapper[0] = NamereservationUtil.getAllowedDCPrefixes(DCController.access$1600(UIAgency.access$1500(this.this$0)));
                    }
                });
                CompoundName[] prefixes = (CompoundName[])wrapper[0];
                if (prefixes == null) {
                    if (this.prefix != null) {
                        this.prefix.removeAll();
                        this.prefix.setEnabled(false);
                        this.setTextVendor(defaultVendor);
                    }
                } else {
                    int i = 0;
                    while (i < prefixes.length) {
                        CompoundName namePrefix = prefixes[i];
                        String myVendor = namePrefix.getPrefix(1).toString();
                        if (myVendor != null && myVendor.length() >= 1 && ComponentNameChecker.checkVendorName(myVendor).getStatus()) {
                            Name name;
                            ArrayList<String> list = (ArrayList<String>)this.prefixMap.get(myVendor);
                            if (list == null) {
                                list = new ArrayList<String>();
                                this.prefixMap.put(myVendor, list);
                            }
                            if (!(name = namePrefix.getSuffix(1)).isEmpty()) {
                                String dcPrefix = name.toString();
                                if (dcPrefix.endsWith("*")) {
                                    list.add(dcPrefix.substring(0, dcPrefix.length() - 1));
                                } else {
                                    try {
                                        name.add("");
                                    }
                                    catch (InvalidNameException e) {
                                        Util.logExceptionMessage(this.theTracer, 3, "update Name Prefixes Problem", e);
                                    }
                                    list.add(name.toString());
                                }
                            }
                            if (list.isEmpty()) {
                                this.prefixMap.remove(myVendor);
                            }
                        }
                        ++i;
                    }
                    Set set = this.prefixMap.keySet();
                    String[] array = new String[]{};
                    String[] vendors = set.toArray(new String[set.size()]);
                    if (vendors != null && vendors.length > 0) {
                        Arrays.sort(vendors, String.CASE_INSENSITIVE_ORDER);
                        if (!set.contains(defaultVendor)) {
                            defaultVendor = vendors[0];
                        }
                        if (this.vendor != null) {
                            this.vendor.setText(defaultVendor);
                        }
                        List list = (List)this.prefixMap.get(defaultVendor);
                        array = list.toArray(new String[list.size()]);
                        if (this.cVendor != null) {
                            this.cVendor.setItems(vendors);
                            this.cVendor.select(this.cVendor.indexOf(defaultVendor));
                            this.cVendor.setEnabled(vendors.length > 1);
                            this.cVendor.setVisible(true);
                            this.vendor.setVisible(false);
                            this.stackLayout.topControl = this.cVendor;
                        }
                    } else {
                        this.setTextVendor(defaultVendor);
                    }
                    if (this.prefix != null) {
                        Arrays.sort(array, String.CASE_INSENSITIVE_ORDER);
                        this.prefix.setItems(array);
                        if (array.length > 0) {
                            this.prefix.select(0);
                        }
                        this.prefix.setEnabled(array.length > 1);
                        this.prefix.setVisible(true);
                    }
                    if (this.cVendor != null) {
                        this.cVendor.update();
                        this.cVendor.redraw();
                    }
                }
            }
        }

        private void setTextVendor(String defaultVendor) {
            if (this.cVendor == null) {
                return;
            }
            this.cVendor.setVisible(false);
            this.vendor.setVisible(true);
            if (defaultVendor != null) {
                this.vendor.setText(defaultVendor);
            }
            this.stackLayout.topControl = this.vendor;
        }

        public Text getCaptionControl() {
            return this.caption;
        }

        public Combo getVendorListControl() {
            return this.cVendor;
        }

        public Combo getLanguagesControl() {
            return this.languages;
        }

        public Combo getDomainsControl() {
            return this.domains;
        }

        public Text getNameControl() {
            return this.name;
        }

        public Combo getPrefixControl() {
            return this.prefix;
        }

        public StackLayout getVendorLayout() {
            return this.stackLayout;
        }

        public ComponentTypeTreeViewer getTypeTreeControl() {
            return this.typeTree;
        }

        public Text getVendorTextControl() {
            return this.vendor;
        }

        public Button getSyncUsedDCControl() {
            return this.syncUsedDCs;
        }

        static /* synthetic */ Map access$1400(UIAgency x0) {
            return x0.prefixMap;
        }

        static /* synthetic */ DCController access$1500(UIAgency x0) {
            return x0.dcController;
        }
    }
}

