/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfUtil;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.tc.complib.ComponentType;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImageRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentTypeTreeViewer
extends TreeViewer {
    private static String VENDOR = "typevendor";
    private static String TYPE = "type";
    private static String SUBTYPE = "sub-type";
    private static Element root;
    private static TracerI theTracer;
    private static SapImageRegistry myImageRegistry;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$core$ComponentTypeTreeViewer;

    public ComponentTypeTreeViewer() {
        this(new Tree(null, 0));
        this.init();
    }

    public ComponentTypeTreeViewer(Composite parent) {
        super(parent);
        this.init();
    }

    public ComponentTypeTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public ComponentTypeTreeViewer(Tree tree) {
        super(tree);
        this.init();
    }

    public String getVendor() {
        Element obj = this.getSelectedElement();
        if (obj != null && SUBTYPE.equals(obj.getTagName())) {
            obj = (Element)obj.getParentNode();
        }
        if (obj != null && TYPE.equals(obj.getTagName())) {
            obj = (Element)obj.getParentNode();
        }
        if (obj == null) {
            return null;
        }
        return ComponentTypeTreeViewer.getNameAttribute(obj);
    }

    public String getType() {
        Element obj = this.getSelectedElement();
        if (obj == null || VENDOR.equals(obj.getTagName())) {
            return null;
        }
        if (SUBTYPE.equals(obj.getTagName())) {
            obj = (Element)obj.getParentNode();
        }
        return ComponentTypeTreeViewer.getNameAttribute(obj);
    }

    public boolean isSelectable() {
        Element obj = this.getSelectedElement();
        if (obj == null) {
            return false;
        }
        if (SUBTYPE.equals(obj.getTagName()) || TYPE.equals(obj.getTagName())) {
            String selectable = obj.getAttribute("selectable");
            if (selectable == null || selectable.length() == 0) {
                return true;
            }
            return Boolean.valueOf(selectable);
        }
        return false;
    }

    public String getSubType() {
        Element obj = this.getSelectedElement();
        if (obj == null || !SUBTYPE.equals(obj.getTagName())) {
            return null;
        }
        return ComponentTypeTreeViewer.getNameAttribute(obj);
    }

    public List getNatures() {
        ArrayList list = new ArrayList();
        Element obj = this.getSelectedElement();
        ComponentTypeTreeViewer.getNatures(list, obj);
        return list;
    }

    public void setActiveType(ComponentType type) {
        Element element = ComponentTypeTreeViewer.getComponentTypeElement(type);
        if (element == null) {
            return;
        }
        this.expandAll();
        Widget goal = this.findItem(element);
        if (goal instanceof Item) {
            ArrayList<Widget> list = new ArrayList<Widget>();
            list.add(goal);
            this.setSelection(list);
        }
    }

    public static List getNatures(ComponentType type) {
        ArrayList list = new ArrayList();
        Element element = ComponentTypeTreeViewer.getComponentTypeElement(type);
        if (element == null) {
            return list;
        }
        ComponentTypeTreeViewer.getNatures(list, element);
        return list;
    }

    public static Element getWizard(ComponentType type) {
        Element element = ComponentTypeTreeViewer.getComponentTypeElement(type);
        if (element == null) {
            return null;
        }
        return ComponentTypeTreeViewer.getWizard(element);
    }

    public static Element getBuildPlugin(ComponentType type) {
        Element element = ComponentTypeTreeViewer.getComponentTypeElement(type);
        if (element == null) {
            return null;
        }
        return ComponentTypeTreeViewer.getBuild(element);
    }

    public static Element getComponentTypeElement(ComponentType type) {
        if (type == null) {
            return null;
        }
        Element vendorElement = ComponentTypeTreeViewer.getTypeElement(VENDOR, type.getVendor(), null);
        if (vendorElement == null) {
            return null;
        }
        Element typeElement = ComponentTypeTreeViewer.getTypeElement(TYPE, type.getType(), vendorElement);
        if (type == null) {
            return null;
        }
        if (type.getSubType() == null) {
            return typeElement;
        }
        Element subtypeElement = ComponentTypeTreeViewer.getTypeElement(SUBTYPE, type.getSubType(), typeElement);
        if (subtypeElement != null) {
            return subtypeElement;
        }
        return typeElement;
    }

    public static Image getTypeImage(ComponentType type) {
        if (type != null) {
            Element typeElement;
            String key = type.getVendor() + "#" + type.getType() + "#" + type.getSubType();
            Image image = myImageRegistry.getImage(key);
            if (image != null) {
                return image;
            }
            Element vendorElement = ComponentTypeTreeViewer.getTypeElement(VENDOR, type.getVendor(), null);
            if (vendorElement != null && (typeElement = ComponentTypeTreeViewer.getTypeElement(TYPE, type.getType(), vendorElement)) != null) {
                Element subtypeElement = ComponentTypeTreeViewer.getTypeElement(SUBTYPE, type.getSubType(), typeElement);
                String imagePath = null;
                imagePath = subtypeElement != null ? subtypeElement.getAttribute("icon") : typeElement.getAttribute("icon");
                if (imagePath != null && imagePath.length() > 0) {
                    ImageDescriptor imageDesc = SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)ComponentProviderPlugin.getPlugin().getDescriptor(), (String)imagePath);
                    myImageRegistry.put(key, imageDesc);
                    image = myImageRegistry.getImage(key);
                    if (image != null) {
                        return image;
                    }
                }
            }
            ImageDescriptor imageDesc = ComponentCategoryImage.getImageDescriptor("Development Component");
            myImageRegistry.put(key, imageDesc);
            return myImageRegistry.getImage(key);
        }
        return ComponentCategoryImage.getImage("Development Component");
    }

    public static List getDependencies(ComponentType type) {
        if (type == null) {
            return null;
        }
        Element vendorElement = ComponentTypeTreeViewer.getTypeElement(VENDOR, type.getVendor(), null);
        if (vendorElement == null) {
            return null;
        }
        Element typeElement = ComponentTypeTreeViewer.getTypeElement(TYPE, type.getType(), vendorElement);
        if (type == null) {
            return null;
        }
        Element subtypeElement = ComponentTypeTreeViewer.getTypeElement(SUBTYPE, type.getSubType(), typeElement);
        if (subtypeElement != null) {
            return ComponentTypeTreeViewer.getDpendencies(subtypeElement);
        }
        return ComponentTypeTreeViewer.getDpendencies(typeElement);
    }

    private static List getDpendencies(Element dependencies) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (dependencies != null) {
            NodeList nodes = dependencies.getElementsByTagName("dependency");
            int i = 0;
            while (i < nodes.getLength()) {
                list.add(nodes.item(i));
                ++i;
            }
        }
        return list;
    }

    private static Element getTypeElement(String vendor, String name, Element root) {
        if (name == null) {
            return null;
        }
        if (root == null) {
            root = ComponentTypeTreeViewer.getElementRoot();
        }
        NodeList nodes = root.getElementsByTagName(vendor);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            Node node = nodes.item(i);
            if (node instanceof Element && name.equals((element = (Element)node).getAttribute("name"))) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static Element getWizard(Element obj) {
        return ComponentTypeTreeViewer.getElement("wizard", obj);
    }

    private static Element getBuild(Element obj) {
        return ComponentTypeTreeViewer.getElement("build", obj);
    }

    private static Element getElement(String name, Element obj) {
        if (obj != null) {
            NodeList children = obj.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element && name.equals(children.item(i).getNodeName().toLowerCase())) {
                    return (Element)children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    private static void getNatures(List list, Element obj) {
        if (obj != null) {
            NodeList children = obj.getChildNodes();
            Element natures = null;
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element && "natures".equals(children.item(i).getNodeName())) {
                    natures = (Element)children.item(i);
                }
                ++i;
            }
            if (natures != null) {
                NodeList nodes = natures.getElementsByTagName("nature");
                int i2 = 0;
                while (i2 < nodes.getLength()) {
                    list.add(nodes.item(i2).getFirstChild().getNodeValue());
                    ++i2;
                }
            }
        }
    }

    private Element getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Element obj = (Element)selection.getFirstElement();
        return obj;
    }

    private void init() {
        this.setContentProvider((IContentProvider)new TypeContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.setInput(ComponentTypeTreeViewer.getElementRoot());
        this.expandToLevel(2);
    }

    private static Element getElementRoot() {
        if (root == null) {
            Document mainDocument = null;
            InputStream input = null;
            try {
                input = DevConfUtil.getComponentTypeXMLDefinition();
                mainDocument = Util.createNewDocumentBuilder().parse(input);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 2, "Reading of DC Type Tree failed", e);
            }
            root = (Element)mainDocument.getElementsByTagName("types").item(0);
        }
        return root;
    }

    protected static String getNameAttribute(Object element) {
        if (element != null && element instanceof Element) {
            Element node = (Element)element;
            return node.getAttribute("name");
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$core$ComponentTypeTreeViewer == null ? (class$com$sap$ide$eclipse$component$core$ComponentTypeTreeViewer = ComponentTypeTreeViewer.class$("com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer")) : class$com$sap$ide$eclipse$component$core$ComponentTypeTreeViewer));
        myImageRegistry = ComponentProviderPlugin.getPlugin().getMyImageRegistry();
    }

    protected class TypeLabelProvider
    extends LabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null && element instanceof Element) {
                Element node = (Element)element;
                String caption = node.getAttribute("caption");
                if (caption == null || "".equals(caption)) {
                    caption = node.getAttribute("name");
                }
                if (caption == null || "".equals(caption)) {
                    caption = "unknown";
                }
                return caption;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            Element node;
            String imagePath;
            if (element != null && element instanceof Element && (imagePath = (node = (Element)element).getAttribute("icon")) != null && imagePath.length() > 0) {
                return SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)ComponentProviderPlugin.getPlugin().getDescriptor(), (String)imagePath);
            }
            return ComponentCategoryImage.getImage("Development Component");
        }
    }

    protected class TypeContentProvider
    implements ITreeContentProvider {
        protected TypeContentProvider() {
        }

        private Object[] toArray(NodeList list) {
            ArrayList<Node> retList = new ArrayList<Node>();
            if (list != null) {
                int i = 0;
                while (i < list.getLength()) {
                    if (list.item(i) instanceof Element) {
                        String element = ((Element)list.item(i)).getTagName();
                        if (VENDOR.equals(element) || (TYPE.equals(element) || SUBTYPE.equals(element)) && this.isPluginExistent((Element)list.item(i))) {
                            retList.add(list.item(i));
                        }
                    }
                    ++i;
                }
            }
            return retList.toArray();
        }

        private boolean isPluginExistent(Element typeElement) {
            Element wizardNode = ComponentTypeTreeViewer.getWizard(typeElement);
            if (wizardNode == null) {
                return true;
            }
            String plugin = wizardNode.getAttribute("pluginid");
            if (plugin == null) {
                return true;
            }
            Plugin plg = null;
            if (plugin != null) {
                plg = Platform.getPlugin((String)plugin);
            }
            return plg != null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == null) {
                return null;
            }
            if (parentElement instanceof Element) {
                return this.toArray(((Element)parentElement).getChildNodes());
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Element) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

