/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.core;

import com.sap.ide.eclipse.component.core.SimpleComponentTreeViewer;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ComponentTreeViewer
implements DisposeListener {
    TabFolder tabFolder = null;
    SimpleComponentTreeViewer dcTreeActive = null;
    SimpleComponentTreeViewer dcTreeInactive = null;
    SimpleComponentTreeViewer dcTreeLocal = null;
    private List modelList = null;
    private static final int ACTIVE = 0;
    private static final int INACTIVE = 1;
    public static final int SC_VISIBLE_LEVEL = 1;
    public static final int DC_VISIBLE_LEVEL = 2;
    public static final int PP_VISIBLE_LEVEL = 4;
    public static final int ENTITY_VISIBLE_LEVEL = 8;
    public static final int MODIFICATION_ALLOWED = 16;
    public static final int BUILDPLUGIN_ONLY = 32;
    public static final int SYNC_ALLOWED = 64;
    public static final int ACTIVE_ONLY = 128;
    public static final int INACTIVE_ONLY = 256;
    public static final int LOCAL_ONLY = 512;

    public ComponentTreeViewer(Composite parent, int label, boolean singleSelection) {
        this(parent, 0, label, null, null, singleSelection);
    }

    public ComponentTreeViewer(Composite parent, int label) {
        this(parent, 0, label, null, null, false);
    }

    public ComponentTreeViewer(Composite parent, int label, IDevelopmentConfiguration conf, Object root, boolean singleSelection) {
        this(parent, 0, label, conf, root, singleSelection);
    }

    public ComponentTreeViewer(Composite parent, int label, IDevelopmentConfiguration conf, Object root) {
        this(parent, 0, label, conf, root, false);
    }

    public ComponentTreeViewer(Composite parent, int style, int level, IDevelopmentConfiguration conf, Object root, boolean singleSelection) {
        DevConfManager.initializeDevConfs(false, null);
        List allConfigRoots = null;
        if (root == null) {
            allConfigRoots = ComponentTreeViewer.getAllConfigurations();
        }
        if (!ComponentTreeViewer.isOnlyOneViewData(conf, root, level)) {
            this.tabFolder = new TabFolder(parent, 0);
            TabItem activeItem = new TabItem(this.tabFolder, 0);
            Composite activeBorder = new Composite((Composite)this.tabFolder, 2048);
            this.dcTreeActive = new SimpleComponentTreeViewer(activeBorder, singleSelection, level | 0x80);
            activeItem.setControl((Control)activeBorder);
            activeItem.setText(ComponentProviderMessages.getString("active.label"));
            TabItem inactiveItem = new TabItem(this.tabFolder, 0);
            Composite inactiveBorder = new Composite((Composite)this.tabFolder, 2048);
            this.dcTreeInactive = new SimpleComponentTreeViewer(inactiveBorder, singleSelection, level | 0x100);
            inactiveItem.setControl((Control)inactiveBorder);
            inactiveItem.setText(ComponentProviderMessages.getString("inactive.label"));
            List localConfigRoots = ComponentTreeViewer.getLocalOnlyConfigurations(allConfigRoots);
            if (localConfigRoots != null && !localConfigRoots.isEmpty()) {
                TabItem localItem = new TabItem(this.tabFolder, 0);
                this.dcTreeLocal = new SimpleComponentTreeViewer((Composite)this.tabFolder, singleSelection, level | 0x200);
                localItem.setControl((Control)this.dcTreeLocal.getTree());
                localItem.setText("Local");
                this.dcTreeLocal.setRoots(localConfigRoots.toArray(new PropertyMap[localConfigRoots.size()]));
            }
            if (allConfigRoots != null) {
                if (localConfigRoots != null) {
                    allConfigRoots.removeAll(localConfigRoots);
                }
                if (this.dcTreeActive != null) {
                    this.dcTreeActive.setRoots(allConfigRoots.toArray(new PropertyMap[allConfigRoots.size()]));
                }
                if (this.dcTreeInactive != null) {
                    this.dcTreeInactive.setRoots(allConfigRoots.toArray(new PropertyMap[allConfigRoots.size()]));
                }
            } else {
                this.setRoot(conf, root);
            }
            this.tabFolder.setLayout((Layout)new TabFolderLayout());
            this.tabFolder.setSelection(new TabItem[]{activeItem});
        } else {
            Composite bordered = new Composite(parent, 2048);
            this.dcTreeActive = new SimpleComponentTreeViewer(bordered, singleSelection, level);
            this.setRoot(conf, root);
        }
    }

    private boolean setRoot(IDevelopmentConfiguration conf, Object root) {
        if (root == null) {
            return true;
        }
        if (root instanceof IDevelopmentComponentNode[]) {
            return this.setRoots((IDevelopmentComponentNode[])root);
        }
        if (this.dcTreeActive != null) {
            this.dcTreeActive.getTree().removeAll();
        }
        if (this.dcTreeInactive != null) {
            this.dcTreeInactive.getTree().removeAll();
        }
        if (this.dcTreeLocal != null) {
            this.dcTreeLocal.getTree().removeAll();
        }
        ArrayList<Model> result = new ArrayList<Model>(1);
        this.getModelList().clear();
        UniqueName name = !conf.isInOfflineMode() ? ComponentMetaDataUtil.createDevConfName(conf) : ComponentMetaDataUtil.createDevConfLocalName(conf);
        this.getModelList().add(ModelAccess.getModel((UniqueName)name));
        if (this.getModelList().isEmpty()) {
            return false;
        }
        if (root == null || root instanceof IDevelopmentConfiguration) {
            result.addAll(this.getModelList());
            this.getModelList().clear();
        } else if (root instanceof ICompartmentNode) {
            this.getModelList().clear();
            ICompartmentNode node = (ICompartmentNode)root;
            UniqueName SCName = ComponentMetaDataUtil.createCompartmentName(node);
            Model model = ComponentMetaDataUtil.createAndRegisterModel(SCName, node);
            result.add(model);
            this.getModelList().add(model);
        } else if (root instanceof IDevelopmentComponentNode) {
            this.getModelList().clear();
            IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)root;
            UniqueName DCName = ComponentMetaDataUtil.createDCName(dcNode, ComponentUtil.getDCState(dcNode));
            Model model = ComponentMetaDataUtil.createAndRegisterModel(DCName, dcNode);
            result.add(model);
            this.getModelList().add(model);
        }
        if (this.dcTreeActive != null) {
            this.dcTreeActive.setRoots(result.toArray(new PropertyMap[result.size()]));
            this.dcTreeActive.getTree().addDisposeListener((DisposeListener)this);
        }
        if (this.dcTreeInactive != null) {
            this.dcTreeInactive.setRoots(result.toArray(new PropertyMap[result.size()]));
        }
        return true;
    }

    private boolean setRoots(IDevelopmentComponentNode[] roots) {
        if (this.dcTreeActive != null) {
            this.dcTreeActive.getTree().removeAll();
        }
        if (this.dcTreeInactive != null) {
            this.dcTreeInactive.getTree().removeAll();
        }
        if (this.dcTreeLocal != null) {
            this.dcTreeLocal.getTree().removeAll();
        }
        if (roots == null || roots.length <= 0) {
            return false;
        }
        ArrayList<Model> result = new ArrayList<Model>(roots.length);
        this.getModelList().clear();
        int i = 0;
        while (i < roots.length) {
            UniqueName DCName = ComponentMetaDataUtil.createDCName(roots[i], ComponentUtil.getDCState(roots[i]));
            Model model = ComponentMetaDataUtil.createAndRegisterModel(DCName, roots[i]);
            result.add(model);
            this.getModelList().add(model);
            ++i;
        }
        if (this.dcTreeActive != null) {
            this.dcTreeActive.setRoots(result.toArray(new PropertyMap[result.size()]));
            this.dcTreeActive.getTree().addDisposeListener((DisposeListener)this);
        }
        if (this.dcTreeInactive != null) {
            this.dcTreeInactive.setRoots(result.toArray(new PropertyMap[result.size()]));
        }
        return true;
    }

    public Control getControl() {
        if (this.tabFolder != null) {
            return this.tabFolder;
        }
        if (this.dcTreeActive != null) {
            return this.dcTreeActive.getTree();
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.dcTreeActive != null) {
            this.dcTreeActive.addSelectionChangedListener(listener);
        }
        if (this.dcTreeInactive != null) {
            this.dcTreeInactive.addSelectionChangedListener(listener);
        }
        if (this.dcTreeLocal != null) {
            this.dcTreeLocal.addSelectionChangedListener(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.tabFolder != null) {
            this.tabFolder.addSelectionListener(listener);
        }
    }

    public IDevelopmentComponentNode getSelectedDC() {
        Object obj = this.getSelectedObject();
        if (obj != null && obj instanceof IDevelopmentComponentNode) {
            return (IDevelopmentComponentNode)obj;
        }
        return null;
    }

    public ICompartmentNode getSelectedSC() {
        Object obj = this.getSelectedObject();
        if (obj != null && obj instanceof ICompartmentNode) {
            return (ICompartmentNode)obj;
        }
        return null;
    }

    public Entity getSelectedEntity() {
        Object obj = this.getSelectedObject();
        if (obj != null && obj instanceof Entity) {
            return (Entity)obj;
        }
        return null;
    }

    public PublicPart getSelectedPP() {
        Object obj = this.getSelectedObject();
        if (obj != null && obj instanceof PublicPart) {
            return (PublicPart)obj;
        }
        return null;
    }

    public boolean isSlectedActiveBranch() {
        Element element = this.getSelectedElement();
        return "active".equals(ComponentUtil.getElementState(element));
    }

    public List getPathToSelectedObject() {
        ArrayList<Object> result = new ArrayList<Object>(5);
        Element element = this.getSelectedElement();
        while (element != null) {
            Object obj;
            String sd = element.getUniqueName().getSubDomain();
            if (!sd.equals("com.sap.ide.eclipse.component.DCMetaData.PPFolder") && (obj = ObjectUtil.getComponentObject(element)) != null) {
                result.add(0, obj);
            }
            element = ObjectUtil.getParent(element);
        }
        return result;
    }

    public boolean isTreeEmpty() {
        if (this.dcTreeActive != null) {
            return this.dcTreeActive.isTreeEmpty();
        }
        return false;
    }

    public Element getSelectedElement() {
        SimpleComponentTreeViewer tv = this.getSimpleTreeViever();
        if (tv != null) {
            return tv.getSelectedElement();
        }
        return null;
    }

    private Object getSelectedObject() {
        Element element = this.getSelectedElement();
        if (element != null) {
            return ObjectUtil.getComponentObject(element);
        }
        return null;
    }

    public SimpleComponentTreeViewer getSimpleTreeViever() {
        if (this.dcTreeActive != null && this.dcTreeInactive == null && this.dcTreeLocal == null) {
            return this.dcTreeActive;
        }
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.dcTreeActive;
        }
        if (this.tabFolder.getSelectionIndex() == 1) {
            return this.dcTreeInactive;
        }
        return this.dcTreeLocal;
    }

    public void widgetDisposed(DisposeEvent e) {
        Iterator it = this.getModelList().iterator();
        while (it.hasNext()) {
            Model model = (Model)it.next();
            model.delete();
        }
    }

    private List getModelList() {
        if (this.modelList == null) {
            this.modelList = new ArrayList();
        }
        return this.modelList;
    }

    private static List getAllConfigurations() {
        ArrayList<Model> lst = new ArrayList<Model>();
        PropertyMap[] models = ModelUtilPlugin.computeModels();
        if (models == null) {
            return lst;
        }
        int i = 0;
        while (i < models.length) {
            Model model;
            Object obj;
            if (models[i] instanceof Model && (obj = ObjectUtil.getComponentObject((Element)(model = (Model)models[i]))) instanceof IDevelopmentConfiguration) {
                lst.add(model);
            }
            ++i;
        }
        return lst;
    }

    private static List getLocalOnlyConfigurations(List confs) {
        ArrayList<Model> lst = new ArrayList<Model>();
        if (confs == null) {
            return lst;
        }
        Iterator iter = confs.iterator();
        while (iter.hasNext()) {
            Model model = (Model)iter.next();
            Object obj = ObjectUtil.getComponentObject((Element)model);
            if (!(obj instanceof IDevelopmentConfiguration) || !((IDevelopmentConfiguration)obj).isLocalConfiguration()) continue;
            lst.add(model);
        }
        return lst;
    }

    private static boolean isOnlyOneViewData(IDevelopmentConfiguration conf, Object root, int level) {
        if (!UserValidator.isDefaultServerOnline()) {
            return true;
        }
        if (conf != null && conf.isLocalConfiguration()) {
            return true;
        }
        if ((0x381 & level) != 0) {
            return true;
        }
        if (root instanceof IDevelopmentComponentNode[]) {
            return true;
        }
        if (root instanceof IDevelopmentConfiguration) {
            if (((IDevelopmentConfiguration)root).isLocalConfiguration()) {
                return true;
            }
        } else {
            if (root instanceof ICompartmentNode) {
                return true;
            }
            if (root instanceof IDevelopmentComponentNode) {
                return true;
            }
        }
        return false;
    }
}

