/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildutility;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GetOptions {
    private String[] argv;
    private String[] validOptions;
    private boolean[] argumentRequired;
    private boolean caseSensitive;
    private Vector optionVector;
    private Vector argumentVector;
    private int entrycounter;
    private List errorList;
    private boolean isValid;

    private GetOptions() {
    }

    public GetOptions(String[] argv, String[] validOptions, boolean[] argumentRequired, boolean caseSensitive) {
        this.argv = argv;
        this.validOptions = validOptions;
        this.argumentRequired = argumentRequired;
        this.caseSensitive = caseSensitive;
        this.optionVector = new Vector();
        this.argumentVector = new Vector();
        this.entrycounter = 0;
        this.errorList = new ArrayList();
        this.isValid = false;
        this.parseOptions();
    }

    public GetOptions(String[] argv, String[] validOptions, boolean[] argumentRequired) {
        this.argv = argv;
        this.validOptions = validOptions;
        this.argumentRequired = argumentRequired;
        this.caseSensitive = false;
        this.optionVector = new Vector();
        this.argumentVector = new Vector();
        this.entrycounter = 0;
        this.errorList = new ArrayList();
        this.isValid = false;
        this.parseOptions();
    }

    public boolean hasNext() {
        if (this.entrycounter < this.optionVector.size() && this.isValid) {
            ++this.entrycounter;
            return true;
        }
        return false;
    }

    public String getOption() {
        if (this.entrycounter > this.optionVector.size() || this.entrycounter == 0 || !this.isValid) {
            return null;
        }
        return (String)this.optionVector.elementAt(this.entrycounter - 1);
    }

    public String getOptionValue() {
        if (this.entrycounter > this.argumentVector.size() || this.entrycounter == 0 || !this.isValid) {
            return null;
        }
        return (String)this.argumentVector.elementAt(this.entrycounter - 1);
    }

    public List getErrorList() {
        return this.errorList;
    }

    public void reset() {
        this.entrycounter = 0;
    }

    public String recognizedOptions() {
        int helpcounter = 1;
        StringBuffer sb = new StringBuffer();
        while (helpcounter <= this.optionVector.size() && this.isValid) {
            String opt = (String)this.optionVector.elementAt(helpcounter - 1);
            String arg = (String)this.argumentVector.elementAt(helpcounter - 1);
            if (opt != null) {
                sb.append("Option: ").append(opt);
            } else {
                sb.append("Option: ");
            }
            if (arg != null) {
                sb.append("    Argument: ").append(arg);
            } else {
                sb.append("    Argument: ");
            }
            sb.append("\n");
            ++helpcounter;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void parseOptions() {
        currentArgvCount = 0;
        longOptionSign = "--";
        shortOptionSign = "-";
        argExpected = false;
        lastOption = "";
        helpVector = new Vector<String>();
        if (this.validOptions.length != this.argumentRequired.length) {
            this.errorList.add("GetOptions was not correctly initialized, arrays passed as second and third argument must have the same length.");
            this.isValid = false;
            return;
        }
        c = 0;
        while (c < this.validOptions.length) {
            opt = this.validOptions[c];
            errmsg = "Option syntax: '-' plus single character or \"--\" plus multiple characters, option " + opt + " is invalid ";
            if (opt.length() == 0 || opt.length() == 1) {
                this.errorList.add(errmsg);
            } else if (opt.startsWith(longOptionSign)) {
                if (opt.length() < 4) {
                    this.errorList.add(errmsg);
                }
            } else if (opt.startsWith(shortOptionSign)) {
                if (opt.length() > 2) {
                    this.errorList.add(errmsg);
                }
            } else {
                this.errorList.add(errmsg);
            }
            ++c;
        }
        if (this.errorList.size() <= 0) ** GOTO lbl97
        this.isValid = false;
        return;
lbl-1000:
        // 1 sources

        {
            currentArg = this.argv[currentArgvCount];
            if (currentArg.startsWith(longOptionSign)) {
                if (argExpected) {
                    // empty if block
                }
                if (currentArg.length() < 4) {
                    this.errorList.add("Option syntax: '-' plus single character or \"--\" plus multiple characters, option " + currentArg + " is invalid ");
                } else {
                    longOption = this.startsWithOption(currentArg);
                    if (longOption == null) {
                        this.errorList.add("Found invalid long option " + currentArg);
                    } else {
                        this.optionVector.add(longOption);
                        if (currentArg.length() == longOption.length()) {
                            argExpected = this.argumentExpected(longOption);
                            lastOption = longOption;
                            this.argumentVector.add(null);
                        } else {
                            value = currentArg.substring(longOption.length());
                            this.argumentVector.add(value);
                            argExpected = false;
                        }
                    }
                }
            } else if (currentArg.startsWith(shortOptionSign)) {
                if (argExpected) {
                    // empty if block
                }
                if (currentArg.length() < 2) {
                    this.errorList.add("Option syntax: '-' plus single character or \"--\" plus multiple characters, option " + currentArg + " is invalid ");
                } else {
                    shortOption = currentArg.substring(0, 2);
                    valopt = this.isvalidOption(shortOption);
                    if (valopt) {
                        value = null;
                        if (currentArg.length() > 2) {
                            value = currentArg.substring(2);
                            argExpected = false;
                        } else {
                            argExpected = this.argumentExpected(shortOption);
                            lastOption = shortOption;
                        }
                        this.optionVector.add(shortOption);
                        this.argumentVector.add(value);
                    } else {
                        this.errorList.add("Found invalid short option " + shortOption);
                    }
                }
            } else if (argExpected) {
                if (this.argumentVector.lastElement() == null) {
                    index = this.argumentVector.lastIndexOf(null);
                    this.argumentVector.setElementAt(currentArg, index);
                }
                argExpected = false;
            } else {
                helpVector.add(currentArg);
            }
            ++currentArgvCount;
lbl97:
            // 2 sources

            ** while (currentArgvCount < this.argv.length)
        }
lbl98:
        // 1 sources

        this.isValid = true;
        i = 0;
        while (i < helpVector.size()) {
            this.optionVector.add(null);
            this.argumentVector.add(helpVector.elementAt(i));
            ++i;
        }
    }

    private String startsWithOption(String arg) {
        if (!this.caseSensitive) {
            String upperArg = arg.toUpperCase();
            int i = 0;
            while (i < this.validOptions.length) {
                String compStr = this.validOptions[i].toUpperCase();
                if (upperArg.equalsIgnoreCase(compStr)) {
                    return this.validOptions[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.validOptions.length) {
                String compStr = this.validOptions[i2].toUpperCase();
                if (upperArg.startsWith(compStr)) {
                    return this.validOptions[i2];
                }
                ++i2;
            }
        } else {
            int i = 0;
            while (i < this.validOptions.length) {
                String compStr = this.validOptions[i].toUpperCase();
                if (arg.equalsIgnoreCase(compStr)) {
                    return this.validOptions[i];
                }
                ++i;
            }
            int i3 = 0;
            while (i3 < this.validOptions.length) {
                String compStr = this.validOptions[i3].toUpperCase();
                if (arg.startsWith(this.validOptions[i3])) {
                    return this.validOptions[i3];
                }
                ++i3;
            }
        }
        return null;
    }

    private boolean argumentExpected(String option) {
        int i = 0;
        while (i < this.validOptions.length) {
            if (this.validOptions[i].equalsIgnoreCase(option)) {
                return this.argumentRequired[i];
            }
            ++i;
        }
        return true;
    }

    private boolean isvalidOption(String option) {
        if (!this.caseSensitive) {
            int i = 0;
            while (i < this.validOptions.length) {
                if (this.validOptions[i].equalsIgnoreCase(option)) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.validOptions.length) {
                if (this.validOptions[i].equals(option)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

