/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import org.eclipse.core.runtime.IPath;

public class UniqueNameUtil {
    public static final String RESOURCE_DOMAIN = "com.tssap.selena.Resource";
    public static final String RESOURCE_SUB_DOMAIN = "folder";
    public static final String EMPTY_STRING = "";

    public static UniqueName createResourceUin(IRootRelativePath rootRelativePath) {
        String name = rootRelativePath.toString();
        return ModelAccess.createUniqueName((String)RESOURCE_DOMAIN, (String)RESOURCE_SUB_DOMAIN, (String)EMPTY_STRING, (String)name, null);
    }

    public static IRootRelativePath getRootRelativePath(Entity entity) {
        if (entity instanceof Model) {
            return RootRelativePath.valueOf(EMPTY_STRING);
        }
        return UniqueNameUtil.getRootRelativePath(entity.getUniqueName());
    }

    public static IRootRelativePath getRootRelativePath(UniqueName uin) {
        if (UniqueNameUtil.isResourceUin(uin)) {
            return RootRelativePath.valueOf(uin.getName());
        }
        return null;
    }

    public static boolean isResourceUin(UniqueName uin) {
        return uin != null && RESOURCE_DOMAIN.equals(uin.getDomain()) && RESOURCE_SUB_DOMAIN.equals(uin.getSubDomain()) && EMPTY_STRING.equals(uin.getLocation()) && !EMPTY_STRING.equals(uin.getName()) && uin.getParametersCount() == 0;
    }

    public static UniqueName createParentUinCandidate(UniqueName modelUin, UniqueName childUin) {
        Assert.isLegal((modelUin != null ? 1 : 0) != 0);
        Assert.isLegal((childUin != null ? 1 : 0) != 0);
        if (UniqueNameUtil.isResourceUin(childUin)) {
            IRootRelativePath childPath = UniqueNameUtil.getRootRelativePath(childUin);
            Assert.isLegal((!childPath.isEmpty() ? 1 : 0) != 0);
            IPath parentPath = childPath.removeLastSegments(1);
            if (parentPath.isEmpty()) {
                return modelUin;
            }
            return UniqueNameUtil.createResourceUin(RootRelativePath.valueOf(parentPath));
        }
        return null;
    }
}

