/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.internal.providers.resources.RootManagerPlugin;
import com.tssap.selena.model.internal.providers.resources.delta.ResourceDeltaBuilder;
import com.tssap.selena.model.internal.providers.resources.root.IgnoreFoldersSupport;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.internal.providers.resources.vetofactory.VetoRootProviderFactory;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.IRootProviderFactory;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;

public class RootManagerImpl
implements IRootManager {
    public static final String EXT_POINT_ROOT_PROVIDER_FACTORIES = "rootProviderFactories";
    public static final String ATTR_CLASS = "class";
    public static final String TAG_PATH_TO_EXCLUDE = "excludePathes";
    private static HashSet ourFactories;
    private final RootProvidersMap myProvidersMap;
    private IProject myProject;
    private ResourceDeltaBuilder myDeltaBuilder;
    private static final String DEFAULT_PACKAGE_NAME_PREFIX;

    public RootManagerImpl(IProject project) {
        RootManagerImpl.loadFactories();
        this.myProject = project;
        this.myProvidersMap = new RootProvidersMap();
        this.reloadAllRoots();
    }

    public void reloadAllRoots() {
        RootProvidersMap rootProvidersMap = this.myProvidersMap;
        synchronized (rootProvidersMap) {
            IRootProvider[] allProviders = this.myProvidersMap.getAll();
            int i = 0;
            while (i < allProviders.length) {
                allProviders[i].unregistered(this.getProject());
                ++i;
            }
            this.myProvidersMap.clear();
            this.initProviders();
        }
    }

    public IProject getProject() {
        return this.myProject;
    }

    public ResourceDeltaBuilder getDeltaBuilder() {
        if (this.myDeltaBuilder == null) {
            this.myDeltaBuilder = new ResourceDeltaBuilder(this);
        }
        return this.myDeltaBuilder;
    }

    private void addProvider(IRootProvider provider) {
        RootProvidersMap rootProvidersMap = this.myProvidersMap;
        synchronized (rootProvidersMap) {
            this.myProvidersMap.add(provider);
        }
    }

    private void removeProvider(IRootProvider provider) {
        RootProvidersMap rootProvidersMap = this.myProvidersMap;
        synchronized (rootProvidersMap) {
            this.myProvidersMap.remove(provider);
        }
    }

    public IRootRelativePath rootRelativePath(IProjectRelativePath projectRelativePath) {
        if (this.isExcludedFromModel(projectRelativePath)) {
            return null;
        }
        IRootProvider[] providers = this.providers(projectRelativePath);
        int i = 0;
        while (i < providers.length) {
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            if (curRoot.isPrefixOf((IPath)projectRelativePath) && curProvider.isValidFolder(projectRelativePath)) {
                IPath result = projectRelativePath.removeFirstSegments(curRoot.segmentCount());
                return RootRelativePath.valueOf(result);
            }
            ++i;
        }
        return null;
    }

    public IRootRelativePath extractRootRelativePath(UniqueName uin) {
        return UniqueNameUtil.getRootRelativePath(uin);
    }

    public IProjectRelativePath[] projectRelativePath(IRootRelativePath rootRelativePath) {
        IRootProvider[] providers = this.providers();
        HashSet<ProjectRelativePath> results = new HashSet<ProjectRelativePath>();
        int i = 0;
        while (i < providers.length) {
            IFolder curFolder;
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            ProjectRelativePath curResult = ProjectRelativePath.valueOf(curRoot.append((IPath)rootRelativePath));
            if (!this.isExcludedFromModel(curResult) && !this.isUnderSubRoot(curProvider, curResult) && curProvider.isValidFolder(curResult) && (curResult.isEmpty() || (curFolder = this.myProject.getFolder((IPath)curResult)) != null && curFolder.exists())) {
                results.add(curResult);
            }
            ++i;
        }
        return results.toArray(new IProjectRelativePath[results.size()]);
    }

    private boolean isUnderSubRoot(IRootProvider provider, IProjectRelativePath path) {
        return this.myProvidersMap.isUnderSubRoot(provider, path);
    }

    public IProjectRelativePath[] projectRelativePath(IRootRelativePath rootRelativePath, String rootGroupId) {
        IRootProvider[] providers = this.myProvidersMap.get(rootGroupId);
        LinkedList<ProjectRelativePath> results = new LinkedList<ProjectRelativePath>();
        int i = 0;
        while (i < providers.length) {
            IFolder mayBeFolder;
            IRootProvider curProvider = providers[i];
            ProjectRelativePath curResult = ProjectRelativePath.valueOf(curProvider.getRootPath().append((IPath)rootRelativePath));
            if (!this.isExcludedFromModel(curResult) && curProvider.isValidFolder(curResult) && (mayBeFolder = this.myProject.getFolder((IPath)curResult)) != null && mayBeFolder.exists()) {
                results.add(curResult);
            }
            ++i;
        }
        return results.toArray(new IProjectRelativePath[results.size()]);
    }

    public IRootRelativePath create(IRootRelativePath rootRelativePath, String namePrefix) {
        String newName = this.findNewName(rootRelativePath, namePrefix);
        IRootProvider[] providers = this.providers();
        HashSet<IPath> alreadyProcessedRoots = new HashSet<IPath>();
        LinkedList<String> processedGroupIds = new LinkedList<String>();
        int i = 0;
        while (i < providers.length) {
            ProjectRelativePath curParentPath;
            IPath curRoot;
            String groupId;
            IRootProvider curProvider = providers[i];
            if (!(curProvider.shouldBeConsistent() == IRootProvider.ConsistencyType.NOT_CONSISTENT || curProvider.shouldBeConsistent() == IRootProvider.ConsistencyType.CONSISTENT_BY_GROUP && processedGroupIds.contains(groupId = curProvider.getID()) || alreadyProcessedRoots.contains(curRoot = curProvider.getRootPath()) || !curProvider.isValidFolder(curParentPath = ProjectRelativePath.valueOf(curRoot.append((IPath)rootRelativePath))))) {
                IFolder curChild = this.myProject.getFolder(curParentPath.append(newName));
                try {
                    curChild.create(true, true, null);
                    alreadyProcessedRoots.add(curRoot);
                    if (curProvider.shouldBeConsistent() == IRootProvider.ConsistencyType.CONSISTENT_BY_GROUP) {
                        processedGroupIds.add(curProvider.getID());
                    }
                }
                catch (CoreException cantCreate) {
                    System.err.println("Can not create subfolder :" + newName + " in " + curParentPath + "\n:" + (Object)((Object)cantCreate));
                }
            }
            ++i;
        }
        return RootRelativePath.valueOf(rootRelativePath.append(newName));
    }

    public IRootRelativePath rename(IRootRelativePath relativePath, String newLastSegment) {
        Assert.isLegal((!relativePath.isEmpty() ? 1 : 0) != 0, (String)"canRename() should be called before rename()");
        if (newLastSegment.equals(relativePath.lastSegment())) {
            return relativePath;
        }
        IRootProvider[] providers = this.providers();
        HashSet<IPath> alreadyProcessedRoots = new HashSet<IPath>();
        HashSet<IRootProvider> notSelfRenamers = new HashSet<IRootProvider>();
        int i = 0;
        while (i < providers.length) {
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            if (!alreadyProcessedRoots.contains(curRoot)) {
                ProjectRelativePath destPath;
                ProjectRelativePath fromPath = ProjectRelativePath.valueOf(curRoot.append((IPath)relativePath));
                if (!curProvider.rename(fromPath, destPath = ProjectRelativePath.valueOf(curRoot.append(relativePath.removeLastSegments(1).append(newLastSegment))))) {
                    notSelfRenamers.add(curProvider);
                } else {
                    alreadyProcessedRoots.add(curRoot);
                }
            }
            ++i;
        }
        Iterator notRenamers = notSelfRenamers.iterator();
        while (notRenamers.hasNext()) {
            IRootProvider curProvider = (IRootProvider)notRenamers.next();
            IPath curRoot = curProvider.getRootPath();
            if (alreadyProcessedRoots.contains(curRoot)) continue;
            ProjectRelativePath fromPath = ProjectRelativePath.valueOf(curRoot.append((IPath)relativePath));
            ProjectRelativePath destPath = ProjectRelativePath.valueOf(curRoot.append(relativePath.removeLastSegments(1).append(newLastSegment)));
            IFolder from = this.myProject.getFolder((IPath)fromPath);
            IPath fullDestPath = null;
            if (from == null || !from.exists()) continue;
            try {
                fullDestPath = from.getFullPath().removeLastSegments(1).append(newLastSegment);
                from.move(fullDestPath, true, true, null);
                alreadyProcessedRoots.add(curRoot);
            }
            catch (CoreException cantRename) {
                System.err.println("Can not rename folder :" + fromPath + " into :" + fullDestPath + "\n:" + (Object)((Object)cantRename));
            }
        }
        return RootRelativePath.valueOf(relativePath.removeLastSegments(1).append(newLastSegment));
    }

    public boolean canRename(IRootRelativePath relativePath, String newLastSegment) {
        if (newLastSegment.indexOf(47) > -1 || newLastSegment.indexOf(58) > -1) {
            return false;
        }
        if (relativePath.isEmpty()) {
            return false;
        }
        if (newLastSegment.equals(relativePath.lastSegment())) {
            return true;
        }
        IRootProvider[] providers = this.providers();
        int i = 0;
        while (i < providers.length) {
            ProjectRelativePath destPath;
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            ProjectRelativePath fromPath = ProjectRelativePath.valueOf(curRoot.append((IPath)relativePath));
            if (curProvider.isValidFolder(fromPath) && this.exists(fromPath) && (!curProvider.isValidFolder(destPath = ProjectRelativePath.valueOf(fromPath.removeLastSegments(1).append(newLastSegment))) || !curProvider.canRename(fromPath, destPath) || this.exists(destPath))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void delete(IRootRelativePath rootRelativePath) {
        IRootProvider[] providers = this.providers();
        HashSet<IPath> alreadyProcessedRoots = new HashSet<IPath>();
        int i = 0;
        while (i < providers.length) {
            IResource toDelete;
            ProjectRelativePath curPathToDelete;
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            if (!alreadyProcessedRoots.contains(curRoot) && curProvider.isValidFolder(curPathToDelete = ProjectRelativePath.valueOf(curRoot.append((IPath)rootRelativePath))) && (toDelete = this.myProject.findMember((IPath)curPathToDelete)) != null && toDelete.exists()) {
                try {
                    toDelete.delete(3, null);
                    alreadyProcessedRoots.add(curRoot);
                }
                catch (CoreException cantDelete) {
                    System.err.println("Can not delete subfolder :" + curPathToDelete + "\n:" + (Object)((Object)cantDelete));
                }
            }
            ++i;
        }
    }

    public Enumeration roots() {
        HashSet<IPath> results = new HashSet<IPath>();
        IRootProvider[] providers = this.providers();
        int i = 0;
        while (i < providers.length) {
            results.add(providers[i].getRootPath());
            ++i;
        }
        return Collections.enumeration(results);
    }

    public Enumeration roots(String rootGroupId) {
        HashSet<IPath> results = new HashSet<IPath>();
        IRootProvider[] providers = this.myProvidersMap.get(rootGroupId);
        int i = 0;
        while (i < providers.length) {
            results.add(providers[i].getRootPath());
            ++i;
        }
        return Collections.enumeration(results);
    }

    public UniqueName getUniqueName(IRootRelativePath rootRelativePath) {
        if (rootRelativePath.isEmpty()) {
            return ModelUinSupport.createModelUin((String)this.myProject.getName());
        }
        return UniqueNameUtil.createResourceUin(rootRelativePath);
    }

    public IRootProvider[] providers(IProjectRelativePath projectRelativePath) {
        return this.myProvidersMap.getFilteredByPath(projectRelativePath);
    }

    private IRootProvider[] providers() {
        return this.myProvidersMap.getAll();
    }

    private String findNewName(IRootRelativePath rootRelativePath, String namePrefix) {
        int suffix = 0;
        if (namePrefix == null) {
            suffix = 1;
            namePrefix = DEFAULT_PACKAGE_NAME_PREFIX;
        }
        IRootProvider[] providers = this.providers();
        int i = 0;
        while (i < providers.length) {
            IRootProvider curProvider = providers[i];
            IPath curRoot = curProvider.getRootPath();
            ProjectRelativePath curParentPath = ProjectRelativePath.valueOf(curRoot.append((IPath)rootRelativePath));
            suffix = Math.max(suffix, this.findValidSuffix(curParentPath, namePrefix, suffix));
            ++i;
        }
        return namePrefix + RootManagerImpl.suffix2String(suffix);
    }

    private int findValidSuffix(IProjectRelativePath parentPath, String name, int startSuffix) {
        Object parent = parentPath.isEmpty() ? this.myProject : this.myProject.getFolder((IPath)parentPath);
        if (!parent.exists()) {
            return startSuffix;
        }
        IResource[] members = null;
        try {
            members = parent.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return startSuffix;
        }
        if (members == null) {
            return startSuffix;
        }
        int curSuffix = startSuffix;
        HashSet<String> usedSuffixes = new HashSet<String>();
        int i = 0;
        while (i < members.length) {
            IResource curMember = members[i];
            String curName = curMember.getName();
            if (curName.toLowerCase().startsWith(name.toLowerCase())) {
                usedSuffixes.add(curName.toLowerCase().substring(name.toLowerCase().length()));
            }
            ++i;
        }
        while (usedSuffixes.contains(RootManagerImpl.suffix2String(curSuffix))) {
            ++curSuffix;
        }
        return curSuffix;
    }

    private boolean exists(IProjectRelativePath projectRelativePath) {
        Assert.isNotNull((Object)projectRelativePath);
        if (projectRelativePath.isEmpty()) {
            return true;
        }
        IResource mayBeExists = this.myProject.findMember((IPath)projectRelativePath);
        return mayBeExists instanceof IContainer && mayBeExists.exists();
    }

    private static void loadFactories() {
        if (ourFactories == null) {
            ourFactories = new HashSet();
            IExtensionPoint point = RootManagerPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_ROOT_PROVIDER_FACTORIES);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    block9: {
                        IConfigurationElement element = elements[j];
                        IRootProviderFactory factory = null;
                        try {
                            if (element.getName().equals(TAG_PATH_TO_EXCLUDE)) {
                                factory = new VetoRootProviderFactory();
                                ((IExecutableExtension)factory).setInitializationData(element, null, null);
                            } else {
                                factory = (IRootProviderFactory)element.createExecutableExtension(ATTR_CLASS);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Can not instantiate RootProvider factory :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            Thread.dumpStack();
                            break block9;
                        }
                        catch (NoClassDefFoundError e) {
                            System.err.println("Can not instantiate RootProvider factory :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            Thread.dumpStack();
                            break block9;
                        }
                        if (factory != null) {
                            ourFactories.add(factory);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void initProviders() {
        Iterator factories = ourFactories.iterator();
        while (factories.hasNext()) {
            IRootProviderFactory curFactory = (IRootProviderFactory)factories.next();
            IRootProvider[] providers = curFactory.createRootProviders(this.myProject);
            if (providers == null) continue;
            int i = 0;
            while (i < providers.length) {
                IRootProvider curProvider = providers[i];
                curProvider.registered(this.myProject);
                this.addProvider(curProvider);
                ++i;
            }
        }
    }

    private boolean isExcludedFromModel(IProjectRelativePath projectRelativePath) {
        return IgnoreFoldersSupport.getInstance().isPathIgnored(projectRelativePath);
    }

    private static String suffix2String(int suffix) {
        return suffix > 0 ? "" + suffix : "";
    }

    static {
        DEFAULT_PACKAGE_NAME_PREFIX = "Package".substring(0, 1).toLowerCase() + "Package".substring(1);
    }

    private static class RootProvidersMap {
        private HashMap myProviders = new HashMap();

        private RootProvidersMap() {
        }

        public IRootProvider[] get(String rootGroupID) {
            HashSet result = new HashSet();
            Set cached = (Set)this.myProviders.get(rootGroupID);
            if (cached != null) {
                result.addAll(cached);
            }
            return result.toArray(new IRootProvider[result.size()]);
        }

        public IRootProvider[] getFilteredByPath(IProjectRelativePath projectRelativePath) {
            Set<IRootProvider> results = new HashSet();
            Iterator entries = this.myProviders.entrySet().iterator();
            while (entries.hasNext()) {
                Set curCached = (Set)entries.next().getValue();
                Iterator providers = curCached.iterator();
                while (providers.hasNext()) {
                    IRootProvider curProvider = (IRootProvider)providers.next();
                    if (!curProvider.getRootPath().isPrefixOf((IPath)projectRelativePath) || !curProvider.isValidFolder(projectRelativePath)) continue;
                    results.add(curProvider);
                }
            }
            results = this.excludeShortRoots(results);
            return results.toArray(new IRootProvider[results.size()]);
        }

        private Set excludeShortRoots(Set rootProviders) {
            if (rootProviders.size() > 1) {
                int maxRootLength = 0;
                HashSet<IRootProvider> providersWithMaxLength = new HashSet<IRootProvider>();
                Iterator providers = rootProviders.iterator();
                while (providers.hasNext()) {
                    IRootProvider curProvider = (IRootProvider)providers.next();
                    IPath curRootPath = curProvider.getRootPath();
                    if (curRootPath.segmentCount() > maxRootLength) {
                        providersWithMaxLength.clear();
                        providersWithMaxLength.add(curProvider);
                        maxRootLength = curRootPath.segmentCount();
                        continue;
                    }
                    if (curRootPath.segmentCount() != maxRootLength) continue;
                    providersWithMaxLength.add(curProvider);
                }
                rootProviders.clear();
                rootProviders.addAll(providersWithMaxLength);
            }
            return rootProviders;
        }

        public IRootProvider[] getAll() {
            HashSet result = new HashSet();
            Iterator allCached = this.myProviders.values().iterator();
            while (allCached.hasNext()) {
                result.addAll((Set)allCached.next());
            }
            return result.toArray(new IRootProvider[result.size()]);
        }

        public void add(IRootProvider rootProvider) {
            String rootGroupID = rootProvider.getID();
            HashSet<IRootProvider> cached = (HashSet<IRootProvider>)this.myProviders.get(rootGroupID);
            if (cached == null) {
                cached = new HashSet<IRootProvider>();
                this.myProviders.put(rootGroupID, cached);
            }
            cached.add(rootProvider);
        }

        public void remove(IRootProvider rootProvider) {
            String rootGroupID = rootProvider.getID();
            HashSet cached = (HashSet)this.myProviders.get(rootGroupID);
            if (cached != null) {
                cached.remove(rootProvider);
                if (cached.isEmpty()) {
                    this.myProviders.remove(rootGroupID);
                }
            }
        }

        public boolean isUnderSubRoot(IRootProvider provider, IProjectRelativePath path) {
            if (path.toString().equals(provider.getRootPath().toString())) {
                return false;
            }
            IPath parentRootPath = provider.getRootPath();
            Iterator groups = this.myProviders.values().iterator();
            while (groups.hasNext()) {
                Set curGroup = (Set)groups.next();
                Iterator providers = curGroup.iterator();
                while (providers.hasNext()) {
                    IRootProvider curProvider = (IRootProvider)providers.next();
                    IPath curRootPath = curProvider.getRootPath();
                    if (curRootPath.equals((Object)parentRootPath) || !parentRootPath.isPrefixOf(curRootPath) || !curRootPath.isPrefixOf((IPath)path)) continue;
                    return true;
                }
            }
            return false;
        }

        private IPath[] findSubRoots(IRootProvider provider) {
            IPath basePath = provider.getRootPath();
            HashSet<IPath> result = new HashSet<IPath>();
            Iterator groups = this.myProviders.values().iterator();
            while (groups.hasNext()) {
                Set curGroup = (Set)groups.next();
                Iterator providers = curGroup.iterator();
                while (providers.hasNext()) {
                    IRootProvider curProvider = (IRootProvider)providers.next();
                    if (curProvider.equals(provider) || curProvider.getRootPath().equals((Object)basePath) || !basePath.isPrefixOf(curProvider.getRootPath())) continue;
                    result.add(curProvider.getRootPath());
                }
            }
            return ((AbstractCollection)result).toArray(new IPath[result.size()]);
        }

        public void clear() {
            this.myProviders.clear();
        }
    }
}

